/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.jnajack.examples;

import java.nio.FloatBuffer;
import org.jaudiolibs.jnajack.util.SimpleAudioClient;

public class SineAudioSource
implements SimpleAudioClient.Processor {
    private static final int TABLE_SIZE = 200;
    private int left_phase = 0;
    private int right_phase = 0;
    private float[] data;

    public static void main(String[] args) throws Exception {
        SimpleAudioClient client = SimpleAudioClient.create("sine", new String[0], new String[]{"output-L", "output-R"}, true, true, new SineAudioSource());
        client.activate();
        while (true) {
            Thread.sleep(1000L);
        }
    }

    public void setup(float samplerate, int buffersize) {
        this.data = new float[200];
        for (int i = 0; i < 200; ++i) {
            this.data[i] = (float)(0.2 * Math.sin((double)i / 200.0 * Math.PI * 2.0));
        }
    }

    public void process(FloatBuffer[] inputs, FloatBuffer[] outputs) {
        FloatBuffer left = outputs[0];
        FloatBuffer right = outputs[1];
        int size = left.capacity();
        for (int i = 0; i < size; ++i) {
            left.put(i, this.data[this.left_phase]);
            right.put(i, this.data[this.right_phase]);
            this.left_phase += 2;
            this.right_phase += 3;
            if (this.left_phase >= 200) {
                this.left_phase -= 200;
            }
            if (this.right_phase < 200) continue;
            this.right_phase -= 200;
        }
    }

    public void shutdown() {
        System.out.println("Sine Audio Source shutdown");
    }
}

