/*
 * Decompiled with CFR 0.152.
 */
package org.musicalmetacreation.musebot.example_agents;

import de.sciss.net.OSCMessage;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.Pitch;
import net.beadsproject.beads.events.KillTrigger;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.WavePlayer;
import org.jaudiolibs.beads.AudioServerIO;
import org.musicalmetacreation.musebot.tools.AudioErrorHandler;
import org.musicalmetacreation.musebot.tools.MusebotAssistant;

public class KeysAgent
extends Application
implements MusebotAssistant.Responder {
    static final AudioContext ac = new AudioContext(new AudioServerIO.Jack("Keys Agent"));
    MusebotAssistant musebot;
    Envelope masterGainEnvelope;
    Gain masterGain;
    Text text;

    static {
        ac.start();
    }

    public static void main(String[] args) {
        try {
            System.out.println("Waiting");
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Launching");
        KeysAgent.launch((String[])args);
    }

    @Override
    public void incoming(OSCMessage msg) {
    }

    @Override
    public void time(final float tempo, final int tickCount) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (KeysAgent.this.text != null) {
                    KeysAgent.this.text.setText("Time: " + tickCount + " (Tempo=" + tempo + ")");
                }
            }
        });
        if (tickCount % 16 == 0) {
            WavePlayer wp = new WavePlayer(ac, Pitch.forceFrequencyToScale((float)Math.random() * 5000.0f + 100.0f, Pitch.pentatonic), Buffer.SINE);
            Envelope e = new Envelope(ac, 0.1f);
            Gain g = new Gain(ac, 1, e);
            g.addInput(wp);
            this.masterGain.addInput(g);
            e.addSegment(0.0f, 1000.0f, new KillTrigger(g));
        }
    }

    @Override
    public void gain(float level, float time) {
        this.masterGainEnvelope.clear();
        this.masterGainEnvelope.addSegment(level, time);
    }

    @Override
    public void kill() {
        this.masterGainEnvelope.clear();
        this.masterGainEnvelope.addSegment(0.0f, 5000.0f, new Bead(){

            @Override
            public void messageReceived(Bead m) {
                System.exit(0);
            }
        });
        this.masterGainEnvelope.lock(true);
    }

    public void start(Stage stage) throws Exception {
        boolean audioError = AudioErrorHandler.handleAudioError(ac);
        this.musebot = new MusebotAssistant();
        this.masterGainEnvelope = new Envelope(ac, 1.0f);
        this.masterGain = new Gain(ac, 2, this.masterGainEnvelope);
        KeysAgent.ac.out.addInput(this.masterGain);
        this.musebot.respondWith(this);
        System.out.println(".....");
        this.text = new Text("Starting");
        System.out.println("Keys agent is running.");
        StackPane root = new StackPane();
        root.getChildren().add((Object)this.text);
        Scene scene = new Scene((Parent)root, 300.0, 250.0);
        stage.setTitle("Musebot Keys Agent!");
        stage.setScene(scene);
        stage.show();
        stage.centerOnScreen();
        stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent arg0) {
                System.exit(0);
            }
        });
        if (audioError) {
            AudioErrorHandler.runAudioErrorAlert("KeysAgent Musebot Example");
        }
    }
}

