/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jmsl.score;

import com.softsynth.jmsl.Composable;
import com.softsynth.jmsl.DefaultDimensionNameSpace;
import com.softsynth.jmsl.DimensionNameSpace;
import com.softsynth.jmsl.DimensionNameSpaceEditable;
import com.softsynth.jmsl.Instrument;
import com.softsynth.jmsl.InstrumentPlayable;
import com.softsynth.jmsl.JMSL;
import com.softsynth.jmsl.Limits;
import com.softsynth.jmsl.score.NoteFactory;
import com.softsynth.jmsl.score.NoteRenderer;
import com.softsynth.jmsl.score.NumberOutOfRangeException;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.Track;
import com.softsynth.jmsl.util.JMSLMath;
import com.softsynth.jmsl.util.SimpleXMLSaver;
import com.softsynth.jmsl.util.XMLString;
import com.softsynth.jmsl.util.XMLWritable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class Note
implements InstrumentPlayable,
Cloneable,
XMLWritable,
DimensionNameSpaceEditable {
    public static byte ACCIDENTAL_SHOW_NORMAL;
    public static byte ACCIDENTAL_SHOW_NEVER;
    public static byte ACCIDENTAL_SHOW_ALWAYS;
    public static double GRACE_NOTE_SIZE_SCALER;
    private Vector a;
    private DimensionNameSpace b;
    private double[] c;
    private double[] d;
    private Track e;
    private Vector f;
    private Note g;
    private Vector h;
    private Note i;
    private Point2D j;
    public static boolean DBUG;
    private byte k;
    private byte l;
    private byte m;
    private byte n;
    private byte o;
    private byte p;
    private Vector q;
    private byte r;
    private byte s;
    public static final int MARK_NONE = 0;
    public static final int MARK_ACCENT = 1;
    public static final int MARK_STACCATO = 2;
    public static final int MARK_TENUTO = 3;
    public static final int MARK_WEDGE = 4;
    public static final int MARK_ACCENT_STACCATO = 5;
    public static final int MARK_ACCENT_TENUTO = 6;
    public static final int MARK_WEDGE_STACCATO = 7;
    public static final int MARK_FERMATA = 8;
    public static final int MARK_HARMONIC = 9;
    public static final int MARK_TRILL = 10;
    public static final int MARK_TRILL_FLAT = 11;
    public static final int MARK_TRILL_SHARP = 12;
    public static final int MARK_TRILL_NATURAL = 13;
    public static final int MARK_MORDANT = 14;
    public static final int MARK_INVERTED_MORDANT = 15;
    public static final int MARK_BOWED_TREMOLO_1 = 16;
    public static final int MARK_BOWED_TREMOLO_2 = 17;
    public static final int MARK_BOWED_TREMOLO_3 = 18;
    public static final int MARK_ACCIACCATURA = 19;
    public static final int STEM_NONE = 0;
    public static final int STEM_UP = 1;
    public static final int STEM_DOWN = 2;
    public static final int ACC_FORCE_REDECLARATION = -1;
    public static final int ACC_NONE = 0;
    public static final int ACC_SHARP = 1;
    public static final int ACC_FLAT = 2;
    public static final int ACC_NATURAL = 3;
    public static final int ACC_DOUBLE_FLAT = 4;
    public static final int ACC_DOUBLE_SHARP = 5;
    public static final int ACC_QUARTERTONE_FLAT = 6;
    public static final int ACC_THREEQUARTERTONE_FLAT = 7;
    public static final int ACC_QUARTERTONE_SHARP = 8;
    public static final int ACC_THREEQUARTERTONE_SHARP = 9;
    public static final int ACC_PREFER_SHARP = 0;
    public static final int ACC_PREFER_FLAT = 1;
    public static final int ACC_NO_PREFERENCE = 2;
    public static final int WHOLE = 0;
    public static final int HALF = 1;
    public static final int QUARTER = 2;
    public static final int EIGHTH = 3;
    public static final int SIXTEENTH = 4;
    public static final int THIRTYSECOND = 5;
    public static final int SIXTYFOURTH = 6;
    public static final int ONEHUNDREDTWENTYEIGHTH = 7;
    public static final int TWOHUNDREDFIFTYSIXTH = 8;
    public static final double[] coreDurations;
    public static final String[] coreDurationNames;
    public static final int NOTEHEAD_BLACK = 0;
    public static final int NOTEHEAD_WHITE = 1;
    public static final int NOTEHEAD_X = 2;
    public static final int NOTEHEAD_X_OVAL = 3;
    public static final int NOTEHEAD_X_DIAMOND = 4;
    public static final int NOTEHEAD_WHITE_DIAMOND = 5;
    public static final int NOTEHEAD_BLACK_DIAMOND = 6;
    public static final int NOTEHEAD_WHITE_TRIANGLE = 7;
    public static final int NOTEHEAD_BLACK_TRIANGLE = 8;
    public static final int NOTEHEAD_WHITE_INVERTEDTRIANGLE = 9;
    public static final int NOTEHEAD_BLACK_INVERTEDTRIANGLE = 10;
    public static final int NOTEHEAD_BREVE = 11;
    public static final int NOTEHEAD_SLASH = 12;
    public static final int NOTEHEAD_RESERVED_1 = 13;
    public static final int NOTEHEAD_RESERVED_2 = 14;
    public static final String[] noteheadNames;
    public static final int DYNAMIC_NONE = 0;
    public static final int DYNAMIC_PPP = 1;
    public static final int DYNAMIC_PP = 2;
    public static final int DYNAMIC_P = 3;
    public static final int DYNAMIC_MP = 4;
    public static final int DYNAMIC_MF = 5;
    public static final int DYNAMIC_F = 6;
    public static final int DYNAMIC_FF = 7;
    public static final int DYNAMIC_FFF = 8;
    private String t;
    private int u;
    private int v;
    private static boolean w;
    private int x;
    private Color y;
    private int z;
    private boolean A;
    private int B;
    private int C;
    public static final String copyright;
    public static int D;
    private static String[] E;

    public Note(Track track, double d2, double d3, double d4, double d5) {
        this.a = new Vector();
        this.g = null;
        this.h = new Vector();
        this.k = ACCIDENTAL_SHOW_NORMAL;
        this.q = new Vector();
        this.t = null;
        this.u = 0;
        this.v = 0;
        this.x = 0;
        this.y = null;
        this.z = -1;
        this.A = false;
        this.B = 0;
        this.C = 0;
        this.setDimensionNameSpace((DimensionNameSpace)DefaultDimensionNameSpace.instance());
        this.e = track;
        this.c = new double[4];
        this.d = new double[this.c.length];
        this.c[0] = d2;
        this.c[1] = d3;
        this.c[2] = d4;
        this.c[3] = d5;
        this.j = new Point2D.Double();
        this.f = new Vector();
    }

    public Note(int n2, int n3, int n4, int n5) {
        boolean bl;
        block9: {
            block8: {
                bl = Score.zb;
                this.a = new Vector();
                this.g = null;
                this.h = new Vector();
                this.k = ACCIDENTAL_SHOW_NORMAL;
                this.q = new Vector();
                this.t = null;
                this.u = 0;
                this.v = 0;
                this.x = 0;
                this.y = null;
                this.z = -1;
                this.A = false;
                this.B = 0;
                this.C = 0;
                this.setDimensionNameSpace((DimensionNameSpace)DefaultDimensionNameSpace.instance());
                this.setNoteDur(n2);
                if (n2 > 1) break block8;
                this.setNoteHeadType(1);
                if (!bl) break block9;
            }
            this.setNoteHeadType(0);
        }
        this.setNumDots(n4);
        this.setAcc(n5);
        this.setTuplet(n3);
        double d2 = coreDurations[n2];
        if (n3 != 0) {
            d2 = Note.tupletDur(n3, d2);
        }
        switch (n4) {
            case 1: {
                d2 *= 1.5;
                if (!bl) break;
            }
            case 2: {
                d2 = d2 + d2 * 0.5 + d2 * 0.25;
                break;
            }
        }
        d2 = NoteFactory.truncPrecision(d2);
        this.c = new double[4];
        this.d = new double[this.c.length];
        this.c[0] = d2;
        this.c[1] = 60.0;
        this.c[2] = 0.2;
        this.c[3] = d2 * 0.8;
        this.j = new Point2D.Double();
        this.f = new Vector();
    }

    public static Note cloneNote(Note note) {
        Note note2 = null;
        try {
            note2 = (Note)note.clone();
            note2.c(new Vector());
            note2.a(new Vector());
            note2.setGraceNotes(new Vector());
            note2.b(new Vector());
            Note.copyProperties(note, note2);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(E[80] + cloneNotSupportedException);
        }
        return note2;
    }

    private void a(Vector vector) {
        this.a = vector;
    }

    public byte getAccidentalVisibilityPolicy() {
        return this.k;
    }

    public void setAccidentalVisibilityPolicy(byte by) {
        this.k = by;
    }

    private void b(Vector vector) {
        this.q = vector;
    }

    public static void copyProperties(Note note, Note note2) {
        Object object;
        double[] dArray = new double[note.getData().length];
        double[] dArray2 = new double[note.getData().length];
        System.arraycopy(note.getData(), 0, dArray, 0, note.getData().length);
        System.arraycopy(note.getData(), 0, dArray2, 0, note.getData().length);
        note2.setData(dArray);
        note2.d = dArray2;
        note2.setNumDots(note.getNumDots());
        note2.replaceDrawingAnchor(new Point2D.Double(note.getDrawingAnchor().getX(), note.getDrawingAnchor().getY()));
        note2.setTrack(note.getTrack());
        note2.setTuplet(note.getTuplet());
        note2.setDimensionNameSpace(note.getDimensionNameSpace());
        note2.setDynamic(note.getDynamic());
        note2.setSlurredOut(note.getSlurredOut());
        note2.setBeamedOut(note.getBeamedOut());
        note2.setGlissOut(note.getGlissOut());
        note2.setNoteDur(note.getNoteDur());
        note2.setAccPref(note.getAccPref());
        if (note.getCrescOut()) {
            note2.setCrescOut(true);
        } else if (note.getDecrescOut()) {
            note2.setDecrescOut(true);
        } else {
            note2.setCrescOut(false);
        }
        if (note.is8va()) {
            note2.set8va(true);
        } else if (note.is8vb()) {
            note2.set8vb(true);
        } else {
            note2.set8va(false);
        }
        note2.setNoteHeadType(note.getNoteHeadType());
        note2.setIsGraceNote(note.isGraceNote());
        NoteFactory.calcAndSetNoteHeadStemTailInfo(note2, note2.getNoteDur());
        NoteFactory.calcAndSetDurationData(note2, note2.getNoteDur(), note2.getTuplet(), note2.getNumDots());
        note2.a(new Vector());
        Enumeration enumeration = note.getUserBeans().elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            note2.addUserBean(object);
        }
        enumeration = note.getGraceNotes().elements();
        while (enumeration.hasMoreElements()) {
            object = (Note)enumeration.nextElement();
            Note note3 = Note.cloneNote(object);
            if (((Note)object).isChord()) {
                for (int i2 = 0; i2 < ((Note)object).getIntervals().size(); ++i2) {
                    Note note4 = (Note)((Note)object).getIntervals().elementAt(i2);
                    Note note5 = Note.cloneNote(note4);
                    note3.addInterval(note5);
                }
            }
            note2.addGraceNote(note3);
        }
        enumeration = note.getMarks().elements();
        while (enumeration.hasMoreElements()) {
            object = (Integer)enumeration.nextElement();
            note2.addMark((Integer)object);
        }
    }

    public static void setIntervalsToTrackOfHandle(Note note) {
        if (note.isChord()) {
            Enumeration enumeration = note.getIntervals().elements();
            while (enumeration.hasMoreElements()) {
                Note note2 = (Note)enumeration.nextElement();
                note2.setTrack(note.getTrack());
                if (!Score.zb) continue;
            }
        }
    }

    public boolean isChord() {
        return !this.f.isEmpty();
    }

    public boolean isInterval() {
        return this.g != null;
    }

    public boolean isMonoNote() {
        return !this.isChord() && !this.isInterval();
    }

    public void setGraceNotes(Vector vector) {
        this.h = vector;
    }

    public Note addGraceNote(Note note) {
        this.h.addElement(note);
        note.setGraceNoteHandle(this);
        return note;
    }

    public Note addGraceNote(double d2, double d3, double d4, double d5, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2) {
        Note note = NoteFactory.makeNote(d2, d3, d4, d5);
        note.setIsGraceNote(true);
        note.setGraceNoteHandle(this);
        note.setAccPref(bl ? 0 : 1);
        note.setBeamedOut(bl2);
        note.setTiedOut(bl4);
        note.setSlurredOut(bl3);
        if (n2 != 0) {
            note.addMark(n2);
        }
        if (bl5) {
            note.addMark(19);
        }
        note.setTrack(this.getTrack());
        NoteFactory.setLevelPitch(note, note.getPitchData());
        this.h.addElement(note);
        return note;
    }

    public void removeGraceNote(Note note) {
        this.h.removeElement(note);
    }

    public Note getGraceNoteHandle() {
        return this.i;
    }

    public void setGraceNoteHandle(Note note) {
        this.i = note;
    }

    public void removeAllGraceNotes() {
        this.h.removeAllElements();
    }

    public Note addInterval(double d2) {
        Note note = Note.cloneNote(this);
        NoteFactory.setLevelPitch(note, d2);
        return this.addInterval(note);
    }

    public Note addInterval(Note note) {
        Note note2;
        double d2;
        if (this.isRest() || note.isRest() || this.getHandle() != null && this.getHandle().isRest()) {
            System.err.println(E[79]);
            return null;
        }
        if (this.getDimensionNameSpace() != null) {
            int n2;
            double[] dArray = note.getData();
            double[] dArray2 = new double[this.getDimensionNameSpace().dimension()];
            if (dArray2.length != this.getData().length) {
                // empty if block
            }
            for (n2 = 0; n2 < Math.min(dArray.length, dArray2.length); ++n2) {
                dArray2[n2] = dArray[n2];
            }
            note.setDimensionNameSpace(this.getDimensionNameSpace());
            for (n2 = 4; n2 < dArray2.length; ++n2) {
                dArray2[n2] = dArray.length > n2 ? dArray[n2] : this.getDimensionNameSpace().getDefault(n2);
            }
            note.setData(dArray2);
            double[] dArray3 = new double[dArray2.length];
            System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length);
            note.d = dArray3;
        }
        double d3 = note.getPitchData();
        boolean bl = false;
        Enumeration enumeration = this.getIntervals().elements();
        while (enumeration.hasMoreElements() && !(bl = (d2 = (note2 = (Note)enumeration.nextElement()).getPitchData()) == d3)) {
        }
        boolean bl2 = bl = bl || d3 == this.getPitchData();
        if (bl) {
            if (DBUG) {
                System.err.println(E[78] + d3);
                System.err.println(E[77] + note);
                System.err.print(E[76] + this.getPitchData() + " ");
                enumeration = this.getIntervals().elements();
                while (enumeration.hasMoreElements()) {
                    note2 = (Note)enumeration.nextElement();
                    d2 = note2.getPitchData();
                    System.err.print(d2 + " ");
                }
                System.err.println("");
            }
            return null;
        }
        this.f.addElement(note);
        note.setHandle(this);
        note.setDynamic(this.getDynamic());
        note.setTrack(this.getTrack());
        note.setSlurredOut(this.getSlurredOut());
        note.setMark(this.getMark());
        note.setBeamedOut(this.getBeamedOut());
        if (this.getCrescOut()) {
            note.setCrescOut(true);
        } else if (this.getDecrescOut()) {
            note.setDecrescOut(true);
        }
        if (this.is8va()) {
            note.set8va(true);
        } else if (this.is8vb()) {
            note.set8vb(true);
        }
        return note;
    }

    public void removeInterval(Note note) {
        this.f.removeElement(note);
    }

    public void clearIntervals() {
        this.f.removeAllElements();
    }

    public void setHandle(Note note) {
        this.g = note;
    }

    public Note getHandle() {
        return this.g;
    }

    public Vector getIntervals() {
        return this.f;
    }

    private void c(Vector vector) {
        this.f = vector;
    }

    public int getNoteIndex() {
        if (this.isInterval()) {
            return this.getTrack().getChildren().indexOf(this.getHandle());
        }
        return this.getTrack().getChildren().indexOf(this);
    }

    public Note nextNote() {
        if (this.getNoteIndex() < this.getTrack().size() - 1) {
            return this.getTrack().getNote(this.getNoteIndex() + 1);
        }
        int n2 = this.getTrack().getTrackIndex();
        int n3 = this.getTrack().getStaff().getStaffIndex();
        int n4 = this.getTrack().getStaff().getMeasure().getMeasureIndex();
        if (n4 == this.getScore().size() - 1) {
            return null;
        }
        Track track = this.getScore().getMeasure(n4 + 1).getStaff(n3).getTrack(n2);
        if (track.isEmpty()) {
            return null;
        }
        return track.getNote(0);
    }

    public Note prevNote() {
        if (this.getNoteIndex() > 0) {
            return this.getTrack().getNote(this.getNoteIndex() - 1);
        }
        int n2 = this.getTrack().getTrackIndex();
        int n3 = this.getTrack().getStaff().getStaffIndex();
        int n4 = this.getTrack().getStaff().getMeasure().getMeasureIndex();
        if (n4 == 0) {
            return null;
        }
        Track track = this.getScore().getMeasure(n4 - 1).getStaff(n3).getTrack(n2);
        if (track.isEmpty()) {
            return null;
        }
        return track.getNote(track.size() - 1);
    }

    public boolean isRest() {
        return this.getPitchData() == 0.0;
    }

    public boolean isBeamable() {
        return !this.isRest();
    }

    public double getDurationData() {
        return this.c[0];
    }

    public double getPitchData() {
        return this.c[1];
    }

    public double getVelData() {
        return this.c[2];
    }

    public double getHoldData() {
        return this.c[3];
    }

    public void setDurationData(double d2) {
        this.c[0] = d2;
    }

    public void setPitchData(double d2) {
        this.c[1] = d2;
    }

    public void setVelData(double d2) {
        this.c[2] = d2;
    }

    public void setHoldData(double d2) {
        this.c[3] = d2;
    }

    public void setData(double d2, double d3, double d4, double d5) {
        this.c[0] = d2;
        this.c[1] = d3;
        this.c[2] = d4;
        this.c[3] = d5;
    }

    public boolean isNoteheadVisible() {
        return 0 == (this.m >> 6 & 1);
    }

    public void setNoteheadVisible(boolean bl) {
        int n2 = bl ? 0 : 1;
        this.m = (byte)(this.m & 0xBF | n2 << 6);
    }

    public boolean isStemVisible() {
        return (this.m >> 4 & 1) == 0;
    }

    public void setStemVisible(boolean bl) {
        int n2 = bl ? 0 : 1;
        this.m = (byte)(this.m & 0xEF | n2 << 4);
    }

    public void setSelected(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        this.m = (byte)(this.m & 0xFD | n2 << 1);
    }

    public boolean getSelected() {
        return 1 == (this.m >> 1 & 1);
    }

    public int getStemInfo() {
        return this.m >> 2 & 3;
    }

    public void setStemInfo(int n2) {
        this.m = (byte)(this.m & 0xF3 | n2 << 2);
        Enumeration enumeration = this.f.elements();
        while (enumeration.hasMoreElements()) {
            ((Note)enumeration.nextElement()).setStemInfo(n2);
        }
    }

    public boolean getStemInfoOverride() {
        return 1 == (this.m >> 5 & 1);
    }

    public void setStemInfoOverride(int n2) {
        this.m = (byte)(this.m & 0xDF | 0x20);
        this.setStemInfo(n2);
    }

    public void clearStemInfoOverride() {
        this.m = (byte)(this.m & 0xDF | 0);
    }

    public void setOverflow(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        this.m = (byte)(this.m & 0xFE | n2);
    }

    public boolean getOverflow() {
        return 1 == (this.m & 1);
    }

    public static double getNoteDurationAsPerformanceTime(int n2) {
        if (n2 < 0 || n2 > 7) {
            throw new NumberOutOfRangeException(E[47] + n2 + E[48]);
        }
        return coreDurations[n2];
    }

    public double getNoteDurationAsPerformanceTime() {
        return coreDurations[this.getNoteDur()];
    }

    public static int getIndexOfCoreDuration(double d2) {
        boolean bl = Score.zb;
        int n2 = -1;
        for (int i2 = 0; i2 < coreDurations.length; ++i2) {
            if (coreDurations[i2] != d2) continue;
            n2 = i2;
            if (!bl) break;
            if (!bl) continue;
        }
        return n2;
    }

    public int getNoteDur() {
        return this.n & 0xF;
    }

    public int getCoreDuration() {
        return this.getNoteDur();
    }

    public void setNoteDur(int n2) {
        this.n = (byte)(this.n & 0xF0 | n2);
    }

    public void setNoteHeadType(int n2) {
        this.n = (byte)(this.n & 0xF | n2 << 4);
    }

    public int getNoteHeadType() {
        return this.n >> 4 & 0xF;
    }

    public int getAcc() {
        return this.l & 0xF;
    }

    public void setAcc(int n2) {
        this.l = (byte)(this.l & 0xF0 | n2);
    }

    public int getAccPref() {
        return this.l >> 4 & 1;
    }

    public void setAccPref(int n2) {
        this.l = (byte)(this.l & 0xEF | n2 << 4);
    }

    public boolean getAccHidden() {
        return 1 == (this.l >> 5 & 1);
    }

    public void setAccHidden(boolean bl) {
        int n2;
        block3: {
            block2: {
                if (!bl) break block2;
                n2 = 1;
                if (!Score.zb) break block3;
            }
            n2 = 0;
        }
        this.l = (byte)(this.l & 0xDF | n2 << 5);
    }

    public boolean getAltEnharmonicSpelling() {
        return 1 == (this.l >> 6 & 1);
    }

    public void setAltEnharmonicSpelling(boolean bl) {
        int n2;
        block3: {
            block2: {
                if (!bl) break block2;
                n2 = 1;
                if (!Score.zb) break block3;
            }
            n2 = 0;
        }
        this.l = (byte)(this.l & 0xBF | n2 << 6);
    }

    public static String accToString(int n2) {
        boolean bl = Score.zb;
        String string = E[54] + n2;
        switch (n2) {
            case 0: {
                string = E[50];
                if (!bl) break;
            }
            case 1: {
                string = E[49];
                if (!bl) break;
            }
            case 2: {
                string = E[55];
                if (!bl) break;
            }
            case 3: {
                string = E[52];
                if (!bl) break;
            }
            case 4: {
                string = E[53];
                if (!bl) break;
            }
            case 5: {
                string = E[51];
            }
        }
        return string;
    }

    public int getNumDots() {
        return this.o & 3;
    }

    public void setNumDots(int n2) {
        this.o = (byte)(this.o & 0xFC | n2);
    }

    public boolean getBeamedOut() {
        return 0 != (this.o & 0x80);
    }

    public boolean getGlissOut() {
        return 0 != (this.p & 0x80);
    }

    public int getDynamic() {
        return this.o >> 3 & 0xF;
    }

    public void setDynamic(int n2) {
        n2 = Limits.clipTo((int)n2, (int)0, (int)8);
        this.o = (byte)(this.o & 0x87 | n2 << 3);
    }

    public void setMark(int n2) {
        this.addMark(n2);
    }

    public void addMark(int n2) {
        if (n2 == 0) {
            this.q.removeAllElements();
        } else {
            Integer n3 = new Integer(n2);
            if (!this.q.contains(n3)) {
                this.q.addElement(n3);
            }
        }
    }

    public int getMark() {
        if (this.q.size() == 0) {
            return 0;
        }
        return (Integer)this.q.elementAt(0);
    }

    public Vector getMarks() {
        return this.q;
    }

    public static String dynamicToString(int n2) {
        boolean bl = Score.zb;
        String string = "";
        switch (n2) {
            case 0: {
                string = E[81];
                if (!bl) break;
            }
            case 1: {
                string = E[84];
                if (!bl) break;
            }
            case 2: {
                string = E[87];
                if (!bl) break;
            }
            case 3: {
                string = "p";
                if (!bl) break;
            }
            case 4: {
                string = E[86];
                if (!bl) break;
            }
            case 5: {
                string = E[85];
                if (!bl) break;
            }
            case 6: {
                string = "f";
                if (!bl) break;
            }
            case 7: {
                string = E[83];
                if (!bl) break;
            }
            case 8: {
                string = E[82];
            }
        }
        return string;
    }

    public static String markToString(int n2) {
        boolean bl = Score.zb;
        String string = "";
        switch (n2) {
            case 0: {
                string = E[70];
                if (!bl) break;
            }
            case 1: {
                string = E[64];
                if (!bl) break;
            }
            case 2: {
                string = E[59];
                if (!bl) break;
            }
            case 3: {
                string = E[65];
                if (!bl) break;
            }
            case 4: {
                string = E[66];
                if (!bl) break;
            }
            case 5: {
                string = E[71];
                if (!bl) break;
            }
            case 6: {
                string = E[62];
                if (!bl) break;
            }
            case 7: {
                string = E[56];
                if (!bl) break;
            }
            case 8: {
                string = E[73];
                if (!bl) break;
            }
            case 9: {
                string = E[75];
                if (!bl) break;
            }
            case 10: {
                string = E[72];
                if (!bl) break;
            }
            case 11: {
                string = E[68];
                if (!bl) break;
            }
            case 12: {
                string = E[61];
                if (!bl) break;
            }
            case 13: {
                string = E[67];
                if (!bl) break;
            }
            case 14: {
                string = E[57];
                if (!bl) break;
            }
            case 15: {
                string = E[60];
                if (!bl) break;
            }
            case 16: {
                string = E[74];
                if (!bl) break;
            }
            case 17: {
                string = E[69];
                if (!bl) break;
            }
            case 18: {
                string = E[58];
                if (!bl) break;
            }
            case 19: {
                string = E[63];
            }
        }
        return string;
    }

    public void setBeamedOut(boolean bl) {
        if (this.isInterval()) {
            this.getHandle().setBeamedOut(bl);
        } else {
            this.a(bl);
            Enumeration enumeration = this.f.elements();
            while (enumeration.hasMoreElements()) {
                ((Note)enumeration.nextElement()).a(bl);
            }
        }
    }

    private void a(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 128;
        }
        this.o = (byte)(this.o & 0x7F | n2);
    }

    public void setGlissOut(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 128;
        }
        this.p = (byte)(this.p & 0x7F | n2);
    }

    public void setTiedOut(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        this.o = (byte)(this.o & 0xFB | n2 << 2);
    }

    public boolean getTiedOut() {
        return 1 == (this.o >> 2 & 1);
    }

    public void setSlurredOut(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        this.p = (byte)(this.p & 0xEF | n2 << 4);
    }

    public boolean getSlurredOut() {
        return 1 == (this.p >> 4 & 1);
    }

    public void setVisible(boolean bl) {
        int n2 = 1;
        if (bl) {
            n2 = 0;
        }
        this.p = (byte)(this.p & 0xDF | n2 << 5);
    }

    public boolean isVisible() {
        return 0 == (this.p >> 5 & 1);
    }

    public boolean isGraceNote() {
        return 1 == (this.p >> 6 & 1);
    }

    public void setIsGraceNote(boolean bl) {
        int n2 = bl ? 1 : 0;
        this.p = (byte)(this.p & 0xBF | n2 << 6);
    }

    public Vector getGraceNotes() {
        return this.h;
    }

    public void setCrescOut(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        this.p = (byte)(this.p & 0xFC | n2);
    }

    public void setDecrescOut(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 3;
        }
        this.p = (byte)(this.p & 0xFC | n2);
    }

    public boolean getCrescOut() {
        return (this.p & 1) == 1 && (this.p & 2) == 0;
    }

    public boolean getDecrescOut() {
        return (this.p & 1) == 1 && (this.p & 2) == 2;
    }

    public void set8vaOut(boolean bl) {
        this.set8va(bl);
    }

    public void set8vbOut(boolean bl) {
        this.set8vb(bl);
    }

    public void set8va(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 4;
        }
        this.p = (byte)(this.p & 0xF3 | n2);
    }

    public void set8vb(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 12;
        }
        this.p = (byte)(this.p & 0xF3 | n2);
    }

    public boolean get8vaOut() {
        return this.is8va();
    }

    public boolean get8vbOut() {
        return this.is8vb();
    }

    public boolean is8va() {
        return (this.p >> 2 & 3) == 1;
    }

    public boolean is8vb() {
        return (this.p >> 2 & 3) == 3;
    }

    public boolean startOf8va() {
        Note note = this.prevNote();
        return this.is8va() && (note == null || !note.is8va());
    }

    public boolean endOf8va() {
        Note note = this.nextNote();
        return this.is8va() && (note == null || !note.is8va());
    }

    public boolean startOf8vb() {
        Note note = this.prevNote();
        return this.is8vb() && (note == null || !note.is8vb());
    }

    public boolean endOf8vb() {
        Note note = this.nextNote();
        return this.is8vb() && (note == null || !note.is8vb());
    }

    Note a(double d2) {
        boolean bl;
        boolean bl2 = Score.zb;
        Note note = this;
        boolean bl3 = bl = d2 == this.getPitchData();
        if (!bl && this.isChord()) {
            Enumeration enumeration = this.getIntervals().elements();
            while (enumeration.hasMoreElements()) {
                Note note2 = (Note)enumeration.nextElement();
                if (note2.getPitchData() == d2) {
                    bl = true;
                    note = note2;
                    if (!bl2) break;
                }
                if (!bl2) continue;
            }
        }
        if (bl) {
            return note;
        }
        return null;
    }

    public boolean getTiedIn() {
        Note note = this.prevNote();
        if (note == null) {
            return false;
        }
        Note note2 = note.a(this.getPitchData());
        return note2 != null && note2.getTiedOut();
    }

    public boolean getCrescIn() {
        Note note = this.prevNote();
        if (note == null) {
            return false;
        }
        return note.getCrescOut();
    }

    public boolean getDecrescIn() {
        Note note = this.prevNote();
        if (note == null) {
            return false;
        }
        return note.getDecrescOut();
    }

    public boolean startOfCresc() {
        Note note = this.prevNote();
        return this.getCrescOut() && (note == null || !note.getCrescOut());
    }

    public boolean endOfCresc() {
        Note note = this.prevNote();
        return !this.getCrescOut() && note != null && note.getCrescOut();
    }

    public boolean startOfDecresc() {
        Note note = this.prevNote();
        return this.getDecrescOut() && (note == null || !note.getDecrescOut());
    }

    public boolean endOfDecresc() {
        Note note = this.prevNote();
        return !this.getDecrescOut() && note != null && note.getDecrescOut();
    }

    public boolean getSlurredIn() {
        Note note = this.prevNote();
        if (note == null) {
            return false;
        }
        return note.getSlurredOut();
    }

    public boolean get8vaIn() {
        Note note = this.prevNote();
        if (note == null) {
            return false;
        }
        return note.is8va();
    }

    public boolean get8vbIn() {
        Note note = this.prevNote();
        if (note == null) {
            return false;
        }
        return note.is8vb();
    }

    public void setLevel(int n2) {
        this.s = (byte)n2;
    }

    public int getLevel() {
        if (!this.A) {
            return this.s & 0xFF;
        }
        return this.z;
    }

    public boolean isOverrideLevel() {
        return this.A;
    }

    public void setOverrideLevel(boolean bl) {
        this.A = bl;
    }

    public void setOverrideLevel(int n2) {
        this.z = n2;
    }

    public int getOverrideLevel() {
        return this.z;
    }

    public void setDrawingAnchor(Point2D point2D) {
        this.j.setLocation(point2D);
    }

    public void replaceDrawingAnchor(Point2D point2D) {
        this.j = point2D;
    }

    public Point2D getDrawingAnchor() {
        return this.j;
    }

    public void setNumTails(int n2) {
    }

    public int getNumTails() {
        return Math.max(0, this.getNoteDur() - 2);
    }

    public void setStaffIndex(int n2) {
        this.B = n2;
    }

    public int getStaffIndex() {
        if (this.getTrack() != null && this.getTrack().getStaff() != null) {
            return this.getTrack().getStaff().getStaffIndex();
        }
        return this.B;
    }

    public void setMeasureIndex(int n2) {
        this.C = n2;
    }

    public int getMeasureIndex() {
        if (this.getTrack() != null && this.getTrack().getStaff() != null) {
            return this.getTrack().getStaff().getMeasure().getMeasureIndex();
        }
        return this.C;
    }

    public int getTuplet() {
        return this.r & 0xFF;
    }

    public void setTuplet(int n2) {
        this.r = (byte)(n2 & 0xFF);
    }

    public Track getTrack() {
        return this.e;
    }

    public Score getScore() {
        if (this.getTrack() == null) {
            return null;
        }
        return this.getTrack().getScore();
    }

    public void setTrack(Track track) {
        this.e = track;
    }

    public double[] getData() {
        return this.c;
    }

    public double[] getDataCopy() {
        double[] dArray = new double[this.getData().length];
        System.arraycopy(this.getData(), 0, dArray, 0, dArray.length);
        return dArray;
    }

    public void setData(double[] dArray) {
        this.c = dArray;
    }

    public void setData(int n2, double d2) {
        this.c[n2] = d2;
    }

    public double getData(int n2) {
        return this.c[n2];
    }

    double a() {
        double d2;
        boolean bl = Score.zb;
        Note note = this;
        double d3 = note.getPitchData();
        double d4 = d2 = this.getDurationData();
        double d5 = this.getHoldData();
        double d6 = note.getTrack().getStaff().getMeasure().getTimeStretch();
        while (note != null && note.getTiedOut()) {
            Note note2;
            block6: {
                block5: {
                    note2 = note.nextNote();
                    if (note2 == null) break block5;
                    note = note2.a(d3);
                    if (!bl) break block6;
                }
                note = null;
            }
            if (note != null) {
                double d7 = note2.getTrack().getStaff().getMeasure().getTimeStretch();
                double d8 = d7 / d6;
                d4 = note.getDurationData() * d8;
                d5 = note.getHoldData() * d8;
                d2 += d4;
            }
            if (!bl) continue;
        }
        d2 -= d4;
        return d2 += d5;
    }

    private void b() {
        boolean bl;
        block9: {
            block8: {
                double d2;
                this.d = new double[this.c.length];
                System.arraycopy(this.c, 0, this.d, 0, this.c.length);
                if (Note.performExpressionMarks() && (this.getMark() == 2 || this.getMark() == 5)) {
                    d2 = 0.5;
                    this.d[3] = d2 * this.d[0];
                }
                if (Note.performExpressionMarks() && this.getMark() == 3) {
                    d2 = 0.95;
                    this.d[3] = d2 * this.d[0];
                }
                if (!this.is8va()) break block8;
                this.d[1] = this.d[1] + 12.0;
                if (!Score.zb) break block9;
            }
            if (this.is8vb()) {
                this.d[1] = this.d[1] - 12.0;
            }
        }
        if (!(bl = this.getTiedIn()) && this.getTiedOut()) {
            double d3;
            this.d[3] = d3 = this.a();
        }
        if (this.isInterval()) {
            this.d[0] = 0.0;
        }
    }

    public static boolean performExpressionMarks() {
        return w;
    }

    public static void setPerformExpressionMarks(boolean bl) {
        w = bl;
    }

    public double[] getPerformanceData() {
        this.b();
        return this.d;
    }

    public double[] getPerformanceDataCopy() {
        double[] dArray = new double[this.getData().length];
        System.arraycopy(this.getPerformanceData(), 0, dArray, 0, dArray.length);
        return dArray;
    }

    void c() {
        block5: {
            block4: {
                double[] dArray = this.getPerformanceData();
                if (this.isInterval()) {
                    JMSL.out.print(E[89]);
                }
                JMSL.out.print(E[90]);
                JMSL.printDoubleArray((double[])dArray);
                if (this.getTrack() == null) break block4;
                int n2 = this.getTrack().getStaff().getMeasure().getMeasureIndex();
                int n3 = this.getTrack().getStaff().getStaffIndex();
                int n4 = this.getTrack().getTrackIndex();
                JMSL.out.println(E[88] + n2 + E[94] + n3 + E[93] + n4);
                JMSL.out.println(E[91] + this.getLevel());
                if (!Score.zb) break block5;
            }
            JMSL.out.println(E[92]);
        }
    }

    public double play(double d2, Composable composable, Instrument instrument) {
        double d3;
        double[] dArray;
        boolean bl;
        block6: {
            bl = Score.zb;
            dArray = this.getPerformanceData();
            d3 = composable.timeStretch();
            if (instrument == null) break block6;
            Enumeration enumeration = this.f.elements();
            while (enumeration.hasMoreElements()) {
                block8: {
                    Note note;
                    block7: {
                        note = (Note)enumeration.nextElement();
                        if (!note.getTiedIn() || note.getVelData() == 0.0) break block7;
                        instrument.update(d2, d3, note.getPerformanceData());
                        if (!bl) break block8;
                    }
                    instrument.play(d2, d3, note.getPerformanceData());
                }
                if (!bl) continue;
            }
            double d4 = this.getTiedIn() && this.getVelData() != 0.0 ? instrument.update(d2, d3, dArray) : instrument.play(d2, d3, dArray);
            return d4;
        }
        if (DBUG) {
            this.c();
            Enumeration enumeration = this.f.elements();
            while (enumeration.hasMoreElements()) {
                ((Note)enumeration.nextElement()).c();
                if (!bl) continue;
            }
        }
        return d2 + dArray[0] * d3;
    }

    public String toString() {
        StringBuffer stringBuffer;
        block13: {
            block12: {
                int n2;
                boolean bl;
                block10: {
                    block11: {
                        block9: {
                            bl = Score.zb;
                            stringBuffer = new StringBuffer();
                            stringBuffer.append(E[106]);
                            if (!this.isChord()) break block9;
                            stringBuffer.append(E[119] + this.getIntervals().size() + E[116]);
                            if (!bl) break block10;
                        }
                        if (!this.isInterval()) break block11;
                        stringBuffer.append(E[120]);
                        if (!bl) break block10;
                    }
                    stringBuffer.append(E[105]);
                }
                if (this.getTrack() != null) {
                    n2 = this.getTrack().getStaff().getMeasure().getMeasureIndex();
                    int n3 = this.getTrack().getStaff().getStaffIndex();
                    stringBuffer.append(E[115] + n2 + E[111] + n3 + "\n");
                }
                stringBuffer.append(E[96]);
                for (n2 = 0; n2 < this.c.length; ++n2) {
                    stringBuffer.append(this.c[n2]);
                    if (n2 >= this.c.length - 1) continue;
                    stringBuffer.append(E[113]);
                    if (!bl) continue;
                }
                stringBuffer.append(E[117]);
                stringBuffer.append(E[102] + this.getNumDots() + E[113]);
                stringBuffer.append(E[114] + this.getNumTails() + E[113]);
                stringBuffer.append(E[108]);
                if (this.getNoteHeadType() != 0) break block12;
                stringBuffer.append(E[104]);
                if (!bl) break block13;
            }
            stringBuffer.append(E[107]);
        }
        if (this.getTuplet() != 0) {
            stringBuffer.append(E[100] + this.getTuplet() + E[113]);
        }
        stringBuffer.append(E[98] + coreDurationNames[this.getNoteDur()] + E[113]);
        stringBuffer.append(E[103] + this.getLevel() + "\n");
        stringBuffer.append(E[110] + this.getTiedOut() + "\n");
        stringBuffer.append(E[109] + Note.dynamicToString(this.getDynamic()) + "\n");
        stringBuffer.append(E[112] + this.getSlurredOut() + "\n");
        stringBuffer.append(E[99] + this.getCrescOut() + "\n");
        stringBuffer.append(E[118] + this.getDecrescOut() + "\n");
        stringBuffer.append(E[97] + this.is8va() + "\n");
        stringBuffer.append(E[101] + this.is8vb() + "\n");
        stringBuffer.append(E[95] + Note.markToString(this.getMark()));
        return stringBuffer.toString();
    }

    public void setXPositionsOfGraceNotes() {
        boolean bl = Score.zb;
        double d2 = this.getScore().getScoreLayoutManager().getZoom();
        double d3 = 0.0;
        if (this.getAcc() != 0 && !this.getAccHidden()) {
            d3 = 12.0 * d2;
        }
        for (int i2 = 0; i2 < this.getGraceNotes().size(); ++i2) {
            Note note = (Note)this.getGraceNotes().elementAt(i2);
            int n2 = this.getGraceNotes().size() - i2;
            this.a(d2, d3, note, n2);
            if (!note.isChord()) continue;
            for (int i3 = 0; i3 < note.getIntervals().size(); ++i3) {
                Note note2 = (Note)note.getIntervals().elementAt(i3);
                this.a(d2, d3, note2, n2);
                if (!bl) continue;
            }
            if (!bl) continue;
        }
    }

    private void a(double d2, double d3, Note note, int n2) {
        ((Point2D.Double)note.getDrawingAnchor()).x = this.getDrawingAnchor().getX() - (double)(n2 * 12) * d2 * 1.2 - d3;
    }

    public void render(Graphics graphics, double d2) {
        block3: {
            block2: {
                double d3 = d2 * GRACE_NOTE_SIZE_SCALER;
                this.a(graphics, d3);
                if (!this.isChord()) break block2;
                this.b(graphics, d3);
                NoteRenderer.b(graphics, d2, this);
                if (!Score.zb) break block3;
            }
            NoteRenderer.render(graphics, d2, this);
        }
    }

    private void a(Graphics graphics, double d2) {
        boolean bl = Score.zb;
        for (int i2 = 0; i2 < this.getGraceNotes().size(); ++i2) {
            Note note = (Note)this.getGraceNotes().elementAt(i2);
            if (note.isChord()) {
                NoteRenderer.b(graphics, d2, note);
                if (!bl) continue;
            }
            NoteRenderer.render(graphics, d2, note);
            if (!bl) continue;
        }
    }

    private void b(Graphics graphics, double d2) {
        boolean bl = Score.zb;
        for (int i2 = 0; i2 < this.getIntervals().size(); ++i2) {
            Note note = (Note)this.getIntervals().elementAt(i2);
            for (int i3 = 0; i3 < note.getGraceNotes().size(); ++i3) {
                Note note2 = (Note)note.getGraceNotes().elementAt(i3);
                if (note2.isChord()) {
                    NoteRenderer.b(graphics, d2, note2);
                    if (!bl) continue;
                }
                NoteRenderer.render(graphics, d2, note2);
                if (!bl) continue;
            }
            if (!bl) continue;
        }
    }

    public static double tupletDur(int n2, double d2) {
        double d3 = Math.pow(2.0, JMSLMath.highestPowerOfTwoLessThan((int)n2)) * d2;
        return d3 / (double)n2;
    }

    public static void resortChord(Note note) {
        Note note2;
        Note note3;
        boolean bl;
        block6: {
            block5: {
                bl = Score.zb;
                note3 = Note.getRoot(note);
                if (note.getHandle() == null) break block5;
                note2 = note.getHandle();
                if (!bl) break block6;
            }
            note2 = note;
        }
        if (note3.getPitchData() == note2.getPitchData()) {
            Note.d(note3.getIntervals());
            return;
        }
        note3.setHandle(null);
        note3.addInterval(note2);
        note2.removeInterval(note3);
        Object object = note2.getIntervals().elements();
        while (object.hasMoreElements()) {
            note3.addInterval((Note)object.nextElement());
            if (!bl) continue;
        }
        note2.clearIntervals();
        Note.d(note3.getIntervals());
        object = note3.getTrack();
        int n2 = object.getChildren().indexOf(note2);
        object.getChildren().removeElement(note2);
        ((Track)((Object)object)).insertNote(note3, n2);
    }

    public static Note[] getSortedChord(Note note) {
        int n2 = 1;
        if (note.isChord()) {
            n2 += note.getIntervals().size();
        }
        Note[] noteArray = new Note[n2];
        noteArray[0] = note;
        int n3 = 1;
        Enumeration enumeration = note.getIntervals().elements();
        while (enumeration.hasMoreElements()) {
            noteArray[n3++] = (Note)enumeration.nextElement();
            if (!Score.zb) continue;
        }
        Note.a(noteArray);
        return noteArray;
    }

    static void d(Vector vector) {
        boolean bl = Score.zb;
        boolean bl2 = false;
        while (!bl2) {
            bl2 = true;
            for (int i2 = 0; i2 < vector.size() - 1; ++i2) {
                Note note = (Note)vector.elementAt(i2);
                Note note2 = (Note)vector.elementAt(i2 + 1);
                if (!(note.getPitchData() > note2.getPitchData())) continue;
                bl2 = false;
                Note note3 = note;
                vector.setElementAt((Note)vector.elementAt(i2 + 1), i2);
                vector.setElementAt(note3, i2 + 1);
                if (!bl) continue;
            }
            if (!bl) continue;
        }
    }

    static void a(Note[] noteArray) {
        boolean bl = Score.zb;
        boolean bl2 = false;
        while (!bl2) {
            bl2 = true;
            for (int i2 = 0; i2 < noteArray.length - 1; ++i2) {
                Note note = noteArray[i2];
                Note note2 = noteArray[i2 + 1];
                if (!(note.getPitchData() > note2.getPitchData())) continue;
                bl2 = false;
                Note note3 = note;
                noteArray[i2] = noteArray[i2 + 1];
                noteArray[i2 + 1] = note3;
                if (!bl) continue;
            }
            if (!bl) continue;
        }
    }

    public static Note getRoot(Note note) {
        Note note2;
        boolean bl;
        block6: {
            block5: {
                bl = Score.zb;
                if (note.getHandle() == null) break block5;
                note2 = note.getHandle();
                if (!bl) break block6;
            }
            note2 = note;
        }
        Enumeration enumeration = note2.getIntervals().elements();
        while (enumeration.hasMoreElements()) {
            Note note3 = (Note)enumeration.nextElement();
            if (note3.getPitchData() < note2.getPitchData()) {
                note2 = note3;
            }
            if (!bl) continue;
        }
        return note2;
    }

    public static Note getHighest(Note note) {
        Note note2;
        boolean bl;
        block7: {
            block6: {
                bl = Score.zb;
                if (note.isMonoNote()) {
                    return note;
                }
                if (note.getHandle() == null) break block6;
                note2 = note.getHandle();
                if (!bl) break block7;
            }
            note2 = note;
        }
        Enumeration enumeration = note2.getIntervals().elements();
        while (enumeration.hasMoreElements()) {
            Note note3 = (Note)enumeration.nextElement();
            if (note3.getPitchData() > note2.getPitchData()) {
                note2 = note3;
            }
            if (!bl) continue;
        }
        return note2;
    }

    public static Note getLowest(Note note) {
        Note note2;
        boolean bl;
        block7: {
            block6: {
                bl = Score.zb;
                if (note.isMonoNote()) {
                    return note;
                }
                if (note.getHandle() == null) break block6;
                note2 = note.getHandle();
                if (!bl) break block7;
            }
            note2 = note;
        }
        Enumeration enumeration = note2.getIntervals().elements();
        while (enumeration.hasMoreElements()) {
            Note note3 = (Note)enumeration.nextElement();
            if (note3.getPitchData() < note2.getPitchData()) {
                note2 = note3;
            }
            if (!bl) continue;
        }
        return note2;
    }

    public void writeXML(PrintWriter printWriter) throws IOException {
        this.writeXML(printWriter, true);
    }

    public void writeXML(PrintWriter printWriter, boolean bl) throws IOException {
        XMLString xMLString;
        block38: {
            block39: {
                boolean bl2;
                block37: {
                    int n2;
                    CharSequence charSequence;
                    block36: {
                        block35: {
                            String string;
                            block34: {
                                block33: {
                                    String string2;
                                    block32: {
                                        block31: {
                                            block29: {
                                                block30: {
                                                    block28: {
                                                        bl2 = Score.zb;
                                                        xMLString = new XMLString();
                                                        if (!this.isInterval()) break block28;
                                                        xMLString.startElement(E[5], false);
                                                        if (!bl2) break block29;
                                                    }
                                                    if (!this.isGraceNote()) break block30;
                                                    xMLString.startElement(E[0], false);
                                                    if (!bl2) break block29;
                                                }
                                                xMLString.startElement(E[26], false);
                                            }
                                            xMLString.addAttribute(E[11], this.getNoteDur() + "");
                                            xMLString.addAttribute(E[13], this.getTuplet() + "");
                                            xMLString.addAttribute(E[44], this.getNumDots() + "");
                                            xMLString.addAttribute(E[46], this.getAcc() + "");
                                            xMLString.addAttribute(E[32], this.getDurationData() + "");
                                            xMLString.addAttribute(E[10], this.getPitchData() + "");
                                            xMLString.addAttribute(E[2], this.getVelData() + "");
                                            xMLString.addAttribute(E[41], this.getHoldData() + "");
                                            xMLString.addAttribute(E[22], this.getBeamedOut() + "");
                                            xMLString.addAttribute(E[38], this.getGlissOut() + "");
                                            xMLString.addAttribute(E[6], this.getTiedOut() + "");
                                            xMLString.addAttribute(E[8], this.getAccPref() + "");
                                            xMLString.addAttribute(E[42], this.getAccidentalVisibilityPolicy() + "");
                                            xMLString.addAttribute(E[39], this.getAltEnharmonicSpelling() + "");
                                            xMLString.addAttribute(E[3], this.getDynamic() + "");
                                            xMLString.addAttribute(E[20], this.getSlurredOut() + "");
                                            xMLString.addAttribute(E[1], this.isGraceNote() + "");
                                            string2 = E[17];
                                            if (!this.getCrescOut()) break block31;
                                            string2 = E[23];
                                            if (!bl2) break block32;
                                        }
                                        if (this.getDecrescOut()) {
                                            string2 = E[36];
                                        }
                                    }
                                    xMLString.addAttribute(E[40], string2 + "");
                                    string = E[17];
                                    if (!this.is8va()) break block33;
                                    string = E[4];
                                    if (!bl2) break block34;
                                }
                                if (this.is8vb()) {
                                    string = E[33];
                                }
                            }
                            xMLString.addAttribute(E[21], string + "");
                            if (this.getMark() != 0) break block35;
                            xMLString.addAttribute(E[15], this.getMark() + "");
                            if (!bl2) break block36;
                        }
                        charSequence = new StringBuffer();
                        for (n2 = 0; n2 < this.getMarks().size(); ++n2) {
                            int n3 = (Integer)this.getMarks().elementAt(n2);
                            charSequence.append(n3 + "");
                            if (n2 >= this.getMarks().size() - 1) continue;
                            charSequence.append("_");
                            if (!bl2) continue;
                        }
                        xMLString.addAttribute(E[15], charSequence.toString());
                    }
                    xMLString.addAttribute(E[24], this.getTextOffsetX() + "");
                    xMLString.addAttribute(E[30], this.getTextOffsetY() + "");
                    xMLString.addAttribute(E[16], this.getNoteHeadType() + "");
                    xMLString.addAttribute(E[12], this.isVisible() + "");
                    xMLString.addAttribute(E[45], this.isNoteheadVisible() + "");
                    xMLString.addAttribute(E[28], this.isStemVisible() + "");
                    xMLString.addAttribute(E[43], this.getOverrideLevel() + "");
                    xMLString.addAttribute(E[34], this.isOverrideLevel() + "");
                    xMLString.addAttribute(E[31], this.getStemInfoOverride() + "");
                    xMLString.addAttribute(E[37], this.getStemInfo() + "");
                    if (this.y != null) {
                        xMLString.addAttribute(E[19], this.y.getRed() + "");
                        xMLString.addAttribute(E[7], this.y.getGreen() + "");
                        xMLString.addAttribute(E[18], this.y.getBlue() + "");
                    }
                    charSequence = "";
                    if (this.getText() != null) {
                        charSequence = XMLString.encodeQuotes((String)this.getText());
                    }
                    xMLString.addAttribute(E[14], (String)charSequence);
                    xMLString.endElement(null, true);
                    printWriter.println(xMLString);
                    if (this.b != null && this.b.dimension() > 4) {
                        for (n2 = 4; n2 < this.b.dimension(); ++n2) {
                            xMLString = new XMLString();
                            xMLString.startElement(E[9], false);
                            xMLString.addAttribute(E[29], n2 + "");
                            xMLString.addAttribute(E[27], this.getDoubleArray()[n2] + "");
                            xMLString.addAttribute(E[35], this.b.getDimensionName(n2));
                            xMLString.endElement(null, false);
                            printWriter.println(xMLString);
                            if (!bl2) continue;
                        }
                    }
                    if (this.isChord() && bl) {
                        Enumeration enumeration = this.f.elements();
                        while (enumeration.hasMoreElements()) {
                            Note note = (Note)enumeration.nextElement();
                            note.writeXML(printWriter);
                            if (!bl2) continue;
                        }
                    }
                    if (this.getGraceNotes().size() > 0) {
                        Enumeration enumeration = this.getGraceNotes().elements();
                        while (enumeration.hasMoreElements()) {
                            Note note = (Note)enumeration.nextElement();
                            note.writeXML(printWriter);
                            if (!bl2) continue;
                        }
                    }
                    if (this.a != null) {
                        Enumeration enumeration = this.a.elements();
                        while (enumeration.hasMoreElements()) {
                            Object e2 = enumeration.nextElement();
                            SimpleXMLSaver simpleXMLSaver = new SimpleXMLSaver(e2, E[25]);
                            simpleXMLSaver.writeXML(printWriter);
                            if (!bl2) continue;
                        }
                    }
                    xMLString = new XMLString();
                    if (this.isInterval() || this.isGraceNote()) break block37;
                    xMLString.endElement(E[26], true);
                    if (!bl2) break block38;
                }
                if (!this.isGraceNote()) break block39;
                xMLString.endElement(E[0], true);
                if (!bl2) break block38;
            }
            xMLString.endElement(E[5], true);
        }
        printWriter.println(xMLString);
    }

    public void setDimensionNameSpace(DimensionNameSpace dimensionNameSpace) {
        this.b = dimensionNameSpace;
    }

    public DimensionNameSpace getDimensionNameSpace() {
        return this.b;
    }

    public double[] getDoubleArray() {
        return this.getData();
    }

    public void setDoubleArray(double[] dArray) {
        this.c = new double[dArray.length];
        this.d = new double[dArray.length];
        System.arraycopy(dArray, 0, this.c, 0, this.c.length);
    }

    public static boolean firstNoteOfLine(Note note) {
        if (note == null || note.getTrack() == null || note.getTrack().getStaff() == null || note.getTrack().getStaff().getMeasure() == null) {
            return false;
        }
        return note.getTrack().getStaff().getMeasure().isBeginningOfLine() && note.getNoteIndex() == 0;
    }

    public static boolean lastNoteOfLine(Note note) {
        if (note == null || note.getTrack() == null || note.getTrack().getStaff() == null || note.getTrack().getStaff().getMeasure() == null) {
            return false;
        }
        boolean bl = note.getTrack().getStaff().getMeasure().f();
        boolean bl2 = note.getNoteIndex() == note.getTrack().size() - 1;
        return bl && bl2;
    }

    public void setText(String string) {
        this.t = string;
    }

    public String getText() {
        return this.t;
    }

    public void setTextOffsetX(int n2) {
        this.u = n2;
    }

    public int getTextOffsetX() {
        return this.u;
    }

    public void setTextOffsetY(int n2) {
        this.v = n2;
    }

    public int getTextOffsetY() {
        return this.v;
    }

    public static void main(String[] stringArray) {
    }

    public Vector getUserBeans() {
        return this.a;
    }

    public void addUserBean(Object object) {
        this.a.addElement(object);
    }

    public void removeUserBean(Object object) {
        this.a.removeElement(object);
    }

    public int getAccidentalOffset() {
        return this.x;
    }

    public void setAccidentalOffset(int n2) {
        this.x = n2;
    }

    public Color getNoteheadColor() {
        return this.y;
    }

    public void setNoteheadColor(Color color) {
        this.y = color;
    }

    static {
        String[] stringArray = new String[121];
        Object var0 = null;
        copyright = Note.z(Note.z("\u0016DDoW\u001cL\\b\u0005]h\u001d6\u0017E\u001b\u00046k\u001cH_6a\u001cO_yS\u0006@M:\u0005\u0014GX6W\u001cL\\bVUYQe@\u0007]Qr"));
        var0 = null;
        stringArray[0] = Note.z(Note.z("\u0012YUu@\u001bD@s"));
        var0 = null;
        stringArray[1] = Note.z(Note.z("<xsDd6nzYq0"));
        var0 = null;
        stringArray[2] = Note.z(Note.z("#nxYf<\u007fm"));
        var0 = null;
        stringArray[3] = Note.z(Note.z("1rz"));
        var0 = null;
        stringArray[4] = Note.z(Note.z("4g`W"));
        var0 = null;
        stringArray[5] = Note.z(Note.z("\u001cE@sW\u0003JX"));
        var0 = null;
        stringArray[6] = Note.z(Note.z("!bqRj \u007f"));
        var0 = null;
        stringArray[7] = Note.z(Note.z(";d`Sm0jpQw0nz"));
        var0 = null;
        stringArray[8] = Note.z(Note.z("4hwFw0m"));
        var0 = null;
        stringArray[9] = Note.z(Note.z("\u0011BY"));
        var0 = null;
        stringArray[10] = Note.z(Note.z("%b`Um"));
        var0 = null;
        stringArray[11] = Note.z(Note.z(";d`Sa y"));
        var0 = null;
        stringArray[12] = Note.z(Note.z("#bg_g9n"));
        var0 = null;
        stringArray[13] = Note.z(Note.z("!~dZ`!"));
        var0 = null;
        stringArray[14] = Note.z(Note.z("!nlB"));
        var0 = null;
        stringArray[15] = Note.z(Note.z("8jf]"));
        var0 = null;
        stringArray[16] = Note.z(Note.z(";d`Sm0jp"));
        var0 = null;
        stringArray[17] = Note.z(Note.z("\u001bDZs"));
        var0 = null;
        stringArray[18] = Note.z(Note.z(";d`Sm0jpTi n"));
        var0 = null;
        stringArray[19] = Note.z(Note.z(";d`Sm0jpD`1"));
        var0 = null;
        stringArray[20] = Note.z(Note.z("&gaDj \u007f"));
        var0 = null;
        stringArray[21] = Note.z(Note.z(":\u007f`Ws4"));
        var0 = null;
        stringArray[22] = Note.z(Note.z("7nu[`1daB"));
        var0 = null;
        stringArray[23] = Note.z(Note.z("\u0016YQeF"));
        var0 = null;
        stringArray[24] = Note.z(Note.z("!nlBj3mgSq-"));
        var0 = null;
        stringArray[25] = Note.z(Note.z("\u0000XQdg\u0010JZ"));
        var0 = null;
        stringArray[26] = Note.z(Note.z("\u001bD@s"));
        var0 = null;
        stringArray[27] = Note.z(Note.z("\u0003JXc@"));
        var0 = null;
        stringArray[28] = Note.z(Note.z("&\u007fq[s<x}Ti0"));
        var0 = null;
        stringArray[29] = Note.z(Note.z("\u001cEPs]"));
        var0 = null;
        stringArray[30] = Note.z(Note.z("!nlBj3mgSq,"));
        var0 = null;
        stringArray[31] = Note.z(Note.z("&\u007fq[l;m{Ys0yf_a0"));
        var0 = null;
        stringArray[32] = Note.z(Note.z("1~fWq<dz"));
        var0 = null;
        stringArray[33] = Note.z(Note.z("7jgEd"));
        var0 = null;
        stringArray[34] = Note.z(Note.z("<x{@`'y}R`9nbSi"));
        var0 = null;
        stringArray[35] = Note.z(Note.z("\u001bJYs"));
        var0 = null;
        stringArray[36] = Note.z(Note.z("\u0011NWd@\u0006H"));
        var0 = null;
        stringArray[37] = Note.z(Note.z("&\u007fq[l;m{"));
        var0 = null;
        stringArray[38] = Note.z(Note.z("2g}Ev:~`"));
        var0 = null;
        stringArray[39] = Note.z(Note.z("4g`Sk=jf[j;bw"));
        var0 = null;
        stringArray[40] = Note.z(Note.z("\"npQ`"));
        var0 = null;
        stringArray[41] = Note.z(Note.z("=dxR"));
        var0 = null;
        stringArray[42] = Note.z(Note.z("4hw@l&{{Zl6r"));
        var0 = null;
        stringArray[43] = Note.z(Note.z(":}qDw<oqZ`#nx"));
        var0 = null;
        stringArray[44] = Note.z(Note.z("1d`E"));
        var0 = null;
        stringArray[45] = Note.z(Note.z(";d`Sm0jp@l&bvZ`"));
        var0 = null;
        stringArray[46] = Note.z(Note.z("4hw_k3d"));
        var0 = null;
        stringArray[47] = Note.z(Note.z("\u0012N@XJ\u0001NpcW\u0014_]yK4XdsW\u0013DF{D\u001bHQBL\u0018N\u001c?\u0005\u0014YS6H\u0000X@6G\u0010\u000bWyK\u0006_UxQU\u001b\u001a8\u0012O\u000b"));
        var0 = null;
        stringArray[48] = Note.z(Note.z("J\u0014\u000b"));
        var0 = null;
        stringArray[49] = Note.z(Note.z("4hwIv=jfF"));
        var0 = null;
        stringArray[50] = Note.z(Note.z("4hwIk:eq"));
        var0 = null;
        stringArray[51] = Note.z(Note.z("4hwIa:~vZ`*x|Ww%"));
        var0 = null;
        stringArray[52] = Note.z(Note.z("4hwIk4\u007faDd9"));
        var0 = null;
        stringArray[53] = Note.z(Note.z("4hwIa:~vZ`*mxWq"));
        var0 = null;
        stringArray[54] = Note.z(Note.z("<ebWi<o\u0014Wf6bpSk!jx6s4gaS\u0005"));
        var0 = null;
        stringArray[55] = Note.z(Note.z("4hwIc9j`"));
        var0 = null;
        stringArray[56] = Note.z(Note.z("\"NPq@Xx@wF\u0016J@y"));
        var0 = null;
        stringArray[57] = Note.z(Note.z("\u0018DFr@\u001b_"));
        var0 = null;
        stringArray[58] = Note.z(Note.z("7DCsAU\u007fFsH\u001aG[6\rF\u0019Zr\f"));
        var0 = null;
        stringArray[59] = Note.z(Note.z("&_UuF\u0014_["));
        var0 = null;
        stringArray[60] = Note.z(Note.z("\u001cEBsW\u0001NP;H\u001aYPsK\u0001"));
        var0 = null;
        stringArray[61] = Note.z(Note.z("!Y]zIXx\\wW\u0005"));
        var0 = null;
        stringArray[62] = Note.z(Note.z("4HWsK\u0001\u0006`sK\u0000_["));
        var0 = null;
        stringArray[63] = Note.z(Note.z("4HW\u007fD\u0016HUbP\u0007J"));
        var0 = null;
        stringArray[64] = Note.z(Note.z("4HWsK\u0001"));
        var0 = null;
        stringArray[65] = Note.z(Note.z("!NZcQ\u001a"));
        var0 = null;
        stringArray[66] = Note.z(Note.z("\"NPq@"));
        var0 = null;
        stringArray[67] = Note.z(Note.z("!Y]zIXeUbP\u0007JX"));
        var0 = null;
        stringArray[68] = Note.z(Note.z("!Y]zIXmXwQ"));
        var0 = null;
        stringArray[69] = Note.z(Note.z("7DCsAU\u007fFsH\u001aG[6\rD\u001d@~\f"));
        var0 = null;
        stringArray[70] = Note.z(Note.z("\u0018JF}z\u001bDZs"));
        var0 = null;
        stringArray[71] = Note.z(Note.z("4HWsK\u0001\u0006gbD\u0016HUbJ"));
        var0 = null;
        stringArray[72] = Note.z(Note.z("!Y]zI"));
        var0 = null;
        stringArray[73] = Note.z(Note.z("3NF{D\u0001J"));
        var0 = null;
        stringArray[74] = Note.z(Note.z("7DCsAU\u007fFsH\u001aG[6\rM_\\?"));
        var0 = null;
        stringArray[75] = Note.z(Note.z("=JF{J\u001bBW"));
        var0 = null;
        stringArray[76] = Note.z(Note.z(";D@sVUBZ6Q\u001dBG6F\u001dDFr\u001fU"));
        var0 = null;
        stringArray[77] = Note.z(Note.z(":MRsK\u0011BZq\u0005;D@s\u001fU"));
        var0 = null;
        stringArray[78] = Note.z(Note.z("\"jfXl;l\u00157\u0004Uj@b@\u0018[@sAU_[6D\u0011O\u0014rP\u0005G]uD\u0001N\u0014xJ\u0001N\u0014bJUH\\yW\u0011\n\u00157\u0004U[]bF\u001d\u0016"));
        var0 = null;
        stringArray[79] = Note.z(Note.z("\"jfXl;l\u00157\u0004UhUxK\u001a_\u0014wA\u0011\u000bFsV\u0001X\u0014bJUH\\yW\u0011X\u0014yWUJPr\u0005\u001cE@sW\u0003JXe\u0005\u0001D\u0014w\u0005\u0007NGb\u0004"));
        var0 = null;
        stringArray[80] = Note.z(Note.z(";D@s\u000b\u0016G[x@;D@s\r\\\u000bQdW\u001aY\u000e6"));
        var0 = null;
        stringArray[81] = Note.z(Note.z("\u0011RZwH\u001cHkxJ\u001bN"));
        var0 = null;
        stringArray[82] = Note.z(Note.z("\u0013MR"));
        var0 = null;
        stringArray[83] = Note.z(Note.z("\u0013M"));
        var0 = null;
        stringArray[84] = Note.z(Note.z("\u0005[D"));
        var0 = null;
        stringArray[85] = Note.z(Note.z("\u0018M"));
        var0 = null;
        stringArray[86] = Note.z(Note.z("\u0018["));
        var0 = null;
        stringArray[87] = Note.z(Note.z("\u0005["));
        var0 = null;
        stringArray[88] = Note.z(Note.z("UfQwVV\u0011\u0014"));
        var0 = null;
        stringArray[89] = Note.z(Note.z("<e`Sw#jx"));
        var0 = null;
        stringArray[90] = Note.z(Note.z(";^Xz\u0005\u001cEGbP\u0018NZb\tUE[b@UOUbDO\u000b"));
        var0 = null;
        stringArray[91] = Note.z(Note.z("9nbSiO\u000b"));
        var0 = null;
        stringArray[92] = Note.z(Note.z("Ue[6Q\u0007JW}\n\u0006_UpCZFQwV\u0000YQ6"));
        var0 = null;
        stringArray[93] = Note.z(Note.z("Y\u000b`d\u0006O\u000b"));
        var0 = null;
        stringArray[94] = Note.z(Note.z("Y\u000bgb\u0006O\u000b"));
        var0 = null;
        stringArray[95] = Note.z(Note.z("|fUdNO\u000b"));
        var0 = null;
        stringArray[96] = Note.z(Note.z("|e[b@RX\u0014f@\u0007M[dH\u0014IXs\u0005\u0011J@w\u001fU\u0003\u0014"));
        var0 = null;
        stringArray[97] = Note.z(Note.z("|\u0013Bw\u0005\u001a^@,\u0005"));
        var0 = null;
        stringArray[98] = Note.z(Note.z("1^F,\u0005"));
        var0 = null;
        stringArray[99] = Note.z(Note.z("|hFsV\u0016\u000b[cQO\u000b"));
        var0 = null;
        stringArray[100] = Note.z(Note.z("!^Dz@\u0001\u0011\u0014"));
        var0 = null;
        stringArray[101] = Note.z(Note.z("|\u0013Bt\u0005\u001a^@,\u0005"));
        var0 = null;
        stringArray[102] = Note.z(Note.z("|o[bVO\u000b"));
        var0 = null;
        stringArray[103] = Note.z(Note.z("9NBsIO\u000b"));
        var0 = null;
        stringArray[104] = Note.z(Note.z("7guUnY\u000b"));
        var0 = null;
        stringArray[105] = Note.z(Note.z("\u0018DZyU\u001dDZ\u007fF\u007f"));
        var0 = null;
        stringArray[106] = Note.z(Note.z(";d`S\u0005"));
        var0 = null;
        stringArray[107] = Note.z(Note.z("\"c}B`Y\u000b"));
        var0 = null;
        stringArray[108] = Note.z(Note.z(";D@sM\u0010JP,\u0005"));
        var0 = null;
        stringArray[109] = Note.z(Note.z("|oMxD\u0018BW,\u0005"));
        var0 = null;
        stringArray[110] = Note.z(Note.z("|\u007f]sAUdAb\u001fU"));
        var0 = null;
        stringArray[111] = Note.z(Note.z("Y\u000bgbD\u0013M\u0014"));
        var0 = null;
        stringArray[112] = Note.z(Note.z("|xXcWUDAb\u001fU"));
        var0 = null;
        stringArray[113] = Note.z(Note.z("Y\u000b"));
        var0 = null;
        stringArray[114] = Note.z(Note.z("!J]zVO\u000b"));
        var0 = null;
        stringArray[115] = Note.z(Note.z("|fQwV\u0000YQ6"));
        var0 = null;
        stringArray[116] = Note.z(Note.z("UBZb@\u0007]UzV\u007f"));
        var0 = null;
        stringArray[117] = Note.z(Note.z("U\u0002>"));
        var0 = null;
        stringArray[118] = Note.z(Note.z("|oQuW\u0010XW6J\u0000_\u000e6"));
        var0 = null;
        stringArray[119] = Note.z(Note.z("6C[dAUCUxA\u0019N\u0014aL\u0001C\u0014"));
        var0 = null;
        stringArray[120] = Note.z(Note.z("6C[dAUBZb@\u0007]Uz/"));
        E = stringArray;
        ACCIDENTAL_SHOW_NORMAL = 0;
        ACCIDENTAL_SHOW_NEVER = 1;
        ACCIDENTAL_SHOW_ALWAYS = (byte)2;
        GRACE_NOTE_SIZE_SCALER = 0.5;
        DBUG = false;
        coreDurations = new double[]{4.0, 2.0, 1.0, 0.5, 0.25, 0.125, 0.0625, 0.03125, 0.015625};
        String[] stringArray2 = new String[9];
        stringArray2[0] = "w";
        stringArray2[1] = "h";
        stringArray2[2] = "q";
        stringArray2[3] = "e";
        stringArray2[4] = "s";
        var0 = null;
        stringArray2[5] = Note.z(Note.z("F\u0019"));
        var0 = null;
        stringArray2[6] = Note.z(Note.z("C\u001f"));
        var0 = null;
        stringArray2[7] = Note.z(Note.z("D\u0019\f"));
        var0 = null;
        stringArray2[8] = Note.z(Note.z("G\u001e\u0002"));
        coreDurationNames = stringArray2;
        String[] stringArray3 = new String[15];
        var0 = null;
        stringArray3[0] = Note.z(Note.z("\u0017GUuN"));
        var0 = null;
        stringArray3[1] = Note.z(Note.z("\u0002C]b@"));
        stringArray3[2] = "X";
        var0 = null;
        stringArray3[3] = Note.z(Note.z("-\u000b[`D\u0019"));
        var0 = null;
        stringArray3[4] = Note.z(Note.z("-\u000bP\u007fD\u0018DZr"));
        var0 = null;
        stringArray3[5] = Note.z(Note.z("\u0002C]b@UO]wH\u001aEP"));
        var0 = null;
        stringArray3[6] = Note.z(Note.z("\u0017GUuNUO]wH\u001aEP"));
        var0 = null;
        stringArray3[7] = Note.z(Note.z("\u0002C]b@U_F\u007fD\u001bLXs"));
        var0 = null;
        stringArray3[8] = Note.z(Note.z("\u0017GUuNU_F\u007fD\u001bLXs"));
        var0 = null;
        stringArray3[9] = Note.z(Note.z("\u0002C]b@UBZ`@\u0007_Qr\u0005\u0001Y]wK\u0012GQ"));
        var0 = null;
        stringArray3[10] = Note.z(Note.z("\u0017GUuNUBZ`@\u0007_Qr\u0005\u0001Y]wK\u0012GQ"));
        var0 = null;
        stringArray3[11] = Note.z(Note.z("\u0017YQ`@"));
        var0 = null;
        stringArray3[12] = Note.z(Note.z("\u0006GUeM"));
        var0 = null;
        stringArray3[13] = Note.z(Note.z("\u0007NGsW\u0003NP6\u0014"));
        var0 = null;
        stringArray3[14] = Note.z(Note.z("\u0007NGsW\u0003NP6\u0017"));
        noteheadNames = stringArray3;
        w = true;
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n2;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n3 = cArray3.length;
                cArray = cArray4;
                n2 = n3;
                if (n3 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n2 == 0);
            cArray = cArray4;
            n2 = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x25);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n2;
            int n3;
            char[] cArray3;
            int n4;
            block9: {
                n4 = 0;
                int n5 = cArray.length;
                cArray3 = cArray;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray2 = cArray3;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 117;
                            break;
                        }
                        case 1: {
                            n7 = 43;
                            break;
                        }
                        case 2: {
                            n7 = 52;
                            break;
                        }
                        case 3: {
                            n7 = 22;
                            break;
                        }
                        default: {
                            n7 = 37;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray3 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray3;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n2 = n3;
            } while (n3 > n4);
        }
        return new String(cArray2).intern();
    }
}

