/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jmsl.jsyn2.unitvoices;

import com.jsyn.data.SegmentedEnvelope;
import com.jsyn.data.SequentialData;
import com.jsyn.instruments.WaveShapingVoice;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitPort;
import com.jsyn.unitgen.Add;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.InterpolatingDelay;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitSink;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.unitgen.VariableRateMonoReader;
import com.softsynth.jmsl.JMSL;
import com.softsynth.jmsl.MusicJob;
import com.softsynth.jmsl.jsyn2.JSynMusicDevice;
import com.softsynth.jmsl.jsyn2.unitvoices.VariableRateReaderUnitVoice;
import com.softsynth.shared.time.TimeStamp;

public class DelayWithFeedback
extends Circuit
implements UnitVoice,
UnitSink {
    private VariableRateMonoReader a;
    private InterpolatingDelay b;
    private Multiply c;
    private SegmentedEnvelope d;
    private Add e;
    private Multiply f;
    public UnitInputPort delay;
    public UnitInputPort feedback;
    public UnitInputPort amplitude;

    public DelayWithFeedback() {
        boolean bl = VariableRateReaderUnitVoice.k;
        this.b = new InterpolatingDelay();
        this.add((UnitGenerator)this.b);
        this.b.allocate(88200);
        this.b.delay.set(0.8);
        this.c = new Multiply();
        this.add((UnitGenerator)this.c);
        this.f = new Multiply();
        this.add((UnitGenerator)this.f);
        this.e = new Add();
        this.add((UnitGenerator)this.e);
        this.a = new VariableRateMonoReader();
        this.add((UnitGenerator)this.a);
        this.a.output.connect(this.c.inputB);
        this.c.output.connect(this.e.inputA);
        this.e.output.connect(this.b.input);
        this.b.output.connect(this.f.inputA);
        this.f.output.connect(this.e.inputB);
        double[] dArray = new double[]{0.01, 1.0, 0.01, 0.0};
        this.d = new SegmentedEnvelope(dArray);
        this.delay = this.b.delay;
        this.addPort((UnitPort)this.delay);
        this.feedback = this.f.inputB;
        this.addPort((UnitPort)this.feedback);
        this.amplitude = this.a.amplitude;
        this.addPort((UnitPort)this.amplitude);
        this.delay.setup(0.0, 0.2, 0.5);
        this.feedback.setup(0.0, 0.5, 2.0);
        if (bl) {
            int n2 = MusicJob.w;
            MusicJob.w = ++n2;
        }
    }

    public UnitInputPort getInput() {
        return this.c.inputA;
    }

    public UnitOutputPort getOutput() {
        return this.f.output;
    }

    public void noteOn(double d2, double d3, TimeStamp timeStamp) {
        this.a.dataQueue.queue((SequentialData)this.d, 0, 1, timeStamp);
    }

    public void noteOff(TimeStamp timeStamp) {
        this.a.dataQueue.queue((SequentialData)this.d, 1, 1, timeStamp);
    }

    public static void main(String[] stringArray) {
        JSynMusicDevice jSynMusicDevice = JSynMusicDevice.instance();
        jSynMusicDevice.open();
        LineOut lineOut = new LineOut();
        jSynMusicDevice.add((UnitGenerator)lineOut);
        lineOut.start();
        WaveShapingVoice waveShapingVoice = new WaveShapingVoice();
        jSynMusicDevice.add((UnitGenerator)waveShapingVoice);
        DelayWithFeedback delayWithFeedback = new DelayWithFeedback();
        jSynMusicDevice.add((UnitGenerator)delayWithFeedback);
        waveShapingVoice.getOutput().connect(0, lineOut.input, 0);
        waveShapingVoice.getOutput().connect(0, delayWithFeedback.getInput(), 0);
        delayWithFeedback.getOutput().connect(0, lineOut.input, 1);
        double d2 = JMSL.realTime();
        double d3 = jSynMusicDevice.jmslTimeToJSynTime(d2);
        TimeStamp timeStamp = new TimeStamp(d3 + 2.0);
        TimeStamp timeStamp2 = new TimeStamp(d3 + 2.25);
        TimeStamp timeStamp3 = new TimeStamp(d3 + 3.0);
        waveShapingVoice.noteOn(880.0, 0.2, timeStamp);
        waveShapingVoice.noteOff(timeStamp3);
        double d4 = 0.0;
        delayWithFeedback.noteOn(d4, 0.2, timeStamp);
        delayWithFeedback.noteOff(timeStamp2);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        JMSL.closeMusicDevices();
        System.exit(0);
    }
}

