/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jmsl.util;

import com.softsynth.jmsl.util.Interpolator;

public class ExponentialInterpolator
implements Interpolator {
    private double a;
    private double b;
    private double c;
    private double d;
    private double e = 1.0;
    private double f;
    private double g;
    private double h;
    private double i;

    public ExponentialInterpolator(double d2, double d3, double d4, double d5) {
        this.setInterp(d2, d3, d4, d5);
    }

    public void setInterp(double d2, double d3, double d4, double d5) {
        double d6 = 0.0;
        if (d2 > d4) {
            d6 = d2;
            d2 = d4;
            d4 = d6;
        }
        if (d3 > d5) {
            d6 = d3;
            d3 = d5;
            d5 = d6;
        }
        this.a = d4 - d2;
        this.b = (d5 - d3) / (Math.exp(this.e) - 1.0);
        this.c = d2;
        this.d = d3;
        this.f = d2;
        this.h = d4;
        this.g = d3;
        this.i = d5;
    }

    void a() {
        this.setInterp(this.f, this.g, this.h, this.i);
    }

    public double interp(double d2) {
        return (Math.exp((d2 - this.c) / this.a * this.e) - 1.0) * this.b + this.d;
    }

    public void setSteepness(double d2) {
        this.e = d2;
        this.a();
    }

    public static void main(String[] stringArray) {
        ExponentialInterpolator exponentialInterpolator = new ExponentialInterpolator(0.0, 1.0, 1.0, 1000.0);
        exponentialInterpolator.setSteepness(2.0);
        System.out.println("" + exponentialInterpolator.interp(1.0));
    }
}

