/*
 * Decompiled with CFR 0.152.
 */
package com.punosmusic.jmsl.plugins;

import com.didkovsky.portview.PVFrame;
import com.punosmusic.jmsl.plugins.TranscribingUnaryTransform;
import com.softsynth.jmsl.JMSL;
import com.softsynth.jmsl.JMSLPlugin;
import com.softsynth.jmsl.MusicShape;
import com.softsynth.jmsl.score.Measure;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.ScoreFrame;
import com.softsynth.jmsl.score.ScoreOperator;
import com.softsynth.jmsl.util.BeanEditor;
import com.softsynth.jmsl.util.BooleanListener;
import com.softsynth.jmsl.util.MarkovObjectChooser;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;

public class MarkovOperator
extends TranscribingUnaryTransform
implements BooleanListener,
JMSLPlugin {
    public static final String copyright = "Markov Operator (C) 2006 Nick Didkovsky, didkovn@mail.rockefeller.edu";
    public int numNotes = 17;
    private MusicShape musicShape;

    public String getName() {
        return "Markov Operator";
    }

    protected void unaryMusicShapeOperation(MusicShape musicShape) {
        this.musicShape = musicShape;
        if (musicShape.size() < 2) {
            this.setMessage("Copy at least 2 notes");
            return;
        }
        try {
            this.getUserInputFromEditor();
        }
        catch (HeadlessException e) {
            this.setMessage("ERROR: " + e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            this.setMessage("ERROR: " + e);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            this.setMessage("ERROR: " + e);
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            this.setMessage("ERROR: " + e);
            e.printStackTrace();
        }
    }

    private void operate_impl() {
        System.out.println("markov operating");
        MusicShape source = (MusicShape)this.musicShape.clone();
        this.musicShape.removeAll();
        MarkovObjectChooser chooser = new MarkovObjectChooser();
        double[] lastData = null;
        int i = 0;
        while (i < source.size()) {
            double[] currentData = source.get(i);
            if (lastData != null) {
                chooser.incTransitionProbability((Object)lastData, (Object)currentData);
            }
            lastData = currentData;
            ++i;
        }
        double[] dataState = (double[])chooser.chooseUniformRandomObject();
        int i2 = 0;
        while (i2 < this.getNumNotes()) {
            if ((dataState = (double[])chooser.next((Object)dataState)) == null) {
                dataState = (double[])chooser.chooseUniformRandomObject();
            }
            double[] dataCopy = new double[dataState.length];
            System.arraycopy(dataState, 0, dataCopy, 0, dataState.length);
            this.musicShape.add(dataCopy);
            ++i2;
        }
        this.transcribeMusicShape(this.getScore(), this.musicShape);
    }

    private void getUserInputFromEditor() throws HeadlessException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        System.out.println("getUserInputFromEditor()");
        PVFrame pvFrame = JMSL.getViewFactory().createFrame();
        BeanEditor beanEditor = new BeanEditor((Frame)pvFrame.getComponent(), null, (Object)this, false, (BooleanListener)this);
        beanEditor.setVisible(true);
    }

    public int getNumNotes() {
        return this.numNotes;
    }

    public void setNumNotes(int numNotes) {
        this.numNotes = numNotes;
    }

    public static void main(String[] args) {
        Score score = new Score(2, 800, 600);
        Measure m = score.addMeasure(4, 4);
        m.setTempo(110.0);
        score.addNote(1.0, 60.0, 0.5, 0.8);
        score.addNote(1.0, 62.0, 0.5, 0.8);
        score.addNote(1.0, 63.0, 0.5, 0.8);
        score.addNote(1.0, 65.0, 0.5, 0.8);
        ScoreFrame scoreFrame = new ScoreFrame();
        scoreFrame.addScoreOperator((ScoreOperator)new MarkovOperator());
        scoreFrame.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JMSL.closeMusicDevices();
                System.exit(0);
            }
        });
        scoreFrame.addScore(score);
        scoreFrame.pack();
        scoreFrame.setVisible(true);
    }

    public void booleanSelected(Object object, boolean flag) {
        if (flag) {
            this.operate_impl();
        }
    }
}

