/*
 * Decompiled with CFR 0.152.
 */
package com.punosmusic.jmsl.plugins;

import com.didkovsky.portview.ViewFactory;
import com.didkovsky.portview.swing.ViewFactorySwing;
import com.softsynth.jmsl.JMSL;
import com.softsynth.jmsl.JMSLRandom;
import com.softsynth.jmsl.MusicShape;
import com.softsynth.jmsl.score.CopyBuffer;
import com.softsynth.jmsl.score.Note;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.ScoreFrame;
import com.softsynth.jmsl.score.ScoreOperator;
import com.softsynth.jmsl.score.transcribe.BeatDivisionSchemeList;
import com.softsynth.jmsl.score.transcribe.ElementMissedException;
import com.softsynth.jmsl.score.transcribe.SearchPathListExpansionException;
import com.softsynth.jmsl.score.transcribe.Transcriber;
import com.softsynth.jmsl.util.TimeSignature;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Vector;

public class TranscribingUnaryTransform
implements ScoreOperator {
    private String message = null;
    private Score score;

    public String getName() {
        return "TranscribingUnaryTransform";
    }

    public Score getScore() {
        return this.score;
    }

    protected void unaryMusicShapeOperation(MusicShape musicShape) {
        musicShape.scale(JMSLRandom.choose((double)0.5, (double)2.0), 0, JMSLRandom.choose((int)musicShape.size()), 0);
        musicShape.scramble(0, musicShape.size() - 1, 1);
        this.transcribeMusicShape(this.score, musicShape);
    }

    public void operate(Score score) {
        System.out.println("TranscribingUnaryTransform by Nick Didkovsky, (c) 2006 Nick Didkovsky, all rights reserved");
        this.setScore(score);
        this.setMessage(null);
        if (score.getSelectedMeasure() == null || score.getSelectedStaff() == null) {
            this.setMessage("You must click in an empty measure and staff to select a destination for this operator.");
            return;
        }
        if (score.getSelectedStaff().getTrack(0).size() != 0) {
            this.setMessage("Please select an EMPTY destination staff");
            return;
        }
        if (Score.copyBuffer.size() == 0) {
            this.setMessage("You must first select and COPY notes from the score");
            return;
        }
        MusicShape musicShape = this.copyBufferToMusicShape(Score.copyBuffer);
        if (musicShape != null) {
            this.unaryMusicShapeOperation(musicShape);
        }
    }

    protected MusicShape copyBufferToMusicShape(CopyBuffer copyBuffer) {
        MusicShape musicShape = null;
        Note prevNote = null;
        Enumeration e = copyBuffer.elements();
        while (e.hasMoreElements()) {
            Note note = (Note)e.nextElement();
            if (musicShape == null) {
                musicShape = new MusicShape(note.getDimensionNameSpace());
            }
            if (note.isInterval()) continue;
            if (note.isChord()) {
                Enumeration intervals = note.getIntervals().elements();
                while (intervals.hasMoreElements()) {
                    Note interval = (Note)intervals.nextElement();
                    if (!interval.getSelected()) continue;
                    double[] dataCopy = interval.getPerformanceDataCopy();
                    if (prevNote != null && this.hasIntervalTiedToThisPitch(prevNote, interval)) {
                        dataCopy[1] = 0.0;
                        dataCopy[2] = 0.0;
                        continue;
                    }
                    musicShape.add(dataCopy);
                }
            }
            double[] performanceData = note.getPerformanceDataCopy();
            if (prevNote != null && prevNote.getTiedOut()) {
                performanceData[1] = 0.0;
                performanceData[2] = 0.0;
                if (musicShape.size() > 0) {
                    musicShape.set(musicShape.get(musicShape.size() - 1, 0) + performanceData[0], musicShape.size() - 1, 0);
                } else {
                    musicShape.add(performanceData);
                }
            } else {
                musicShape.add(performanceData);
            }
            prevNote = note;
        }
        return musicShape;
    }

    private boolean hasIntervalTiedToThisPitch(Note prevNote, Note interval) {
        if (!prevNote.isChord()) {
            return false;
        }
        double pitch = interval.getPitchData();
        boolean isTied = false;
        Enumeration e = prevNote.getIntervals().elements();
        while (e.hasMoreElements()) {
            Note n = (Note)e.nextElement();
            if (!n.getTiedOut() || n.getPitchData() != pitch) continue;
            isTied = true;
            break;
        }
        return isTied;
    }

    protected void transcribeMusicShape(Score score, MusicShape musicShape) {
        try {
            BeatDivisionSchemeList.defaultSetup();
            Transcriber transcriber = new Transcriber();
            transcriber.setScore(score);
            score.setCurrentMeasureNumber(score.getSelectedMeasure().getMeasureIndex());
            score.setCurrentStaffNumber(score.getSelectedStaff().getStaffIndex());
            transcriber.setSourceMusicShape(musicShape);
            Vector<TimeSignature> timeSignatures = new Vector<TimeSignature>();
            int i = score.getSelectedMeasure().getMeasureIndex();
            while (i < score.size()) {
                timeSignatures.addElement(score.getMeasure(i).getTimeSig());
                ++i;
            }
            transcriber.setTimeSignatures(timeSignatures);
            musicShape.integrate(0);
            transcriber.transcribe();
            score.render();
        }
        catch (SearchPathListExpansionException e) {
            this.setMessage("ERROR: " + (Object)((Object)e));
            e.printStackTrace();
        }
        catch (ElementMissedException e) {
            this.setMessage("ERROR: " + (Object)((Object)e));
            e.printStackTrace();
        }
    }

    public String getResultString() {
        return this.message;
    }

    public String getMessage() {
        return this.message;
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    public static void main(String[] args) {
        JMSL.setViewFactory((ViewFactory)new ViewFactorySwing());
        Score score = new Score(2, 800, 600);
        score.addMeasure(4, 4);
        score.addMeasure(5, 4);
        score.addMeasure(3, 4);
        final ScoreFrame scoreFrame = new ScoreFrame();
        scoreFrame.addScoreOperator((ScoreOperator)new TranscribingUnaryTransform());
        scoreFrame.addScore(score);
        scoreFrame.setSize(900, 700);
        scoreFrame.setVisible(true);
        scoreFrame.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JMSL.closeMusicDevices();
                scoreFrame.quit();
            }
        });
    }

    public void setScore(Score score) {
        this.score = score;
    }
}

