/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jmsl;

import com.softsynth.jmsl.CompareDim;
import com.softsynth.jmsl.DefaultDimensionNameSpace;
import com.softsynth.jmsl.DimAttributes;
import com.softsynth.jmsl.DimensionComparison;
import com.softsynth.jmsl.DimensionNameSpace;
import com.softsynth.jmsl.DimensionNameSpaceTranslator;
import com.softsynth.jmsl.Instrument;
import com.softsynth.jmsl.InstrumentAdapter;
import com.softsynth.jmsl.JMSL;
import com.softsynth.jmsl.JMSLRandom;
import com.softsynth.jmsl.Limits;
import com.softsynth.jmsl.MusicJob;
import com.softsynth.jmsl.MusicShapeDimensionException;
import com.softsynth.jmsl.PlayLurker;
import com.softsynth.jmsl.util.ObjectArrayEnumerator;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class MusicShape
extends MusicJob
implements Cloneable,
DimensionNameSpace {
    private int x = 0;
    DimAttributes[] y;
    static int z;
    private boolean A;
    private boolean B = true;
    private boolean C = true;
    private static boolean D;
    private boolean E = false;
    private static String[] F;

    public MusicShape(DimensionNameSpace dimensionNameSpace) {
        this(dimensionNameSpace.dimension());
        for (int i2 = 0; i2 < this.dimension(); ++i2) {
            this.setDimensionName(i2, dimensionNameSpace.getDimensionName(i2));
            this.setLimits(i2, dimensionNameSpace.getLowLimit(i2), dimensionNameSpace.getHighLimit(i2));
            this.setDefault(i2, dimensionNameSpace.getDefault(i2));
            if (JMSL.p == 0) continue;
        }
    }

    public MusicShape(int n2) {
        this(new InstrumentAdapter(), n2);
    }

    public MusicShape(Instrument instrument, int n2) {
        this.s = F[22] + z++;
        this.x = n2;
        this.setInstrument(instrument);
        this.y = new DimAttributes[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.y[i2] = new DimAttributes(F[23] + i2);
            this.setLimits(i2, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        this.A = false;
    }

    public Vector getData() {
        return this.u;
    }

    public void useStandardInvariants(boolean bl) {
        this.B = bl;
    }

    public boolean usesStandardInvariants() {
        return this.B;
    }

    public void useStandardDimensionNameSpace() {
        DefaultDimensionNameSpace defaultDimensionNameSpace = DefaultDimensionNameSpace.instance();
        for (int i2 = 0; i2 < Math.min(this.dimension(), defaultDimensionNameSpace.dimension()); ++i2) {
            this.setDimensionName(i2, defaultDimensionNameSpace.getDimensionName(i2));
            this.setLimits(i2, defaultDimensionNameSpace.getLowLimit(i2), defaultDimensionNameSpace.getHighLimit(i2));
            this.setDefault(i2, defaultDimensionNameSpace.getDefault(i2));
            if (JMSL.p == 0) continue;
        }
    }

    public double[] getDefaultArray() {
        return MusicShape.getDefaultArray(this);
    }

    public static double[] getDefaultArray(DimensionNameSpace dimensionNameSpace) {
        double[] dArray = new double[dimensionNameSpace.dimension()];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = dimensionNameSpace.getDefault(i2);
            if (JMSL.p == 0) continue;
        }
        return dArray;
    }

    public synchronized void copyDataFrom(MusicShape musicShape) {
        this.x = musicShape.dimension();
        this.removeAll();
        Enumeration enumeration = musicShape.elements();
        while (enumeration.hasMoreElements()) {
            double[] dArray = (double[])enumeration.nextElement();
            double[] dArray2 = new double[dArray.length];
            System.arraycopy(dArray, 0, dArray, 0, dArray2.length);
            this.add(dArray2);
            if (JMSL.p == 0) continue;
        }
    }

    public synchronized void copyDataFrom(Vector vector) {
        this.removeAll();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            double[] dArray = (double[])enumeration.nextElement();
            double[] dArray2 = new double[dArray.length];
            System.arraycopy(dArray, 0, dArray, 0, dArray2.length);
            this.add(dArray2);
            if (JMSL.p == 0) continue;
        }
        this.x = ((double[])vector.elementAt(0)).length;
    }

    public int dimension() {
        return this.x;
    }

    public void set(double[] dArray, int n2) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        if (this.isConstrainedToLimits()) {
            for (int i2 = 0; i2 < dArray2.length; ++i2) {
                dArray2[i2] = Limits.clipTo(dArray2[i2], this.getLowLimit(i2), this.getHighLimit(i2));
                if (JMSL.p == 0) continue;
            }
        }
        this.u.setElementAt(dArray2, n2);
    }

    public void set(double d2, int n2, int n3) {
        if (this.isConstrainedToLimits()) {
            d2 = Limits.clipTo(d2, this.getLowLimit(n3), this.getHighLimit(n3));
        }
        ((double[])this.u.elementAt((int)n2))[n3] = d2;
    }

    public void set(int n2, int n3, int n4) {
        this.set((double)n2, n3, n4);
    }

    public void set(long l2, int n2, int n3) {
        this.set((double)l2, n2, n3);
    }

    public void fill(double d2, int n2, int n3, int n4) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            this.set(d2, i2, n4);
            if (JMSL.p == 0) continue;
        }
    }

    public void sumSet(int n2, int n3, int n4) {
        this.set(n2 + this.getInt(n3, n4), n3, n4);
    }

    public void sumSet(double d2, int n2, int n3) {
        this.set(d2 + this.get(n2, n3), n2, n3);
    }

    public void setDimName(String string, int n2) {
        if (n2 < this.dimension()) {
            this.y[n2].a(string);
        }
    }

    public void setDimName(int n2, String string) {
        this.setDimName(string, n2);
    }

    public void insert(double[] dArray, int n2) {
        this.u.insertElementAt(dArray, n2);
    }

    public void remove(int n2) {
        this.u.removeElementAt(n2);
    }

    public void remove(int n2, int n3) {
        int n4 = n3 - n2;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (!Limits.within(n2, 0, this.u.size() - 1)) continue;
            this.remove(n2);
            if (JMSL.p == 0) continue;
        }
    }

    public void add(double[] dArray) {
        if (!JMSL.isLicensed()) {
            return;
        }
        this.a(dArray);
        this.u.addElement(dArray);
    }

    void a(double[] dArray) {
        if (dArray.length != this.dimension()) {
            throw new MusicShapeDimensionException(F[28] + dArray.length + F[27] + this.dimension());
        }
    }

    public void add(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        double[] dArray = new double[]{d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13};
        this.a(dArray);
        this.add(dArray);
    }

    public void add(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        double[] dArray = new double[]{d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12};
        this.a(dArray);
        this.add(dArray);
    }

    public void add(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11) {
        double[] dArray = new double[]{d2, d3, d4, d5, d6, d7, d8, d9, d10, d11};
        this.a(dArray);
        this.add(dArray);
    }

    public void add(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double[] dArray = new double[]{d2, d3, d4, d5, d6, d7, d8, d9, d10};
        this.a(dArray);
        this.add(dArray);
    }

    public void add(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double[] dArray = new double[]{d2, d3, d4, d5, d6, d7, d8, d9};
        this.a(dArray);
        this.add(dArray);
    }

    public void add(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double[] dArray = new double[]{d2, d3, d4, d5, d6, d7, d8};
        this.a(dArray);
        this.add(dArray);
    }

    public void add(double d2, double d3, double d4, double d5, double d6, double d7) {
        double[] dArray = new double[]{d2, d3, d4, d5, d6, d7};
        this.a(dArray);
        this.add(dArray);
    }

    public void add(double d2, double d3, double d4, double d5, double d6) {
        double[] dArray = new double[]{d2, d3, d4, d5, d6};
        this.a(dArray);
        this.add(dArray);
    }

    public void add(double d2, double d3, double d4, double d5) {
        double[] dArray = new double[]{d2, d3, d4, d5};
        this.a(dArray);
        this.add(dArray);
    }

    public void add(double d2, double d3, double d4) {
        double[] dArray = new double[]{d2, d3, d4};
        this.a(dArray);
        this.add(dArray);
    }

    public void add(double d2, double d3) {
        double[] dArray = new double[]{d2, d3};
        this.a(dArray);
        this.add(dArray);
    }

    public void add(double d2) {
        double[] dArray = new double[]{d2};
        this.a(dArray);
        this.add(dArray);
    }

    public void copyDimensionNameSpace(DimensionNameSpace dimensionNameSpace) {
        if (this.dimension() != dimensionNameSpace.dimension()) {
            throw new ArrayIndexOutOfBoundsException(F[4] + dimensionNameSpace.dimension() + F[3] + this.dimension() + F[0] + this.getName());
        }
        for (int i2 = 0; i2 < dimensionNameSpace.dimension(); ++i2) {
            this.setDimensionName(i2, dimensionNameSpace.getDimensionName(i2));
            this.setLimits(i2, dimensionNameSpace.getLowLimit(i2), dimensionNameSpace.getHighLimit(i2));
            this.setDefault(i2, dimensionNameSpace.getDefault(i2));
            if (JMSL.p == 0) continue;
        }
    }

    public int getNumberOfNames() {
        return this.dimension();
    }

    public String getDimensionName(int n2) {
        if (n2 < this.dimension()) {
            return this.y[n2].getName();
        }
        return null;
    }

    public int getDimension(String string) {
        int n2 = JMSL.p;
        int n3 = -1;
        for (int i2 = 0; i2 < this.dimension(); ++i2) {
            if (!this.getDimensionName(i2).equalsIgnoreCase(string)) continue;
            n3 = i2;
            if (n2 == 0) break;
            if (n2 == 0) continue;
        }
        return n3;
    }

    public void setDimensionName(int n2, String string) {
        if (n2 < this.dimension()) {
            this.y[n2].a(string);
        }
    }

    public void setDefault(int n2, double d2) {
        if (n2 < this.dimension()) {
            this.y[n2].setDefault(d2);
        }
    }

    public double getDefault(int n2) {
        if (n2 < this.dimension()) {
            return this.y[n2].getDefault();
        }
        return Double.NEGATIVE_INFINITY;
    }

    public Enumeration dimensionNames() {
        Object[] objectArray = new Object[this.y.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = this.y[i2].getName();
            if (JMSL.p == 0) continue;
        }
        return new ObjectArrayEnumerator(objectArray);
    }

    public MusicShape translate(DimensionNameSpace dimensionNameSpace) {
        MusicShape musicShape = new MusicShape(dimensionNameSpace.dimension());
        DimensionNameSpaceTranslator dimensionNameSpaceTranslator = new DimensionNameSpaceTranslator();
        dimensionNameSpaceTranslator.setDestinationDimensionNameSpace(dimensionNameSpace);
        dimensionNameSpaceTranslator.setSourceDimensionNameSpace(this);
        for (int i2 = 0; i2 < this.size(); ++i2) {
            musicShape.add(dimensionNameSpaceTranslator.translate(this.get(i2)));
            if (JMSL.p == 0) continue;
        }
        return musicShape;
    }

    public String getDimName(int n2) {
        return this.y[n2].getName();
    }

    public double[] get(int n2) {
        double[] dArray = new double[this.dimension()];
        double[] dArray2 = (double[])this.u.elementAt(n2);
        System.arraycopy(dArray2, 0, dArray, 0, dArray2.length);
        return dArray;
    }

    public double get(int n2, int n3) {
        return ((double[])this.u.elementAt(n2))[n3];
    }

    public int getInt(int n2, int n3) {
        int n4 = (int)(((double[])this.u.elementAt(n2))[n3] + 0.5);
        return n4;
    }

    public double getMin(int n2) {
        return this.y[n2].getMin();
    }

    public double getMean(int n2) {
        return this.y[n2].getMean();
    }

    public double getMax(int n2) {
        return this.y[n2].getMax();
    }

    public double getSum(int n2) {
        return this.y[n2].getSum();
    }

    public double getLowLimit(int n2) {
        return this.y[n2].getLow();
    }

    public double getHighLimit(int n2) {
        return this.y[n2].getHigh();
    }

    public void setLimits(int n2, double d2, double d3) {
        this.y[n2].setLimits(d2, d3);
    }

    public void calcDimStats(int n2) {
        if (this.size() > 0) {
            double d2 = this.get(0, n2);
            double d3 = this.get(0, n2);
            double d4 = 0.0;
            for (int i2 = 0; i2 < this.size(); ++i2) {
                double d5 = this.get(i2, n2);
                if (d5 < d2) {
                    d2 = this.get(i2, n2);
                }
                if (d5 > d3) {
                    d3 = this.get(i2, n2);
                }
                d4 += d5;
                if (JMSL.p == 0) continue;
            }
            this.y[n2].d(d4);
            this.y[n2].a(d2);
            this.y[n2].c(d3);
            this.y[n2].b(d4 / (double)this.size());
        }
    }

    public void calcStats() {
        for (int i2 = 0; i2 < this.dimension(); ++i2) {
            this.calcDimStats(i2);
            if (JMSL.p == 0) continue;
        }
        this.A = true;
    }

    public boolean statsCalculated() {
        return this.A;
    }

    public static boolean isClippingEnabled() {
        return D;
    }

    public static void setClippingEnabled(boolean bl) {
        D = bl;
    }

    public void setClipped(double d2, int n2, int n3) {
        ((double[])this.u.elementAt((int)n2))[n3] = MusicShape.isClippingEnabled() ? this.y[n3].clip(d2) : d2;
    }

    public double clipValDim(double d2, int n2) {
        return this.y[n2].clip(d2);
    }

    public void convertTimeBaseDim(double d2, double d3, int n2) {
        double d4 = d3 / d2;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.set(this.get(i2, n2) * d4, i2, n2);
            if (JMSL.p == 0) continue;
        }
    }

    public double integrate(int n2) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            d3 = this.get(i2, n2);
            this.set(d2, i2, n2);
            d2 += d3;
            if (JMSL.p == 0) continue;
        }
        return d2;
    }

    public void differentiate(double d2, int n2) {
        if (this.size() == 0) {
            return;
        }
        double d3 = this.get(0, n2);
        for (int i2 = 0; i2 < this.size() - 1; ++i2) {
            double d4 = this.get(i2 + 1, n2) - this.get(i2, n2);
            this.set(d4, i2, n2);
            if (JMSL.p == 0) continue;
        }
        if (this.size() > 0) {
            this.set(d2 - this.get(this.size() - 1, n2) + d3, this.size() - 1, n2);
        }
    }

    public void randomize(double d2, double d3, int n2, int n3, int n4) {
        int n5;
        if (n3 < n2) {
            n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        for (n5 = n2; n5 <= n3; ++n5) {
            this.setClipped(JMSLRandom.choose(d2, d3), n5, n4);
            if (JMSL.p == 0) continue;
        }
    }

    public void transpose(double d2, int n2, int n3, int n4) {
        int n5;
        if (n3 < n2 && this.isSafeOrdering()) {
            n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        for (n5 = n2; n5 <= n3; ++n5) {
            this.setClipped(this.get(n5, n4) + d2, n5, n4);
            if (JMSL.p == 0) continue;
        }
    }

    public void scale(double d2, int n2, int n3, int n4) {
        int n5;
        if (n3 < n2 && this.isSafeOrdering()) {
            n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        for (n5 = n2; n5 <= n3; ++n5) {
            this.setClipped(this.get(n5, n4) * d2, n5, n4);
            if (JMSL.p == 0) continue;
        }
    }

    public void invert(double d2, int n2, int n3, int n4) {
        int n5;
        double d3 = d2 * 2.0;
        if (n3 < n2 && this.isSafeOrdering()) {
            n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        for (n5 = n2; n5 <= n3; ++n5) {
            this.setClipped(d3 - this.get(n5, n4), n5, n4);
            if (JMSL.p == 0) continue;
        }
    }

    public void reverse(int n2, int n3, int n4) {
        int n5 = JMSL.p;
        double d2 = 0.0;
        double d3 = 0.0;
        if (n2 > n3) {
            int n6 = n3;
            n3 = n2;
            n2 = n6;
        }
        while (n2 < n3) {
            block6: {
                block5: {
                    if (n4 >= 0) break block5;
                    double[] dArray = this.get(n3);
                    double[] dArray2 = this.get(n2);
                    this.set(dArray, n2);
                    this.set(dArray2, n3);
                    if (n5 == 0) break block6;
                }
                d2 = this.get(n3, n4);
                d3 = this.get(n2, n4);
                this.set(d2, n2, n4);
                this.set(d3, n3, n4);
            }
            ++n2;
            --n3;
            if (n5 == 0) continue;
        }
    }

    public void swap(int n2, int n3, int n4) {
        block3: {
            block2: {
                if (n4 >= 0) break block2;
                double[] dArray = this.get(n2);
                this.set(this.get(n3), n2);
                this.set(dArray, n3);
                if (JMSL.p == 0) break block3;
            }
            double d2 = this.get(n2, n4);
            this.set(this.get(n3, n4), n2, n4);
            this.set(d2, n3, n4);
        }
    }

    public void scramble(int n2, int n3, int n4) {
        int n5;
        if (n3 < n2 && this.isSafeOrdering()) {
            n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        for (n5 = n2; n5 <= n3; ++n5) {
            this.swap(n5, JMSLRandom.choose(n2, n3 + 1), n4);
            if (JMSL.p == 0) continue;
        }
    }

    public void sort(int n2, int n3, int n4, DimensionComparison dimensionComparison) {
        int n5 = JMSL.p;
        for (int i2 = n3; i2 >= n2; --i2) {
            boolean bl = false;
            for (int i3 = n2; i3 < i2; ++i3) {
                if (1 != dimensionComparison.compare(this.get(i3), this.get(i3 + 1), n4)) continue;
                this.swap(i3, i3 + 1, -1);
                bl = true;
                if (n5 == 0) continue;
            }
            if (bl) continue;
            return;
        }
    }

    public void sort(int n2) {
        CompareDim compareDim = new CompareDim();
        this.sort(0, this.size() - 1, n2, compareDim);
    }

    public void sort(int n2, int n3, int n4) {
        if (n3 < n2 && this.isSafeOrdering()) {
            int n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        this.sort(n2, n3, n4, new CompareDim());
    }

    public void sort() {
        this.sort(0);
    }

    public void printDimNames() {
        for (int i2 = 0; i2 < this.dimension(); ++i2) {
            JMSL.out.print(F[1] + i2 + F[2] + this.getDimName(i2));
            if (i2 == this.dimension() - 1) continue;
            JMSL.out.print(F[0]);
            if (JMSL.p == 0) continue;
        }
        JMSL.out.println();
    }

    public void printStats() {
        for (int i2 = 0; i2 < this.dimension(); ++i2) {
            this.y[i2].printStats();
            if (JMSL.p == 0) continue;
        }
    }

    public void printDim(int n2) {
        JMSL.out.print(n2 + F[2]);
        JMSL.printDoubleArray(this.get(n2));
    }

    public void print() {
        this.calcStats();
        JMSL.out.println(this.getName());
        this.printDimNames();
        this.printStats();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.printDim(i2);
            if (JMSL.p == 0) continue;
        }
        JMSL.out.println(F[11]);
    }

    public void dumpSource(String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
        this.dumpSource(printWriter);
        printWriter.close();
    }

    public void dumpSource(PrintWriter printWriter) throws IOException {
        printWriter.println(this.dumpSource());
    }

    public String dumpSource() {
        int n2;
        int n3 = JMSL.p;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(F[17] + this.getName() + F[12] + this.dimension() + F[13]);
        for (n2 = 0; n2 < this.dimension(); ++n2) {
            stringBuffer.append(this.getName() + F[16] + n2 + F[19] + this.getDimensionName(n2) + F[18]);
            double d2 = this.getLowLimit(n2);
            double d3 = this.getHighLimit(n2);
            double d4 = this.getDefault(n2);
            stringBuffer.append(this.getName() + F[21] + n2 + F[0] + this.a(d2) + F[0] + this.a(d3) + F[13]);
            stringBuffer.append(this.getName() + F[15] + n2 + F[0] + d4 + F[13]);
            if (n3 == 0) continue;
        }
        for (n2 = 0; n2 < this.size(); ++n2) {
            stringBuffer.append(this.getName() + F[20]);
            for (int i2 = 0; i2 < this.dimension(); ++i2) {
                stringBuffer.append(this.get(n2, i2) + "");
                if (i2 == this.dimension() - 1) continue;
                stringBuffer.append(F[0]);
                if (n3 == 0) continue;
            }
            stringBuffer.append(F[14]);
            if (n3 == 0) continue;
        }
        return stringBuffer.toString();
    }

    private String a(double d2) {
        if (d2 == Double.NEGATIVE_INFINITY) {
            return F[26];
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return F[25];
        }
        return d2 + "";
    }

    public String toString() {
        int n2;
        int n3 = JMSL.p;
        StringBuffer stringBuffer = new StringBuffer();
        this.calcStats();
        stringBuffer.append(this.getName() + "\n");
        for (n2 = 0; n2 < this.dimension(); ++n2) {
            stringBuffer.append(F[1] + n2 + F[2] + this.getDimName(n2));
            if (n2 == this.dimension() - 1) continue;
            stringBuffer.append(F[0]);
            if (n3 == 0) continue;
        }
        stringBuffer.append("\n");
        for (n2 = 0; n2 < this.dimension(); ++n2) {
            stringBuffer.append(this.y[n2].toString() + "\n");
            if (n3 == 0) continue;
        }
        for (n2 = 0; n2 < this.size(); ++n2) {
            stringBuffer.append(n2 + F[2]);
            for (int i2 = 0; i2 < this.dimension(); ++i2) {
                stringBuffer.append(this.get(n2, i2));
                if (i2 == this.dimension() - 1) continue;
                stringBuffer.append(F[0]);
                if (n3 == 0) continue;
            }
            stringBuffer.append("\n");
            if (n3 == 0) continue;
        }
        stringBuffer.append(F[24]);
        return stringBuffer.toString();
    }

    public double start(double d2) throws InterruptedException {
        if (this.instrument != null) {
            d2 = this.instrument.open(d2);
        }
        return d2;
    }

    public double stop(double d2) throws InterruptedException {
        if (this.instrument != null) {
            d2 = this.instrument.close(d2);
        }
        return d2;
    }

    public void finishAll() {
        this.finish();
    }

    public double internalRepeat(double d2) throws InterruptedException {
        int n2 = JMSL.p;
        double[] dArray = null;
        if (this.instrument != null) {
            DimensionNameSpaceTranslator dimensionNameSpaceTranslator = null;
            if (this.instrument.getDimensionNameSpace() != null) {
                dimensionNameSpaceTranslator = new DimensionNameSpaceTranslator();
                dimensionNameSpaceTranslator.setSourceDimensionNameSpace(this);
                dimensionNameSpaceTranslator.setDestinationDimensionNameSpace(this.instrument.getDimensionNameSpace());
                dArray = new double[this.instrument.getDimensionNameSpace().dimension()];
                if (this.B) {
                    for (int i2 = 0; i2 < 4; ++i2) {
                        dimensionNameSpaceTranslator.addInvariant(i2);
                        if (n2 == 0) continue;
                    }
                }
            }
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements() && (!this.f || n2 != 0)) {
                double[] dArray2 = (double[])enumeration.nextElement();
                Enumeration enumeration2 = this.r.elements();
                while (enumeration2.hasMoreElements()) {
                    PlayLurker playLurker = (PlayLurker)enumeration2.nextElement();
                    playLurker.notifyPlayLurker(d2, this, this.indexOf(dArray2));
                    if (n2 == 0) continue;
                }
                if (this.getDataTranslator() != null) {
                    dArray2 = this.getDataTranslator().translate(this, dArray2);
                }
                if (this.instrument.getDimensionNameSpace() != null) {
                    dArray2 = dimensionNameSpaceTranslator.translate(dArray2, dArray);
                }
                d2 = this.instrument.play(d2, this.timeStretch(), dArray2);
                JMSL.sleepUntil(d2);
                if (n2 == 0) continue;
            }
        }
        return d2;
    }

    public void prefab() {
        this.prefab(17);
    }

    public void prefab(int n2) {
        int n3 = JMSL.p;
        Limits limits = new Limits(40.0, 78.0, 3.0);
        for (int i2 = 0; i2 < n2; ++i2) {
            limits.randomStep();
            int n4 = limits.getIntValue();
            double d2 = (double)JMSLRandom.choose(5) * 0.25;
            double d3 = (double)JMSLRandom.choose(5) * 0.5 + 0.5;
            double d4 = JMSLRandom.choose(this.getLowLimit(2), this.getHighLimit(2) / 2.0);
            double[] dArray = new double[this.dimension()];
            dArray[0] = d2;
            if (dArray.length > 1) {
                dArray[1] = n4;
            }
            if (dArray.length > 2) {
                dArray[2] = d4;
            }
            if (dArray.length > 3) {
                dArray[3] = d3;
            }
            for (int i3 = 4; i3 < this.dimension(); ++i3) {
                double d5;
                dArray[i3] = d5 = JMSLRandom.choose(this.getLowLimit(i3), this.getHighLimit(i3));
                if (n3 == 0) continue;
            }
            this.add(dArray);
            if (n3 == 0) continue;
        }
    }

    public synchronized Object clone() {
        try {
            MusicShape musicShape = (MusicShape)super.clone();
            musicShape.u = new Vector();
            for (int i2 = 0; i2 < this.size(); ++i2) {
                musicShape.add(this.get(i2));
                if (JMSL.p == 0) continue;
            }
            return musicShape;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public static int qa() {
        int n2;
        int n3 = JMSL.p;
        MusicShape musicShape = new MusicShape(2);
        for (n2 = 0; n2 < 8; ++n2) {
            musicShape.add(JMSLRandom.choose(10.0), JMSLRandom.choose(10.0));
            if (n3 == 0) continue;
        }
        musicShape.sort();
        for (n2 = 0; n2 < musicShape.size() - 1; ++n2) {
            if (!(musicShape.get(n2, 0) > musicShape.get(n2 + 1, 0))) continue;
            return 1;
        }
        musicShape.reverse(0, musicShape.size() - 1, 0);
        for (n2 = 0; n2 < musicShape.size() - 1; ++n2) {
            if (!(musicShape.get(n2, 0) < musicShape.get(n2 + 1, 0))) continue;
            return 2;
        }
        return 0;
    }

    public static MusicShape readBinaryHMSLShape(DataInputStream dataInputStream) throws IOException {
        int n2 = JMSL.p;
        int n3 = dataInputStream.readInt();
        int n4 = dataInputStream.readInt();
        int n5 = dataInputStream.readInt();
        MusicShape musicShape = new MusicShape(n4);
        JMSL.out.println(F[5] + n3 + F[6] + n4 + F[7] + n5);
        for (int i2 = 0; i2 < n3; ++i2) {
            double[] dArray = new double[n4];
            for (int i3 = 0; i3 < n4; ++i3) {
                dArray[i3] = dataInputStream.readInt();
                if (n2 == 0) continue;
            }
            musicShape.add(dArray);
            if (n2 == 0) continue;
        }
        return musicShape;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.u);
        objectOutputStream.writeObject(this.y);
        objectOutputStream.writeObject(new Integer(this.x));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.u = (Vector)objectInputStream.readObject();
        this.y = (DimAttributes[])objectInputStream.readObject();
        this.x = (Integer)objectInputStream.readObject();
    }

    public void save(PrintWriter printWriter) throws IOException {
        int n2;
        int n3 = JMSL.p;
        printWriter.println(this.x + "");
        for (n2 = 0; n2 < this.x; ++n2) {
            printWriter.println(this.getDimensionName(n2));
            if (n3 == 0) continue;
        }
        for (n2 = 0; n2 < this.size(); ++n2) {
            String string = n2 + "\t";
            for (int i2 = 0; i2 < this.x; ++i2) {
                string = string + this.get(n2, i2) + "\t";
                if (n3 == 0) continue;
            }
            printWriter.println(string);
            if (n3 == 0) continue;
        }
    }

    public void load(BufferedReader bufferedReader) throws IOException {
        int n2 = JMSL.p;
        String string = bufferedReader.readLine();
        int n3 = -1;
        try {
            n3 = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(F[8] + string + "\n" + numberFormatException);
        }
        if (this.x != n3) {
            throw new IOException(F[9] + this.x + F[3] + n3);
        }
        for (int i2 = 0; i2 < this.x; ++i2) {
            string = bufferedReader.readLine();
            if (string == null) {
                throw new IOException(F[10] + i2);
            }
            this.setDimensionName(i2, string);
            if (n2 == 0) continue;
        }
        this.removeAll();
        string = bufferedReader.readLine();
        while (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            String string2 = stringTokenizer.nextToken();
            double[] dArray = new double[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                double d2;
                dArray[i3] = d2 = new Double(stringTokenizer.nextToken()).doubleValue();
                if (n2 == 0) continue;
            }
            this.add(dArray);
            string = bufferedReader.readLine();
            if (n2 == 0) continue;
        }
    }

    public static void main(String[] stringArray) {
        MusicShape musicShape = new MusicShape(1);
        musicShape.add(0.0);
        musicShape.add(1.0);
        musicShape.add(2.0);
        musicShape.print();
        musicShape.differentiate(5.0, 0);
        musicShape.print();
        musicShape = new MusicShape(1);
        musicShape.add(1.0);
        musicShape.add(2.0);
        musicShape.add(3.0);
        musicShape.print();
        musicShape.differentiate(5.0, 0);
        musicShape.print();
    }

    public boolean isSafeOrdering() {
        return this.C;
    }

    public void setSafeOrdering(boolean bl) {
        this.C = bl;
    }

    public boolean isConstrainedToLimits() {
        return this.E;
    }

    public void setConstrainedToLimits(boolean bl) {
        this.E = bl;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block318: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block317: {
                char[] cArray3;
                Object var0;
                block316: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block315: {
                        char[] cArray5;
                        block314: {
                            int n7;
                            int n8;
                            char[] cArray6;
                            block313: {
                                char[] cArray7;
                                block312: {
                                    int n9;
                                    int n10;
                                    char[] cArray8;
                                    block311: {
                                        char[] cArray9;
                                        block310: {
                                            int n11;
                                            int n12;
                                            char[] cArray10;
                                            block309: {
                                                char[] cArray11;
                                                block308: {
                                                    int n13;
                                                    int n14;
                                                    char[] cArray12;
                                                    block307: {
                                                        char[] cArray13;
                                                        block306: {
                                                            int n15;
                                                            int n16;
                                                            char[] cArray14;
                                                            block305: {
                                                                char[] cArray15;
                                                                block304: {
                                                                    int n17;
                                                                    int n18;
                                                                    char[] cArray16;
                                                                    block303: {
                                                                        char[] cArray17;
                                                                        block302: {
                                                                            int n19;
                                                                            int n20;
                                                                            char[] cArray18;
                                                                            block301: {
                                                                                char[] cArray19;
                                                                                block300: {
                                                                                    int n21;
                                                                                    int n22;
                                                                                    char[] cArray20;
                                                                                    block299: {
                                                                                        char[] cArray21;
                                                                                        block298: {
                                                                                            int n23;
                                                                                            int n24;
                                                                                            char[] cArray22;
                                                                                            block297: {
                                                                                                char[] cArray23;
                                                                                                block296: {
                                                                                                    int n25;
                                                                                                    int n26;
                                                                                                    char[] cArray24;
                                                                                                    block295: {
                                                                                                        char[] cArray25;
                                                                                                        block294: {
                                                                                                            int n27;
                                                                                                            int n28;
                                                                                                            char[] cArray26;
                                                                                                            block293: {
                                                                                                                char[] cArray27;
                                                                                                                block292: {
                                                                                                                    int n29;
                                                                                                                    int n30;
                                                                                                                    char[] cArray28;
                                                                                                                    block291: {
                                                                                                                        char[] cArray29;
                                                                                                                        block290: {
                                                                                                                            int n31;
                                                                                                                            int n32;
                                                                                                                            char[] cArray30;
                                                                                                                            block289: {
                                                                                                                                char[] cArray31;
                                                                                                                                block288: {
                                                                                                                                    int n33;
                                                                                                                                    int n34;
                                                                                                                                    char[] cArray32;
                                                                                                                                    block287: {
                                                                                                                                        char[] cArray33;
                                                                                                                                        block286: {
                                                                                                                                            int n35;
                                                                                                                                            int n36;
                                                                                                                                            char[] cArray34;
                                                                                                                                            block285: {
                                                                                                                                                char[] cArray35;
                                                                                                                                                block284: {
                                                                                                                                                    int n37;
                                                                                                                                                    int n38;
                                                                                                                                                    char[] cArray36;
                                                                                                                                                    block283: {
                                                                                                                                                        char[] cArray37;
                                                                                                                                                        block282: {
                                                                                                                                                            int n39;
                                                                                                                                                            int n40;
                                                                                                                                                            char[] cArray38;
                                                                                                                                                            block281: {
                                                                                                                                                                char[] cArray39;
                                                                                                                                                                block280: {
                                                                                                                                                                    int n41;
                                                                                                                                                                    int n42;
                                                                                                                                                                    char[] cArray40;
                                                                                                                                                                    block279: {
                                                                                                                                                                        char[] cArray41;
                                                                                                                                                                        block278: {
                                                                                                                                                                            int n43;
                                                                                                                                                                            int n44;
                                                                                                                                                                            char[] cArray42;
                                                                                                                                                                            block277: {
                                                                                                                                                                                char[] cArray43;
                                                                                                                                                                                block276: {
                                                                                                                                                                                    int n45;
                                                                                                                                                                                    int n46;
                                                                                                                                                                                    char[] cArray44;
                                                                                                                                                                                    block275: {
                                                                                                                                                                                        char[] cArray45;
                                                                                                                                                                                        block274: {
                                                                                                                                                                                            int n47;
                                                                                                                                                                                            int n48;
                                                                                                                                                                                            char[] cArray46;
                                                                                                                                                                                            block273: {
                                                                                                                                                                                                char[] cArray47;
                                                                                                                                                                                                block272: {
                                                                                                                                                                                                    int n49;
                                                                                                                                                                                                    int n50;
                                                                                                                                                                                                    char[] cArray48;
                                                                                                                                                                                                    block271: {
                                                                                                                                                                                                        char[] cArray49;
                                                                                                                                                                                                        block270: {
                                                                                                                                                                                                            int n51;
                                                                                                                                                                                                            int n52;
                                                                                                                                                                                                            char[] cArray50;
                                                                                                                                                                                                            block269: {
                                                                                                                                                                                                                char[] cArray51;
                                                                                                                                                                                                                block268: {
                                                                                                                                                                                                                    int n53;
                                                                                                                                                                                                                    int n54;
                                                                                                                                                                                                                    char[] cArray52;
                                                                                                                                                                                                                    block267: {
                                                                                                                                                                                                                        char[] cArray53;
                                                                                                                                                                                                                        block266: {
                                                                                                                                                                                                                            int n55;
                                                                                                                                                                                                                            int n56;
                                                                                                                                                                                                                            char[] cArray54;
                                                                                                                                                                                                                            block265: {
                                                                                                                                                                                                                                char[] cArray55;
                                                                                                                                                                                                                                block264: {
                                                                                                                                                                                                                                    int n57;
                                                                                                                                                                                                                                    int n58;
                                                                                                                                                                                                                                    char[] cArray56;
                                                                                                                                                                                                                                    block263: {
                                                                                                                                                                                                                                        char[] cArray57;
                                                                                                                                                                                                                                        block262: {
                                                                                                                                                                                                                                            int n59;
                                                                                                                                                                                                                                            int n60;
                                                                                                                                                                                                                                            char[] cArray58;
                                                                                                                                                                                                                                            block261: {
                                                                                                                                                                                                                                                stringArray = new String[29];
                                                                                                                                                                                                                                                var0 = null;
                                                                                                                                                                                                                                                char[] cArray59 = "\nz".toCharArray();
                                                                                                                                                                                                                                                n4 = 0;
                                                                                                                                                                                                                                                int n61 = cArray59.length;
                                                                                                                                                                                                                                                cArray58 = cArray59;
                                                                                                                                                                                                                                                n60 = n61;
                                                                                                                                                                                                                                                if (n61 <= 1) break block261;
                                                                                                                                                                                                                                                cArray57 = cArray58;
                                                                                                                                                                                                                                                n59 = n60;
                                                                                                                                                                                                                                                if (n60 <= n4) break block262;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            do {
                                                                                                                                                                                                                                                char[] cArray60 = cArray58;
                                                                                                                                                                                                                                                char[] cArray61 = cArray58;
                                                                                                                                                                                                                                                int n62 = n4;
                                                                                                                                                                                                                                                while (true) {
                                                                                                                                                                                                                                                    int n63;
                                                                                                                                                                                                                                                    char c2 = cArray60[n62];
                                                                                                                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                                                                                                                        case 0: {
                                                                                                                                                                                                                                                            n63 = 38;
                                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        case 1: {
                                                                                                                                                                                                                                                            n63 = 90;
                                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        case 2: {
                                                                                                                                                                                                                                                            n63 = 32;
                                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        case 3: {
                                                                                                                                                                                                                                                            n63 = 112;
                                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        default: {
                                                                                                                                                                                                                                                            n63 = 79;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    cArray60[n62] = (char)(c2 ^ n63);
                                                                                                                                                                                                                                                    ++n4;
                                                                                                                                                                                                                                                    cArray58 = cArray61;
                                                                                                                                                                                                                                                    n60 = n60;
                                                                                                                                                                                                                                                    if (n60 != 0) break;
                                                                                                                                                                                                                                                    cArray61 = cArray58;
                                                                                                                                                                                                                                                    n59 = n60;
                                                                                                                                                                                                                                                    n62 = n60;
                                                                                                                                                                                                                                                    cArray60 = cArray58;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                cArray57 = cArray58;
                                                                                                                                                                                                                                                n59 = n60;
                                                                                                                                                                                                                                            } while (n60 > n4);
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        stringArray[0] = new String(cArray57).intern();
                                                                                                                                                                                                                                        var0 = null;
                                                                                                                                                                                                                                        char[] cArray62 = "B3MP".toCharArray();
                                                                                                                                                                                                                                        n4 = 0;
                                                                                                                                                                                                                                        int n64 = cArray62.length;
                                                                                                                                                                                                                                        cArray56 = cArray62;
                                                                                                                                                                                                                                        n58 = n64;
                                                                                                                                                                                                                                        if (n64 <= 1) break block263;
                                                                                                                                                                                                                                        cArray55 = cArray56;
                                                                                                                                                                                                                                        n57 = n58;
                                                                                                                                                                                                                                        if (n58 <= n4) break block264;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    do {
                                                                                                                                                                                                                                        char[] cArray63 = cArray56;
                                                                                                                                                                                                                                        char[] cArray64 = cArray56;
                                                                                                                                                                                                                                        int n65 = n4;
                                                                                                                                                                                                                                        while (true) {
                                                                                                                                                                                                                                            int n66;
                                                                                                                                                                                                                                            char c3 = cArray63[n65];
                                                                                                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                                                                                                case 0: {
                                                                                                                                                                                                                                                    n66 = 38;
                                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 1: {
                                                                                                                                                                                                                                                    n66 = 90;
                                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 2: {
                                                                                                                                                                                                                                                    n66 = 32;
                                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3: {
                                                                                                                                                                                                                                                    n66 = 112;
                                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                default: {
                                                                                                                                                                                                                                                    n66 = 79;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            cArray63[n65] = (char)(c3 ^ n66);
                                                                                                                                                                                                                                            ++n4;
                                                                                                                                                                                                                                            cArray56 = cArray64;
                                                                                                                                                                                                                                            n58 = n58;
                                                                                                                                                                                                                                            if (n58 != 0) break;
                                                                                                                                                                                                                                            cArray64 = cArray56;
                                                                                                                                                                                                                                            n57 = n58;
                                                                                                                                                                                                                                            n65 = n58;
                                                                                                                                                                                                                                            cArray63 = cArray56;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        cArray55 = cArray56;
                                                                                                                                                                                                                                        n57 = n58;
                                                                                                                                                                                                                                    } while (n58 > n4);
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                stringArray[1] = new String(cArray55).intern();
                                                                                                                                                                                                                                var0 = null;
                                                                                                                                                                                                                                char[] cArray65 = "\u001cz".toCharArray();
                                                                                                                                                                                                                                n4 = 0;
                                                                                                                                                                                                                                int n67 = cArray65.length;
                                                                                                                                                                                                                                cArray54 = cArray65;
                                                                                                                                                                                                                                n56 = n67;
                                                                                                                                                                                                                                if (n67 <= 1) break block265;
                                                                                                                                                                                                                                cArray53 = cArray54;
                                                                                                                                                                                                                                n55 = n56;
                                                                                                                                                                                                                                if (n56 <= n4) break block266;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            do {
                                                                                                                                                                                                                                char[] cArray66 = cArray54;
                                                                                                                                                                                                                                char[] cArray67 = cArray54;
                                                                                                                                                                                                                                int n68 = n4;
                                                                                                                                                                                                                                while (true) {
                                                                                                                                                                                                                                    int n69;
                                                                                                                                                                                                                                    char c4 = cArray66[n68];
                                                                                                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                                                                                                        case 0: {
                                                                                                                                                                                                                                            n69 = 38;
                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        case 1: {
                                                                                                                                                                                                                                            n69 = 90;
                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        case 2: {
                                                                                                                                                                                                                                            n69 = 32;
                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        case 3: {
                                                                                                                                                                                                                                            n69 = 112;
                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        default: {
                                                                                                                                                                                                                                            n69 = 79;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    cArray66[n68] = (char)(c4 ^ n69);
                                                                                                                                                                                                                                    ++n4;
                                                                                                                                                                                                                                    cArray54 = cArray67;
                                                                                                                                                                                                                                    n56 = n56;
                                                                                                                                                                                                                                    if (n56 != 0) break;
                                                                                                                                                                                                                                    cArray67 = cArray54;
                                                                                                                                                                                                                                    n55 = n56;
                                                                                                                                                                                                                                    n68 = n56;
                                                                                                                                                                                                                                    cArray66 = cArray54;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                cArray53 = cArray54;
                                                                                                                                                                                                                                n55 = n56;
                                                                                                                                                                                                                            } while (n56 > n4);
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        stringArray[2] = new String(cArray53).intern();
                                                                                                                                                                                                                        var0 = null;
                                                                                                                                                                                                                        char[] cArray68 = "\u0006{\u001dP".toCharArray();
                                                                                                                                                                                                                        n4 = 0;
                                                                                                                                                                                                                        int n70 = cArray68.length;
                                                                                                                                                                                                                        cArray52 = cArray68;
                                                                                                                                                                                                                        n54 = n70;
                                                                                                                                                                                                                        if (n70 <= 1) break block267;
                                                                                                                                                                                                                        cArray51 = cArray52;
                                                                                                                                                                                                                        n53 = n54;
                                                                                                                                                                                                                        if (n54 <= n4) break block268;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    do {
                                                                                                                                                                                                                        char[] cArray69 = cArray52;
                                                                                                                                                                                                                        char[] cArray70 = cArray52;
                                                                                                                                                                                                                        int n71 = n4;
                                                                                                                                                                                                                        while (true) {
                                                                                                                                                                                                                            int n72;
                                                                                                                                                                                                                            char c5 = cArray69[n71];
                                                                                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                                                                                case 0: {
                                                                                                                                                                                                                                    n72 = 38;
                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                case 1: {
                                                                                                                                                                                                                                    n72 = 90;
                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                case 2: {
                                                                                                                                                                                                                                    n72 = 32;
                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                case 3: {
                                                                                                                                                                                                                                    n72 = 112;
                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                default: {
                                                                                                                                                                                                                                    n72 = 79;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            cArray69[n71] = (char)(c5 ^ n72);
                                                                                                                                                                                                                            ++n4;
                                                                                                                                                                                                                            cArray52 = cArray70;
                                                                                                                                                                                                                            n54 = n54;
                                                                                                                                                                                                                            if (n54 != 0) break;
                                                                                                                                                                                                                            cArray70 = cArray52;
                                                                                                                                                                                                                            n53 = n54;
                                                                                                                                                                                                                            n71 = n54;
                                                                                                                                                                                                                            cArray69 = cArray52;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        cArray51 = cArray52;
                                                                                                                                                                                                                        n53 = n54;
                                                                                                                                                                                                                    } while (n54 > n4);
                                                                                                                                                                                                                }
                                                                                                                                                                                                                stringArray[3] = new String(cArray51).intern();
                                                                                                                                                                                                                var0 = null;
                                                                                                                                                                                                                char[] cArray71 = "E5P\t\u000bO7E\u001e<O5N>.K?s\u0000.E?\bYc\u0006>I\u001d*H)I\u001f!UzN\u001f;\u00069O\u001d?G.I\u0012#Ct\u0000".toCharArray();
                                                                                                                                                                                                                n4 = 0;
                                                                                                                                                                                                                int n73 = cArray71.length;
                                                                                                                                                                                                                cArray50 = cArray71;
                                                                                                                                                                                                                n52 = n73;
                                                                                                                                                                                                                if (n73 <= 1) break block269;
                                                                                                                                                                                                                cArray49 = cArray50;
                                                                                                                                                                                                                n51 = n52;
                                                                                                                                                                                                                if (n52 <= n4) break block270;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            do {
                                                                                                                                                                                                                char[] cArray72 = cArray50;
                                                                                                                                                                                                                char[] cArray73 = cArray50;
                                                                                                                                                                                                                int n74 = n4;
                                                                                                                                                                                                                while (true) {
                                                                                                                                                                                                                    int n75;
                                                                                                                                                                                                                    char c6 = cArray72[n74];
                                                                                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                                                                                        case 0: {
                                                                                                                                                                                                                            n75 = 38;
                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        case 1: {
                                                                                                                                                                                                                            n75 = 90;
                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        case 2: {
                                                                                                                                                                                                                            n75 = 32;
                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        case 3: {
                                                                                                                                                                                                                            n75 = 112;
                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        default: {
                                                                                                                                                                                                                            n75 = 79;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    cArray72[n74] = (char)(c6 ^ n75);
                                                                                                                                                                                                                    ++n4;
                                                                                                                                                                                                                    cArray50 = cArray73;
                                                                                                                                                                                                                    n52 = n52;
                                                                                                                                                                                                                    if (n52 != 0) break;
                                                                                                                                                                                                                    cArray73 = cArray50;
                                                                                                                                                                                                                    n51 = n52;
                                                                                                                                                                                                                    n74 = n52;
                                                                                                                                                                                                                    cArray72 = cArray50;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                cArray49 = cArray50;
                                                                                                                                                                                                                n51 = n52;
                                                                                                                                                                                                            } while (n52 > n4);
                                                                                                                                                                                                        }
                                                                                                                                                                                                        stringArray[4] = new String(cArray49).intern();
                                                                                                                                                                                                        var0 = null;
                                                                                                                                                                                                        char[] cArray74 = "c6E\u001d*H.SJo".toCharArray();
                                                                                                                                                                                                        n4 = 0;
                                                                                                                                                                                                        int n76 = cArray74.length;
                                                                                                                                                                                                        cArray48 = cArray74;
                                                                                                                                                                                                        n50 = n76;
                                                                                                                                                                                                        if (n76 <= 1) break block271;
                                                                                                                                                                                                        cArray47 = cArray48;
                                                                                                                                                                                                        n49 = n50;
                                                                                                                                                                                                        if (n50 <= n4) break block272;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    do {
                                                                                                                                                                                                        char[] cArray75 = cArray48;
                                                                                                                                                                                                        char[] cArray76 = cArray48;
                                                                                                                                                                                                        int n77 = n4;
                                                                                                                                                                                                        while (true) {
                                                                                                                                                                                                            int n78;
                                                                                                                                                                                                            char c7 = cArray75[n77];
                                                                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                                                                case 0: {
                                                                                                                                                                                                                    n78 = 38;
                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                case 1: {
                                                                                                                                                                                                                    n78 = 90;
                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                case 2: {
                                                                                                                                                                                                                    n78 = 32;
                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                case 3: {
                                                                                                                                                                                                                    n78 = 112;
                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                default: {
                                                                                                                                                                                                                    n78 = 79;
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                            cArray75[n77] = (char)(c7 ^ n78);
                                                                                                                                                                                                            ++n4;
                                                                                                                                                                                                            cArray48 = cArray76;
                                                                                                                                                                                                            n50 = n50;
                                                                                                                                                                                                            if (n50 != 0) break;
                                                                                                                                                                                                            cArray76 = cArray48;
                                                                                                                                                                                                            n49 = n50;
                                                                                                                                                                                                            n77 = n50;
                                                                                                                                                                                                            cArray75 = cArray48;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        cArray47 = cArray48;
                                                                                                                                                                                                        n49 = n50;
                                                                                                                                                                                                    } while (n50 > n4);
                                                                                                                                                                                                }
                                                                                                                                                                                                stringArray[5] = new String(cArray47).intern();
                                                                                                                                                                                                var0 = null;
                                                                                                                                                                                                char[] cArray77 = "\u0006\u001eI\u001d*H)I\u001f!U`\u0000".toCharArray();
                                                                                                                                                                                                n4 = 0;
                                                                                                                                                                                                int n79 = cArray77.length;
                                                                                                                                                                                                cArray46 = cArray77;
                                                                                                                                                                                                n48 = n79;
                                                                                                                                                                                                if (n79 <= 1) break block273;
                                                                                                                                                                                                cArray45 = cArray46;
                                                                                                                                                                                                n47 = n48;
                                                                                                                                                                                                if (n48 <= n4) break block274;
                                                                                                                                                                                            }
                                                                                                                                                                                            do {
                                                                                                                                                                                                char[] cArray78 = cArray46;
                                                                                                                                                                                                char[] cArray79 = cArray46;
                                                                                                                                                                                                int n80 = n4;
                                                                                                                                                                                                while (true) {
                                                                                                                                                                                                    int n81;
                                                                                                                                                                                                    char c8 = cArray78[n80];
                                                                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                                                                        case 0: {
                                                                                                                                                                                                            n81 = 38;
                                                                                                                                                                                                            break;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        case 1: {
                                                                                                                                                                                                            n81 = 90;
                                                                                                                                                                                                            break;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        case 2: {
                                                                                                                                                                                                            n81 = 32;
                                                                                                                                                                                                            break;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        case 3: {
                                                                                                                                                                                                            n81 = 112;
                                                                                                                                                                                                            break;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        default: {
                                                                                                                                                                                                            n81 = 79;
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                    cArray78[n80] = (char)(c8 ^ n81);
                                                                                                                                                                                                    ++n4;
                                                                                                                                                                                                    cArray46 = cArray79;
                                                                                                                                                                                                    n48 = n48;
                                                                                                                                                                                                    if (n48 != 0) break;
                                                                                                                                                                                                    cArray79 = cArray46;
                                                                                                                                                                                                    n47 = n48;
                                                                                                                                                                                                    n80 = n48;
                                                                                                                                                                                                    cArray78 = cArray46;
                                                                                                                                                                                                }
                                                                                                                                                                                                cArray45 = cArray46;
                                                                                                                                                                                                n47 = n48;
                                                                                                                                                                                            } while (n48 > n4);
                                                                                                                                                                                        }
                                                                                                                                                                                        stringArray[6] = new String(cArray45).intern();
                                                                                                                                                                                        var0 = null;
                                                                                                                                                                                        char[] cArray80 = "\u0006-I\u0014;N`\u0000".toCharArray();
                                                                                                                                                                                        n4 = 0;
                                                                                                                                                                                        int n82 = cArray80.length;
                                                                                                                                                                                        cArray44 = cArray80;
                                                                                                                                                                                        n46 = n82;
                                                                                                                                                                                        if (n82 <= 1) break block275;
                                                                                                                                                                                        cArray43 = cArray44;
                                                                                                                                                                                        n45 = n46;
                                                                                                                                                                                        if (n46 <= n4) break block276;
                                                                                                                                                                                    }
                                                                                                                                                                                    do {
                                                                                                                                                                                        char[] cArray81 = cArray44;
                                                                                                                                                                                        char[] cArray82 = cArray44;
                                                                                                                                                                                        int n83 = n4;
                                                                                                                                                                                        while (true) {
                                                                                                                                                                                            int n84;
                                                                                                                                                                                            char c9 = cArray81[n83];
                                                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                                                case 0: {
                                                                                                                                                                                                    n84 = 38;
                                                                                                                                                                                                    break;
                                                                                                                                                                                                }
                                                                                                                                                                                                case 1: {
                                                                                                                                                                                                    n84 = 90;
                                                                                                                                                                                                    break;
                                                                                                                                                                                                }
                                                                                                                                                                                                case 2: {
                                                                                                                                                                                                    n84 = 32;
                                                                                                                                                                                                    break;
                                                                                                                                                                                                }
                                                                                                                                                                                                case 3: {
                                                                                                                                                                                                    n84 = 112;
                                                                                                                                                                                                    break;
                                                                                                                                                                                                }
                                                                                                                                                                                                default: {
                                                                                                                                                                                                    n84 = 79;
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                            cArray81[n83] = (char)(c9 ^ n84);
                                                                                                                                                                                            ++n4;
                                                                                                                                                                                            cArray44 = cArray82;
                                                                                                                                                                                            n46 = n46;
                                                                                                                                                                                            if (n46 != 0) break;
                                                                                                                                                                                            cArray82 = cArray44;
                                                                                                                                                                                            n45 = n46;
                                                                                                                                                                                            n83 = n46;
                                                                                                                                                                                            cArray81 = cArray44;
                                                                                                                                                                                        }
                                                                                                                                                                                        cArray43 = cArray44;
                                                                                                                                                                                        n45 = n46;
                                                                                                                                                                                    } while (n46 > n4);
                                                                                                                                                                                }
                                                                                                                                                                                stringArray[7] = new String(cArray43).intern();
                                                                                                                                                                                var0 = null;
                                                                                                                                                                                char[] cArray83 = "h5TP.\u00064U\u001d-C(\u001aP".toCharArray();
                                                                                                                                                                                n4 = 0;
                                                                                                                                                                                int n85 = cArray83.length;
                                                                                                                                                                                cArray42 = cArray83;
                                                                                                                                                                                n44 = n85;
                                                                                                                                                                                if (n85 <= 1) break block277;
                                                                                                                                                                                cArray41 = cArray42;
                                                                                                                                                                                n43 = n44;
                                                                                                                                                                                if (n44 <= n4) break block278;
                                                                                                                                                                            }
                                                                                                                                                                            do {
                                                                                                                                                                                char[] cArray84 = cArray42;
                                                                                                                                                                                char[] cArray85 = cArray42;
                                                                                                                                                                                int n86 = n4;
                                                                                                                                                                                while (true) {
                                                                                                                                                                                    int n87;
                                                                                                                                                                                    char c10 = cArray84[n86];
                                                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                                                        case 0: {
                                                                                                                                                                                            n87 = 38;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        case 1: {
                                                                                                                                                                                            n87 = 90;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        case 2: {
                                                                                                                                                                                            n87 = 32;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        case 3: {
                                                                                                                                                                                            n87 = 112;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        default: {
                                                                                                                                                                                            n87 = 79;
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                    cArray84[n86] = (char)(c10 ^ n87);
                                                                                                                                                                                    ++n4;
                                                                                                                                                                                    cArray42 = cArray85;
                                                                                                                                                                                    n44 = n44;
                                                                                                                                                                                    if (n44 != 0) break;
                                                                                                                                                                                    cArray85 = cArray42;
                                                                                                                                                                                    n43 = n44;
                                                                                                                                                                                    n86 = n44;
                                                                                                                                                                                    cArray84 = cArray42;
                                                                                                                                                                                }
                                                                                                                                                                                cArray41 = cArray42;
                                                                                                                                                                                n43 = n44;
                                                                                                                                                                            } while (n44 > n4);
                                                                                                                                                                        }
                                                                                                                                                                        stringArray[8] = new String(cArray41).intern();
                                                                                                                                                                        var0 = null;
                                                                                                                                                                        char[] cArray86 = "O4C\u001f\"V;T\u0019-J?\u0000\u0014&K?N\u0003&I4S\\o".toCharArray();
                                                                                                                                                                        n4 = 0;
                                                                                                                                                                        int n88 = cArray86.length;
                                                                                                                                                                        cArray40 = cArray86;
                                                                                                                                                                        n42 = n88;
                                                                                                                                                                        if (n88 <= 1) break block279;
                                                                                                                                                                        cArray39 = cArray40;
                                                                                                                                                                        n41 = n42;
                                                                                                                                                                        if (n42 <= n4) break block280;
                                                                                                                                                                    }
                                                                                                                                                                    do {
                                                                                                                                                                        char[] cArray87 = cArray40;
                                                                                                                                                                        char[] cArray88 = cArray40;
                                                                                                                                                                        int n89 = n4;
                                                                                                                                                                        while (true) {
                                                                                                                                                                            int n90;
                                                                                                                                                                            char c11 = cArray87[n89];
                                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                                case 0: {
                                                                                                                                                                                    n90 = 38;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                case 1: {
                                                                                                                                                                                    n90 = 90;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                case 2: {
                                                                                                                                                                                    n90 = 32;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                case 3: {
                                                                                                                                                                                    n90 = 112;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                default: {
                                                                                                                                                                                    n90 = 79;
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                            cArray87[n89] = (char)(c11 ^ n90);
                                                                                                                                                                            ++n4;
                                                                                                                                                                            cArray40 = cArray88;
                                                                                                                                                                            n42 = n42;
                                                                                                                                                                            if (n42 != 0) break;
                                                                                                                                                                            cArray88 = cArray40;
                                                                                                                                                                            n41 = n42;
                                                                                                                                                                            n89 = n42;
                                                                                                                                                                            cArray87 = cArray40;
                                                                                                                                                                        }
                                                                                                                                                                        cArray39 = cArray40;
                                                                                                                                                                        n41 = n42;
                                                                                                                                                                    } while (n42 > n4);
                                                                                                                                                                }
                                                                                                                                                                stringArray[9] = new String(cArray39).intern();
                                                                                                                                                                var0 = null;
                                                                                                                                                                char[] cArray89 = "H5\u0000\u001e.K?\u0000\u0016 S4DP&HzF\u0019#CzF\u001f=\u0006>I\u001d*H)I\u001f!\u0006".toCharArray();
                                                                                                                                                                n4 = 0;
                                                                                                                                                                int n91 = cArray89.length;
                                                                                                                                                                cArray38 = cArray89;
                                                                                                                                                                n40 = n91;
                                                                                                                                                                if (n91 <= 1) break block281;
                                                                                                                                                                cArray37 = cArray38;
                                                                                                                                                                n39 = n40;
                                                                                                                                                                if (n40 <= n4) break block282;
                                                                                                                                                            }
                                                                                                                                                            do {
                                                                                                                                                                char[] cArray90 = cArray38;
                                                                                                                                                                char[] cArray91 = cArray38;
                                                                                                                                                                int n92 = n4;
                                                                                                                                                                while (true) {
                                                                                                                                                                    int n93;
                                                                                                                                                                    char c12 = cArray90[n92];
                                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                                        case 0: {
                                                                                                                                                                            n93 = 38;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        case 1: {
                                                                                                                                                                            n93 = 90;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        case 2: {
                                                                                                                                                                            n93 = 32;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        case 3: {
                                                                                                                                                                            n93 = 112;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        default: {
                                                                                                                                                                            n93 = 79;
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                    cArray90[n92] = (char)(c12 ^ n93);
                                                                                                                                                                    ++n4;
                                                                                                                                                                    cArray38 = cArray91;
                                                                                                                                                                    n40 = n40;
                                                                                                                                                                    if (n40 != 0) break;
                                                                                                                                                                    cArray91 = cArray38;
                                                                                                                                                                    n39 = n40;
                                                                                                                                                                    n92 = n40;
                                                                                                                                                                    cArray90 = cArray38;
                                                                                                                                                                }
                                                                                                                                                                cArray37 = cArray38;
                                                                                                                                                                n39 = n40;
                                                                                                                                                            } while (n40 > n4);
                                                                                                                                                        }
                                                                                                                                                        stringArray[10] = new String(cArray37).intern();
                                                                                                                                                        var0 = null;
                                                                                                                                                        char[] cArray92 = "\u000bw\r]".toCharArray();
                                                                                                                                                        n4 = 0;
                                                                                                                                                        int n94 = cArray92.length;
                                                                                                                                                        cArray36 = cArray92;
                                                                                                                                                        n38 = n94;
                                                                                                                                                        if (n94 <= 1) break block283;
                                                                                                                                                        cArray35 = cArray36;
                                                                                                                                                        n37 = n38;
                                                                                                                                                        if (n38 <= n4) break block284;
                                                                                                                                                    }
                                                                                                                                                    do {
                                                                                                                                                        char[] cArray93 = cArray36;
                                                                                                                                                        char[] cArray94 = cArray36;
                                                                                                                                                        int n95 = n4;
                                                                                                                                                        while (true) {
                                                                                                                                                            int n96;
                                                                                                                                                            char c13 = cArray93[n95];
                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                case 0: {
                                                                                                                                                                    n96 = 38;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 1: {
                                                                                                                                                                    n96 = 90;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 2: {
                                                                                                                                                                    n96 = 32;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 3: {
                                                                                                                                                                    n96 = 112;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                default: {
                                                                                                                                                                    n96 = 79;
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                            cArray93[n95] = (char)(c13 ^ n96);
                                                                                                                                                            ++n4;
                                                                                                                                                            cArray36 = cArray94;
                                                                                                                                                            n38 = n38;
                                                                                                                                                            if (n38 != 0) break;
                                                                                                                                                            cArray94 = cArray36;
                                                                                                                                                            n37 = n38;
                                                                                                                                                            n95 = n38;
                                                                                                                                                            cArray93 = cArray36;
                                                                                                                                                        }
                                                                                                                                                        cArray35 = cArray36;
                                                                                                                                                        n37 = n38;
                                                                                                                                                    } while (n38 > n4);
                                                                                                                                                }
                                                                                                                                                stringArray[11] = new String(cArray35).intern();
                                                                                                                                                var0 = null;
                                                                                                                                                char[] cArray95 = "\u0006g\u0000\u001e*Qzm\u0005<O9s\u0018.V?\b".toCharArray();
                                                                                                                                                n4 = 0;
                                                                                                                                                int n97 = cArray95.length;
                                                                                                                                                cArray34 = cArray95;
                                                                                                                                                n36 = n97;
                                                                                                                                                if (n97 <= 1) break block285;
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n35 = n36;
                                                                                                                                                if (n36 <= n4) break block286;
                                                                                                                                            }
                                                                                                                                            do {
                                                                                                                                                char[] cArray96 = cArray34;
                                                                                                                                                char[] cArray97 = cArray34;
                                                                                                                                                int n98 = n4;
                                                                                                                                                while (true) {
                                                                                                                                                    int n99;
                                                                                                                                                    char c14 = cArray96[n98];
                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                        case 0: {
                                                                                                                                                            n99 = 38;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 1: {
                                                                                                                                                            n99 = 90;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 2: {
                                                                                                                                                            n99 = 32;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 3: {
                                                                                                                                                            n99 = 112;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        default: {
                                                                                                                                                            n99 = 79;
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                    cArray96[n98] = (char)(c14 ^ n99);
                                                                                                                                                    ++n4;
                                                                                                                                                    cArray34 = cArray97;
                                                                                                                                                    n36 = n36;
                                                                                                                                                    if (n36 != 0) break;
                                                                                                                                                    cArray97 = cArray34;
                                                                                                                                                    n35 = n36;
                                                                                                                                                    n98 = n36;
                                                                                                                                                    cArray96 = cArray34;
                                                                                                                                                }
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n35 = n36;
                                                                                                                                            } while (n36 > n4);
                                                                                                                                        }
                                                                                                                                        stringArray[12] = new String(cArray33).intern();
                                                                                                                                        var0 = null;
                                                                                                                                        char[] cArray98 = "\u000fa*".toCharArray();
                                                                                                                                        n4 = 0;
                                                                                                                                        int n100 = cArray98.length;
                                                                                                                                        cArray32 = cArray98;
                                                                                                                                        n34 = n100;
                                                                                                                                        if (n100 <= 1) break block287;
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n33 = n34;
                                                                                                                                        if (n34 <= n4) break block288;
                                                                                                                                    }
                                                                                                                                    do {
                                                                                                                                        char[] cArray99 = cArray32;
                                                                                                                                        char[] cArray100 = cArray32;
                                                                                                                                        int n101 = n4;
                                                                                                                                        while (true) {
                                                                                                                                            int n102;
                                                                                                                                            char c15 = cArray99[n101];
                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                case 0: {
                                                                                                                                                    n102 = 38;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 1: {
                                                                                                                                                    n102 = 90;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 2: {
                                                                                                                                                    n102 = 32;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 3: {
                                                                                                                                                    n102 = 112;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                default: {
                                                                                                                                                    n102 = 79;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            cArray99[n101] = (char)(c15 ^ n102);
                                                                                                                                            ++n4;
                                                                                                                                            cArray32 = cArray100;
                                                                                                                                            n34 = n34;
                                                                                                                                            if (n34 != 0) break;
                                                                                                                                            cArray100 = cArray32;
                                                                                                                                            n33 = n34;
                                                                                                                                            n101 = n34;
                                                                                                                                            cArray99 = cArray32;
                                                                                                                                        }
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n33 = n34;
                                                                                                                                    } while (n34 > n4);
                                                                                                                                }
                                                                                                                                stringArray[13] = new String(cArray31).intern();
                                                                                                                                var0 = null;
                                                                                                                                char[] cArray101 = "\u0006s\u001bz".toCharArray();
                                                                                                                                n4 = 0;
                                                                                                                                int n103 = cArray101.length;
                                                                                                                                cArray30 = cArray101;
                                                                                                                                n32 = n103;
                                                                                                                                if (n103 <= 1) break block289;
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n31 = n32;
                                                                                                                                if (n32 <= n4) break block290;
                                                                                                                            }
                                                                                                                            do {
                                                                                                                                char[] cArray102 = cArray30;
                                                                                                                                char[] cArray103 = cArray30;
                                                                                                                                int n104 = n4;
                                                                                                                                while (true) {
                                                                                                                                    int n105;
                                                                                                                                    char c16 = cArray102[n104];
                                                                                                                                    switch (n4 % 5) {
                                                                                                                                        case 0: {
                                                                                                                                            n105 = 38;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 1: {
                                                                                                                                            n105 = 90;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 2: {
                                                                                                                                            n105 = 32;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 3: {
                                                                                                                                            n105 = 112;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        default: {
                                                                                                                                            n105 = 79;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    cArray102[n104] = (char)(c16 ^ n105);
                                                                                                                                    ++n4;
                                                                                                                                    cArray30 = cArray103;
                                                                                                                                    n32 = n32;
                                                                                                                                    if (n32 != 0) break;
                                                                                                                                    cArray103 = cArray30;
                                                                                                                                    n31 = n32;
                                                                                                                                    n104 = n32;
                                                                                                                                    cArray102 = cArray30;
                                                                                                                                }
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n31 = n32;
                                                                                                                            } while (n32 > n4);
                                                                                                                        }
                                                                                                                        stringArray[14] = new String(cArray29).intern();
                                                                                                                        var0 = null;
                                                                                                                        char[] cArray104 = "\b)E\u0004\u000bC<A\u0005#Rr".toCharArray();
                                                                                                                        n4 = 0;
                                                                                                                        int n106 = cArray104.length;
                                                                                                                        cArray28 = cArray104;
                                                                                                                        n30 = n106;
                                                                                                                        if (n106 <= 1) break block291;
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n29 = n30;
                                                                                                                        if (n30 <= n4) break block292;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        char[] cArray105 = cArray28;
                                                                                                                        char[] cArray106 = cArray28;
                                                                                                                        int n107 = n4;
                                                                                                                        while (true) {
                                                                                                                            int n108;
                                                                                                                            char c17 = cArray105[n107];
                                                                                                                            switch (n4 % 5) {
                                                                                                                                case 0: {
                                                                                                                                    n108 = 38;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 1: {
                                                                                                                                    n108 = 90;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 2: {
                                                                                                                                    n108 = 32;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 3: {
                                                                                                                                    n108 = 112;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                default: {
                                                                                                                                    n108 = 79;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            cArray105[n107] = (char)(c17 ^ n108);
                                                                                                                            ++n4;
                                                                                                                            cArray28 = cArray106;
                                                                                                                            n30 = n30;
                                                                                                                            if (n30 != 0) break;
                                                                                                                            cArray106 = cArray28;
                                                                                                                            n29 = n30;
                                                                                                                            n107 = n30;
                                                                                                                            cArray105 = cArray28;
                                                                                                                        }
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n29 = n30;
                                                                                                                    } while (n30 > n4);
                                                                                                                }
                                                                                                                stringArray[15] = new String(cArray27).intern();
                                                                                                                var0 = null;
                                                                                                                char[] cArray107 = "\b)E\u0004\u000bO7E\u001e<O5N>.K?\bP".toCharArray();
                                                                                                                n4 = 0;
                                                                                                                int n109 = cArray107.length;
                                                                                                                cArray26 = cArray107;
                                                                                                                n28 = n109;
                                                                                                                if (n109 <= 1) break block293;
                                                                                                                cArray25 = cArray26;
                                                                                                                n27 = n28;
                                                                                                                if (n28 <= n4) break block294;
                                                                                                            }
                                                                                                            do {
                                                                                                                char[] cArray108 = cArray26;
                                                                                                                char[] cArray109 = cArray26;
                                                                                                                int n110 = n4;
                                                                                                                while (true) {
                                                                                                                    int n111;
                                                                                                                    char c18 = cArray108[n110];
                                                                                                                    switch (n4 % 5) {
                                                                                                                        case 0: {
                                                                                                                            n111 = 38;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 1: {
                                                                                                                            n111 = 90;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 2: {
                                                                                                                            n111 = 32;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 3: {
                                                                                                                            n111 = 112;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        default: {
                                                                                                                            n111 = 79;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    cArray108[n110] = (char)(c18 ^ n111);
                                                                                                                    ++n4;
                                                                                                                    cArray26 = cArray109;
                                                                                                                    n28 = n28;
                                                                                                                    if (n28 != 0) break;
                                                                                                                    cArray109 = cArray26;
                                                                                                                    n27 = n28;
                                                                                                                    n110 = n28;
                                                                                                                    cArray108 = cArray26;
                                                                                                                }
                                                                                                                cArray25 = cArray26;
                                                                                                                n27 = n28;
                                                                                                            } while (n28 > n4);
                                                                                                        }
                                                                                                        stringArray[16] = new String(cArray25).intern();
                                                                                                        var0 = null;
                                                                                                        char[] cArray110 = "k/S\u0019,u2A\u0000*\u0006".toCharArray();
                                                                                                        n4 = 0;
                                                                                                        int n112 = cArray110.length;
                                                                                                        cArray24 = cArray110;
                                                                                                        n26 = n112;
                                                                                                        if (n112 <= 1) break block295;
                                                                                                        cArray23 = cArray24;
                                                                                                        n25 = n26;
                                                                                                        if (n26 <= n4) break block296;
                                                                                                    }
                                                                                                    do {
                                                                                                        char[] cArray111 = cArray24;
                                                                                                        char[] cArray112 = cArray24;
                                                                                                        int n113 = n4;
                                                                                                        while (true) {
                                                                                                            int n114;
                                                                                                            char c19 = cArray111[n113];
                                                                                                            switch (n4 % 5) {
                                                                                                                case 0: {
                                                                                                                    n114 = 38;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 1: {
                                                                                                                    n114 = 90;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 2: {
                                                                                                                    n114 = 32;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 3: {
                                                                                                                    n114 = 112;
                                                                                                                    break;
                                                                                                                }
                                                                                                                default: {
                                                                                                                    n114 = 79;
                                                                                                                }
                                                                                                            }
                                                                                                            cArray111[n113] = (char)(c19 ^ n114);
                                                                                                            ++n4;
                                                                                                            cArray24 = cArray112;
                                                                                                            n26 = n26;
                                                                                                            if (n26 != 0) break;
                                                                                                            cArray112 = cArray24;
                                                                                                            n25 = n26;
                                                                                                            n113 = n26;
                                                                                                            cArray111 = cArray24;
                                                                                                        }
                                                                                                        cArray23 = cArray24;
                                                                                                        n25 = n26;
                                                                                                    } while (n26 > n4);
                                                                                                }
                                                                                                stringArray[17] = new String(cArray23).intern();
                                                                                                var0 = null;
                                                                                                char[] cArray113 = "\u0004s\u001bz".toCharArray();
                                                                                                n4 = 0;
                                                                                                int n115 = cArray113.length;
                                                                                                cArray22 = cArray113;
                                                                                                n24 = n115;
                                                                                                if (n115 <= 1) break block297;
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                                if (n24 <= n4) break block298;
                                                                                            }
                                                                                            do {
                                                                                                char[] cArray114 = cArray22;
                                                                                                char[] cArray115 = cArray22;
                                                                                                int n116 = n4;
                                                                                                while (true) {
                                                                                                    int n117;
                                                                                                    char c20 = cArray114[n116];
                                                                                                    switch (n4 % 5) {
                                                                                                        case 0: {
                                                                                                            n117 = 38;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 1: {
                                                                                                            n117 = 90;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 2: {
                                                                                                            n117 = 32;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 3: {
                                                                                                            n117 = 112;
                                                                                                            break;
                                                                                                        }
                                                                                                        default: {
                                                                                                            n117 = 79;
                                                                                                        }
                                                                                                    }
                                                                                                    cArray114[n116] = (char)(c20 ^ n117);
                                                                                                    ++n4;
                                                                                                    cArray22 = cArray115;
                                                                                                    n24 = n24;
                                                                                                    if (n24 != 0) break;
                                                                                                    cArray115 = cArray22;
                                                                                                    n23 = n24;
                                                                                                    n116 = n24;
                                                                                                    cArray114 = cArray22;
                                                                                                }
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                            } while (n24 > n4);
                                                                                        }
                                                                                        stringArray[18] = new String(cArray21).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray116 = "\nz\u0002".toCharArray();
                                                                                        n4 = 0;
                                                                                        int n118 = cArray116.length;
                                                                                        cArray20 = cArray116;
                                                                                        n22 = n118;
                                                                                        if (n118 <= 1) break block299;
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                        if (n22 <= n4) break block300;
                                                                                    }
                                                                                    do {
                                                                                        char[] cArray117 = cArray20;
                                                                                        char[] cArray118 = cArray20;
                                                                                        int n119 = n4;
                                                                                        while (true) {
                                                                                            int n120;
                                                                                            char c21 = cArray117[n119];
                                                                                            switch (n4 % 5) {
                                                                                                case 0: {
                                                                                                    n120 = 38;
                                                                                                    break;
                                                                                                }
                                                                                                case 1: {
                                                                                                    n120 = 90;
                                                                                                    break;
                                                                                                }
                                                                                                case 2: {
                                                                                                    n120 = 32;
                                                                                                    break;
                                                                                                }
                                                                                                case 3: {
                                                                                                    n120 = 112;
                                                                                                    break;
                                                                                                }
                                                                                                default: {
                                                                                                    n120 = 79;
                                                                                                }
                                                                                            }
                                                                                            cArray117[n119] = (char)(c21 ^ n120);
                                                                                            ++n4;
                                                                                            cArray20 = cArray118;
                                                                                            n22 = n22;
                                                                                            if (n22 != 0) break;
                                                                                            cArray118 = cArray20;
                                                                                            n21 = n22;
                                                                                            n119 = n22;
                                                                                            cArray117 = cArray20;
                                                                                        }
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                    } while (n22 > n4);
                                                                                }
                                                                                stringArray[19] = new String(cArray19).intern();
                                                                                var0 = null;
                                                                                char[] cArray119 = "\b;D\u0014g\u0006".toCharArray();
                                                                                n4 = 0;
                                                                                int n121 = cArray119.length;
                                                                                cArray18 = cArray119;
                                                                                n20 = n121;
                                                                                if (n121 <= 1) break block301;
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                                if (n20 <= n4) break block302;
                                                                            }
                                                                            do {
                                                                                char[] cArray120 = cArray18;
                                                                                char[] cArray121 = cArray18;
                                                                                int n122 = n4;
                                                                                while (true) {
                                                                                    int n123;
                                                                                    char c22 = cArray120[n122];
                                                                                    switch (n4 % 5) {
                                                                                        case 0: {
                                                                                            n123 = 38;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n123 = 90;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n123 = 32;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n123 = 112;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n123 = 79;
                                                                                        }
                                                                                    }
                                                                                    cArray120[n122] = (char)(c22 ^ n123);
                                                                                    ++n4;
                                                                                    cArray18 = cArray121;
                                                                                    n20 = n20;
                                                                                    if (n20 != 0) break;
                                                                                    cArray121 = cArray18;
                                                                                    n19 = n20;
                                                                                    n122 = n20;
                                                                                    cArray120 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                            } while (n20 > n4);
                                                                        }
                                                                        stringArray[20] = new String(cArray17).intern();
                                                                        var0 = null;
                                                                        char[] cArray122 = "\b)E\u0004\u0003O7I\u0004<\u000e".toCharArray();
                                                                        n4 = 0;
                                                                        int n124 = cArray122.length;
                                                                        cArray16 = cArray122;
                                                                        n18 = n124;
                                                                        if (n124 <= 1) break block303;
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                        if (n18 <= n4) break block304;
                                                                    }
                                                                    do {
                                                                        char[] cArray123 = cArray16;
                                                                        char[] cArray124 = cArray16;
                                                                        int n125 = n4;
                                                                        while (true) {
                                                                            int n126;
                                                                            char c23 = cArray123[n125];
                                                                            switch (n4 % 5) {
                                                                                case 0: {
                                                                                    n126 = 38;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n126 = 90;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n126 = 32;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n126 = 112;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n126 = 79;
                                                                                }
                                                                            }
                                                                            cArray123[n125] = (char)(c23 ^ n126);
                                                                            ++n4;
                                                                            cArray16 = cArray124;
                                                                            n18 = n18;
                                                                            if (n18 != 0) break;
                                                                            cArray124 = cArray16;
                                                                            n17 = n18;
                                                                            n125 = n18;
                                                                            cArray123 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                    } while (n18 > n4);
                                                                }
                                                                stringArray[21] = new String(cArray15).intern();
                                                                var0 = null;
                                                                char[] cArray125 = "K/S\u0019,u2A\u0000*y".toCharArray();
                                                                n4 = 0;
                                                                int n127 = cArray125.length;
                                                                cArray14 = cArray125;
                                                                n16 = n127;
                                                                if (n127 <= 1) break block305;
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                                if (n16 <= n4) break block306;
                                                            }
                                                            do {
                                                                char[] cArray126 = cArray14;
                                                                char[] cArray127 = cArray14;
                                                                int n128 = n4;
                                                                while (true) {
                                                                    int n129;
                                                                    char c24 = cArray126[n128];
                                                                    switch (n4 % 5) {
                                                                        case 0: {
                                                                            n129 = 38;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n129 = 90;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n129 = 32;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n129 = 112;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n129 = 79;
                                                                        }
                                                                    }
                                                                    cArray126[n128] = (char)(c24 ^ n129);
                                                                    ++n4;
                                                                    cArray14 = cArray127;
                                                                    n16 = n16;
                                                                    if (n16 != 0) break;
                                                                    cArray127 = cArray14;
                                                                    n15 = n16;
                                                                    n128 = n16;
                                                                    cArray126 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                            } while (n16 > n4);
                                                        }
                                                        stringArray[22] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray128 = "B3M/".toCharArray();
                                                        n4 = 0;
                                                        int n130 = cArray128.length;
                                                        cArray12 = cArray128;
                                                        n14 = n130;
                                                        if (n130 <= 1) break block307;
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                        if (n14 <= n4) break block308;
                                                    }
                                                    do {
                                                        char[] cArray129 = cArray12;
                                                        char[] cArray130 = cArray12;
                                                        int n131 = n4;
                                                        while (true) {
                                                            int n132;
                                                            char c25 = cArray129[n131];
                                                            switch (n4 % 5) {
                                                                case 0: {
                                                                    n132 = 38;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n132 = 90;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n132 = 32;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n132 = 112;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n132 = 79;
                                                                }
                                                            }
                                                            cArray129[n131] = (char)(c25 ^ n132);
                                                            ++n4;
                                                            cArray12 = cArray130;
                                                            n14 = n14;
                                                            if (n14 != 0) break;
                                                            cArray130 = cArray12;
                                                            n13 = n14;
                                                            n131 = n14;
                                                            cArray129 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                    } while (n14 > n4);
                                                }
                                                stringArray[23] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray131 = "\u000bw\r]E".toCharArray();
                                                n4 = 0;
                                                int n133 = cArray131.length;
                                                cArray10 = cArray131;
                                                n12 = n133;
                                                if (n133 <= 1) break block309;
                                                cArray9 = cArray10;
                                                n11 = n12;
                                                if (n12 <= n4) break block310;
                                            }
                                            do {
                                                char[] cArray132 = cArray10;
                                                char[] cArray133 = cArray10;
                                                int n134 = n4;
                                                while (true) {
                                                    int n135;
                                                    char c26 = cArray132[n134];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n135 = 38;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n135 = 90;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n135 = 32;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n135 = 112;
                                                            break;
                                                        }
                                                        default: {
                                                            n135 = 79;
                                                        }
                                                    }
                                                    cArray132[n134] = (char)(c26 ^ n135);
                                                    ++n4;
                                                    cArray10 = cArray133;
                                                    n12 = n12;
                                                    if (n12 != 0) break;
                                                    cArray133 = cArray10;
                                                    n11 = n12;
                                                    n134 = n12;
                                                    cArray132 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n11 = n12;
                                            } while (n12 > n4);
                                        }
                                        stringArray[24] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray134 = "b5U\u0012#Ctp?\u001co\u000ei&\ny\u0013n6\u0006h\u0013t)".toCharArray();
                                        n4 = 0;
                                        int n136 = cArray134.length;
                                        cArray8 = cArray134;
                                        n10 = n136;
                                        if (n136 <= 1) break block311;
                                        cArray7 = cArray8;
                                        n9 = n10;
                                        if (n10 <= n4) break block312;
                                    }
                                    do {
                                        char[] cArray135 = cArray8;
                                        char[] cArray136 = cArray8;
                                        int n137 = n4;
                                        while (true) {
                                            int n138;
                                            char c27 = cArray135[n137];
                                            switch (n4 % 5) {
                                                case 0: {
                                                    n138 = 38;
                                                    break;
                                                }
                                                case 1: {
                                                    n138 = 90;
                                                    break;
                                                }
                                                case 2: {
                                                    n138 = 32;
                                                    break;
                                                }
                                                case 3: {
                                                    n138 = 112;
                                                    break;
                                                }
                                                default: {
                                                    n138 = 79;
                                                }
                                            }
                                            cArray135[n137] = (char)(c27 ^ n138);
                                            ++n4;
                                            cArray8 = cArray136;
                                            n10 = n10;
                                            if (n10 != 0) break;
                                            cArray136 = cArray8;
                                            n9 = n10;
                                            n137 = n10;
                                            cArray135 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n9 = n10;
                                    } while (n10 > n4);
                                }
                                stringArray[25] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray137 = "b5U\u0012#Ctn5\bg\u000ei&\ny\u0013n6\u0006h\u0013t)".toCharArray();
                                n4 = 0;
                                int n139 = cArray137.length;
                                cArray6 = cArray137;
                                n8 = n139;
                                if (n139 <= 1) break block313;
                                cArray5 = cArray6;
                                n7 = n8;
                                if (n8 <= n4) break block314;
                            }
                            do {
                                char[] cArray138 = cArray6;
                                char[] cArray139 = cArray6;
                                int n140 = n4;
                                while (true) {
                                    int n141;
                                    char c28 = cArray138[n140];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n141 = 38;
                                            break;
                                        }
                                        case 1: {
                                            n141 = 90;
                                            break;
                                        }
                                        case 2: {
                                            n141 = 32;
                                            break;
                                        }
                                        case 3: {
                                            n141 = 112;
                                            break;
                                        }
                                        default: {
                                            n141 = 79;
                                        }
                                    }
                                    cArray138[n140] = (char)(c28 ^ n141);
                                    ++n4;
                                    cArray6 = cArray139;
                                    n8 = n8;
                                    if (n8 != 0) break;
                                    cArray139 = cArray6;
                                    n7 = n8;
                                    n140 = n8;
                                    cArray138 = cArray6;
                                }
                                cArray5 = cArray6;
                                n7 = n8;
                            } while (n8 > n4);
                        }
                        stringArray[26] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray140 = "\u0006.OP\u0002S)I\u0013\u001cN;P\u0015oI<\u0000\u0014&K?N\u0003&I4\u0000".toCharArray();
                        n4 = 0;
                        int n142 = cArray140.length;
                        cArray4 = cArray140;
                        n6 = n142;
                        if (n142 <= 1) break block315;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block316;
                    }
                    do {
                        char[] cArray141 = cArray4;
                        char[] cArray142 = cArray4;
                        int n143 = n4;
                        while (true) {
                            int n144;
                            char c29 = cArray141[n143];
                            switch (n4 % 5) {
                                case 0: {
                                    n144 = 38;
                                    break;
                                }
                                case 1: {
                                    n144 = 90;
                                    break;
                                }
                                case 2: {
                                    n144 = 32;
                                    break;
                                }
                                case 3: {
                                    n144 = 112;
                                    break;
                                }
                                default: {
                                    n144 = 79;
                                }
                            }
                            cArray141[n143] = (char)(c29 ^ n144);
                            ++n4;
                            cArray4 = cArray142;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray142 = cArray4;
                            n5 = n6;
                            n143 = n6;
                            cArray141 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[27] = new String(cArray3).intern();
                var0 = null;
                char[] cArray143 = "r(I\u0015+\u0006.OP.B>\bYoG(R\u00116\u00065FP#C4G\u0004'\u0006".toCharArray();
                n4 = 0;
                int n145 = cArray143.length;
                cArray2 = cArray143;
                n3 = n145;
                if (n145 <= 1) break block317;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block318;
            }
            do {
                char[] cArray144 = cArray2;
                char[] cArray145 = cArray2;
                int n146 = n4;
                while (true) {
                    int n147;
                    char c30 = cArray144[n146];
                    switch (n4 % 5) {
                        case 0: {
                            n147 = 38;
                            break;
                        }
                        case 1: {
                            n147 = 90;
                            break;
                        }
                        case 2: {
                            n147 = 32;
                            break;
                        }
                        case 3: {
                            n147 = 112;
                            break;
                        }
                        default: {
                            n147 = 79;
                        }
                    }
                    cArray144[n146] = (char)(c30 ^ n147);
                    ++n4;
                    cArray2 = cArray145;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray145 = cArray2;
                    n2 = n3;
                    n146 = n3;
                    cArray144 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[28] = new String(cArray).intern();
        F = stringArray;
        z = 1;
        D = true;
    }
}

