/*
 * Decompiled with CFR 0.152.
 */
package hu.sadam.musicxml;

import com.algomusic.max.MaxScoreInstrument;
import com.algomusic.max.MaxScoreRenderedMessageListener;
import com.softsynth.jmsl.score.KeySignature;
import com.softsynth.jmsl.score.Measure;
import com.softsynth.jmsl.score.Orchestra;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.Staff;
import com.softsynth.jmsl.score.Track;
import com.softsynth.jmsl.util.TimeSignature;
import hu.sadam.musicxml.jaxb.Articulations;
import hu.sadam.musicxml.jaxb.Attributes;
import hu.sadam.musicxml.jaxb.Backup;
import hu.sadam.musicxml.jaxb.Barline;
import hu.sadam.musicxml.jaxb.Beam;
import hu.sadam.musicxml.jaxb.BeamValue;
import hu.sadam.musicxml.jaxb.Clef;
import hu.sadam.musicxml.jaxb.ClefSign;
import hu.sadam.musicxml.jaxb.Direction;
import hu.sadam.musicxml.jaxb.DirectionType;
import hu.sadam.musicxml.jaxb.Dynamics;
import hu.sadam.musicxml.jaxb.Fermata;
import hu.sadam.musicxml.jaxb.FormattedText;
import hu.sadam.musicxml.jaxb.Forward;
import hu.sadam.musicxml.jaxb.Key;
import hu.sadam.musicxml.jaxb.Lyric;
import hu.sadam.musicxml.jaxb.MidiInstrument;
import hu.sadam.musicxml.jaxb.Notations;
import hu.sadam.musicxml.jaxb.Note;
import hu.sadam.musicxml.jaxb.Notehead;
import hu.sadam.musicxml.jaxb.Ornaments;
import hu.sadam.musicxml.jaxb.PageMargins;
import hu.sadam.musicxml.jaxb.PerMinute;
import hu.sadam.musicxml.jaxb.Pitch;
import hu.sadam.musicxml.jaxb.ScorePart;
import hu.sadam.musicxml.jaxb.ScorePartwise;
import hu.sadam.musicxml.jaxb.Slur;
import hu.sadam.musicxml.jaxb.StaffLayout;
import hu.sadam.musicxml.jaxb.StartStop;
import hu.sadam.musicxml.jaxb.StartStopContinue;
import hu.sadam.musicxml.jaxb.Step;
import hu.sadam.musicxml.jaxb.Technical;
import hu.sadam.musicxml.jaxb.TextElementData;
import hu.sadam.musicxml.jaxb.Tie;
import hu.sadam.musicxml.jaxb.Time;
import hu.sadam.musicxml.jaxb.TimeModification;
import hu.sadam.musicxml.jaxb.Transpose;
import hu.sadam.musicxml.jaxb.Tremolo;
import hu.sadam.musicxml.jaxb.TypedText;
import hu.sadam.musicxml.jaxb.UpDownStopContinue;
import hu.sadam.musicxml.jaxb.WedgeType;
import hu.sadam.musicxml.jaxb.YesNo;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class MusicXMLtoJScoreXMLConverter {
    public static final String version = "2012-11-11";
    private static Unmarshaller unmarshaller;
    private static Transformer transformer;
    private int minTrackCount;
    private ScorePartwise root;
    private HashMap<ScorePart, PartDescriptor> parts;
    private Score score;

    public static double convertToDouble(BigDecimal bd) {
        double result = 0.0;
        if (bd != null) {
            result = bd.doubleValue();
        }
        return result;
    }

    public static int convertToInt(BigInteger bi) {
        int result = 0;
        if (bi != null) {
            result = bi.intValue();
        }
        return result;
    }

    public static int convertToInt(String s) {
        int result = 0;
        if (s != null) {
            try {
                result = new Integer(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static int convertToIndex(BigInteger bi) {
        int result = 0;
        if (bi != null) {
            result = bi.intValue() - 1;
        }
        return result;
    }

    public static int convertToIndex(String s) {
        int result = 0;
        if (s != null) {
            try {
                result = new Integer(s) - 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private static int convertHexDigitToDecimal(char c) {
        switch (c) {
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    private static int convertHexCodeToByte(String s) {
        if (s == null || s.length() > 2) {
            return 0;
        }
        if (s.length() == 1) {
            s = String.valueOf('0') + s;
        }
        return MusicXMLtoJScoreXMLConverter.convertHexDigitToDecimal(s.charAt(1)) + (MusicXMLtoJScoreXMLConverter.convertHexDigitToDecimal(s.charAt(0)) << 4);
    }

    public static Color convertToColor(String s) {
        int alpha = 255;
        int red = 0;
        int green = 0;
        int blue = 0;
        if (s != null && (s.length() == 7 || s.length() == 9) && s.startsWith("#")) {
            if (s.length() == 9) {
                alpha = MusicXMLtoJScoreXMLConverter.convertHexCodeToByte(s.substring(1, 3));
                s = s.substring(3);
            } else {
                s = s.substring(1);
            }
            red = MusicXMLtoJScoreXMLConverter.convertHexCodeToByte(s.substring(0, 2));
            green = MusicXMLtoJScoreXMLConverter.convertHexCodeToByte(s.substring(2, 4));
            blue = MusicXMLtoJScoreXMLConverter.convertHexCodeToByte(s.substring(4));
        }
        return new Color(red, green, blue, alpha);
    }

    public static double convertTypeToDuration(String type, int dots) {
        double duration = 0.0;
        if (type == null) {
            return duration;
        }
        if ((type = type.toLowerCase()).equals("long")) {
            duration = 16.0;
        } else if (type.equals("breve")) {
            duration = 8.0;
        } else if (type.equals("whole")) {
            duration = 4.0;
        } else if (type.equals("half")) {
            duration = 2.0;
        } else if (type.equals("quarter")) {
            duration = 1.0;
        } else if (type.equals("8th") || type.equals("eighth")) {
            duration = 0.5;
        } else if (type.equals("16th") || type.equals("sixteenth")) {
            duration = 0.25;
        } else if (type.equals("32nd") || type.equals("thirtysecond")) {
            duration = 0.125;
        } else if (type.equals("64th") || type.equals("sixtyforth")) {
            duration = 0.0625;
        } else if (type.equals("128th") || type.equals("onetwentyeighth")) {
            duration = 0.03125;
        } else if (type.equals("256th") || type.equals("twofiftysixth")) {
            duration = 0.015625;
        }
        if (dots > 0) {
            duration *= (1.0 - Math.pow(0.5, dots + 1)) / 0.5;
        }
        return duration;
    }

    public static int convertDynamics(Dynamics d) {
        for (JAXBElement<?> j : d.getPOrPpOrPpp()) {
            String s = j.getName().getLocalPart().toLowerCase();
            if (s.equals("fff")) {
                return 8;
            }
            if (s.equals("ff")) {
                return 7;
            }
            if (s.equals("f")) {
                return 6;
            }
            if (s.equals("mf")) {
                return 5;
            }
            if (s.equals("mp")) {
                return 4;
            }
            if (s.equals("p")) {
                return 3;
            }
            if (s.equals("pp")) {
                return 2;
            }
            if (!s.equals("ppp")) continue;
            return 1;
        }
        return 0;
    }

    protected Measure getCurrentMeasure() {
        return this.score.getMeasure(this.score.getCurrentMeasureNumber());
    }

    protected Staff getCurrentStaff() {
        return this.getCurrentMeasure().getStaff(this.score.getCurrentStaffNumber());
    }

    protected Track getCurrentTrack() {
        return this.getCurrentStaff().getTrack(this.score.getCurrentTrackNumber());
    }

    protected Staff getStaff(int staveNumber) {
        return this.score.getMeasure(this.score.getCurrentMeasureNumber()).getStaff(staveNumber);
    }

    protected Staff getStaff(ScorePartwise.Part p, BigInteger staveNumber) {
        return this.score.getMeasure(this.score.getCurrentMeasureNumber()).getStaff(MusicXMLtoJScoreXMLConverter.convertToIndex(staveNumber) + this.parts.get((Object)p.getId()).baseStaff);
    }

    protected void gotoMeasure(ScorePartwise.Part.Measure m) {
        if (m.getNumber() != null) {
            this.score.setCurrentMeasureNumber(MusicXMLtoJScoreXMLConverter.convertToIndex(m.getNumber()));
        }
    }

    protected void gotoStaff(ScorePartwise.Part p, BigInteger i) {
        this.score.setCurrentStaffNumber(this.parts.get((Object)p.getId()).baseStaff + MusicXMLtoJScoreXMLConverter.convertToIndex(i));
    }

    protected int getY(double pitch, BigDecimal value) {
        if (value == null) {
            return 0;
        }
        return (int)(-1.2 * (double)value.intValue());
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void buildScoreSkeleton(boolean maxScore) {
        partList = new ArrayList<ScorePart>();
        stavesInParts = new HashMap<ScorePart, Integer>();
        for (Object o : this.root.getPartList().getPartGroupOrScorePart()) {
            if (!(o instanceof ScorePart)) continue;
            partList.add((ScorePart)o);
        }
        measures = 0;
        trackCount = this.minTrackCount;
        for (Object currentPart : this.root.getPart()) {
            staveCount = 1;
            for (ScorePartwise.Part.Measure currentMeasure : currentPart.getMeasure()) {
                measures = Math.max(measures, MusicXMLtoJScoreXMLConverter.convertToInt(currentMeasure.getNumber()));
                for (Object o : currentMeasure.getNoteOrBackupOrForward()) {
                    if (!(o instanceof Attributes)) continue;
                    staveCount = Math.max(staveCount, MusicXMLtoJScoreXMLConverter.convertToInt(((Attributes)o).getStaves()));
                }
                for (Object o : currentMeasure.getNoteOrBackupOrForward()) {
                    if (!(o instanceof Note) && !(o instanceof Direction) && !(o instanceof Forward)) continue;
                    voice = null;
                    if (o instanceof Note) {
                        voice = ((Note)o).getVoice();
                    }
                    if (o instanceof Direction) {
                        voice = ((Direction)o).getVoice();
                    }
                    if (o instanceof Forward) {
                        voice = ((Forward)o).getVoice();
                    }
                    trackCount = Math.max(trackCount, MusicXMLtoJScoreXMLConverter.convertToInt(voice));
                }
            }
            stavesInParts.put((ScorePart)currentPart.getId(), staveCount);
        }
        this.parts = new HashMap<K, V>();
        staveCount = 0;
        for (Object currentPart : partList) {
            newDescriptor = new PartDescriptor();
            newDescriptor.baseStaff = staveCount;
            newDescriptor.staveCount = (Integer)stavesInParts.get(currentPart);
            staveCount += newDescriptor.staveCount;
            this.parts.put((ScorePart)currentPart, newDescriptor);
        }
        width = 800;
        height = 600;
        if (this.root.getDefaults() != null && this.root.getDefaults().getPageLayout() != null) {
            pl = this.root.getDefaults().getPageLayout();
            if (pl.getPageHeight() != null) {
                height = pl.getPageHeight().intValue();
            }
            if (pl.getPageWidth() != null) {
                width = pl.getPageWidth().intValue();
            }
        }
        this.score = new Score(staveCount, width, height);
        if (this.root.getWork() != null) {
            this.score.setName(this.root.getWork().getWorkTitle());
            this.score.setScoreSubtitle(this.root.getMovementTitle());
        } else {
            this.score.setName(this.root.getMovementTitle());
        }
        if (this.root.getIdentification() != null) {
            for (TypedText creator : this.root.getIdentification().getCreator()) {
                if (!creator.getType().equalsIgnoreCase("composer")) continue;
                this.score.setComposer(creator.getValue());
            }
            for (TypedText rights : this.root.getIdentification().getRights()) {
                this.score.setCopyright(rights.getValue());
            }
        }
        if (this.root.getDefaults() != null) {
            if (this.root.getDefaults().getPageLayout() != null) {
                for (PageMargins pm : this.root.getDefaults().getPageLayout().getPageMargins()) {
                    if (pm.getTopMargin() != null) {
                        this.score.setTopMargin(pm.getTopMargin().doubleValue());
                    }
                    if (pm.getBottomMargin() != null) {
                        this.score.setBottomMargin(pm.getBottomMargin().doubleValue());
                    }
                    if (pm.getLeftMargin() != null) {
                        this.score.setLeftMargin(pm.getLeftMargin().doubleValue());
                    }
                    if (pm.getRightMargin() == null) continue;
                    this.score.setRightMargin(pm.getRightMargin().doubleValue());
                }
            }
            this.root.getDefaults().getSystemLayout();
            if (this.root.getDefaults().getStaffLayout() != null) {
                for (StaffLayout sl : this.root.getDefaults().getStaffLayout()) {
                    sl.getNumber();
                }
            }
        }
        this.score.setOrchestra(new Orchestra());
        if (maxScore) {
            i = 0;
            while (i != staveCount) {
                newInstrument = new MaxScoreInstrument();
                newInstrument.setInsIndex(i);
                newInstrument.setEditEnabled(true);
                newInstrument.setName("MaxScoreIns-" + i);
                newInstrument.setMixerClassName("com.softsynth.jmsl.NullMixer");
                newInstrument.setTransposition(0.0);
                this.score.getOrchestra().addInstrument(newInstrument);
                ++i;
            }
        }
        this.score.setNumTracksPerStaff(trackCount);
        while (measures != 0) {
            --measures;
            this.score.addMeasure();
            this.score.setCurrentMeasureNumber(this.score.size() - 1);
            i = staveCount;
            while (i != 0) {
                block32: {
                    if ((currentStaff = this.getStaff(--i)).getInstrument() != null) break block32;
                    partIndex = 0;
                    if (true) ** GOTO lbl110
                    do {
                        ++partIndex;
lbl110:
                        // 2 sources

                        if (partIndex >= partList.size()) break;
                        pd = this.parts.get(partList.get(partIndex));
                    } while (i < pd.baseStaff || pd.baseStaff + pd.staveCount <= i);
                    currentStaff.setInstrumentIndex(partIndex);
                    currentStaff.setInstrument();
                }
                currentStaff.removeAll();
                j = trackCount;
                while (j != 0) {
                    --j;
                    currentStaff.addTrack();
                }
            }
        }
        if (maxScore) {
            this.score.addUserBean(new MaxScoreRenderedMessageListener());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void parse() {
        HashSet<Integer> parsedMeasureSet = new HashSet<Integer>();
        for (ScorePartwise.Part currentPart : this.root.getPart()) {
            this.gotoStaff(currentPart, null);
            FormattedText textToSet = null;
            double invDivisions = 1.0;
            double velocity = 0.8;
            HashMap<Integer, WedgeType> wedgeMap = new HashMap<Integer, WedgeType>();
            HashMap ottavaMap = new HashMap();
            HashMap<Integer, StartStopContinue> slurMap = new HashMap<Integer, StartStopContinue>();
            int dynamicsToSet = 0;
            int staveCount = this.parts.get((Object)((ScorePart)currentPart.getId())).staveCount;
            int baseStaff = this.parts.get((Object)((ScorePart)currentPart.getId())).baseStaff;
            for (Object midiDeviceAndMidiInstrument : ((ScorePart)currentPart.getId()).getMidiDeviceAndMidiInstrument()) {
                MidiInstrument midiInstrument;
                if (!(midiDeviceAndMidiInstrument instanceof MidiInstrument) || (midiInstrument = (MidiInstrument)midiDeviceAndMidiInstrument).getVolume() == null) continue;
                velocity = midiInstrument.getVolume().doubleValue() / 127.0;
            }
            int i = 0;
            while (i != staveCount) {
                wedgeMap.put(i, WedgeType.STOP);
                ottavaMap.put(i, new HashMap());
                ++i;
            }
            for (ScorePartwise.Part.Measure currentMeasure : currentPart.getMeasure()) {
                this.gotoMeasure(currentMeasure);
                if (this.score.getCurrentMeasureNumber() != 0) {
                    Measure lastMeasure = this.score.getMeasure(this.score.getCurrentMeasureNumber() - 1);
                    Measure activeMeasure = this.getCurrentMeasure();
                    if (!parsedMeasureSet.contains(activeMeasure.getMeasureIndex())) {
                        activeMeasure.setTimeSig(lastMeasure.getTimeSig());
                        activeMeasure.setTempo(lastMeasure.getTempo());
                        parsedMeasureSet.add(activeMeasure.getMeasureIndex());
                    }
                    int staveNumber = baseStaff;
                    while (staveNumber < baseStaff + staveCount) {
                        activeMeasure.getStaff(staveNumber).setClef(lastMeasure.getStaff(staveNumber).getClef());
                        activeMeasure.getStaff(staveNumber).setKeySignature(lastMeasure.getStaff(staveNumber).getKeySignature());
                        activeMeasure.getStaff(staveNumber).setTransposition(lastMeasure.getStaff(staveNumber).getTransposition());
                        ++staveNumber;
                    }
                }
                double currentTime = 0.0;
                for (Object o : currentMeasure.getNoteOrBackupOrForward()) {
                    Note xmlNote;
                    if (o instanceof Attributes) {
                        Attributes attr = (Attributes)o;
                        double currentDivisions = MusicXMLtoJScoreXMLConverter.convertToDouble(attr.getDivisions());
                        if (currentDivisions != 0.0) {
                            invDivisions = 1.0 / currentDivisions;
                        }
                        for (Clef clef : attr.getClef()) {
                            ClefSign clefSign = clef.getSign();
                            BigInteger line = clef.getLine();
                            if (clefSign == null) continue;
                            com.softsynth.jmsl.score.Clef newScoreObject = com.softsynth.jmsl.score.Clef.TREBLE_CLEF;
                            String sign = clefSign.value().toLowerCase();
                            if (sign.equals("f")) {
                                newScoreObject = com.softsynth.jmsl.score.Clef.BASS_CLEF;
                            }
                            if (sign.equals("c") && line != null) {
                                switch (line.intValue()) {
                                    case 3: {
                                        newScoreObject = com.softsynth.jmsl.score.Clef.ALTO_CLEF;
                                        break;
                                    }
                                    case 4: {
                                        newScoreObject = com.softsynth.jmsl.score.Clef.TENOR_CLEF;
                                    }
                                }
                            }
                            if (sign.equals("percussion")) {
                                newScoreObject = com.softsynth.jmsl.score.Clef.PERCUSSION_CLEF;
                            }
                            if (clef.getNumber() != null) {
                                this.getStaff(currentPart, clef.getNumber()).setClef(newScoreObject);
                                continue;
                            }
                            int countingEnd = this.parts.get((Object)((ScorePart)currentPart.getId())).baseStaff + this.parts.get((Object)((ScorePart)currentPart.getId())).staveCount;
                            int currentStave = this.parts.get((Object)((ScorePart)currentPart.getId())).baseStaff;
                            while (currentStave != countingEnd) {
                                this.getCurrentMeasure().getStaff(currentStave).setClef(newScoreObject);
                                ++currentStave;
                            }
                        }
                        for (Key key : attr.getKey()) {
                            if (key.getFifths() == null) continue;
                            int fifths = key.getFifths().intValue();
                            KeySignature newScoreObject = new KeySignature();
                            if (fifths < 0) {
                                newScoreObject.setKeySignatureType(1);
                            } else {
                                newScoreObject.setKeySignatureType(0);
                            }
                            newScoreObject.setNumAccidentals(Math.abs(fifths));
                            if (key.getNumber() != null) {
                                this.getStaff(currentPart, key.getNumber()).setKeySignature(newScoreObject);
                                continue;
                            }
                            int countingEnd = this.parts.get((Object)((ScorePart)currentPart.getId())).baseStaff + this.parts.get((Object)((ScorePart)currentPart.getId())).staveCount;
                            int currentStave = this.parts.get((Object)((ScorePart)currentPart.getId())).baseStaff;
                            while (currentStave != countingEnd) {
                                this.getCurrentMeasure().getStaff(currentStave).setKeySignature(newScoreObject);
                                ++currentStave;
                            }
                        }
                        for (Time time : attr.getTime()) {
                            Integer numerator = null;
                            Integer denominator = null;
                            for (JAXBElement<String> e : time.getTimeSignature()) {
                                if (e.getName().getLocalPart().equalsIgnoreCase("beats")) {
                                    try {
                                        numerator = new Integer((String)e.getValue());
                                    }
                                    catch (NumberFormatException countingEnd) {
                                        // empty catch block
                                    }
                                }
                                if (!e.getName().getLocalPart().toLowerCase().equalsIgnoreCase("beat-type")) continue;
                                try {
                                    denominator = new Integer((String)e.getValue());
                                }
                                catch (NumberFormatException countingEnd) {
                                    // empty catch block
                                }
                            }
                            if (numerator == null || denominator == null) continue;
                            TimeSignature newScoreObject = new TimeSignature(numerator, denominator);
                            this.getCurrentMeasure().setTimeSig(newScoreObject);
                        }
                        for (Transpose transpose : attr.getTranspose()) {
                            double transposition = MusicXMLtoJScoreXMLConverter.convertToDouble(transpose.getChromatic()) + (double)(12 * MusicXMLtoJScoreXMLConverter.convertToInt(transpose.getOctaveChange()));
                            if (transpose.getNumber() != null) {
                                this.getStaff(currentPart, transpose.getNumber()).setTransposition(transposition);
                                continue;
                            }
                            int countingEnd = this.parts.get((Object)((ScorePart)currentPart.getId())).baseStaff + this.parts.get((Object)((ScorePart)currentPart.getId())).staveCount;
                            int currentStave = this.parts.get((Object)((ScorePart)currentPart.getId())).baseStaff;
                            while (currentStave != countingEnd) {
                                this.getCurrentMeasure().getStaff(currentStave).setTransposition(transposition);
                                ++currentStave;
                            }
                        }
                    }
                    if (o instanceof Barline) {
                        Barline barline = (Barline)o;
                        if (barline.getRepeat() != null) {
                            switch (barline.getRepeat().getDirection()) {
                                case FORWARD: {
                                    this.getCurrentMeasure().setRepeatStart(true);
                                    break;
                                }
                                case BACKWARD: {
                                    this.getCurrentMeasure().setRepeatEnd(true);
                                    BigInteger times = barline.getRepeat().getTimes();
                                    if (times == null || times.intValue() <= 1) break;
                                    this.getCurrentMeasure().setNumRepeats(times.intValue() - 1);
                                }
                            }
                        }
                        if (barline.getBarStyle() != null) {
                            switch (barline.getBarStyle().getValue()) {
                                case NONE: {
                                    this.getCurrentMeasure().setBarNone(true);
                                    break;
                                }
                                case LIGHT_LIGHT: 
                                case HEAVY_HEAVY: {
                                    this.getCurrentMeasure().setDoubleBar(true);
                                    break;
                                }
                                case LIGHT_HEAVY: {
                                    this.getCurrentMeasure().setPeriodDoubleBar(true);
                                }
                            }
                        }
                    }
                    if (o instanceof Direction) {
                        int currentStave = MusicXMLtoJScoreXMLConverter.convertToIndex(((Direction)o).getStaff());
                        for (DirectionType dt : ((Direction)o).getDirectionType()) {
                            for (Dynamics dynamics : dt.getDynamics()) {
                                int i2 = MusicXMLtoJScoreXMLConverter.convertDynamics(dynamics);
                                if (i2 == 0) continue;
                                dynamicsToSet = i2;
                            }
                            if (dt.getMetronome() != null) {
                                void var24_39;
                                String string = "";
                                int dotCount = 0;
                                double perMinute = 0.0;
                                for (JAXBElement<?> content : dt.getMetronome().getContent()) {
                                    if (content.getName().getLocalPart().equalsIgnoreCase("beat-unit")) {
                                        String string2 = (String)content.getValue();
                                    }
                                    if (content.getName().getLocalPart().equalsIgnoreCase("beat-unit-dot")) {
                                        ++dotCount;
                                    }
                                    if (!content.getName().getLocalPart().equalsIgnoreCase("per-minute")) continue;
                                    perMinute = Double.parseDouble(((PerMinute)content.getValue()).getValue());
                                }
                                this.getCurrentMeasure().setTempo(MusicXMLtoJScoreXMLConverter.convertTypeToDuration((String)var24_39, dotCount) * perMinute);
                            }
                            if (dt.getWedge() != null) {
                                switch (dt.getWedge().getType()) {
                                    case CRESCENDO: {
                                        wedgeMap.put(currentStave, WedgeType.CRESCENDO);
                                        break;
                                    }
                                    case DIMINUENDO: {
                                        wedgeMap.put(currentStave, WedgeType.DIMINUENDO);
                                        break;
                                    }
                                    case STOP: {
                                        wedgeMap.put(currentStave, WedgeType.STOP);
                                    }
                                }
                            }
                            if (dt.getOctaveShift() != null) {
                                switch (dt.getOctaveShift().getType()) {
                                    case UP: {
                                        ((HashMap)ottavaMap.get(currentStave)).put(dt.getOctaveShift().getNumber(), UpDownStopContinue.DOWN);
                                        break;
                                    }
                                    case DOWN: {
                                        ((HashMap)ottavaMap.get(currentStave)).put(dt.getOctaveShift().getNumber(), UpDownStopContinue.UP);
                                        break;
                                    }
                                    case STOP: {
                                        ((HashMap)ottavaMap.get(currentStave)).remove(dt.getOctaveShift().getNumber());
                                    }
                                }
                            }
                            Iterator<FormattedText> dotCount = dt.getWords().iterator();
                            while (dotCount.hasNext()) {
                                FormattedText formattedText;
                                textToSet = formattedText = dotCount.next();
                            }
                        }
                        if (((Direction)o).getSound() != null && ((Direction)o).getSound().getTempo() != null) {
                            this.getCurrentMeasure().setTempo(((Direction)o).getSound().getTempo().doubleValue());
                        }
                    }
                    if (o instanceof Backup) {
                        currentTime -= MusicXMLtoJScoreXMLConverter.convertToDouble(((Backup)o).getDuration()) * invDivisions;
                    }
                    if (o instanceof Forward) {
                        currentTime += MusicXMLtoJScoreXMLConverter.convertToDouble(((Forward)o).getDuration()) * invDivisions;
                    }
                    if (!(o instanceof Note) || (xmlNote = (Note)o).getGrace() != null && MusicXMLtoJScoreXMLConverter.convertToDouble(xmlNote.getGrace().getMakeTime()) == 0.0) continue;
                    if (xmlNote.getStaff() != null) {
                        this.gotoStaff(currentPart, xmlNote.getStaff());
                    }
                    int currentStave = this.score.getCurrentStaffNumber() - this.parts.get((Object)((ScorePart)currentPart.getId())).baseStaff;
                    if (xmlNote.getVoice() != null) {
                        this.score.setCurrentTrackNumber(MusicXMLtoJScoreXMLConverter.convertToIndex(xmlNote.getVoice()));
                    }
                    double holdTime = invDivisions;
                    if (xmlNote.getDuration() != null) {
                        holdTime *= xmlNote.getDuration().doubleValue();
                    }
                    double jmslPitch = 0.0;
                    Step step = null;
                    double alter = 0.0;
                    Pitch xmlPitch = xmlNote.getPitch();
                    if (xmlPitch != null) {
                        step = xmlPitch.getStep();
                        switch (step) {
                            case A: {
                                jmslPitch = 21.0;
                                break;
                            }
                            case B: {
                                jmslPitch = 23.0;
                                break;
                            }
                            case C: {
                                jmslPitch = 12.0;
                                break;
                            }
                            case D: {
                                jmslPitch = 14.0;
                                break;
                            }
                            case E: {
                                jmslPitch = 16.0;
                                break;
                            }
                            case F: {
                                jmslPitch = 17.0;
                                break;
                            }
                            case G: {
                                jmslPitch = 19.0;
                            }
                        }
                        jmslPitch += (double)xmlPitch.getOctave() * 12.0;
                        alter = MusicXMLtoJScoreXMLConverter.convertToDouble(xmlPitch.getAlter());
                        jmslPitch += alter;
                    }
                    if (xmlNote.getRest() != null) {
                        jmslPitch = 0.0;
                    }
                    double duration = holdTime;
                    if (xmlNote.getType() != null) {
                        TimeModification tm;
                        duration = MusicXMLtoJScoreXMLConverter.convertTypeToDuration(xmlNote.getType().getValue(), xmlNote.getDot().size());
                        if (xmlNote.getTimeModification() != null && (tm = xmlNote.getTimeModification()).getNormalNotes() != null && tm.getActualNotes() != null) {
                            duration *= tm.getNormalNotes().doubleValue() / tm.getActualNotes().doubleValue();
                        }
                    }
                    Color noteHeadColor = null;
                    Integer noteHeadType = null;
                    if (xmlNote.getNotehead() != null) {
                        boolean isFilled;
                        Notehead noteHead = xmlNote.getNotehead();
                        noteHeadColor = MusicXMLtoJScoreXMLConverter.convertToColor(noteHead.getColor());
                        boolean bl = isFilled = noteHead.getFilled() == null || noteHead.getFilled() == YesNo.YES;
                        if (noteHead.getValue() != null) {
                            switch (noteHead.getValue()) {
                                case SLASH: {
                                    noteHeadType = 12;
                                    break;
                                }
                                case TRIANGLE: {
                                    noteHeadType = isFilled ? 8 : 7;
                                    break;
                                }
                                case DIAMOND: {
                                    noteHeadType = isFilled ? 6 : 5;
                                    break;
                                }
                                case SQUARE: {
                                    noteHeadType = 11;
                                    break;
                                }
                                case RECTANGLE: {
                                    noteHeadType = 11;
                                    break;
                                }
                                case CROSS: {
                                    noteHeadType = 2;
                                    break;
                                }
                                case X: {
                                    noteHeadType = 2;
                                    break;
                                }
                                case CIRCLE_X: {
                                    noteHeadType = 3;
                                    break;
                                }
                                case INVERTED_TRIANGLE: {
                                    noteHeadType = isFilled ? 10 : 9;
                                    break;
                                }
                                case SLASHED: {
                                    noteHeadType = 12;
                                    break;
                                }
                                default: {
                                    noteHeadType = null;
                                }
                            }
                        }
                    }
                    Track currentTrack = this.getCurrentTrack();
                    com.softsynth.jmsl.score.Note jmslNote = null;
                    if (!currentTrack.getChildren().isEmpty()) {
                        jmslNote = (com.softsynth.jmsl.score.Note)currentTrack.getChildren().lastElement();
                    }
                    if (jmslNote == null && currentTime != 0.0 || jmslNote != null && currentTrack.getEndTimeOfNote(jmslNote) < currentTime) {
                        double restToInsert = currentTime;
                        if (jmslNote != null) {
                            restToInsert -= currentTrack.getStartTimeOfNote(jmslNote) - currentTrack.getStartTime();
                        }
                        this.score.addNote(restToInsert, 0.0, 0.0, restToInsert);
                    }
                    if (xmlNote.getChord() == null) {
                        jmslNote = this.score.addNote(duration, jmslPitch, velocity, holdTime);
                        currentTime += duration;
                    } else {
                        double lastTime = currentTime - duration;
                        if (currentTrack.isEmpty() || currentTrack.getFirstNoteAfterTime(lastTime) == null) {
                            jmslNote = this.score.addNote(duration, jmslPitch, velocity, holdTime);
                        } else {
                            com.softsynth.jmsl.score.Note rootNote = currentTrack.getFirstNoteAfterTime(lastTime);
                            jmslNote = com.softsynth.jmsl.score.Note.cloneNote(rootNote);
                            jmslNote.setData(duration, jmslPitch, velocity, holdTime);
                            rootNote.addInterval(jmslNote);
                        }
                    }
                    if (noteHeadType != null) {
                        jmslNote.setNoteHeadType(noteHeadType);
                    }
                    if (noteHeadColor != null) {
                        jmslNote.setNoteheadColor(noteHeadColor);
                    }
                    jmslNote.setAccPref(0);
                    if (alter < 0.0) {
                        jmslNote.setAccPref(1);
                    }
                    jmslNote.setAltEnharmonicSpelling(false);
                    if (Math.abs(alter) > 1.0 || step != null && (alter == 1.0 && (step == Step.E || step == Step.B) || alter == -1.0 && (step == Step.F || step == Step.C))) {
                        jmslNote.setAltEnharmonicSpelling(true);
                    }
                    jmslNote.setAcc(0);
                    jmslNote.setAccHidden(true);
                    switch ((int)(2.0 * alter)) {
                        case 4: {
                            jmslNote.setAcc(5);
                            break;
                        }
                        case 3: {
                            jmslNote.setAcc(9);
                            break;
                        }
                        case 2: {
                            jmslNote.setAcc(1);
                            break;
                        }
                        case 1: {
                            jmslNote.setAcc(8);
                            break;
                        }
                        case -1: {
                            jmslNote.setAcc(6);
                            break;
                        }
                        case -2: {
                            jmslNote.setAcc(2);
                            break;
                        }
                        case -3: {
                            jmslNote.setAcc(7);
                            break;
                        }
                        case -4: {
                            jmslNote.setAcc(4);
                        }
                    }
                    if (xmlNote.getAccidental() != null) {
                        jmslNote.setAccHidden(false);
                        switch (xmlNote.getAccidental().getValue()) {
                            case SHARP: 
                            case NATURAL_SHARP: {
                                jmslNote.setAcc(1);
                                break;
                            }
                            case FLAT: 
                            case NATURAL_FLAT: {
                                jmslNote.setAcc(2);
                                break;
                            }
                            case NATURAL: {
                                jmslNote.setAcc(3);
                                break;
                            }
                            case DOUBLE_SHARP: 
                            case SHARP_SHARP: {
                                jmslNote.setAcc(5);
                                break;
                            }
                            case FLAT_FLAT: {
                                jmslNote.setAcc(4);
                                break;
                            }
                            case QUARTER_SHARP: {
                                jmslNote.setAcc(8);
                                break;
                            }
                            case QUARTER_FLAT: {
                                jmslNote.setAcc(6);
                                break;
                            }
                            case THREE_QUARTERS_SHARP: {
                                jmslNote.setAcc(9);
                                break;
                            }
                            case THREE_QUARTERS_FLAT: {
                                jmslNote.setAcc(7);
                            }
                        }
                    }
                    if (xmlNote.getBeam().size() != 0) {
                        for (Beam currentBeam : xmlNote.getBeam()) {
                            if (currentBeam.getValue() != BeamValue.BEGIN && currentBeam.getValue() != BeamValue.CONTINUE) continue;
                            jmslNote.setBeamedOut(true);
                            break;
                        }
                    }
                    switch ((WedgeType)((Object)wedgeMap.get(currentStave))) {
                        case CRESCENDO: {
                            jmslNote.setCrescOut(true);
                            break;
                        }
                        case DIMINUENDO: {
                            jmslNote.setDecrescOut(true);
                            break;
                        }
                        default: {
                            jmslNote.setCrescOut(false);
                        }
                    }
                    for (UpDownStopContinue udsc : ((HashMap)ottavaMap.get(currentStave)).values()) {
                        switch (udsc) {
                            case UP: {
                                jmslNote.set8va(true);
                                jmslNote.setPitchData(jmslNote.getPitchData() - 12.0);
                                break;
                            }
                            case DOWN: {
                                jmslNote.set8vb(true);
                                jmslNote.setPitchData(jmslNote.getPitchData() + 12.0);
                            }
                        }
                    }
                    for (Tie t : xmlNote.getTie()) {
                        if (t.getType() == StartStop.START) {
                            jmslNote.setTiedOut(true);
                        }
                        if (t.getType() != StartStop.STOP) continue;
                        jmslNote.setTiedOut(false);
                    }
                    if (xmlNote.getStem() != null) {
                        switch (xmlNote.getStem().getValue()) {
                            case UP: {
                                jmslNote.setStemInfoOverride(1);
                                break;
                            }
                            case DOWN: {
                                jmslNote.setStemInfoOverride(2);
                                break;
                            }
                            case NONE: {
                                jmslNote.setStemInfoOverride(0);
                            }
                        }
                    }
                    if (textToSet != null) {
                        jmslNote.setText(textToSet.getValue());
                        jmslNote.setTextOffsetY(this.getY(jmslNote.getPitchData(), textToSet.getDefaultY()));
                        textToSet = null;
                    }
                    if (xmlNote.getLyric().size() != 0) {
                        Lyric l = xmlNote.getLyric().get(0);
                        String s = "";
                        for (Object text : l.getElisionAndSyllabicAndText()) {
                            if (!(text instanceof TextElementData)) continue;
                            if (!s.isEmpty()) {
                                s = String.valueOf(s) + '-';
                            }
                            s = String.valueOf(s) + ((TextElementData)text).getValue();
                        }
                        jmslNote.setText(s);
                        jmslNote.setTextOffsetY(this.getY(jmslNote.getPitchData(), l.getDefaultY()));
                    }
                    boolean isAccented = false;
                    boolean isStrongAccented = false;
                    boolean isTenuto = false;
                    boolean isStaccato = false;
                    for (Notations currentNotation : xmlNote.getNotations()) {
                        for (Object n : currentNotation.getTiedOrSlurOrTuplet()) {
                            int i3;
                            if (n instanceof Slur) {
                                Slur s = (Slur)n;
                                slurMap.put(s.getNumber(), s.getType());
                            }
                            if (n instanceof Dynamics && (i3 = MusicXMLtoJScoreXMLConverter.convertDynamics((Dynamics)n)) != 0) {
                                dynamicsToSet = i3;
                            }
                            if (n instanceof Articulations) {
                                for (JAXBElement<?> j : ((Articulations)n).getAccentOrStrongAccentOrStaccato()) {
                                    if (j.getName().getLocalPart().equalsIgnoreCase("accent")) {
                                        isAccented = true;
                                    }
                                    if (j.getName().getLocalPart().equalsIgnoreCase("strong-accent")) {
                                        isStrongAccented = true;
                                    }
                                    if (j.getName().getLocalPart().equalsIgnoreCase("staccato")) {
                                        isStaccato = true;
                                    }
                                    if (!j.getName().getLocalPart().equalsIgnoreCase("tenuto")) continue;
                                    isTenuto = true;
                                }
                            }
                            if (n instanceof Fermata) {
                                jmslNote.addMark(8);
                            }
                            if (n instanceof Ornaments) {
                                for (JAXBElement<?> j : ((Ornaments)n).getTrillMarkOrTurnOrDelayedTurn()) {
                                    if (j.getName().getLocalPart().equalsIgnoreCase("mordent")) {
                                        jmslNote.addMark(14);
                                    }
                                    if (j.getName().getLocalPart().equalsIgnoreCase("inverted-mordent")) {
                                        jmslNote.addMark(15);
                                    }
                                    if (j.getName().getLocalPart().equalsIgnoreCase("trill-mark")) {
                                        jmslNote.addMark(10);
                                    }
                                    if (!j.getName().getLocalPart().equalsIgnoreCase("tremolo") || j.getValue() == null) continue;
                                    try {
                                        switch (((Tremolo)j.getValue()).getValue()) {
                                            case 1: {
                                                jmslNote.addMark(16);
                                                break;
                                            }
                                            case 2: {
                                                jmslNote.addMark(17);
                                                break;
                                            }
                                            case 3: {
                                                jmslNote.addMark(18);
                                            }
                                        }
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (!(n instanceof Technical)) continue;
                            for (JAXBElement<?> j : ((Technical)n).getUpBowOrDownBowOrHarmonic()) {
                                if (!j.getName().getLocalPart().equalsIgnoreCase("harmonic")) continue;
                                jmslNote.addMark(9);
                            }
                        }
                    }
                    if (isAccented && !isStrongAccented && isStaccato && !isTenuto) {
                        jmslNote.addMark(5);
                    } else if (isAccented && !isStrongAccented && !isStaccato && isTenuto) {
                        jmslNote.addMark(6);
                    } else if (!isAccented && isStrongAccented && isStaccato && !isTenuto) {
                        jmslNote.addMark(7);
                    } else {
                        if (isAccented) {
                            jmslNote.addMark(1);
                        }
                        if (isStrongAccented) {
                            jmslNote.addMark(4);
                        }
                        if (isStaccato) {
                            jmslNote.addMark(2);
                        }
                        if (isTenuto) {
                            jmslNote.addMark(3);
                        }
                    }
                    jmslNote.setDynamic(dynamicsToSet);
                    dynamicsToSet = 0;
                    jmslNote.setSlurredOut(false);
                    for (StartStopContinue ssc : slurMap.values()) {
                        if (ssc != StartStopContinue.START && ssc != StartStopContinue.CONTINUE) continue;
                        jmslNote.setSlurredOut(true);
                    }
                }
            }
        }
    }

    public StringReader removeDoctype(InputStream source) {
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(source));
        StringWriter stringWriter = new StringWriter();
        boolean removeLine = false;
        try {
            String currentLine = lineNumberReader.readLine();
            while (currentLine != null) {
                if (currentLine.indexOf("<!DOCTYPE") != -1) {
                    removeLine = true;
                }
                if (!removeLine) {
                    stringWriter.append(currentLine);
                }
                if (currentLine.indexOf(">") != -1) {
                    removeLine = false;
                }
                currentLine = lineNumberReader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new StringReader(stringWriter.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream convertToPartwise(InputStream originalSource) {
        BufferedInputStream source = new BufferedInputStream(originalSource);
        source.mark(Integer.MAX_VALUE);
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(source));
            boolean isTimewise = false;
            String currentLine = lineNumberReader.readLine();
            while (true) {
                if (currentLine == null) {
                    source.reset();
                    if (!isTimewise) {
                        return source;
                    }
                    try {
                        if (transformer == null) {
                            transformer = TransformerFactory.newInstance().newTemplates(new StreamSource(new File("timepart.xsl"))).newTransformer();
                        }
                        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
                        transformer.transform(new StreamSource(source), new StreamResult(xmlOutputStream));
                        return new ByteArrayInputStream(xmlOutputStream.toByteArray());
                    }
                    catch (TransformerConfigurationException e) {
                        e.printStackTrace();
                        return null;
                    }
                    catch (TransformerException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                int commentIndex = currentLine.indexOf("<!--");
                int timewiseIndex = currentLine.indexOf("<score-timewise>");
                int partwiseIndex = currentLine.indexOf("<score-partwise>");
                if ((timewiseIndex != -1 || partwiseIndex != -1) && (commentIndex == -1 || commentIndex > timewiseIndex && timewiseIndex != -1 || commentIndex > partwiseIndex && partwiseIndex != -1)) {
                    isTimewise = timewiseIndex < partwiseIndex && timewiseIndex != -1 || partwiseIndex == -1;
                    currentLine = null;
                    continue;
                }
                if (commentIndex != -1) {
                    do {
                        if ((commentIndex = currentLine.indexOf("-->")) != -1) continue;
                        currentLine = lineNumberReader.readLine();
                    } while (currentLine != null && commentIndex == -1);
                    if (currentLine == null || (currentLine = currentLine.substring(commentIndex + 3)).length() != 0) continue;
                    currentLine = lineNumberReader.readLine();
                    continue;
                }
                currentLine = lineNumberReader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void loadXML(InputStream source, boolean maxScore) {
        InputStream streamToParse = this.convertToPartwise(source);
        if (streamToParse != null) {
            try {
                this.root = (ScorePartwise)unmarshaller.unmarshal((Reader)this.removeDoctype(streamToParse));
                this.buildScoreSkeleton(maxScore);
                this.parse();
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
    }

    public Score getScore() {
        return this.score;
    }

    public int getMinTrackCount() {
        return this.minTrackCount;
    }

    public void setMinTrackCount(int newMinTrackCount) {
        if (newMinTrackCount < 0) {
            return;
        }
        this.minTrackCount = newMinTrackCount;
    }

    public MusicXMLtoJScoreXMLConverter() {
        try {
            if (unmarshaller == null) {
                JAXBContext jaxbContext = JAXBContext.newInstance((String)"hu.sadam.musicxml.jaxb");
                Unmarshaller newUnmarshaller = jaxbContext.createUnmarshaller();
                newUnmarshaller.setAttachmentUnmarshaller(null);
                newUnmarshaller.setSchema(null);
                unmarshaller = newUnmarshaller;
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        this.setMinTrackCount(2);
    }

    class PartDescriptor {
        public int baseStaff;
        public int staveCount;

        PartDescriptor() {
        }
    }
}

