/*
 * Created on 23-Apr-2006
 * Martin Robinson
 * This software is released and may be distributed under the GNU GPL license
 * See: http://www.gnu.org/licenses/gpl.txt
 */
package uk.co.miajo.NN;
import java.io.*;
public class Layer {
    //private int numprev;
    private Node nodes[];
    
    public Layer(int numnodes, int numprev)
    {
        if(numnodes < 1) numnodes = 1;
        if(numprev < 1) numprev = 1;
        //else numprev = _numprev;
        
        nodes = new Node[numnodes];
        for(int i = 0; i < numnodes; i++)
        {
            nodes[i] = new Node(numprev);
        }
    }
    
    public void write(final String comment, BufferedWriter buffer, Listener callback)
    {
        for(int i = 0; i < nodes.length; i++)
        {
            String nodeComment = comment;
            if(nodeComment != null) {
                nodeComment = nodeComment+" Node "+i;
            }
            nodes[i].write(comment, buffer, callback);
        }
    }
    
    public void read(BufferedReader buffer, Listener callback)
    {
        for(int i = 0; i < nodes.length; i++)
        {
            nodes[i].read(buffer, callback);
        }
    }
    
    public int numInputs()
    {
        //return numprev;
        return nodes[0].numWeights();
    }
    
    public int numOutputs()
    {
        return nodes.length;
    }
    
    public void init(double w)
    {
        for(int i = 0; i < nodes.length; i++)
        {
            nodes[i].init(w);
        }
    }
    
    public void rand(double w)
    {
        for(int i = 0; i < nodes.length; i++)
        {
            nodes[i].rand(w);
        }
    }
    
    public double[] propogate(double inputVector[])
    {
        double outputVector[] = new double[nodes.length];
        
        for(int i = 0; i < nodes.length; i++)
        {
            outputVector[i] = nodes[i].propogate(inputVector);
        }
        
        return outputVector;
    }
    
    
    public double[] backProp(double errorVector[], double actfuncoff, double learnrate)
    {
        double adjustVector[] = new double[this.numInputs()];
        
        for(int i = 0; i < nodes.length; i++)
        {
            adjustVector = nodes[i].backProp(errorVector[i], actfuncoff, learnrate, adjustVector);
        }
        
        return adjustVector;
    }
    
    
}
