/*
 * Created on 23-Apr-2006
 * Martin Robinson
 * This software is released and may be distributed under the GNU GPL license
 * See: http://www.gnu.org/licenses/gpl.txt
 */
package uk.co.miajo.NN;
import java.util.*;

public class Utility {
    
    public static double defaultWeight = 0.1;
    public static double defaultLearnRate = 0.25;
    public static double defaultActFuncOffset = 0.01;
    
    public static double randomDouble(double min, double max)
    {
       double r = Math.random();
       double d = max-min;
       return r * d + min;
    }
    
    public static double randomWeight()
    {
        return randomDouble(-defaultWeight, defaultWeight);
    }
    
    public static double randomWeight(double w)
    {
        return randomDouble(-w, w);
    }
    
    public static double[] subtractVectors(double v1[], double v2[])
    {
        double v[] = new double[v1.length];
        
        for(int i = 0; i < v1.length; i++)
        {
           v[i] = v1[i] - v2[i];
        }
        
        return v;
    }
    
    public static void printDoubleArray(String prefix, double array[])
    {
        System.out.print(prefix);
        for(int i = 0; i < array.length; i++)
        {
            System.out.print((float)array[i]);
            System.out.print(" ");
        }
        System.out.println();
    }
    
    public static int[] parseIntArray(String string)
    {
        StringTokenizer strtok = new StringTokenizer(string);
        int intArray[] = new int[strtok.countTokens()];
        
        for(int i = 0; i < intArray.length; i++)
        {
            String token = strtok.nextToken();
            try {
                intArray[i] = Integer.parseInt(token);
            }
            catch(Exception e1)
            {
                try {
                    intArray[i] = (int)Double.parseDouble(token);
                }
                catch(Exception e2)
                {
                    intArray[i] = 0;
                }
            }
        }
        
        return intArray;
    }
    
    public static double[] parseDoubleArray(String string)
    {
        StringTokenizer strtok = new StringTokenizer(string);
        double doubleArray[] = new double[strtok.countTokens()];
        
        for(int i = 0; i < doubleArray.length; i++)
        {
            String token = strtok.nextToken();
            try {
                doubleArray[i] = Double.parseDouble(token);
            }
            catch(Exception e1)
            {
                doubleArray[i] = 0.;
            }
        }
        
        return doubleArray;
    }
}
