const serveHTTPPortNumber = 3000;
const sendUDPPortNumber = 6000;
const receiveUDPPortNumber = 33334;

const botsFolder = './bots/';
const audioFolder = './assets/';

const fs = require('fs');
const express = require('express'); //ideally this should use the Router object to make the routing changeable https://github.com/expressjs/express/issues/2596
const app = express();
const http = require('http').Server(app);
const io = require('socket.io')(http);
const events = require('events');
const osc = require('node-osc-master');
const os = require( 'os' );
const dgram = require('dgram'); //for UDP; see www.hacksparrow.com/node-js-udp-server-and-client-example.html
const cluster = require('cluster');
const chokidar = require('chokidar'); //for watching file changes https://stackoverflow.com/questions/13695046/watch-a-folder-for-changes-using-node-js-and-print-file-paths-when-they-are-cha
// var path = require("path");
// would eventually be a good idea to use this to manipulate the template strings: npm i outdent

const myIP = os.networkInterfaces().en0[1].address;

/* these stanzas serve the assets */

let botsWatcher = chokidar.watch(botsFolder, {ignored: /^\./, persistent: true});
botsWatcher
	.on('add', whatBotsToServe)
	.on('unlink', whatBotsToServe)

let assetsWatcher = chokidar.watch(botsFolder, {ignored: /^\./, persistent: true});
assetsWatcher
	.on('add', whatAssetsToServe)
	.on('unlink', whatAssetsToServe)

http.listen(serveHTTPPortNumber, function(){
	console.log('\x1b[1m\x1b[36m','\n===< Welcome to the Musebots Server!!!111 >===','\x1b[0m');

	console.log("\nServin' up the web bots here: ");
	console.log('\x1b[1m\x1b[4m\x1b[33m%s\x1b[0m',`http://${myIP}:${serveHTTPPortNumber}`);
	console.log('\x1b[2m','\nHint: on Mac you can command-double-click the above url to open it from this terminal.\n','\x1b[0m');

	console.log(
		'To communicate with any outside program on this machine,',
		'this server forwards incoming messages from the web bots to port',
		'\x1b[1m\x1b[33m',`${sendUDPPortNumber}`,'\x1b[0m','and receives incoming messages at port',
		'\x1b[1m\x1b[33m',`${receiveUDPPortNumber}.`,'\x1b[0m',
		' You can use this to communicate with Max/MSP, for example.'
	);
});

let theHeader =
	`<!DOCTYPE html>
	<html>

	<head>
		<title>Musebots index!</title>
		<link rel="stylesheet" type="text/css" href="main.css">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
	</head>

	<body>
		<h1>Click on any of these here bots to load'em!</h1>`
let theContent = ``;
let theFooter = `
		<p><a href="mailto:?body=Paste%20this%20into%20your%20web%20browser%20address%20bar:%0D%0A%0D%0A${myIP}:${serveHTTPPortNumber}&subject=Temporary%20Musebots%20Address!">
			If other people on the same network want their browsers to play along, click here to email them the temporary link to this page!
		</a></p>
	</body>

	</html>
`

function whatBotsToServe(){
	theContent = ``;

	fs.readdirSync(botsFolder).forEach(file => {
		if(file.search(/.htm/)>0){
			let theLocation=`http://${myIP}:${serveHTTPPortNumber}/${file}`

			theContent += `
			<li><a href="${theLocation}" target="_blank">${file}</a></li>
			`

			app.get('/' + file, function(req, res){
			  res.sendFile(__dirname + '/bots/'+file);
			});
		}
	})
}
app.get('/', (req, res) => res.send(theHeader+theContent+theFooter));

function whatAssetsToServe(){
	fs.readdirSync(audioFolder).forEach(file => {
		if(file.search(/.mp3|.css|.js/)>0){
			app.get('/'+file, function(req, res){
			  res.sendFile(__dirname + '/assets/'+file);
			});
		}
	});
}

/* these stanzas set up the websockets communication with the bots */

/* if a message comes in from outside, via UDP */
let broadcastServer = new osc.Server(receiveUDPPortNumber,'0.0.0.0');
broadcastServer.on('message', function (msg) {
	io.emit('chat message', msg.join(" "));
});
let theSender = new osc.Client('localhost',sendUDPPortNumber);

/* if a message comes in from one of the web bots */
io.on('connection', function(socket){
	console.log('A bot connected!');
	socket.on('disconnect', function(){
		console.log('A bot disconnected!');
	});

	socket.on('chat message', function(msg){
		socket.broadcast.emit('chat message', msg);
		theSender.send(msg.split(" "));
	});
});
