/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.mxjedit;

import com.cycling74.max.Callback;
import com.cycling74.max.MXJClassLoader;
import com.cycling74.max.MXJPreferences;
import com.cycling74.max.MaxSystem;
import com.cycling74.mxjedit.CTokenMarker;
import com.cycling74.mxjedit.GLSLTokenMarker;
import com.cycling74.mxjedit.JEditTextArea;
import com.cycling74.mxjedit.JavaScriptTokenMarker;
import com.cycling74.mxjedit.JavaTokenMarker;
import com.cycling74.mxjedit.MXJClassRefFrame;
import com.cycling74.mxjedit.MXJEditCfunkCompileFrame;
import com.cycling74.mxjedit.MXJEditCompileContext;
import com.cycling74.mxjedit.MXJEditCompileFrame;
import com.cycling74.mxjedit.SyntaxDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.Segment;

public class MXJEditor
extends JFrame {
    private static final String UNTITLED = "Untitled";
    private JEditTextArea _editor = null;
    private JMenuBar _menubar = null;
    private JMenu _fmenu;
    private JMenu _emenu;
    private JMenuItem _mode_menu;
    private JMenuItem _mode_menu_compile;
    private JMenuItem _mode_menu_findclass;
    private JMenuItem _fmenu_new;
    private JMenuItem _fmenu_open;
    private JMenuItem _fmenu_save;
    private JMenuItem _fmenu_saveas;
    private JMenuItem _fmenu_close;
    private JMenuItem _emenu_undo;
    private JMenuItem _emenu_redo;
    private JMenuItem _emenu_cut;
    private JMenuItem _emenu_copy;
    private JMenuItem _emenu_paste;
    private JMenuItem _emenu_find;
    private JMenuItem _emenu_gotoline;
    private JMenuItem _emenu_findagain;
    private JMenuItem _emenu_findselected;
    private JMenuItem[] _fontmenu_elements = null;
    private File _current_file = null;
    private String _current_search_term;
    private int _current_mode;
    private static final char[] __accs = new char[]{'X', 'C', 'V', 'S', 'Z', 'O', 'N', 'W', 'F', 'G', 'H', 'L', 'K', 'D', 'E'};
    private Callback saveCallback = null;
    public static final int MODE_JAVA = 1;
    public static final int MODE_DEFAULT = 2;
    public static final int MODE_JAVASCRIPT = 3;
    public static final int MODE_GLSL = 4;
    public static final int MODE_CFUNK = 5;
    private MXJEditCompileFrame _compile_frame = null;
    private MXJEditCfunkCompileFrame _cf_compile_frame = null;

    public MXJEditor(Callback saveCallback) {
        this();
        this.saveCallback = saveCallback;
    }

    public MXJEditor() {
        this.setTitle(UNTITLED);
        this._menubar = new JMenuBar();
        this._fmenu = new JMenu("File");
        this._fmenu_new = new JMenuItem("New");
        this._fmenu_new.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this._fmenu_new.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MXJEditor.this.menu_new();
            }
        });
        this._fmenu_open = new JMenuItem("Open...");
        this._fmenu_open.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this._fmenu_open.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MXJEditor.this.menu_open();
            }
        });
        this._fmenu_save = new JMenuItem("Save");
        this._fmenu_save.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this._fmenu_save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MXJEditor.this.menu_save();
            }
        });
        this._fmenu_saveas = new JMenuItem("Save As...");
        this._fmenu_saveas.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MXJEditor.this.menu_saveas();
            }
        });
        this._fmenu_close = new JMenuItem("Close");
        this._fmenu_close.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this._fmenu_close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MXJEditor.this.menu_close();
            }
        });
        this._fmenu.add(this._fmenu_new);
        this._fmenu.add(this._fmenu_open);
        this._fmenu.add(this._fmenu_save);
        this._fmenu.add(this._fmenu_saveas);
        this._fmenu.add(this._fmenu_close);
        this._menubar.add(this._fmenu);
        this._emenu = new JMenu("Edit");
        this._menubar.add(this._emenu);
        this._emenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                MXJEditor.this._emenu_undo.setEnabled(MXJEditor.this._editor.getUndoManager().canUndo());
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
        this._emenu_undo = new JMenuItem("Undo");
        this._emenu_undo.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this._emenu_undo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MXJEditor.this.menu_undo();
            }
        });
        this._emenu_redo = new JMenuItem("Redo");
        this._emenu_redo.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this._emenu_redo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MXJEditor.this.menu_redo();
            }
        });
        this._emenu_cut = new JMenuItem("Cut");
        this._emenu_cut.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this._emenu_cut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MXJEditor.this.menu_cut();
            }
        });
        this._emenu_copy = new JMenuItem("Copy");
        this._emenu_copy.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this._emenu_copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MXJEditor.this.menu_copy();
            }
        });
        this._emenu_paste = new JMenuItem("Paste");
        this._emenu_paste.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this._emenu_paste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MXJEditor.this.menu_paste();
            }
        });
        this._emenu_find = new JMenuItem("Find...");
        this._emenu_find.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this._emenu_find.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MXJEditor.this.menu_find();
            }
        });
        this._emenu_findagain = new JMenuItem("Find Again");
        this._emenu_findagain.setAccelerator(KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this._emenu_findagain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MXJEditor.this.menu_findagain();
            }
        });
        this._emenu_findselected = new JMenuItem("Find Selected");
        this._emenu_findselected.setAccelerator(KeyStroke.getKeyStroke(72, 1 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this._emenu_findselected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MXJEditor.this.menu_findselected();
            }
        });
        this._emenu_gotoline = new JMenuItem("Goto Line...");
        this._emenu_gotoline.setAccelerator(KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this._emenu_gotoline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MXJEditor.this.menu_gotoline();
            }
        });
        this._emenu.add(this._emenu_undo);
        this._emenu.add(this._emenu_cut);
        this._emenu.add(this._emenu_copy);
        this._emenu.add(this._emenu_paste);
        this._emenu.add(this._emenu_find);
        this._emenu.add(this._emenu_findagain);
        this._emenu.add(this._emenu_findselected);
        this._emenu.add(this._emenu_gotoline);
        this.setJMenuBar(this._menubar);
        this._editor = new JEditTextArea(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._editor, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MXJEditor.this.setVisible(false);
                MXJEditor.this.dispose();
            }
        });
        this.setTabSize(4);
        this.setSize(new Dimension(640, 480));
        MaxSystem.registerCommandAccelerators(__accs);
        Dimension dim = this.getToolkit().getScreenSize();
        this.setLocation(dim.width / 3, 20);
        this._editor.requestFocus();
    }

    public void setMode(int mode) {
        switch (mode) {
            case 1: {
                if (this._current_mode != 1) {
                    this._clear_mode_menu();
                }
                this._editor.setTokenMarker(new JavaTokenMarker());
                if (this._mode_menu == null) {
                    this._mode_menu = new JMenu("Java");
                    this._mode_menu_compile = new JMenuItem("Open Compile Window...");
                    this._mode_menu_compile.setAccelerator(KeyStroke.getKeyStroke(75, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
                    this._mode_menu_compile.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            MXJEditor.this.menu_java_compile();
                        }
                    });
                    this._mode_menu_findclass = new JMenuItem("Open Class Reference for Selected Class...");
                    this._mode_menu_findclass.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
                    this._mode_menu_findclass.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            MXJEditor.this.menu_java_findclass();
                        }
                    });
                    this._mode_menu.add(this._mode_menu_compile);
                    this._mode_menu.add(this._mode_menu_findclass);
                    this.getJMenuBar().add(this._mode_menu);
                }
                this._current_mode = mode;
                break;
            }
            case 3: {
                if (this._current_mode != 3) {
                    this._clear_mode_menu();
                }
                this._editor.setTokenMarker(new JavaScriptTokenMarker());
                if (this._mode_menu == null) {
                    this._mode_menu = new JMenu("JavaScript");
                    JMenuItem _mode_menu_check_syn = new JMenuItem("Check Syntax");
                    _mode_menu_check_syn.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            System.out.println("Do Syntax check!!(Not implemented)");
                        }
                    });
                    this._mode_menu.add(_mode_menu_check_syn);
                    this.getJMenuBar().add(this._mode_menu);
                }
                this._current_mode = mode;
                break;
            }
            case 4: {
                if (this._current_mode != 4) {
                    this._clear_mode_menu();
                }
                this._editor.setTokenMarker(new GLSLTokenMarker());
                if (this._mode_menu != null) {
                    this.getJMenuBar().remove(this._mode_menu);
                    this._mode_menu = null;
                }
                this._current_mode = mode;
                break;
            }
            case 5: {
                if (this._current_mode != 5) {
                    this._clear_mode_menu();
                }
                this._editor.setTokenMarker(new CTokenMarker());
                if (this._mode_menu == null) {
                    this._mode_menu = new JMenu("CFunk");
                    this._mode_menu_compile = new JMenuItem("Open Compile Window...");
                    this._mode_menu_compile.setAccelerator(KeyStroke.getKeyStroke(75, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
                    this._mode_menu_compile.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            MXJEditor.this.menu_cfunk_compile();
                        }
                    });
                    this._mode_menu.add(this._mode_menu_compile);
                    this.getJMenuBar().add(this._mode_menu);
                }
                this._current_mode = mode;
                break;
            }
            case 2: {
                if (this._mode_menu != null) {
                    this.getJMenuBar().remove(this._mode_menu);
                    this._mode_menu = null;
                }
                this._current_mode = mode;
            }
            default: {
                this._editor.setTokenMarker(null);
            }
        }
    }

    private void _clear_mode_menu() {
        if (this._mode_menu != null) {
            this.getJMenuBar().remove(this._mode_menu);
            this._mode_menu = null;
        }
    }

    private void _do_set_buffer(String s) {
        this.setEditable(true);
        this._editor.setText(s);
        this._editor.scrollTo(0, 0);
        this._editor.select(0, 0);
    }

    public void setBuffer(String st) {
        this._do_set_buffer(st);
    }

    public void setBufferFromFile(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            this.setBufferFromFile(f);
        } else {
            System.err.println("File " + filename + " not found!");
        }
    }

    public void setBufferFromFile(File f) {
        StringBuffer buf = new StringBuffer(2048);
        String s = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            this.setTitle("loading " + f.getAbsolutePath());
            while ((s = br.readLine()) != null) {
                buf.append(s + "\n");
            }
            this._do_set_buffer(buf.toString());
            this.set_current_file(f);
            if (f.getName().endsWith(".java")) {
                this.setMode(1);
            } else if (f.getName().endsWith(".js")) {
                this.setMode(3);
            } else if (f.getName().endsWith(".jxs") || f.getName().endsWith("glsl")) {
                this.setMode(4);
            } else if (f.getName().endsWith(".cfunk.c")) {
                this.setMode(5);
            } else {
                this.setMode(2);
            }
        }
        catch (FileNotFoundException fne) {
            System.err.println("File " + f.getName() + " not found!");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void setEditable(boolean editable) {
        if (this._current_mode == 1) {
            this._mode_menu_compile.setEnabled(editable);
        }
        this._editor.editable = editable;
    }

    public boolean isEditable() {
        return this._editor.isEditable();
    }

    public void setTabSize(int tabsize) {
        this._editor.getDocument().putProperty("tabSize", new Integer(tabsize));
    }

    private void menu_new() {
        MXJEditor e = new MXJEditor();
        Point p = this.getLocationOnScreen();
        e.setLocation(p.x + 5, p.y + 5);
        e.setVisible(true);
    }

    private void menu_open() {
        FileDialog fd = new FileDialog(this);
        fd.setVisible(true);
        String filename = fd.getFile();
        if (filename != null) {
            this.setBufferFromFile(fd.getDirectory() + filename);
        }
    }

    protected void menu_save() {
        if (this.getTitle().equals(UNTITLED) || !this.isEditable()) {
            this.menu_saveas();
        } else {
            this.do_save(this._current_file);
        }
        if (this.saveCallback != null) {
            this.saveCallback.execute();
        }
    }

    private void menu_saveas() {
        FileDialog fd = new FileDialog((Frame)this, "Save As..", 1);
        if (this._current_file != null) {
            fd.setDirectory(this._current_file.getPath());
            fd.setFile(this._current_file.getName());
        } else {
            fd.setDirectory("");
        }
        fd.setVisible(true);
        String filename = fd.getFile();
        if (filename != null) {
            this.do_save(new File(fd.getDirectory() + filename));
        }
    }

    private void do_save(File f) {
        String ap = f.getAbsolutePath();
        try {
            f.getParentFile().mkdirs();
            BufferedWriter out = new BufferedWriter(new FileWriter(f, false));
            String s = null;
            for (int i = 0; i < this._editor.getLineCount(); ++i) {
                s = this._editor.getLineText(i);
                out.write(s + "\n", 0, s.length() + 1);
            }
            out.close();
            this.set_current_file(f);
            this.setEditable(true);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.err.println("(MXJEditor) Save Failed: " + f.getAbsolutePath() + "\n" + ioe.getMessage());
            this.menu_saveas();
        }
    }

    private void menu_close() {
        this.setVisible(false);
        this.dispose();
    }

    private void menu_cut() {
        this._editor.cut();
    }

    private void menu_copy() {
        this._editor.copy();
    }

    private void menu_paste() {
        this._editor.paste();
    }

    private void menu_gotoline() {
        MaxSystem.nextWindowIsModal();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int doclen = MXJEditor.this._editor.getLineCount();
                try {
                    int i = Integer.parseInt(JOptionPane.showInputDialog(MXJEditor.this, "Goto Line", "Goto Line:", -1));
                    if (i < 1) {
                        i = 1;
                    } else if (i > doclen) {
                        i = doclen;
                    }
                    MXJEditor.this._editor.setCaretPosition(MXJEditor.this._editor.getLineStartOffset(i - 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
    }

    public void gotoLine(int l) {
        int doclen = this._editor.getLineCount();
        if (l < 1) {
            l = 1;
        } else if (l > doclen) {
            l = doclen;
        }
        this._editor.setCaretPosition(this._editor.getLineStartOffset(l - 1));
    }

    public void selectLine(int l) {
        int doclen = this._editor.getLineCount();
        if (l < 1) {
            l = 1;
        } else if (l > doclen) {
            l = doclen;
        }
        this._editor.select(this._editor.getLineStartOffset(l - 1), this._editor.getLineEndOffset(l - 1) - 1);
    }

    public void setCurrentSearchTerm(String s) {
        this._current_search_term = s;
    }

    public void menu_find() {
        MaxSystem.nextWindowIsModal();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String def = MXJEditor.this._current_search_term != null ? MXJEditor.this._current_search_term : "";
                String s = (String)JOptionPane.showInputDialog(MXJEditor.this, "Find", "Find:", -1, null, null, def);
                if (s != null) {
                    SyntaxDocument doc = MXJEditor.this._editor.getDocument();
                    MXJEditor.this.do_find(s, MXJEditor.this._editor.getCaretPosition(), doc.getLength(), true);
                }
            }
        });
    }

    public void menu_findagain() {
        SyntaxDocument doc = this._editor.getDocument();
        if (this._current_search_term != null) {
            this.do_find(this._current_search_term, this._editor.getCaretPosition(), doc.getLength(), true);
        } else {
            this.beep();
        }
    }

    public void menu_findselected() {
        String selection = this._editor.getSelectedText();
        SyntaxDocument doc = this._editor.getDocument();
        if (selection == null) {
            return;
        }
        if (selection.length() > 1) {
            if (this.do_find(selection, this._editor.getCaretPosition(), doc.getLength(), true)) {
                this.setCurrentSearchTerm(selection);
            } else {
                this.beep();
            }
        }
    }

    private boolean do_find(String s, int from_offset, int to_offset, boolean wrap) {
        if (s != null) {
            s = s.trim();
            this.setCurrentSearchTerm(s);
            SyntaxDocument doc = this._editor.getDocument();
            int offs = from_offset;
            int nleft = to_offset - offs;
            Segment text = new Segment();
            text.setPartialReturn(true);
            char[] term = new char[s.length()];
            s.getChars(0, s.length(), term, 0);
            int t_len = term.length;
            boolean inmatch = false;
            int i = 0;
            int abscount = offs;
            try {
                int t = 0;
                String doc_text = doc.getText(offs, nleft);
                for (i = 0; i < doc_text.length(); ++i) {
                    char c = doc_text.charAt(i);
                    if (c == term[t]) {
                        if (++t != t_len) continue;
                        this._editor.select(i - (t_len - 1) + offs, i + offs + 1);
                        return true;
                    }
                    t = 0;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            if (wrap) {
                return this.do_find(s, 0, from_offset + 1, false);
            }
            this.beep();
            return false;
        }
        return false;
    }

    private void menu_undo() {
        if (this._editor.getUndoManager().canUndo()) {
            this._editor.getUndoManager().undo();
        } else {
            this.beep();
        }
    }

    private void menu_redo() {
        if (this._editor.getUndoManager().canRedo()) {
            this._editor.getUndoManager().redo();
        }
    }

    private void menu_java_compile() {
        this.menu_save();
        if (this._current_file != null) {
            String f_sep = System.getProperty("file.separator");
            String p_sep = System.getProperty("path.separator");
            String[] cp = MaxSystem.getClassPath();
            StringBuffer cpath = new StringBuffer();
            for (int i = 0; i < cp.length; ++i) {
                cpath.append(cp[i]);
                if (i == cp.length - 1) continue;
                cpath.append(p_sep);
            }
            final MXJEditCompileContext ctx = new MXJEditCompileContext();
            ctx.setSourceFile(this._current_file.getAbsolutePath());
            ctx.setSourceDirectory(this._current_file.getAbsoluteFile().getParent());
            ctx.setBuildDirectory(this._current_file.getAbsoluteFile().getParent());
            ctx.setCompileCommand(MXJPreferences.getMXJCompilerCommmand());
            ctx.setClassPath(cpath.toString());
            ctx.setEditor(this);
            if (this._compile_frame != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MXJEditor.this._compile_frame.setCompileContext(ctx);
                        MXJEditor.this._compile_frame.setVisible(true);
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MXJEditor.this._compile_frame = new MXJEditCompileFrame(ctx);
                    }
                });
            }
        }
    }

    private void menu_cfunk_compile() {
        this.menu_save();
        if (this._current_file != null) {
            String f_sep = System.getProperty("file.separator");
            String p_sep = System.getProperty("path.separator");
            final MXJEditCompileContext ctx = new MXJEditCompileContext();
            ctx.setSourceFile(this._current_file.getAbsolutePath());
            ctx.setSourceDirectory(this._current_file.getAbsoluteFile().getParent());
            ctx.setEditor(this);
            if (this._cf_compile_frame != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MXJEditor.this._cf_compile_frame.setCompileContext(ctx);
                        MXJEditor.this._cf_compile_frame.setVisible(true);
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MXJEditor.this._cf_compile_frame = new MXJEditCfunkCompileFrame(ctx);
                    }
                });
            }
        }
    }

    private boolean _is_whitespace(char c) {
        return Character.isWhitespace(c) || c == '\n' || c == '\r';
    }

    void menu_java_findclass() {
        String classname = this._editor.getSelectedText();
        if (classname == null) {
            return;
        }
        HashSet<String> prefixes = new HashSet<String>();
        String line = null;
        prefixes.add("java.lang");
        for (int i = 0; i < this._editor.getLineCount(); ++i) {
            line = this._editor.getLineText(i).trim();
            if (line.equals("") || line.startsWith("/") || line.startsWith("*")) continue;
            if (line.startsWith("import")) {
                int dot_idx = line.lastIndexOf(46);
                line = line.substring(0, dot_idx).split(" ")[1].trim();
                prefixes.add(line);
                continue;
            }
            if (line.startsWith("package")) {
                int semi_idx = line.lastIndexOf(59);
                line = line.substring(0, semi_idx).split(" ")[1].trim();
                prefixes.add(line);
                continue;
            }
            if (line.length() == 1) {
                if (!this._is_whitespace(line.charAt(0))) continue;
                continue;
            }
            if (line.length() != 2) break;
            if (this._is_whitespace(line.charAt(0)) && !this._is_whitespace(line.charAt(1))) continue;
        }
        Class c = null;
        Iterator it = prefixes.iterator();
        String prefix = null;
        while (it.hasNext()) {
            prefix = (String)it.next();
            c = MXJClassLoader.getInstance().loadClazz(prefix + "." + classname, false, false);
            if (c == null) continue;
        }
        if (c == null && (c = MXJClassLoader.getInstance().loadClazz(classname, false, false)) == null) {
            this.beep();
            return;
        }
        final Class cc = c;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MXJClassRefFrame f = new MXJClassRefFrame(cc);
            }
        });
    }

    public void setCurrentFile(File f) {
        this.set_current_file(f);
    }

    private void set_current_file(File f) {
        String s = f.getAbsolutePath();
        this._current_file = f;
        this.setTitle(s);
    }

    public static void main(String[] args) {
        MXJEditor e = new MXJEditor();
    }

    private void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    protected void finalize() {
    }

    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (vis) {
            this._editor.requestFocus();
        }
    }
}

