/*
 * Decompiled with CFR 0.152.
 */
package jode.bytecode;

import jode.AssertError;
import jode.bytecode.ClassInfo;

public class TypeSignature {
    private static final StringBuffer appendSignature(StringBuffer stringBuffer, Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return stringBuffer.append('Z');
            }
            if (clazz == Byte.TYPE) {
                return stringBuffer.append('B');
            }
            if (clazz == Character.TYPE) {
                return stringBuffer.append('C');
            }
            if (clazz == Short.TYPE) {
                return stringBuffer.append('S');
            }
            if (clazz == Integer.TYPE) {
                return stringBuffer.append('I');
            }
            if (clazz == Long.TYPE) {
                return stringBuffer.append('J');
            }
            if (clazz == Float.TYPE) {
                return stringBuffer.append('F');
            }
            if (clazz == Double.TYPE) {
                return stringBuffer.append('D');
            }
            if (clazz == Void.TYPE) {
                return stringBuffer.append('V');
            }
            throw new AssertError("Unknown primitive type: " + clazz);
        }
        if (clazz.isArray()) {
            return TypeSignature.appendSignature(stringBuffer.append('['), clazz.getComponentType());
        }
        return stringBuffer.append('L').append(clazz.getName().replace('.', '/')).append(';');
    }

    public static String getSignature(Class clazz) {
        return TypeSignature.appendSignature(new StringBuffer(), clazz).toString();
    }

    public static String getSignature(Class[] classArray, Class clazz) {
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = 0;
        while (n < classArray.length) {
            TypeSignature.appendSignature(stringBuffer, classArray[n]);
            ++n;
        }
        return TypeSignature.appendSignature(stringBuffer.append(')'), clazz).toString();
    }

    public static Class getClass(String string) throws ClassNotFoundException {
        switch (string.charAt(0)) {
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'V': {
                return Void.TYPE;
            }
            case 'L': {
                string = string.substring(1, string.length() - 1).replace('/', '.');
            }
            case '[': {
                return Class.forName(string);
            }
        }
        throw new IllegalArgumentException(string);
    }

    private static boolean usingTwoSlots(char c) {
        return "JD".indexOf(c) >= 0;
    }

    public static int getTypeSize(String string) {
        return TypeSignature.usingTwoSlots(string.charAt(0)) ? 2 : 1;
    }

    public static String getElementType(String string) {
        if (string.charAt(0) != '[') {
            throw new IllegalArgumentException();
        }
        return string.substring(1);
    }

    public static ClassInfo getClassInfo(String string) {
        if (string.charAt(0) != 'L') {
            throw new IllegalArgumentException();
        }
        return ClassInfo.forName(string.substring(1, string.length() - 1).replace('/', '.'));
    }

    public static int skipType(String string, int n) {
        char c = string.charAt(n++);
        while (c == '[') {
            c = string.charAt(n++);
        }
        if (c == 'L') {
            return string.indexOf(59, n) + 1;
        }
        return n;
    }

    public static int getArgumentSize(String string) {
        int n = 0;
        int n2 = 1;
        char c;
        while ((c = string.charAt(n2)) != ')') {
            n2 = TypeSignature.skipType(string, n2);
            if (TypeSignature.usingTwoSlots(c)) {
                n += 2;
                continue;
            }
            ++n;
        }
        return n;
    }

    public static int getReturnSize(String string) {
        int n = string.length();
        if (string.charAt(n - 2) == ')') {
            char c = string.charAt(n - 1);
            return c == 'V' ? 0 : (TypeSignature.usingTwoSlots(c) ? 2 : 1);
        }
        return 1;
    }

    public static String[] getParameterTypes(String string) {
        int n = 1;
        int n2 = 0;
        while (string.charAt(n) != ')') {
            n = TypeSignature.skipType(string, n);
            ++n2;
        }
        String[] stringArray = new String[n2];
        n = 1;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n;
            n = TypeSignature.skipType(string, n);
            stringArray[n3] = string.substring(n4, n);
            ++n3;
        }
        return stringArray;
    }

    public static String getReturnType(String string) {
        return string.substring(string.lastIndexOf(41) + 1);
    }

    private static int checkClassName(String string, int n) throws IllegalArgumentException, StringIndexOutOfBoundsException {
        char c;
        do {
            if ((c = string.charAt(n++)) != ';') continue;
            return n;
        } while (c == '/' || Character.isJavaIdentifierPart(c));
        throw new IllegalArgumentException("Illegal java class name: " + string);
    }

    private static int checkTypeSig(String string, int n) {
        char c = string.charAt(n++);
        while (c == '[') {
            c = string.charAt(n++);
        }
        if (c == 'L') {
            n = TypeSignature.checkClassName(string, n);
        } else if ("ZBSCIJFD".indexOf(c) == -1) {
            throw new IllegalArgumentException("Type sig error: " + string);
        }
        return n;
    }

    public static void checkTypeSig(String string) throws IllegalArgumentException {
        try {
            if (TypeSignature.checkTypeSig(string, 0) != string.length()) {
                throw new IllegalArgumentException("Type sig too long: " + string);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Incomplete type sig: " + string);
        }
    }

    public static void checkMethodTypeSig(String string) throws IllegalArgumentException {
        try {
            if (string.charAt(0) != '(') {
                throw new IllegalArgumentException("No method signature: " + string);
            }
            int n = 1;
            while (string.charAt(n) != ')') {
                n = TypeSignature.checkTypeSig(string, n);
            }
            n = string.charAt(++n) == 'V' ? ++n : TypeSignature.checkTypeSig(string, n);
            if (n != string.length()) {
                throw new IllegalArgumentException("Type sig too long: " + string);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Incomplete type sig: " + string);
        }
    }
}

