/*
 * Decompiled with CFR 0.152.
 */
package jode.decompiler;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import jode.decompiler.Decompiler;

public class Window
implements Runnable,
ActionListener {
    TextField classpathField;
    TextField classField;
    TextArea sourcecodeArea;
    TextArea errorArea;
    Checkbox verboseCheck;
    Checkbox prettyCheck;
    Button startButton;
    Button saveButton;
    String lastClassName;
    String lastClassPath;
    Frame frame;
    PrintWriter errStream;
    Decompiler decompiler = new Decompiler();
    Thread decompileThread;

    private void buildComponents(Container container) {
        if (container instanceof Frame) {
            this.frame = (Frame)container;
        }
        container.setFont(new Font("dialog", 0, 10));
        this.classpathField = new TextField(50);
        this.classField = new TextField(50);
        this.sourcecodeArea = new TextArea(20, 80);
        this.errorArea = new TextArea(3, 80);
        this.verboseCheck = new Checkbox("verbose", true);
        this.prettyCheck = new Checkbox("pretty", true);
        this.startButton = new Button("start");
        this.saveButton = new Button("save");
        this.saveButton.setEnabled(false);
        this.sourcecodeArea.setEditable(false);
        this.errorArea.setEditable(false);
        Font font = new Font("monospaced", 0, 10);
        this.sourcecodeArea.setFont(font);
        this.errorArea.setFont(font);
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints3.fill = 1;
        gridBagConstraints4.fill = 0;
        gridBagConstraints5.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints5.anchor = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        container.add((Component)new Label("class path: "), gridBagConstraints);
        container.add((Component)this.classpathField, gridBagConstraints2);
        container.add((Component)new Label("class name: "), gridBagConstraints);
        container.add((Component)this.classField, gridBagConstraints2);
        container.add((Component)this.verboseCheck, gridBagConstraints4);
        container.add((Component)this.prettyCheck, gridBagConstraints4);
        gridBagConstraints.weightx = 1.0;
        container.add((Component)new Label(), gridBagConstraints);
        container.add((Component)this.startButton, gridBagConstraints5);
        gridBagConstraints5.gridwidth = 0;
        container.add((Component)this.saveButton, gridBagConstraints5);
        container.add((Component)this.sourcecodeArea, gridBagConstraints3);
        gridBagConstraints3.gridheight = 0;
        gridBagConstraints3.weighty = 0.0;
        container.add((Component)this.errorArea, gridBagConstraints3);
        this.startButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        Window window = this;
        if (window == null) {
            throw null;
        }
        this.errStream = new PrintWriter(window.new AreaWriter(this.errorArea));
        this.decompiler.setErr(this.errStream);
    }

    public void setClassPath(String string) {
        this.classpathField.setText(string);
    }

    public void setClass(String string) {
        this.classField.setText(string);
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.startButton) {
            this.startButton.setEnabled(false);
            this.decompileThread = new Thread(this);
            this.sourcecodeArea.setText("Please wait, while decompiling...\n");
            this.decompileThread.start();
        } else if (object == this.saveButton) {
            if (this.frame == null) {
                this.frame = new Frame();
            }
            FileDialog fileDialog = new FileDialog(this.frame, "Save decompiled code", 1);
            fileDialog.setFile(this.lastClassName.substring(this.lastClassName.lastIndexOf(46) + 1).concat(".java"));
            fileDialog.show();
            String string = fileDialog.getFile();
            if (string == null) {
                return;
            }
            try {
                File file = new File(new File(fileDialog.getDirectory()), string);
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(this.sourcecodeArea.getText());
                fileWriter.close();
            }
            catch (IOException iOException) {
                this.errorArea.setText("");
                this.errStream.println("Couldn't write to file " + string + ": ");
                iOException.printStackTrace(this.errStream);
            }
            catch (SecurityException securityException) {
                this.errorArea.setText("");
                this.errStream.println("Couldn't write to file " + string + ": ");
                securityException.printStackTrace(this.errStream);
            }
        }
    }

    /*
     * Loose catch block
     */
    public void run() {
        Object object;
        this.decompiler.setOption("verbose", this.verboseCheck.getState() ? "1" : "0");
        this.decompiler.setOption("pretty", this.prettyCheck.getState() ? "1" : "0");
        this.errorArea.setText("");
        this.saveButton.setEnabled(false);
        this.lastClassName = this.classField.getText();
        String string = this.classpathField.getText();
        if (!string.equals(this.lastClassPath)) {
            this.decompiler.setClassPath(string);
            this.lastClassPath = string;
        }
        try {
            Window window = this;
            if (window == null) {
                throw null;
            }
            object = new BufferedWriter(window.new AreaWriter(this.sourcecodeArea), 512);
            try {
                this.decompiler.decompile(this.lastClassName, (Writer)object, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.sourcecodeArea.setText("`" + this.lastClassName + "' is not a class name.\n" + "You have to give a full qualified classname " + "with '.' as package delimiter \n" + "and without .class ending.");
                Object var3_7 = null;
                object = this;
                synchronized (object) {
                    this.decompileThread = null;
                    this.startButton.setEnabled(true);
                }
                return;
            }
            this.saveButton.setEnabled(true);
            Object var3_8 = null;
            object = this;
        }
        catch (Throwable throwable) {
            Object var3_10 = null;
            Window window = this;
            synchronized (window) {
                this.decompileThread = null;
                this.startButton.setEnabled(true);
            }
            throw throwable;
        }
        synchronized (object) {
            this.decompileThread = null;
            this.startButton.setEnabled(true);
        }
        {
            catch (Throwable throwable) {
                this.sourcecodeArea.setText("Didn't succeed.\nCheck the below area for more info.");
                throwable.printStackTrace();
                Object var3_9 = null;
                Window window = this;
                synchronized (window) {
                    this.decompileThread = null;
                    this.startButton.setEnabled(true);
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Jode (c) 1998-2001 Jochen Hoenicke <jochen@gnu.org>");
        Window window = new Window(frame);
        String string = System.getProperty("java.class.path");
        if (string != null) {
            window.setClassPath(string.replace(File.pathSeparatorChar, ','));
        }
        String string2 = window.getClass().getName();
        window.setClass(string2);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        frame.pack();
        frame.show();
    }

    public Window(Container container) {
        this.buildComponents(container);
    }

    public class AreaWriter
    extends Writer {
        boolean initialized = false;
        private TextArea area;

        public void write(char[] cArray, int n, int n2) throws IOException {
            if (!this.initialized) {
                this.area.setText("");
                this.initialized = true;
            }
            this.area.append(new String(cArray, n, n2));
        }

        public void flush() {
        }

        public void close() {
        }

        public AreaWriter(TextArea textArea) {
            this.area = textArea;
        }
    }
}

