/*
 * Decompiled with CFR 0.152.
 */
package jode.jvm;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import jode.AssertError;
import jode.GlobalOptions;
import jode.bytecode.BytecodeInfo;
import jode.bytecode.ClassInfo;
import jode.bytecode.Handler;
import jode.bytecode.Instruction;
import jode.bytecode.MethodInfo;
import jode.bytecode.Opcodes;
import jode.bytecode.Reference;
import jode.bytecode.TypeSignature;
import jode.jvm.VerifyException;

public class CodeVerifier
implements Opcodes {
    static Type tNull = Type.tType("0");
    static Type tInt = Type.tType("I");
    static Type tLong = Type.tType("J");
    static Type tFloat = Type.tType("F");
    static Type tDouble = Type.tType("D");
    static Type tString = Type.tType("Ljava/lang/String;");
    static Type tNone = Type.tType("?");
    static Type tSecondPart = new Type("2");
    static Type tObject = new Type("Ljava/lang/Object;");
    ClassInfo ci;
    MethodInfo mi;
    BytecodeInfo bi;
    String methodType;
    String returnType;
    String[] types = new String[]{"I", "J", "F", "D", "+", "B", "C", "S"};
    String[] arrayTypes = new String[]{"[I", "[J", "[F", "[D", "[Ljava/lang/Object;", "[B", "[C", "[S"};

    public VerifyInfo initInfo() {
        CodeVerifier codeVerifier = this;
        if (codeVerifier == null) {
            throw null;
        }
        VerifyInfo verifyInfo = codeVerifier.new VerifyInfo();
        int n = 1;
        int n2 = 0;
        if (!this.mi.isStatic()) {
            String string = this.ci.getName().replace('.', '/');
            verifyInfo.locals[n2++] = this.mi.getName().equals("<init>") ? Type.tType("N" + string + ";", null) : Type.tType("L" + string + ";");
        }
        while (this.methodType.charAt(n) != ')') {
            int n3 = n;
            n = TypeSignature.skipType(this.methodType, n);
            String string = this.methodType.substring(n3, n);
            verifyInfo.locals[n2++] = Type.tType(string);
            if (TypeSignature.getTypeSize(string) != 2) continue;
            verifyInfo.locals[n2++] = tSecondPart;
        }
        while (n2 < this.bi.getMaxLocals()) {
            verifyInfo.locals[n2++] = tNone;
        }
        return verifyInfo;
    }

    public boolean mergeInfo(Instruction instruction, VerifyInfo verifyInfo) throws VerifyException {
        Type type;
        if (instruction.getTmpInfo() == null) {
            instruction.setTmpInfo(verifyInfo);
            return true;
        }
        boolean bl = false;
        VerifyInfo verifyInfo2 = (VerifyInfo)instruction.getTmpInfo();
        if (verifyInfo2.stackHeight != verifyInfo.stackHeight) {
            throw new VerifyException("Stack height differ at: " + instruction.getDescription());
        }
        int n = 0;
        while (n < verifyInfo2.stackHeight) {
            type = verifyInfo2.stack[n].mergeType(verifyInfo.stack[n]);
            if (!type.equals(verifyInfo2.stack[n])) {
                if (type == tNone) {
                    throw new VerifyException("Type error while merging: " + verifyInfo2.stack[n] + " and " + verifyInfo.stack[n]);
                }
                bl = true;
                verifyInfo2.stack[n] = type;
            }
            ++n;
        }
        n = 0;
        while (n < this.bi.getMaxLocals()) {
            type = verifyInfo2.locals[n].mergeType(verifyInfo.locals[n]);
            if (!type.equals(verifyInfo2.locals[n])) {
                bl = true;
                verifyInfo2.locals[n] = type;
            }
            ++n;
        }
        if (verifyInfo2.jsrTargets != null) {
            if (verifyInfo.jsrTargets == null) {
                n = 0;
            } else {
                n = verifyInfo.jsrTargets.length;
                int n2 = 0;
                int n3 = 0;
                while (n3 < verifyInfo2.jsrTargets.length) {
                    int n4 = n2;
                    while (n4 < n) {
                        if (verifyInfo2.jsrTargets[n3] == verifyInfo.jsrTargets[n4]) {
                            System.arraycopy(verifyInfo.jsrTargets, n4, verifyInfo.jsrTargets, n2, n - n4);
                            n -= n4 - n2;
                            ++n2;
                            break;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                n = n2;
            }
            if (n != verifyInfo2.jsrTargets.length) {
                if (n == 0) {
                    verifyInfo2.jsrTargets = null;
                } else {
                    verifyInfo2.jsrTargets = new Instruction[n];
                    System.arraycopy(verifyInfo.jsrTargets, 0, verifyInfo2.jsrTargets, 0, n);
                }
                bl = true;
            }
        }
        return bl;
    }

    public VerifyInfo modelEffect(Instruction instruction, VerifyInfo verifyInfo) throws VerifyException {
        int n = verifyInfo.jsrTargets != null ? verifyInfo.jsrTargets.length : 0;
        VerifyInfo verifyInfo2 = (VerifyInfo)verifyInfo.clone();
        int n2 = instruction.getOpcode();
        switch (n2) {
            case 0: 
            case 167: {
                break;
            }
            case 18: {
                Object object = instruction.getConstant();
                Type type = object == null ? tNull : (object instanceof Integer ? tInt : (object instanceof Float ? tFloat : tString));
                verifyInfo2.push(type);
                break;
            }
            case 20: {
                Object object = instruction.getConstant();
                Type type = object instanceof Long ? tLong : tDouble;
                verifyInfo2.push(type);
                verifyInfo2.push(tSecondPart);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                if (n > 0 && (!verifyInfo2.jsrLocals[n - 1].get(instruction.getLocalSlot()) || (n2 & 1) == 0 && !verifyInfo2.jsrLocals[n - 1].get(instruction.getLocalSlot() + 1))) {
                    verifyInfo2.jsrLocals = (BitSet[])verifyInfo2.jsrLocals.clone();
                    verifyInfo2.jsrLocals[n - 1] = (BitSet)verifyInfo2.jsrLocals[n - 1].clone();
                    verifyInfo2.jsrLocals[n - 1].set(instruction.getLocalSlot());
                    if ((n2 & 1) == 0) {
                        verifyInfo2.jsrLocals[n - 1].set(instruction.getLocalSlot() + 1);
                    }
                }
                if ((n2 & 1) == 0 && verifyInfo2.locals[instruction.getLocalSlot() + 1] != tSecondPart) {
                    throw new VerifyException(instruction.getDescription());
                }
                Type type = verifyInfo2.locals[instruction.getLocalSlot()];
                if (!type.isOfType(this.types[n2 - 21])) {
                    throw new VerifyException(instruction.getDescription());
                }
                verifyInfo2.push(type);
                if ((n2 & 1) != 0) break;
                verifyInfo2.push(tSecondPart);
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                if (!verifyInfo2.pop().isOfType("I")) {
                    throw new VerifyException(instruction.getDescription());
                }
                Type type = verifyInfo2.pop();
                if (!(type.isOfType(this.arrayTypes[n2 - 46]) || n2 == 51 && type.isOfType("[Z"))) {
                    throw new VerifyException(instruction.getDescription());
                }
                String string = type.getTypeSig();
                Type type2 = string.charAt(0) == '[' ? Type.tType(string.substring(1)) : (n2 == 50 ? tNull : Type.tType(this.types[n2 - 46]));
                verifyInfo2.push(type2);
                if ((1 << n2 - 46 & 0xA) == 0) break;
                verifyInfo2.push(tSecondPart);
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                if (n > 0 && (!verifyInfo2.jsrLocals[n - 1].get(instruction.getLocalSlot()) || (n2 & 1) != 0 && !verifyInfo2.jsrLocals[n - 1].get(instruction.getLocalSlot() + 1))) {
                    verifyInfo2.jsrLocals = (BitSet[])verifyInfo2.jsrLocals.clone();
                    verifyInfo2.jsrLocals[n - 1] = (BitSet)verifyInfo2.jsrLocals[n - 1].clone();
                    verifyInfo2.jsrLocals[n - 1].set(instruction.getLocalSlot());
                    if ((n2 & 1) != 0) {
                        verifyInfo2.jsrLocals[n - 1].set(instruction.getLocalSlot() + 1);
                    }
                }
                if ((n2 & 1) != 0 && verifyInfo2.pop() != tSecondPart) {
                    throw new VerifyException(instruction.getDescription());
                }
                Type type = verifyInfo2.pop();
                if (!(type.isOfType(this.types[n2 - 54]) || n2 == 58 && type.isOfType("R"))) {
                    throw new VerifyException(instruction.getDescription());
                }
                verifyInfo2.locals[instruction.getLocalSlot()] = type;
                if ((n2 & 1) == 0) break;
                verifyInfo2.locals[instruction.getLocalSlot() + 1] = tSecondPart;
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                String string;
                if ((1 << n2 - 79 & 0xA) != 0 && verifyInfo2.pop() != tSecondPart) {
                    throw new VerifyException(instruction.getDescription());
                }
                Type type = verifyInfo2.pop();
                if (!verifyInfo2.pop().isOfType("I")) {
                    throw new VerifyException(instruction.getDescription());
                }
                Type type3 = verifyInfo2.pop();
                if (!(type3.isOfType(this.arrayTypes[n2 - 79]) || n2 == 84 && type3.isOfType("[Z"))) {
                    throw new VerifyException(instruction.getDescription());
                }
                String string2 = string = n2 >= 84 ? "I" : this.types[n2 - 79];
                if (type.isOfType(string)) break;
                throw new VerifyException(instruction.getDescription());
            }
            case 87: 
            case 88: {
                int n3 = n2 - 86;
                verifyInfo2.need(n3);
                verifyInfo2.stackHeight -= n3;
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                int n4 = n2 - 89;
                verifyInfo2.reserve(1);
                verifyInfo2.need(n4 + 1);
                if (verifyInfo2.stack[verifyInfo2.stackHeight - 1] == tSecondPart) {
                    throw new VerifyException(instruction.getDescription());
                }
                int n5 = verifyInfo2.stackHeight - (n4 + 1);
                if (verifyInfo2.stack[n5] == tSecondPart) {
                    throw new VerifyException(instruction.getDescription() + " on long or double");
                }
                int n6 = verifyInfo2.stackHeight;
                while (n6 > n5) {
                    verifyInfo2.stack[n6] = verifyInfo2.stack[n6 - 1];
                    --n6;
                }
                verifyInfo2.stack[n5] = verifyInfo2.stack[verifyInfo2.stackHeight++];
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                int n7 = n2 - 92;
                verifyInfo2.reserve(2);
                verifyInfo2.need(n7 + 2);
                if (verifyInfo2.stack[verifyInfo2.stackHeight - 2] == tSecondPart) {
                    throw new VerifyException(instruction.getDescription() + " on misaligned long or double");
                }
                int n8 = verifyInfo2.stackHeight;
                int n9 = n8 - (n7 + 2);
                if (verifyInfo2.stack[n9] == tSecondPart) {
                    throw new VerifyException(instruction.getDescription() + " on long or double");
                }
                int n10 = n8;
                while (n10 > n9) {
                    verifyInfo2.stack[n10 + 1] = verifyInfo2.stack[n10 - 1];
                    --n10;
                }
                verifyInfo2.stack[n9 + 1] = verifyInfo2.stack[n8 + 1];
                verifyInfo2.stack[n9] = verifyInfo2.stack[n8];
                verifyInfo2.stackHeight += 2;
                break;
            }
            case 95: {
                verifyInfo2.need(2);
                if (verifyInfo2.stack[verifyInfo2.stackHeight - 2] == tSecondPart || verifyInfo2.stack[verifyInfo2.stackHeight - 1] == tSecondPart) {
                    throw new VerifyException(instruction.getDescription() + " on misaligned long or double");
                }
                Type type = verifyInfo2.stack[verifyInfo2.stackHeight - 1];
                verifyInfo2.stack[verifyInfo2.stackHeight - 1] = verifyInfo2.stack[verifyInfo2.stackHeight - 2];
                verifyInfo2.stack[verifyInfo2.stackHeight - 2] = type;
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                String string = this.types[n2 - 96 & 3];
                if ((n2 & 1) != 0 && verifyInfo2.pop() != tSecondPart) {
                    throw new VerifyException(instruction.getDescription());
                }
                if (!verifyInfo2.pop().isOfType(string)) {
                    throw new VerifyException(instruction.getDescription());
                }
                if ((n2 & 1) != 0) {
                    verifyInfo2.need(2);
                    if (verifyInfo2.stack[verifyInfo2.stackHeight - 1] == tSecondPart && verifyInfo2.stack[verifyInfo2.stackHeight - 2].isOfType(string)) break;
                    throw new VerifyException(instruction.getDescription());
                }
                verifyInfo2.need(1);
                if (verifyInfo2.stack[verifyInfo2.stackHeight - 1].isOfType(string)) break;
                throw new VerifyException(instruction.getDescription());
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                String string = this.types[n2 - 116 & 3];
                if ((n2 & 1) != 0) {
                    verifyInfo2.need(2);
                    if (verifyInfo2.stack[verifyInfo2.stackHeight - 1] == tSecondPart && verifyInfo2.stack[verifyInfo2.stackHeight - 2].isOfType(string)) break;
                    throw new VerifyException(instruction.getDescription());
                }
                verifyInfo2.need(1);
                if (verifyInfo2.stack[verifyInfo2.stackHeight - 1].isOfType(string)) break;
                throw new VerifyException(instruction.getDescription());
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                if (!verifyInfo2.pop().isOfType("I")) {
                    throw new VerifyException(instruction.getDescription());
                }
                if ((n2 & 1) != 0) {
                    verifyInfo2.need(2);
                    if (verifyInfo2.stack[verifyInfo2.stackHeight - 1] == tSecondPart && verifyInfo2.stack[verifyInfo2.stackHeight - 2].isOfType("J")) break;
                    throw new VerifyException(instruction.getDescription());
                }
                verifyInfo2.need(1);
                if (verifyInfo2.stack[verifyInfo2.stackHeight - 1].isOfType("I")) break;
                throw new VerifyException(instruction.getDescription());
            }
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                if ((n2 & 1) != 0 && verifyInfo2.pop() != tSecondPart) {
                    throw new VerifyException(instruction.getDescription());
                }
                if (!verifyInfo2.pop().isOfType(this.types[n2 & 1])) {
                    throw new VerifyException(instruction.getDescription());
                }
                if ((n2 & 1) != 0) {
                    verifyInfo2.need(2);
                    if (verifyInfo2.stack[verifyInfo2.stackHeight - 1] == tSecondPart && verifyInfo2.stack[verifyInfo2.stackHeight - 2].isOfType("J")) break;
                    throw new VerifyException(instruction.getDescription());
                }
                verifyInfo2.need(1);
                if (verifyInfo2.stack[verifyInfo2.stackHeight - 1].isOfType("I")) break;
                throw new VerifyException(instruction.getDescription());
            }
            case 132: {
                if (verifyInfo2.locals[instruction.getLocalSlot()].isOfType("I")) break;
                throw new VerifyException(instruction.getDescription());
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: {
                int n11 = (n2 - 133) / 3;
                int n12 = (n2 - 133) % 3;
                if (n12 >= n11) {
                    ++n12;
                }
                if ((n11 & 1) != 0 && verifyInfo2.pop() != tSecondPart) {
                    throw new VerifyException(instruction.getDescription());
                }
                if (!verifyInfo2.pop().isOfType(this.types[n11])) {
                    throw new VerifyException(instruction.getDescription());
                }
                verifyInfo2.push(Type.tType(this.types[n12]));
                if ((n12 & 1) == 0) break;
                verifyInfo2.push(tSecondPart);
                break;
            }
            case 145: 
            case 146: 
            case 147: {
                verifyInfo2.need(1);
                if (verifyInfo2.stack[verifyInfo2.stackHeight - 1].isOfType("I")) break;
                throw new VerifyException(instruction.getDescription());
            }
            case 148: {
                if (verifyInfo2.pop() != tSecondPart) {
                    throw new VerifyException(instruction.getDescription());
                }
                if (!verifyInfo2.pop().isOfType("J")) {
                    throw new VerifyException(instruction.getDescription());
                }
                if (verifyInfo2.pop() != tSecondPart) {
                    throw new VerifyException(instruction.getDescription());
                }
                if (!verifyInfo2.pop().isOfType("J")) {
                    throw new VerifyException(instruction.getDescription());
                }
                verifyInfo2.push(tInt);
                break;
            }
            case 151: 
            case 152: {
                if (verifyInfo2.pop() != tSecondPart) {
                    throw new VerifyException(instruction.getDescription());
                }
                if (!verifyInfo2.pop().isOfType("D")) {
                    throw new VerifyException(instruction.getDescription());
                }
                if (verifyInfo2.pop() != tSecondPart) {
                    throw new VerifyException(instruction.getDescription());
                }
                if (!verifyInfo2.pop().isOfType("D")) {
                    throw new VerifyException(instruction.getDescription());
                }
                verifyInfo2.push(tInt);
                break;
            }
            case 149: 
            case 150: {
                if (!verifyInfo2.pop().isOfType("F")) {
                    throw new VerifyException(instruction.getDescription());
                }
                if (!verifyInfo2.pop().isOfType("F")) {
                    throw new VerifyException(instruction.getDescription());
                }
                verifyInfo2.push(tInt);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: {
                if (verifyInfo2.pop().isOfType("I")) break;
                throw new VerifyException(instruction.getDescription());
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                if (!verifyInfo2.pop().isOfType("I")) {
                    throw new VerifyException(instruction.getDescription());
                }
                if (verifyInfo2.pop().isOfType("I")) break;
                throw new VerifyException(instruction.getDescription());
            }
            case 165: 
            case 166: {
                if (!verifyInfo2.pop().isOfType("+")) {
                    throw new VerifyException(instruction.getDescription());
                }
                if (verifyInfo2.pop().isOfType("+")) break;
                throw new VerifyException(instruction.getDescription());
            }
            case 198: 
            case 199: {
                if (verifyInfo2.pop().isOfType("+")) break;
                throw new VerifyException(instruction.getDescription());
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                if ((1 << n2 - 172 & 0xA) != 0 && verifyInfo2.pop() != tSecondPart) {
                    throw new VerifyException(instruction.getDescription());
                }
                Type type = verifyInfo2.pop();
                if (type.isOfType(this.types[n2 - 172]) && type.isOfType(TypeSignature.getReturnType(this.methodType))) break;
                throw new VerifyException(instruction.getDescription());
            }
            case 168: {
                Instruction instruction2 = instruction.getSingleSucc();
                verifyInfo2.stack[verifyInfo2.stackHeight++] = Type.tType("R", instruction2);
                verifyInfo2.jsrTargets = new Instruction[n + 1];
                verifyInfo2.jsrLocals = new BitSet[n + 1];
                if (n > 0) {
                    int n13 = 0;
                    while (n13 < verifyInfo.jsrTargets.length) {
                        if (verifyInfo.jsrTargets[n13] == instruction.getSingleSucc()) {
                            throw new VerifyException(instruction.getDescription() + " is recursive");
                        }
                        ++n13;
                    }
                    System.arraycopy(verifyInfo.jsrTargets, 0, verifyInfo2.jsrTargets, 0, n);
                    System.arraycopy(verifyInfo.jsrLocals, 0, verifyInfo2.jsrLocals, 0, n);
                }
                verifyInfo2.jsrTargets[n] = instruction.getSingleSucc();
                verifyInfo2.jsrLocals[n] = new BitSet();
                break;
            }
            case 177: {
                if (this.returnType.equals("V")) break;
                throw new VerifyException(instruction.getDescription());
            }
            case 178: {
                Reference reference = instruction.getReference();
                String string = reference.getType();
                verifyInfo2.push(Type.tType(string));
                if (TypeSignature.getTypeSize(string) != 2) break;
                verifyInfo2.push(tSecondPart);
                break;
            }
            case 180: {
                Reference reference = instruction.getReference();
                String string = reference.getClazz();
                if (!verifyInfo2.pop().isOfType(string)) {
                    throw new VerifyException(instruction.getDescription());
                }
                String string3 = reference.getType();
                verifyInfo2.push(Type.tType(string3));
                if (TypeSignature.getTypeSize(string3) != 2) break;
                verifyInfo2.push(tSecondPart);
                break;
            }
            case 179: {
                Reference reference = instruction.getReference();
                String string = reference.getType();
                if (TypeSignature.getTypeSize(string) == 2 && verifyInfo2.pop() != tSecondPart) {
                    throw new VerifyException(instruction.getDescription());
                }
                if (verifyInfo2.pop().isOfType(string)) break;
                throw new VerifyException(instruction.getDescription());
            }
            case 181: {
                Reference reference = instruction.getReference();
                String string = reference.getType();
                if (TypeSignature.getTypeSize(string) == 2 && verifyInfo2.pop() != tSecondPart) {
                    throw new VerifyException(instruction.getDescription());
                }
                if (!verifyInfo2.pop().isOfType(string)) {
                    throw new VerifyException(instruction.getDescription());
                }
                String string4 = reference.getClazz();
                if (verifyInfo2.pop().isOfType(string4)) break;
                throw new VerifyException(instruction.getDescription());
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                Reference reference = instruction.getReference();
                String string = reference.getType();
                String[] stringArray = TypeSignature.getParameterTypes(string);
                int n14 = stringArray.length - 1;
                while (n14 >= 0) {
                    if (TypeSignature.getTypeSize(stringArray[n14]) == 2 && verifyInfo2.pop() != tSecondPart) {
                        throw new VerifyException(instruction.getDescription());
                    }
                    if (!verifyInfo2.pop().isOfType(stringArray[n14])) {
                        throw new VerifyException(instruction.getDescription());
                    }
                    --n14;
                }
                if (reference.getName().equals("<init>")) {
                    Object object;
                    Type type = verifyInfo2.pop();
                    String string5 = type.getTypeSig();
                    String string6 = reference.getClazz();
                    if (n2 != 183 || string5.charAt(0) != 'N' || string6.charAt(0) != 'L') {
                        throw new VerifyException(instruction.getDescription());
                    }
                    if (!(string5.substring(1).equals(string6.substring(1)) || ((ClassInfo)(object = ClassInfo.forName(string5.substring(1, string5.length() - 1).replace('/', '.')))).getSuperclass() == TypeSignature.getClassInfo(string6) && type.getInstruction() == null)) {
                        throw new VerifyException(instruction.getDescription());
                    }
                    object = Type.tType("L" + string5.substring(1));
                    int n15 = 0;
                    while (n15 < verifyInfo2.stackHeight) {
                        if (verifyInfo2.stack[n15] == type) {
                            verifyInfo2.stack[n15] = object;
                        }
                        ++n15;
                    }
                    n15 = 0;
                    while (n15 < verifyInfo2.locals.length) {
                        if (verifyInfo2.locals[n15] == type) {
                            verifyInfo2.locals[n15] = object;
                        }
                        ++n15;
                    }
                } else if (n2 != 184) {
                    String string7 = reference.getClazz();
                    if (!verifyInfo2.pop().isOfType(string7)) {
                        throw new VerifyException(instruction.getDescription());
                    }
                }
                String string8 = TypeSignature.getReturnType(string);
                if (string8.equals("V")) break;
                verifyInfo2.push(Type.tType(string8));
                if (TypeSignature.getTypeSize(string8) != 2) break;
                verifyInfo2.push(tSecondPart);
                break;
            }
            case 187: {
                String string = instruction.getClazzType();
                verifyInfo2.stack[verifyInfo2.stackHeight++] = Type.tType("N" + string.substring(1), instruction);
                break;
            }
            case 190: {
                if (!verifyInfo2.pop().isOfType("[*")) {
                    throw new VerifyException(instruction.getDescription());
                }
                verifyInfo2.push(tInt);
                break;
            }
            case 191: {
                if (verifyInfo2.pop().isOfType("Ljava/lang/Throwable;")) break;
                throw new VerifyException(instruction.getDescription());
            }
            case 192: {
                String string = instruction.getClazzType();
                if (!verifyInfo2.pop().isOfType("+")) {
                    throw new VerifyException(instruction.getDescription());
                }
                verifyInfo2.push(Type.tType(string));
                break;
            }
            case 193: {
                if (!verifyInfo2.pop().isOfType("Ljava/lang/Object;")) {
                    throw new VerifyException(instruction.getDescription());
                }
                verifyInfo2.push(tInt);
                break;
            }
            case 194: 
            case 195: {
                if (verifyInfo2.pop().isOfType("Ljava/lang/Object;")) break;
                throw new VerifyException(instruction.getDescription());
            }
            case 197: {
                int n16 = instruction.getDimensions();
                int n17 = n16 - 1;
                while (n17 >= 0) {
                    if (!verifyInfo2.pop().isOfType("I")) {
                        throw new VerifyException(instruction.getDescription());
                    }
                    --n17;
                }
                String string = instruction.getClazzType();
                verifyInfo2.push(Type.tType(string));
                break;
            }
            default: {
                throw new AssertError("Invalid opcode " + n2);
            }
        }
        return verifyInfo2;
    }

    public void doVerify() throws VerifyException {
        VerifyInfo verifyInfo;
        Instruction instruction;
        Iterator iterator;
        HashSet<Instruction> hashSet = new HashSet<Instruction>();
        Instruction instruction2 = (Instruction)this.bi.getInstructions().get(0);
        instruction2.setTmpInfo(this.initInfo());
        hashSet.add(instruction2);
        Handler[] handlerArray = this.bi.getExceptionHandlers();
        while (!hashSet.isEmpty()) {
            VerifyInfo verifyInfo2;
            Instruction[] instructionArray;
            VerifyInfo verifyInfo3;
            Object object;
            int n;
            Object object2;
            iterator = hashSet.iterator();
            instruction = (Instruction)iterator.next();
            iterator.remove();
            if (!instruction.doesAlwaysJump() && instruction.getNextByAddr() == null) {
                throw new VerifyException("Flow can fall off end of method");
            }
            verifyInfo = (VerifyInfo)instruction.getTmpInfo();
            int n2 = instruction.getOpcode();
            if (n2 == 169) {
                BitSet[] bitSetArray;
                object2 = verifyInfo.locals[instruction.getLocalSlot()];
                if (verifyInfo.jsrTargets == null || !((Type)object2).isOfType("R")) {
                    throw new VerifyException(instruction.getDescription());
                }
                n = verifyInfo.jsrTargets.length - 1;
                object = ((Type)object2).getInstruction();
                while (object != verifyInfo.jsrTargets[n]) {
                    if (--n >= 0) continue;
                    throw new VerifyException(instruction.getDescription());
                }
                verifyInfo3 = (VerifyInfo)((Instruction)object).getTmpInfo();
                if (verifyInfo3.retInstr == null) {
                    verifyInfo3.retInstr = instruction;
                } else if (verifyInfo3.retInstr != instruction) {
                    throw new VerifyException("JsrTarget has more than one ret: " + ((Instruction)object).getDescription());
                }
                if (n > 0) {
                    instructionArray = new Instruction[n];
                    bitSetArray = new BitSet[n];
                    System.arraycopy(verifyInfo.jsrTargets, 0, instructionArray, 0, n);
                    System.arraycopy(verifyInfo.jsrLocals, 0, bitSetArray, 0, n);
                } else {
                    instructionArray = null;
                    bitSetArray = null;
                }
                int n3 = 0;
                while (n3 < ((Instruction)object).getPreds().length) {
                    Instruction instruction3 = ((Instruction)object).getPreds()[n3];
                    if (instruction3.getTmpInfo() != null) {
                        hashSet.add(instruction3);
                    }
                    ++n3;
                }
                continue;
            }
            object2 = this.modelEffect(instruction, verifyInfo);
            if (!instruction.doesAlwaysJump() && this.mergeInfo(instruction.getNextByAddr(), (VerifyInfo)object2)) {
                hashSet.add(instruction.getNextByAddr());
            }
            if (n2 == 168 && (verifyInfo2 = (VerifyInfo)instruction.getSingleSucc().getTmpInfo()) != null && verifyInfo2.retInstr != null) {
                object = (VerifyInfo)verifyInfo.clone();
                verifyInfo3 = (VerifyInfo)verifyInfo2.retInstr.getTmpInfo();
                instructionArray = verifyInfo3.jsrLocals[verifyInfo3.jsrLocals.length - 1];
                int n4 = 0;
                while (n4 < this.bi.getMaxLocals()) {
                    if (instructionArray.get(n4)) {
                        ((VerifyInfo)object).locals[n4] = verifyInfo3.locals[n4];
                    }
                    ++n4;
                }
                if (this.mergeInfo(instruction.getNextByAddr(), (VerifyInfo)object)) {
                    hashSet.add(instruction.getNextByAddr());
                }
            }
            if (instruction.getSuccs() != null) {
                int n5 = 0;
                while (n5 < instruction.getSuccs().length) {
                    if (this.mergeInfo(instruction.getSuccs()[n5], (VerifyInfo)((VerifyInfo)object2).clone())) {
                        hashSet.add(instruction.getSuccs()[n5]);
                    }
                    ++n5;
                }
            }
            n = 0;
            while (n < handlerArray.length) {
                if (handlerArray[n].start.compareTo(instruction) <= 0 && handlerArray[n].end.compareTo(instruction) >= 0) {
                    object = (VerifyInfo)verifyInfo.clone();
                    ((VerifyInfo)object).stackHeight = 1;
                    ((VerifyInfo)object).stack[0] = handlerArray[n].type != null ? Type.tType("L" + handlerArray[n].type.replace('.', '/') + ";") : Type.tType("Ljava/lang/Throwable;");
                    if (this.mergeInfo(handlerArray[n].catcher, (VerifyInfo)object)) {
                        hashSet.add(handlerArray[n].catcher);
                    }
                }
                ++n;
            }
        }
        if ((GlobalOptions.debuggingFlags & 2) != 0) {
            iterator = this.bi.getInstructions().iterator();
            while (iterator.hasNext()) {
                instruction = (Instruction)iterator.next();
                verifyInfo = (VerifyInfo)instruction.getTmpInfo();
                if (verifyInfo != null) {
                    GlobalOptions.err.println(verifyInfo.toString());
                }
                GlobalOptions.err.println(instruction.getDescription());
            }
        }
        iterator = this.bi.getInstructions().iterator();
        while (iterator.hasNext()) {
            instruction = (Instruction)iterator.next();
            instruction.setTmpInfo(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void verify() throws VerifyException {
        block4: {
            try {
                this.doVerify();
                break block4;
            }
            catch (VerifyException var1_1) {
                var2_2 = this.bi.getInstructions().iterator();
                ** while (var2_2.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                var3_3 = (Instruction)var2_2.next();
                var4_4 = (VerifyInfo)var3_3.getTmpInfo();
                if (var4_4 != null) {
                    GlobalOptions.err.println(var4_4.toString());
                }
                GlobalOptions.err.println(var3_3.getDescription());
                var3_3.setTmpInfo(null);
                continue;
            }
lbl14:
            // 1 sources

            throw var1_1;
        }
    }

    public CodeVerifier(ClassInfo classInfo, MethodInfo methodInfo, BytecodeInfo bytecodeInfo) {
        this.ci = classInfo;
        this.mi = methodInfo;
        this.bi = bytecodeInfo;
        this.methodType = methodInfo.getType();
        this.returnType = TypeSignature.getReturnType(this.methodType);
    }

    private static class Type {
        private String typeSig;
        private Instruction instr;

        public static Type tType(String string) {
            return new Type(string);
        }

        public static Type tType(String string, Instruction instruction) {
            return new Type(string, instruction);
        }

        public String getTypeSig() {
            return this.typeSig;
        }

        public Instruction getInstruction() {
            return this.instr;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean isOfType(String string) {
            String string2 = this.typeSig;
            if ((GlobalOptions.debuggingFlags & 2) != 0) {
                GlobalOptions.err.println("isOfType(" + string2 + "," + string + ")");
            }
            if (string2.equals(string)) {
                return true;
            }
            char c = string2.charAt(0);
            char c2 = string.charAt(0);
            switch (c2) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    if ("ZBCSI".indexOf(c) >= 0) return true;
                    return false;
                }
                case '+': {
                    if ("L[nNR0".indexOf(c) >= 0) return true;
                    return false;
                }
                case '[': {
                    if (c == '0') {
                        return true;
                    }
                    while (true) {
                        if (c != '[' || c2 != '[') {
                            if (c2 != '*') break;
                            return true;
                        }
                        string2 = string2.substring(1);
                        string = string.substring(1);
                        c = string2.charAt(0);
                        c2 = string.charAt(0);
                    }
                    if (c2 != 'L') {
                        return false;
                    }
                }
                case 'L': {
                    if (c == '0') {
                        return true;
                    }
                    if ("L[".indexOf(c) < 0) {
                        return false;
                    }
                    ClassInfo classInfo = TypeSignature.getClassInfo(string);
                    if (classInfo.isInterface()) return true;
                    if (classInfo == ClassInfo.javaLangObject) {
                        return true;
                    }
                    if (c != 'L') return false;
                    return classInfo.superClassOf(TypeSignature.getClassInfo(string2));
                }
            }
            return false;
        }

        public Type mergeType(Type type) {
            String string = this.typeSig;
            String string2 = type.typeSig;
            if (this.equals(type)) {
                return this;
            }
            char c = string.charAt(0);
            char c2 = string2.charAt(0);
            if (c == '*') {
                return type;
            }
            if (c2 == '*') {
                return this;
            }
            if ("ZBCSI".indexOf(c) >= 0 && "ZBCSI".indexOf(c2) >= 0) {
                return this;
            }
            if (c == '0') {
                return "L[0".indexOf(c2) >= 0 ? type : tNone;
            }
            if (c2 == '0') {
                return "L[".indexOf(c) >= 0 ? this : tNone;
            }
            int n = 0;
            while (c == '[' && c2 == '[') {
                string = string.substring(1);
                string2 = string2.substring(1);
                c = string.charAt(0);
                c2 = string2.charAt(0);
                ++n;
            }
            if (c == '[' && c2 == 'L' || c == 'L' && c2 == '[') {
                if (n == 0) {
                    return tObject;
                }
                StringBuffer stringBuffer = new StringBuffer(n + 18);
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.append("[");
                    ++n2;
                }
                stringBuffer.append("Ljava/lang/Object;");
                return Type.tType(stringBuffer.toString());
            }
            if (c == 'L' && c2 == 'L') {
                ClassInfo classInfo;
                ClassInfo classInfo2 = TypeSignature.getClassInfo(string);
                if (classInfo2.superClassOf(classInfo = TypeSignature.getClassInfo(string2))) {
                    return this;
                }
                if (classInfo.superClassOf(classInfo2)) {
                    return type;
                }
                while (!(classInfo2 = classInfo2.getSuperclass()).superClassOf(classInfo)) {
                }
                StringBuffer stringBuffer = new StringBuffer(n + classInfo2.getName().length() + 2);
                int n3 = 0;
                while (n3 < n) {
                    stringBuffer.append("[");
                    ++n3;
                }
                stringBuffer.append("L").append(classInfo2.getName().replace('.', '/')).append(";");
                return Type.tType(stringBuffer.toString());
            }
            if (n > 0) {
                if (n == 1) {
                    return tObject;
                }
                StringBuffer stringBuffer = new StringBuffer(n + 17);
                int n4 = 0;
                while (n4 < n - 1) {
                    stringBuffer.append("[");
                    ++n4;
                }
                stringBuffer.append("Ljava/lang/Object;");
                return Type.tType(stringBuffer.toString());
            }
            return tNone;
        }

        public boolean equals(Object object) {
            if (object instanceof Type) {
                Type type = (Type)object;
                return this.typeSig.equals(type.typeSig) && this.instr == type.instr;
            }
            return false;
        }

        public String toString() {
            if (this.instr != null) {
                return this.typeSig + "@" + this.instr.getAddr();
            }
            return this.typeSig;
        }

        public Type(String string) {
            this.typeSig = string;
        }

        public Type(String string, Instruction instruction) {
            this.typeSig = string;
            this.instr = instruction;
        }
    }

    class VerifyInfo
    implements Cloneable {
        Type[] stack;
        Type[] locals;
        Instruction[] jsrTargets;
        BitSet[] jsrLocals;
        int stackHeight;
        int maxHeight;
        Instruction retInstr;

        public Object clone() {
            try {
                VerifyInfo verifyInfo = (VerifyInfo)super.clone();
                verifyInfo.stack = (Type[])this.stack.clone();
                verifyInfo.locals = (Type[])this.locals.clone();
                return verifyInfo;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertError("Clone not supported?");
            }
        }

        public final void reserve(int n) throws VerifyException {
            if (this.stackHeight + n > this.maxHeight) {
                this.maxHeight = this.stackHeight + n;
                if (this.maxHeight > this.stack.length) {
                    throw new VerifyException("stack overflow");
                }
            }
        }

        public final void need(int n) throws VerifyException {
            if (this.stackHeight < n) {
                throw new VerifyException("stack underflow");
            }
        }

        public final void push(Type type) throws VerifyException {
            this.reserve(1);
            this.stack[this.stackHeight++] = type;
        }

        public final Type pop() throws VerifyException {
            this.need(1);
            return this.stack[--this.stackHeight];
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("locals:[");
            String string = "";
            int n = 0;
            while (n < this.locals.length) {
                stringBuffer.append(string).append(n).append(':');
                stringBuffer.append(this.locals[n]);
                string = ",";
                ++n;
            }
            stringBuffer.append("], stack:[");
            string = "";
            n = 0;
            while (n < this.stackHeight) {
                stringBuffer.append(string).append(this.stack[n]);
                string = ",";
                ++n;
            }
            if (this.jsrTargets != null) {
                stringBuffer.append("], jsrs:[");
                string = "";
                n = 0;
                while (n < this.jsrTargets.length) {
                    stringBuffer.append(string).append(this.jsrTargets[n]).append(this.jsrLocals[n]);
                    string = ",";
                    ++n;
                }
            }
            return stringBuffer.append("]").toString();
        }

        VerifyInfo() {
            this.stack = new Type[CodeVerifier.this.bi.getMaxStack()];
            this.locals = new Type[CodeVerifier.this.bi.getMaxLocals()];
            this.jsrTargets = null;
            this.jsrLocals = null;
            this.stackHeight = 0;
            this.maxHeight = 0;
            this.retInstr = null;
        }
    }
}

