/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PShapeSVG;
import processing.core.PStyle;
import processing.xml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PApplet
extends Applet
implements PConstants,
Runnable,
MouseListener,
MouseMotionListener,
KeyListener,
FocusListener {
    public static final String javaVersionName = System.getProperty("java.version");
    public static final float javaVersion = new Float(javaVersionName.substring(0, 3)).floatValue();
    public static int platform;
    public static boolean useQuartz;
    public static final int MENU_SHORTCUT;
    public PGraphics g;
    public Frame frame;
    public int screenWidth;
    public int screenHeight;
    public Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    public PGraphics recorder;
    public String[] args;
    public String sketchPath;
    static final boolean THREAD_DEBUG = false;
    public static final int DEFAULT_WIDTH = 100;
    public static final int DEFAULT_HEIGHT = 100;
    public static final int MIN_WINDOW_WIDTH = 128;
    public static final int MIN_WINDOW_HEIGHT = 128;
    public boolean defaultSize;
    volatile boolean resizeRequest;
    volatile int resizeWidth;
    volatile int resizeHeight;
    public int[] pixels;
    public int width;
    public int height;
    public int mouseX;
    public int mouseY;
    public int pmouseX;
    public int pmouseY;
    protected int dmouseX;
    protected int dmouseY;
    protected int emouseX;
    protected int emouseY;
    public boolean firstMouse;
    public int mouseButton;
    public boolean mousePressed;
    public MouseEvent mouseEvent;
    public char key;
    public int keyCode;
    public boolean keyPressed;
    public KeyEvent keyEvent;
    public boolean focused = false;
    public boolean online = false;
    long millisOffset;
    public float frameRate = 10.0f;
    protected long frameRateLastNanos = 0L;
    protected float frameRateTarget = 60.0f;
    protected long frameRatePeriod = 16666666L;
    protected boolean looping;
    protected boolean redraw;
    public int frameCount;
    public boolean finished;
    protected boolean exitCalled;
    Thread thread;
    protected RegisteredMethods sizeMethods;
    protected RegisteredMethods preMethods;
    protected RegisteredMethods drawMethods;
    protected RegisteredMethods postMethods;
    protected RegisteredMethods mouseEventMethods;
    protected RegisteredMethods keyEventMethods;
    protected RegisteredMethods disposeMethods;
    public static final String ARGS_EDITOR_LOCATION = "--editor-location";
    public static final String ARGS_EXTERNAL = "--external";
    public static final String ARGS_LOCATION = "--location";
    public static final String ARGS_DISPLAY = "--display";
    public static final String ARGS_BGCOLOR = "--bgcolor";
    public static final String ARGS_PRESENT = "--present";
    public static final String ARGS_EXCLUSIVE = "--exclusive";
    public static final String ARGS_STOP_COLOR = "--stop-color";
    public static final String ARGS_HIDE_STOP = "--hide-stop";
    public static final String ARGS_SKETCH_FOLDER = "--sketch-path";
    public static final String EXTERNAL_STOP = "__STOP__";
    public static final String EXTERNAL_MOVE = "__MOVE__";
    boolean external = false;
    static final String ERROR_MIN_MAX = "Cannot use min() or max() on an empty array.";
    MouseEvent[] mouseEventQueue = new MouseEvent[10];
    int mouseEventCount;
    KeyEvent[] keyEventQueue = new KeyEvent[10];
    int keyEventCount;
    static String openLauncher;
    int cursorType = 0;
    boolean cursorVisible = true;
    PImage invisibleCursor;
    Random internalRandom;
    static final int PERLIN_YWRAPB = 4;
    static final int PERLIN_YWRAP = 16;
    static final int PERLIN_ZWRAPB = 8;
    static final int PERLIN_ZWRAP = 256;
    static final int PERLIN_SIZE = 4095;
    int perlin_octaves = 4;
    float perlin_amp_falloff = 0.5f;
    int perlin_TWOPI;
    int perlin_PI;
    float[] perlin_cosTable;
    float[] perlin;
    Random perlinRandom;
    protected String[] loadImageFormats;
    public int requestImageMax = 4;
    volatile int requestImageCount;
    public File selectedFile;
    protected Frame parentFrame;
    protected static HashMap<String, Pattern> matchPatterns;
    private static NumberFormat int_nf;
    private static int int_nf_digits;
    private static boolean int_nf_commas;
    private static NumberFormat float_nf;
    private static int float_nf_left;
    private static int float_nf_right;
    private static boolean float_nf_commas;
    public static final byte[] ICON_IMAGE;

    static {
        String osname = System.getProperty("os.name");
        platform = osname.indexOf("Mac") != -1 ? 2 : (osname.indexOf("Windows") != -1 ? 1 : (osname.equals("Linux") ? 3 : 0));
        useQuartz = true;
        MENU_SHORTCUT = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        byte[] byArray = new byte[205];
        byArray[0] = 71;
        byArray[1] = 73;
        byArray[2] = 70;
        byArray[3] = 56;
        byArray[4] = 57;
        byArray[5] = 97;
        byArray[6] = 16;
        byArray[8] = 16;
        byArray[10] = -77;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = 12;
        byArray[20] = 12;
        byArray[21] = 13;
        byArray[22] = -15;
        byArray[23] = -15;
        byArray[24] = -14;
        byArray[25] = 45;
        byArray[26] = 57;
        byArray[27] = 74;
        byArray[28] = 54;
        byArray[29] = 80;
        byArray[30] = 111;
        byArray[31] = 47;
        byArray[32] = 71;
        byArray[33] = 97;
        byArray[34] = 62;
        byArray[35] = 88;
        byArray[36] = 117;
        byArray[37] = 1;
        byArray[38] = 14;
        byArray[39] = 27;
        byArray[40] = 7;
        byArray[41] = 41;
        byArray[42] = 73;
        byArray[43] = 15;
        byArray[44] = 52;
        byArray[45] = 85;
        byArray[46] = 2;
        byArray[47] = 31;
        byArray[48] = 55;
        byArray[49] = 4;
        byArray[50] = 54;
        byArray[51] = 94;
        byArray[52] = 18;
        byArray[53] = 69;
        byArray[54] = 109;
        byArray[55] = 37;
        byArray[56] = 87;
        byArray[57] = 126;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = 33;
        byArray[62] = -7;
        byArray[63] = 4;
        byArray[64] = 1;
        byArray[67] = 15;
        byArray[69] = 44;
        byArray[74] = 16;
        byArray[76] = 16;
        byArray[79] = 4;
        byArray[80] = 122;
        byArray[81] = -16;
        byArray[82] = -107;
        byArray[83] = 114;
        byArray[84] = -86;
        byArray[85] = -67;
        byArray[86] = 83;
        byArray[87] = 30;
        byArray[88] = -42;
        byArray[89] = 26;
        byArray[90] = -17;
        byArray[91] = -100;
        byArray[92] = -45;
        byArray[93] = 56;
        byArray[94] = -57;
        byArray[95] = -108;
        byArray[96] = 48;
        byArray[97] = 40;
        byArray[98] = 122;
        byArray[99] = -90;
        byArray[100] = 104;
        byArray[101] = 67;
        byArray[102] = -91;
        byArray[103] = -51;
        byArray[104] = 32;
        byArray[105] = -53;
        byArray[106] = 77;
        byArray[107] = -78;
        byArray[108] = -100;
        byArray[109] = 47;
        byArray[110] = -86;
        byArray[111] = 12;
        byArray[112] = 76;
        byArray[113] = -110;
        byArray[114] = -20;
        byArray[115] = -74;
        byArray[116] = -101;
        byArray[117] = 97;
        byArray[118] = -93;
        byArray[119] = 27;
        byArray[120] = 40;
        byArray[121] = 20;
        byArray[122] = -65;
        byArray[123] = 65;
        byArray[124] = 48;
        byArray[125] = -111;
        byArray[126] = 99;
        byArray[127] = -20;
        byArray[128] = -112;
        byArray[129] = -117;
        byArray[130] = -123;
        byArray[131] = -47;
        byArray[132] = -105;
        byArray[133] = 24;
        byArray[134] = 114;
        byArray[135] = -112;
        byArray[136] = 74;
        byArray[137] = 69;
        byArray[138] = 84;
        byArray[139] = 25;
        byArray[140] = 93;
        byArray[141] = 88;
        byArray[142] = -75;
        byArray[143] = 9;
        byArray[144] = 46;
        byArray[145] = 2;
        byArray[146] = 49;
        byArray[147] = 88;
        byArray[148] = -116;
        byArray[149] = -67;
        byArray[150] = 7;
        byArray[151] = -19;
        byArray[152] = -83;
        byArray[153] = 60;
        byArray[154] = 38;
        byArray[155] = 3;
        byArray[156] = -34;
        byArray[157] = 2;
        byArray[158] = 66;
        byArray[159] = -95;
        byArray[160] = 27;
        byArray[161] = -98;
        byArray[162] = 13;
        byArray[163] = 4;
        byArray[164] = -17;
        byArray[165] = 55;
        byArray[166] = 33;
        byArray[167] = 109;
        byArray[168] = 11;
        byArray[169] = 11;
        byArray[170] = -2;
        byArray[171] = -128;
        byArray[172] = 121;
        byArray[173] = 123;
        byArray[174] = 62;
        byArray[175] = 91;
        byArray[176] = 120;
        byArray[177] = -128;
        byArray[178] = 127;
        byArray[179] = 122;
        byArray[180] = 115;
        byArray[181] = 102;
        byArray[182] = 2;
        byArray[183] = 119;
        byArray[185] = -116;
        byArray[186] = -113;
        byArray[187] = -119;
        byArray[188] = 6;
        byArray[189] = 102;
        byArray[190] = 121;
        byArray[191] = -108;
        byArray[192] = -126;
        byArray[193] = 5;
        byArray[194] = 18;
        byArray[195] = 6;
        byArray[196] = 4;
        byArray[197] = -102;
        byArray[198] = -101;
        byArray[199] = -100;
        byArray[200] = 114;
        byArray[201] = 15;
        byArray[202] = 17;
        byArray[204] = 59;
        ICON_IMAGE = byArray;
    }

    @Override
    public void init() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.screenWidth = screen.width;
        this.screenHeight = screen.height;
        this.setFocusTraversalKeysEnabled(false);
        this.millisOffset = System.currentTimeMillis();
        this.finished = false;
        this.looping = true;
        this.redraw = true;
        this.firstMouse = true;
        this.sizeMethods = new RegisteredMethods();
        this.preMethods = new RegisteredMethods();
        this.drawMethods = new RegisteredMethods();
        this.postMethods = new RegisteredMethods();
        this.mouseEventMethods = new RegisteredMethods();
        this.keyEventMethods = new RegisteredMethods();
        this.disposeMethods = new RegisteredMethods();
        try {
            this.getAppletContext();
            this.online = true;
        }
        catch (NullPointerException e) {
            this.online = false;
        }
        try {
            if (this.sketchPath == null) {
                this.sketchPath = System.getProperty("user.dir");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Dimension size = this.getSize();
        if (size.width != 0 && size.height != 0) {
            this.g = this.makeGraphics(size.width, size.height, this.getSketchRenderer(), null, true);
        } else {
            this.defaultSize = true;
            int w = this.getSketchWidth();
            int h = this.getSketchHeight();
            this.g = this.makeGraphics(w, h, this.getSketchRenderer(), null, true);
            this.setSize(w, h);
            this.setPreferredSize(new Dimension(w, h));
        }
        this.width = this.g.width;
        this.height = this.g.height;
        this.addListeners();
        this.start();
    }

    public int getSketchWidth() {
        return 100;
    }

    public int getSketchHeight() {
        return 100;
    }

    public String getSketchRenderer() {
        return "processing.core.PGraphicsJava2D";
    }

    @Override
    public void start() {
        this.finished = false;
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread((Runnable)this, "Animation Thread");
        this.thread.start();
    }

    @Override
    public void stop() {
        this.finished = true;
        if (this.thread == null) {
            return;
        }
        this.thread = null;
        if (this.g != null) {
            this.g.dispose();
        }
        this.disposeMethods.handle();
    }

    @Override
    public void destroy() {
        this.stop();
    }

    public void registerSize(Object o) {
        Class[] methodArgs = new Class[]{Integer.TYPE, Integer.TYPE};
        this.registerWithArgs(this.sizeMethods, "size", o, methodArgs);
    }

    public void registerPre(Object o) {
        this.registerNoArgs(this.preMethods, "pre", o);
    }

    public void registerDraw(Object o) {
        this.registerNoArgs(this.drawMethods, "draw", o);
    }

    public void registerPost(Object o) {
        this.registerNoArgs(this.postMethods, "post", o);
    }

    public void registerMouseEvent(Object o) {
        Class[] methodArgs = new Class[]{MouseEvent.class};
        this.registerWithArgs(this.mouseEventMethods, "mouseEvent", o, methodArgs);
    }

    public void registerKeyEvent(Object o) {
        Class[] methodArgs = new Class[]{KeyEvent.class};
        this.registerWithArgs(this.keyEventMethods, "keyEvent", o, methodArgs);
    }

    public void registerDispose(Object o) {
        this.registerNoArgs(this.disposeMethods, "dispose", o);
    }

    protected void registerNoArgs(RegisteredMethods meth, String name, Object o) {
        Class<?> c = o.getClass();
        try {
            Method method = c.getMethod(name, new Class[0]);
            meth.add(o, method);
        }
        catch (NoSuchMethodException nsme) {
            this.die("There is no public " + name + "() method in the class " + o.getClass().getName());
        }
        catch (Exception e) {
            this.die("Could not register " + name + " + () for " + o, e);
        }
    }

    protected void registerWithArgs(RegisteredMethods meth, String name, Object o, Class<?>[] cargs) {
        Class<?> c = o.getClass();
        try {
            Method method = c.getMethod(name, cargs);
            meth.add(o, method);
        }
        catch (NoSuchMethodException nsme) {
            this.die("There is no public " + name + "() method in the class " + o.getClass().getName());
        }
        catch (Exception e) {
            this.die("Could not register " + name + " + () for " + o, e);
        }
    }

    public void unregisterSize(Object o) {
        Class[] methodArgs = new Class[]{Integer.TYPE, Integer.TYPE};
        this.unregisterWithArgs(this.sizeMethods, "size", o, methodArgs);
    }

    public void unregisterPre(Object o) {
        this.unregisterNoArgs(this.preMethods, "pre", o);
    }

    public void unregisterDraw(Object o) {
        this.unregisterNoArgs(this.drawMethods, "draw", o);
    }

    public void unregisterPost(Object o) {
        this.unregisterNoArgs(this.postMethods, "post", o);
    }

    public void unregisterMouseEvent(Object o) {
        Class[] methodArgs = new Class[]{MouseEvent.class};
        this.unregisterWithArgs(this.mouseEventMethods, "mouseEvent", o, methodArgs);
    }

    public void unregisterKeyEvent(Object o) {
        Class[] methodArgs = new Class[]{KeyEvent.class};
        this.unregisterWithArgs(this.keyEventMethods, "keyEvent", o, methodArgs);
    }

    public void unregisterDispose(Object o) {
        this.unregisterNoArgs(this.disposeMethods, "dispose", o);
    }

    protected void unregisterNoArgs(RegisteredMethods meth, String name, Object o) {
        Class<?> c = o.getClass();
        try {
            Method method = c.getMethod(name, new Class[0]);
            meth.remove(o, method);
        }
        catch (Exception e) {
            this.die("Could not unregister " + name + "() for " + o, e);
        }
    }

    protected void unregisterWithArgs(RegisteredMethods meth, String name, Object o, Class<?>[] cargs) {
        Class<?> c = o.getClass();
        try {
            Method method = c.getMethod(name, cargs);
            meth.remove(o, method);
        }
        catch (Exception e) {
            this.die("Could not unregister " + name + "() for " + o, e);
        }
    }

    public void setup() {
    }

    public void draw() {
        this.finished = true;
    }

    protected void resizeRenderer(int iwidth, int iheight) {
        if (this.width != iwidth || this.height != iheight) {
            this.g.setSize(iwidth, iheight);
            this.width = iwidth;
            this.height = iheight;
        }
    }

    public void size(int iwidth, int iheight) {
        this.size(iwidth, iheight, "processing.core.PGraphicsJava2D", null);
    }

    public void size(int iwidth, int iheight, String irenderer) {
        this.size(iwidth, iheight, irenderer, null);
    }

    public void size(final int iwidth, final int iheight, String irenderer, String ipath) {
        String currentRenderer;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PApplet.this.setPreferredSize(new Dimension(iwidth, iheight));
                PApplet.this.setSize(iwidth, iheight);
            }
        });
        if (ipath != null) {
            ipath = this.savePath(ipath);
        }
        if (!(currentRenderer = this.g.getClass().getName()).equals(irenderer)) {
            this.g = this.makeGraphics(iwidth, iheight, irenderer, ipath, true);
            this.width = iwidth;
            this.height = iheight;
            this.defaultSize = false;
            throw new RendererChangeException();
        }
        this.resizeRenderer(iwidth, iheight);
    }

    public PGraphics createGraphics(int iwidth, int iheight, String irenderer) {
        PGraphics pg = this.makeGraphics(iwidth, iheight, irenderer, null, false);
        return pg;
    }

    public PGraphics createGraphics(int iwidth, int iheight, String irenderer, String ipath) {
        if (ipath != null) {
            ipath = this.savePath(ipath);
        }
        PGraphics pg = this.makeGraphics(iwidth, iheight, irenderer, ipath, false);
        pg.parent = this;
        return pg;
    }

    protected PGraphics makeGraphics(int iwidth, int iheight, String irenderer, String ipath, boolean iprimary) {
        String s;
        if (irenderer.equals("processing.opengl.PGraphicsOpenGL") && platform == 1 && (s = System.getProperty("java.version")) != null && s.equals("1.5.0_10")) {
            System.err.println("OpenGL support is broken with Java 1.5.0_10");
            System.err.println("See http://dev.processing.org/bugs/show_bug.cgi?id=513 for more info.");
            throw new RuntimeException("Please update your Java installation (see bug #513)");
        }
        String openglError = "Before using OpenGL, first select Import Library > opengl from the Sketch menu.";
        try {
            Class<?> rendererClass = Thread.currentThread().getContextClassLoader().loadClass(irenderer);
            Constructor<?> constructor = rendererClass.getConstructor(new Class[0]);
            PGraphics pg = (PGraphics)constructor.newInstance(new Object[0]);
            pg.setParent(this);
            pg.setPrimary(iprimary);
            if (ipath != null) {
                pg.setPath(ipath);
            }
            pg.setSize(iwidth, iheight);
            return pg;
        }
        catch (InvocationTargetException ite) {
            String msg = ite.getTargetException().getMessage();
            if (msg != null && msg.indexOf("no jogl in java.library.path") != -1) {
                throw new RuntimeException(String.valueOf(openglError) + " (The native library is missing.)");
            }
            ite.getTargetException().printStackTrace();
            Throwable target = ite.getTargetException();
            if (platform == 2) {
                target.printStackTrace(System.out);
            }
            throw new RuntimeException(target.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            if (cnfe.getMessage().indexOf("processing.opengl.PGraphicsGL") != -1) {
                throw new RuntimeException(String.valueOf(openglError) + " (The library .jar file is missing.)");
            }
            throw new RuntimeException("You need to use \"Import Library\" to add " + irenderer + " to your sketch.");
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException || e instanceof NoSuchMethodException || e instanceof IllegalAccessException) {
                e.printStackTrace();
                String msg = String.valueOf(irenderer) + " needs to be updated " + "for the current release of Processing.";
                throw new RuntimeException(msg);
            }
            if (platform == 2) {
                e.printStackTrace(System.out);
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    public PImage createImage(int wide, int high, int format) {
        PImage image = new PImage(wide, high, format);
        image.parent = this;
        return image;
    }

    @Override
    public void update(Graphics screen) {
        this.paint(screen);
    }

    @Override
    public void paint(Graphics screen) {
        if (this.frameCount == 0) {
            return;
        }
        if (this.g != null && this.g.image != null) {
            screen.drawImage(this.g.image, 0, 0, null);
        }
    }

    protected void paint() {
        try {
            Graphics screen = this.getGraphics();
            if (screen != null) {
                if (this.g != null && this.g.image != null) {
                    screen.drawImage(this.g.image, 0, 0, null);
                }
                Toolkit.getDefaultToolkit().sync();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        long beforeTime = System.nanoTime();
        long overSleepTime = 0L;
        int noDelays = 0;
        int NO_DELAYS_PER_YIELD = 15;
        while (Thread.currentThread() == this.thread && !this.finished) {
            long afterTime;
            long timeDiff;
            long sleepTime;
            if (this.resizeRequest) {
                this.resizeRenderer(this.resizeWidth, this.resizeHeight);
                this.resizeRequest = false;
            }
            this.handleDraw();
            if (this.frameCount == 1) {
                this.requestFocusInWindow();
            }
            if ((sleepTime = this.frameRatePeriod - (timeDiff = (afterTime = System.nanoTime()) - beforeTime) - overSleepTime) > 0L) {
                try {
                    Thread.sleep(sleepTime / 1000000L, (int)(sleepTime % 1000000L));
                    noDelays = 0;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                overSleepTime = System.nanoTime() - afterTime - sleepTime;
            } else {
                overSleepTime = 0L;
                if (noDelays > 15) {
                    Thread.yield();
                    noDelays = 0;
                }
            }
            beforeTime = System.nanoTime();
        }
        this.stop();
        if (this.exitCalled) {
            this.exit2();
        }
    }

    public void handleDraw() {
        if (this.g != null && (this.looping || this.redraw)) {
            if (!this.g.canDraw()) {
                return;
            }
            this.g.beginDraw();
            if (this.recorder != null) {
                this.recorder.beginDraw();
            }
            long now = System.nanoTime();
            if (this.frameCount == 0) {
                try {
                    this.setup();
                }
                catch (RendererChangeException e) {
                    return;
                }
                this.defaultSize = false;
            } else {
                double rate = 1000000.0 / ((double)(now - this.frameRateLastNanos) / 1000000.0);
                float instantaneousRate = (float)rate / 1000.0f;
                this.frameRate = this.frameRate * 0.9f + instantaneousRate * 0.1f;
                this.preMethods.handle();
                this.pmouseX = this.dmouseX;
                this.pmouseY = this.dmouseY;
                this.draw();
                this.dmouseX = this.mouseX;
                this.dmouseY = this.mouseY;
                this.dequeueMouseEvents();
                this.dequeueKeyEvents();
                this.drawMethods.handle();
                this.redraw = false;
            }
            this.g.endDraw();
            if (this.recorder != null) {
                this.recorder.endDraw();
            }
            this.frameRateLastNanos = now;
            ++this.frameCount;
            this.paint();
            this.postMethods.handle();
        }
    }

    public synchronized void redraw() {
        if (!this.looping) {
            this.redraw = true;
        }
    }

    public synchronized void loop() {
        if (!this.looping) {
            this.looping = true;
        }
    }

    public synchronized void noLoop() {
        if (this.looping) {
            this.looping = false;
        }
    }

    public void addListeners() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                Rectangle bounds = c.getBounds();
                PApplet.this.resizeRequest = true;
                PApplet.this.resizeWidth = bounds.width;
                PApplet.this.resizeHeight = bounds.height;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueMouseEvent(MouseEvent e) {
        MouseEvent[] mouseEventArray = this.mouseEventQueue;
        synchronized (this.mouseEventQueue) {
            if (this.mouseEventCount == this.mouseEventQueue.length) {
                MouseEvent[] temp = new MouseEvent[this.mouseEventCount << 1];
                System.arraycopy(this.mouseEventQueue, 0, temp, 0, this.mouseEventCount);
                this.mouseEventQueue = temp;
            }
            this.mouseEventQueue[this.mouseEventCount++] = e;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dequeueMouseEvents() {
        MouseEvent[] mouseEventArray = this.mouseEventQueue;
        synchronized (this.mouseEventQueue) {
            int i = 0;
            while (i < this.mouseEventCount) {
                this.mouseEvent = this.mouseEventQueue[i];
                this.handleMouseEvent(this.mouseEvent);
                ++i;
            }
            this.mouseEventCount = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void handleMouseEvent(MouseEvent event) {
        int id = event.getID();
        if (id == 506 || id == 503) {
            this.pmouseX = this.emouseX;
            this.pmouseY = this.emouseY;
            this.mouseX = event.getX();
            this.mouseY = event.getY();
        }
        this.mouseEvent = event;
        int modifiers = event.getModifiers();
        if ((modifiers & 0x10) != 0) {
            this.mouseButton = 37;
        } else if ((modifiers & 8) != 0) {
            this.mouseButton = 3;
        } else if ((modifiers & 4) != 0) {
            this.mouseButton = 39;
        }
        if (platform == 2 && this.mouseEvent.isPopupTrigger()) {
            this.mouseButton = 39;
        }
        this.mouseEventMethods.handle(new Object[]{event});
        if (this.firstMouse) {
            this.pmouseX = this.mouseX;
            this.pmouseY = this.mouseY;
            this.dmouseX = this.mouseX;
            this.dmouseY = this.mouseY;
            this.firstMouse = false;
        }
        switch (id) {
            case 501: {
                this.mousePressed = true;
                this.mousePressed();
                break;
            }
            case 502: {
                this.mousePressed = false;
                this.mouseReleased();
                break;
            }
            case 500: {
                this.mouseClicked();
                break;
            }
            case 506: {
                this.mouseDragged();
                break;
            }
            case 503: {
                this.mouseMoved();
            }
        }
        if (id == 506 || id == 503) {
            this.emouseX = this.mouseX;
            this.emouseY = this.mouseY;
        }
    }

    protected void checkMouseEvent(MouseEvent event) {
        if (this.looping) {
            this.enqueueMouseEvent(event);
        } else {
            this.handleMouseEvent(event);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkMouseEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkMouseEvent(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.checkMouseEvent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.checkMouseEvent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.checkMouseEvent(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.checkMouseEvent(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.checkMouseEvent(e);
    }

    public void mousePressed() {
    }

    public void mouseReleased() {
    }

    public void mouseClicked() {
    }

    public void mouseDragged() {
    }

    public void mouseMoved() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueKeyEvent(KeyEvent e) {
        KeyEvent[] keyEventArray = this.keyEventQueue;
        synchronized (this.keyEventQueue) {
            if (this.keyEventCount == this.keyEventQueue.length) {
                KeyEvent[] temp = new KeyEvent[this.keyEventCount << 1];
                System.arraycopy(this.keyEventQueue, 0, temp, 0, this.keyEventCount);
                this.keyEventQueue = temp;
            }
            this.keyEventQueue[this.keyEventCount++] = e;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dequeueKeyEvents() {
        KeyEvent[] keyEventArray = this.keyEventQueue;
        synchronized (this.keyEventQueue) {
            int i = 0;
            while (i < this.keyEventCount) {
                this.keyEvent = this.keyEventQueue[i];
                this.handleKeyEvent(this.keyEvent);
                ++i;
            }
            this.keyEventCount = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void handleKeyEvent(KeyEvent event) {
        this.keyEvent = event;
        this.key = event.getKeyChar();
        this.keyCode = event.getKeyCode();
        this.keyEventMethods.handle(new Object[]{event});
        switch (event.getID()) {
            case 401: {
                this.keyPressed = true;
                this.keyPressed();
                break;
            }
            case 402: {
                this.keyPressed = false;
                this.keyReleased();
                break;
            }
            case 400: {
                this.keyTyped();
            }
        }
        if (event.getID() == 401) {
            if (this.key == '\u001b') {
                this.exit();
            }
            if (this.external && event.getModifiers() == MENU_SHORTCUT && event.getKeyCode() == 87) {
                this.exit();
            }
        }
    }

    protected void checkKeyEvent(KeyEvent event) {
        if (this.looping) {
            this.enqueueKeyEvent(event);
        } else {
            this.handleKeyEvent(event);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.checkKeyEvent(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.checkKeyEvent(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.checkKeyEvent(e);
    }

    public void keyPressed() {
    }

    public void keyReleased() {
    }

    public void keyTyped() {
    }

    public void focusGained() {
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.focused = true;
        this.focusGained();
    }

    public void focusLost() {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.focused = false;
        this.focusLost();
    }

    public int millis() {
        return (int)(System.currentTimeMillis() - this.millisOffset);
    }

    public static int second() {
        return Calendar.getInstance().get(13);
    }

    public static int minute() {
        return Calendar.getInstance().get(12);
    }

    public static int hour() {
        return Calendar.getInstance().get(11);
    }

    public static int day() {
        return Calendar.getInstance().get(5);
    }

    public static int month() {
        return Calendar.getInstance().get(2) + 1;
    }

    public static int year() {
        return Calendar.getInstance().get(1);
    }

    public void delay(int napTime) {
        if (this.frameCount != 0 && napTime > 0) {
            try {
                Thread.sleep(napTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void frameRate(float newRateTarget) {
        this.frameRateTarget = newRateTarget;
        this.frameRatePeriod = (long)(1.0E9 / (double)this.frameRateTarget);
    }

    public String param(String what) {
        if (this.online) {
            return this.getParameter(what);
        }
        System.err.println("param() only works inside a web browser");
        return null;
    }

    public void status(String what) {
        if (this.online) {
            this.showStatus(what);
        } else {
            System.out.println(what);
        }
    }

    public void link(String here) {
        this.link(here, null);
    }

    public void link(String url, String frameTitle) {
        if (this.online) {
            try {
                if (frameTitle == null) {
                    this.getAppletContext().showDocument(new URL(url));
                }
                this.getAppletContext().showDocument(new URL(url), frameTitle);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Could not open " + url);
            }
        } else {
            try {
                if (platform == 1) {
                    url = url.replaceAll("&", "^&");
                    Runtime.getRuntime().exec("cmd /c start " + url);
                } else if (platform == 2) {
                    try {
                        Class<?> eieio = Class.forName("com.apple.eio.FileManager");
                        Method openMethod = eieio.getMethod("openURL", String.class);
                        openMethod.invoke(null, url);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    PApplet.open(url);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Could not open " + url);
            }
        }
    }

    public static void open(String filename) {
        PApplet.open(new String[]{filename});
    }

    public static Process open(String[] argv) {
        String[] params = null;
        if (platform == 1) {
            params = new String[]{"cmd", "/c"};
        } else if (platform == 2) {
            params = new String[]{"open"};
        } else if (platform == 3) {
            Process p2;
            if (openLauncher == null) {
                try {
                    p2 = Runtime.getRuntime().exec(new String[]{"gnome-open"});
                    p2.waitFor();
                    openLauncher = "gnome-open";
                }
                catch (Exception p2) {
                    // empty catch block
                }
            }
            if (openLauncher == null) {
                try {
                    p2 = Runtime.getRuntime().exec(new String[]{"kde-open"});
                    p2.waitFor();
                    openLauncher = "kde-open";
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (openLauncher == null) {
                System.err.println("Could not find gnome-open or kde-open, the open() command may not work.");
            }
            if (openLauncher != null) {
                params = new String[]{openLauncher};
            }
        }
        if (params != null) {
            if (params[0].equals(argv[0])) {
                return PApplet.exec(argv);
            }
            params = PApplet.concat(params, argv);
            return PApplet.exec(params);
        }
        return PApplet.exec(argv);
    }

    public static Process exec(String[] argv) {
        try {
            return Runtime.getRuntime().exec(argv);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not open " + PApplet.join(argv, ' '));
        }
    }

    public void die(String what) {
        this.stop();
        throw new RuntimeException(what);
    }

    public void die(String what, Exception e) {
        if (e != null) {
            e.printStackTrace();
        }
        this.die(what);
    }

    public void exit() {
        if (this.thread == null) {
            this.exit2();
        } else if (this.looping) {
            this.finished = true;
            this.exitCalled = true;
        } else if (!this.looping) {
            this.stop();
            this.exit2();
        }
    }

    void exit2() {
        try {
            System.exit(0);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void method(String name) {
        try {
            Method method = this.getClass().getMethod(name, new Class[0]);
            method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
        }
        catch (NoSuchMethodException nsme) {
            System.err.println("There is no public " + name + "() method " + "in the class " + this.getClass().getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void thread(final String name) {
        Thread later = new Thread(){

            public void run() {
                PApplet.this.method(name);
            }
        };
        later.start();
    }

    public void save(String filename) {
        this.g.save(this.savePath(filename));
    }

    public void saveFrame() {
        try {
            this.g.save(this.savePath("screen-" + PApplet.nf(this.frameCount, 4) + ".tif"));
        }
        catch (SecurityException se) {
            System.err.println("Can't use saveFrame() when running in a browser, unless using a signed applet.");
        }
    }

    public void saveFrame(String what) {
        try {
            this.g.save(this.savePath(this.insertFrame(what)));
        }
        catch (SecurityException se) {
            System.err.println("Can't use saveFrame() when running in a browser, unless using a signed applet.");
        }
    }

    protected String insertFrame(String what) {
        int first = what.indexOf(35);
        int last = what.lastIndexOf(35);
        if (first != -1 && last - first > 0) {
            String prefix = what.substring(0, first);
            int count = last - first + 1;
            String suffix = what.substring(last + 1);
            return String.valueOf(prefix) + PApplet.nf(this.frameCount, count) + suffix;
        }
        return what;
    }

    public void cursor(int cursorType) {
        this.setCursor(Cursor.getPredefinedCursor(cursorType));
        this.cursorVisible = true;
        this.cursorType = cursorType;
    }

    public void cursor(PImage image) {
        this.cursor(image, image.width / 2, image.height / 2);
    }

    public void cursor(PImage image, int hotspotX, int hotspotY) {
        Image jimage = this.createImage(new MemoryImageSource(image.width, image.height, image.pixels, 0, image.width));
        Point hotspot = new Point(hotspotX, hotspotY);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Cursor cursor = tk.createCustomCursor(jimage, hotspot, "Custom Cursor");
        this.setCursor(cursor);
        this.cursorVisible = true;
    }

    public void cursor() {
        if (!this.cursorVisible) {
            this.cursorVisible = true;
            this.setCursor(Cursor.getPredefinedCursor(this.cursorType));
        }
    }

    public void noCursor() {
        if (!this.cursorVisible) {
            return;
        }
        if (this.invisibleCursor == null) {
            this.invisibleCursor = new PImage(16, 16, 2);
        }
        this.cursor(this.invisibleCursor, 8, 8);
        this.cursorVisible = false;
    }

    public static void print(byte what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(boolean what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(char what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(int what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(float what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(String what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(Object what) {
        if (what == null) {
            System.out.print("null");
        } else {
            System.out.println(what.toString());
        }
    }

    public static void println() {
        System.out.println();
    }

    public static void println(byte what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(boolean what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(char what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(int what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(float what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(String what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(Object what) {
        block20: {
            block21: {
                block19: {
                    if (what != null) break block19;
                    System.out.println("null");
                    break block20;
                }
                String name = what.getClass().getName();
                if (name.charAt(0) != '[') break block21;
                switch (name.charAt(1)) {
                    case '[': {
                        System.out.println(what);
                        break;
                    }
                    case 'L': {
                        Object[] poo = (Object[])what;
                        int i = 0;
                        while (i < poo.length) {
                            if (poo[i] instanceof String) {
                                System.out.println("[" + i + "] \"" + poo[i] + "\"");
                            } else {
                                System.out.println("[" + i + "] " + poo[i]);
                            }
                            ++i;
                        }
                        break block20;
                    }
                    case 'Z': {
                        boolean[] zz = (boolean[])what;
                        int i = 0;
                        while (i < zz.length) {
                            System.out.println("[" + i + "] " + zz[i]);
                            ++i;
                        }
                        break block20;
                    }
                    case 'B': {
                        byte[] bb = (byte[])what;
                        int i = 0;
                        while (i < bb.length) {
                            System.out.println("[" + i + "] " + bb[i]);
                            ++i;
                        }
                        break block20;
                    }
                    case 'C': {
                        char[] cc = (char[])what;
                        int i = 0;
                        while (i < cc.length) {
                            System.out.println("[" + i + "] '" + cc[i] + "'");
                            ++i;
                        }
                        break block20;
                    }
                    case 'I': {
                        int[] ii = (int[])what;
                        int i = 0;
                        while (i < ii.length) {
                            System.out.println("[" + i + "] " + ii[i]);
                            ++i;
                        }
                        break block20;
                    }
                    case 'F': {
                        float[] ff = (float[])what;
                        int i = 0;
                        while (i < ff.length) {
                            System.out.println("[" + i + "] " + ff[i]);
                            ++i;
                        }
                        break block20;
                    }
                    case 'D': {
                        double[] dd = (double[])what;
                        int i = 0;
                        while (i < dd.length) {
                            System.out.println("[" + i + "] " + dd[i]);
                            ++i;
                        }
                        break block20;
                    }
                    default: {
                        System.out.println(what);
                        break;
                    }
                }
                break block20;
            }
            System.out.println(what);
        }
    }

    public static final float abs(float n) {
        return n < 0.0f ? -n : n;
    }

    public static final int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static final float sq(float a) {
        return a * a;
    }

    public static final float sqrt(float a) {
        return (float)Math.sqrt(a);
    }

    public static final float log(float a) {
        return (float)Math.log(a);
    }

    public static final float exp(float a) {
        return (float)Math.exp(a);
    }

    public static final float pow(float a, float b) {
        return (float)Math.pow(a, b);
    }

    public static final int max(int a, int b) {
        return a > b ? a : b;
    }

    public static final float max(float a, float b) {
        return a > b ? a : b;
    }

    public static final int max(int a, int b, int c) {
        return a > b ? (a > c ? a : c) : (b > c ? b : c);
    }

    public static final float max(float a, float b, float c) {
        return a > b ? (a > c ? a : c) : (b > c ? b : c);
    }

    public static final int max(int[] list) {
        if (list.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        int max = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] > max) {
                max = list[i];
            }
            ++i;
        }
        return max;
    }

    public static final float max(float[] list) {
        if (list.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        float max = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] > max) {
                max = list[i];
            }
            ++i;
        }
        return max;
    }

    public static final int min(int a, int b) {
        return a < b ? a : b;
    }

    public static final float min(float a, float b) {
        return a < b ? a : b;
    }

    public static final int min(int a, int b, int c) {
        return a < b ? (a < c ? a : c) : (b < c ? b : c);
    }

    public static final float min(float a, float b, float c) {
        return a < b ? (a < c ? a : c) : (b < c ? b : c);
    }

    public static final int min(int[] list) {
        if (list.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        int min = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] < min) {
                min = list[i];
            }
            ++i;
        }
        return min;
    }

    public static final float min(float[] list) {
        if (list.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        float min = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] < min) {
                min = list[i];
            }
            ++i;
        }
        return min;
    }

    public static final int constrain(int amt, int low, int high) {
        return amt < low ? low : (amt > high ? high : amt);
    }

    public static final float constrain(float amt, float low, float high) {
        return amt < low ? low : (amt > high ? high : amt);
    }

    public static final float sin(float angle) {
        return (float)Math.sin(angle);
    }

    public static final float cos(float angle) {
        return (float)Math.cos(angle);
    }

    public static final float tan(float angle) {
        return (float)Math.tan(angle);
    }

    public static final float asin(float value) {
        return (float)Math.asin(value);
    }

    public static final float acos(float value) {
        return (float)Math.acos(value);
    }

    public static final float atan(float value) {
        return (float)Math.atan(value);
    }

    public static final float atan2(float a, float b) {
        return (float)Math.atan2(a, b);
    }

    public static final float degrees(float radians) {
        return radians * 57.295776f;
    }

    public static final float radians(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static final int ceil(float what) {
        return (int)Math.ceil(what);
    }

    public static final int floor(float what) {
        return (int)Math.floor(what);
    }

    public static final int round(float what) {
        return Math.round(what);
    }

    public static final float mag(float a, float b) {
        return (float)Math.sqrt(a * a + b * b);
    }

    public static final float mag(float a, float b, float c) {
        return (float)Math.sqrt(a * a + b * b + c * c);
    }

    public static final float dist(float x1, float y1, float x2, float y2) {
        return PApplet.sqrt(PApplet.sq(x2 - x1) + PApplet.sq(y2 - y1));
    }

    public static final float dist(float x1, float y1, float z1, float x2, float y2, float z2) {
        return PApplet.sqrt(PApplet.sq(x2 - x1) + PApplet.sq(y2 - y1) + PApplet.sq(z2 - z1));
    }

    public static final float lerp(float start, float stop, float amt) {
        return start + (stop - start) * amt;
    }

    public static final float norm(float value, float start, float stop) {
        return (value - start) / (stop - start);
    }

    public static final float map(float value, float istart, float istop, float ostart, float ostop) {
        return ostart + (ostop - ostart) * ((value - istart) / (istop - istart));
    }

    public final float random(float howbig) {
        if (howbig == 0.0f) {
            return 0.0f;
        }
        if (this.internalRandom == null) {
            this.internalRandom = new Random();
        }
        float value = 0.0f;
        while ((value = this.internalRandom.nextFloat() * howbig) == howbig) {
        }
        return value;
    }

    public final float random(float howsmall, float howbig) {
        if (howsmall >= howbig) {
            return howsmall;
        }
        float diff = howbig - howsmall;
        return this.random(diff) + howsmall;
    }

    public final void randomSeed(long what) {
        if (this.internalRandom == null) {
            this.internalRandom = new Random();
        }
        this.internalRandom.setSeed(what);
    }

    public float noise(float x) {
        return this.noise(x, 0.0f, 0.0f);
    }

    public float noise(float x, float y) {
        return this.noise(x, y, 0.0f);
    }

    public float noise(float x, float y, float z) {
        if (this.perlin == null) {
            if (this.perlinRandom == null) {
                this.perlinRandom = new Random();
            }
            this.perlin = new float[4096];
            int i = 0;
            while (i < 4096) {
                this.perlin[i] = this.perlinRandom.nextFloat();
                ++i;
            }
            this.perlin_cosTable = PGraphics.cosLUT;
            this.perlin_PI = 720;
            this.perlin_TWOPI = 720;
            this.perlin_PI >>= 1;
        }
        if (x < 0.0f) {
            x = -x;
        }
        if (y < 0.0f) {
            y = -y;
        }
        if (z < 0.0f) {
            z = -z;
        }
        int xi = (int)x;
        int yi = (int)y;
        int zi = (int)z;
        float xf = x - (float)xi;
        float yf = y - (float)yi;
        float zf = z - (float)zi;
        float r = 0.0f;
        float ampl = 0.5f;
        int i = 0;
        while (i < this.perlin_octaves) {
            int of = xi + (yi << 4) + (zi << 8);
            float rxf = this.noise_fsc(xf);
            float ryf = this.noise_fsc(yf);
            float n1 = this.perlin[of & 0xFFF];
            n1 += rxf * (this.perlin[of + 1 & 0xFFF] - n1);
            float n2 = this.perlin[of + 16 & 0xFFF];
            n2 += rxf * (this.perlin[of + 16 + 1 & 0xFFF] - n2);
            n1 += ryf * (n2 - n1);
            n2 = this.perlin[(of += 256) & 0xFFF];
            n2 += rxf * (this.perlin[of + 1 & 0xFFF] - n2);
            float n3 = this.perlin[of + 16 & 0xFFF];
            n3 += rxf * (this.perlin[of + 16 + 1 & 0xFFF] - n3);
            n2 += ryf * (n3 - n2);
            n1 += this.noise_fsc(zf) * (n2 - n1);
            r += n1 * ampl;
            ampl *= this.perlin_amp_falloff;
            xi <<= 1;
            xf *= 2.0f;
            yi <<= 1;
            yf *= 2.0f;
            zi <<= 1;
            zf *= 2.0f;
            if (xf >= 1.0f) {
                ++xi;
                xf -= 1.0f;
            }
            if (yf >= 1.0f) {
                ++yi;
                yf -= 1.0f;
            }
            if (zf >= 1.0f) {
                ++zi;
                zf -= 1.0f;
            }
            ++i;
        }
        return r;
    }

    private float noise_fsc(float i) {
        return 0.5f * (1.0f - this.perlin_cosTable[(int)(i * (float)this.perlin_PI) % this.perlin_TWOPI]);
    }

    public void noiseDetail(int lod) {
        if (lod > 0) {
            this.perlin_octaves = lod;
        }
    }

    public void noiseDetail(int lod, float falloff) {
        if (lod > 0) {
            this.perlin_octaves = lod;
        }
        if (falloff > 0.0f) {
            this.perlin_amp_falloff = falloff;
        }
    }

    public void noiseSeed(long what) {
        if (this.perlinRandom == null) {
            this.perlinRandom = new Random();
        }
        this.perlinRandom.setSeed(what);
        this.perlin = null;
    }

    public PImage loadImage(String filename) {
        return this.loadImage(filename, null);
    }

    public PImage loadImage(String filename, String extension) {
        block16: {
            byte[] bytes;
            block17: {
                if (extension == null) {
                    int question;
                    String lower = filename.toLowerCase();
                    int dot = filename.lastIndexOf(46);
                    if (dot == -1) {
                        extension = "unknown";
                    }
                    if ((question = (extension = lower.substring(dot + 1)).indexOf(63)) != -1) {
                        extension = extension.substring(0, question);
                    }
                }
                if ((extension = extension.toLowerCase()).equals("tga")) {
                    try {
                        return this.loadImageTGA(filename);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                if (extension.equals("tif") || extension.equals("tiff")) {
                    bytes = this.loadBytes(filename);
                    return bytes == null ? null : PImage.loadTIFF(bytes);
                }
                if (!extension.equals("jpg") && !extension.equals("jpeg") && !extension.equals("gif") && !extension.equals("png") && !extension.equals("unknown")) break block16;
                bytes = this.loadBytes(filename);
                if (bytes != null) break block17;
                return null;
            }
            try {
                Image awtImage = Toolkit.getDefaultToolkit().createImage(bytes);
                PImage image = this.loadImageMT(awtImage);
                if (image.width == -1) {
                    System.err.println("The file " + filename + " contains bad image data, or may not be an image.");
                }
                if (extension.equals("gif") || extension.equals("png")) {
                    image.checkAlpha();
                }
                return image;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.loadImageFormats == null) {
            this.loadImageFormats = ImageIO.getReaderFormatNames();
        }
        if (this.loadImageFormats != null) {
            int i = 0;
            while (i < this.loadImageFormats.length) {
                if (extension.equals(this.loadImageFormats[i])) {
                    return this.loadImageIO(filename);
                }
                ++i;
            }
        }
        System.err.println("Could not find a method to load " + filename);
        return null;
    }

    public PImage requestImage(String filename) {
        return this.requestImage(filename, null);
    }

    public PImage requestImage(String filename, String extension) {
        PImage vessel = this.createImage(0, 0, 2);
        AsyncImageLoader ail = new AsyncImageLoader(filename, extension, vessel);
        ail.start();
        return vessel;
    }

    protected PImage loadImageMT(Image awtImage) {
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(awtImage, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        PImage image = new PImage(awtImage);
        image.parent = this;
        return image;
    }

    protected PImage loadImageIO(String filename) {
        InputStream stream = this.createInput(filename);
        if (stream == null) {
            System.err.println("The image " + filename + " could not be found.");
            return null;
        }
        try {
            BufferedImage bi = ImageIO.read(stream);
            PImage outgoing = new PImage(bi.getWidth(), bi.getHeight());
            outgoing.parent = this;
            bi.getRGB(0, 0, outgoing.width, outgoing.height, outgoing.pixels, 0, outgoing.width);
            outgoing.checkAlpha();
            return outgoing;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected PImage loadImageTGA(String filename) throws IOException {
        PImage outgoing;
        block47: {
            boolean reversed;
            int h;
            int w;
            int format;
            InputStream is;
            block45: {
                block46: {
                    int count;
                    is = this.createInput(filename);
                    if (is == null) {
                        return null;
                    }
                    byte[] header = new byte[18];
                    int offset = 0;
                    do {
                        if ((count = is.read(header, offset, header.length - offset)) != -1) continue;
                        return null;
                    } while ((offset += count) < 18);
                    format = 0;
                    if (!(header[2] != 3 && header[2] != 11 || header[16] != 8 || header[17] != 8 && header[17] != 40)) {
                        format = 4;
                    } else if (!(header[2] != 2 && header[2] != 10 || header[16] != 24 || header[17] != 32 && header[17] != 0)) {
                        format = 1;
                    } else if (!(header[2] != 2 && header[2] != 10 || header[16] != 32 || header[17] != 8 && header[17] != 40)) {
                        format = 2;
                    }
                    if (format == 0) {
                        System.err.println("Unknown .tga file format for " + filename);
                        return null;
                    }
                    w = ((header[13] & 0xFF) << 8) + (header[12] & 0xFF);
                    h = ((header[15] & 0xFF) << 8) + (header[14] & 0xFF);
                    outgoing = this.createImage(w, h, format);
                    boolean bl = reversed = (header[17] & 0x20) != 0;
                    if (header[2] != 2 && header[2] != 3) break block45;
                    if (!reversed) break block46;
                    int index = (h - 1) * w;
                    switch (format) {
                        case 4: {
                            int y = h - 1;
                            while (y >= 0) {
                                int x = 0;
                                while (x < w) {
                                    outgoing.pixels[index + x] = is.read();
                                    ++x;
                                }
                                index -= w;
                                --y;
                            }
                            break block47;
                        }
                        case 1: {
                            int y = h - 1;
                            while (y >= 0) {
                                int x = 0;
                                while (x < w) {
                                    outgoing.pixels[index + x] = is.read() | is.read() << 8 | is.read() << 16 | 0xFF000000;
                                    ++x;
                                }
                                index -= w;
                                --y;
                            }
                            break block47;
                        }
                        case 2: {
                            int y = h - 1;
                            while (y >= 0) {
                                int x = 0;
                                while (x < w) {
                                    outgoing.pixels[index + x] = is.read() | is.read() << 8 | is.read() << 16 | is.read() << 24;
                                    ++x;
                                }
                                index -= w;
                                --y;
                            }
                            break block0;
                        }
                    }
                    break block47;
                }
                int count = w * h;
                switch (format) {
                    case 4: {
                        int i = 0;
                        while (i < count) {
                            outgoing.pixels[i] = is.read();
                            ++i;
                        }
                        break block47;
                    }
                    case 1: {
                        int i = 0;
                        while (i < count) {
                            outgoing.pixels[i] = is.read() | is.read() << 8 | is.read() << 16 | 0xFF000000;
                            ++i;
                        }
                        break block47;
                    }
                    case 2: {
                        int i = 0;
                        while (i < count) {
                            outgoing.pixels[i] = is.read() | is.read() << 8 | is.read() << 16 | is.read() << 24;
                            ++i;
                        }
                        break block5;
                    }
                }
                break block47;
            }
            int index = 0;
            int[] px = outgoing.pixels;
            block30: while (index < px.length) {
                boolean isRLE;
                int num = is.read();
                boolean bl = isRLE = (num & 0x80) != 0;
                if (isRLE) {
                    num -= 127;
                    int pixel = 0;
                    switch (format) {
                        case 4: {
                            pixel = is.read();
                            break;
                        }
                        case 1: {
                            pixel = 0xFF000000 | is.read() | is.read() << 8 | is.read() << 16;
                            break;
                        }
                        case 2: {
                            pixel = is.read() | is.read() << 8 | is.read() << 16 | is.read() << 24;
                        }
                    }
                    int i = 0;
                    while (i < num) {
                        px[index++] = pixel;
                        if (index == px.length) continue block30;
                        ++i;
                    }
                    continue;
                }
                ++num;
                switch (format) {
                    case 4: {
                        int i = 0;
                        while (i < num) {
                            px[index++] = is.read();
                            ++i;
                        }
                        continue block30;
                    }
                    case 1: {
                        int i = 0;
                        while (i < num) {
                            px[index++] = 0xFF000000 | is.read() | is.read() << 8 | is.read() << 16;
                            ++i;
                        }
                        continue block30;
                    }
                    case 2: {
                        int i = 0;
                        while (i < num) {
                            px[index++] = is.read() | is.read() << 8 | is.read() << 16 | is.read() << 24;
                            ++i;
                        }
                        continue block30;
                    }
                }
            }
            if (!reversed) {
                int[] temp = new int[w];
                int y = 0;
                while (y < h / 2) {
                    int z = h - 1 - y;
                    System.arraycopy(px, y * w, temp, 0, w);
                    System.arraycopy(px, z * w, px, y * w, w);
                    System.arraycopy(temp, 0, px, z * w, w);
                    ++y;
                }
            }
        }
        return outgoing;
    }

    public PShape loadShape(String filename) {
        if (filename.toLowerCase().endsWith(".svg")) {
            return new PShapeSVG(this, filename);
        }
        if (filename.toLowerCase().endsWith(".svgz")) {
            try {
                GZIPInputStream input = new GZIPInputStream(this.createInput(filename));
                XMLElement xml = new XMLElement(PApplet.createReader(input));
                return new PShapeSVG(xml);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public PFont loadFont(String filename) {
        try {
            InputStream input = this.createInput(filename);
            return new PFont(input);
        }
        catch (Exception e) {
            this.die("Could not load font " + filename + ". " + "Make sure that the font has been copied " + "to the data folder of your sketch.", e);
            return null;
        }
    }

    protected PFont createDefaultFont(float size) {
        return this.createFont("SansSerif", size, true, null);
    }

    public PFont createFont(String name, float size) {
        return this.createFont(name, size, true, null);
    }

    public PFont createFont(String name, float size, boolean smooth) {
        return this.createFont(name, size, smooth, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PFont createFont(String name, float size, boolean smooth, char[] charset) {
        String lowerName = name.toLowerCase();
        Font baseFont = null;
        try {
            boolean bl;
            InputStream stream = null;
            if (lowerName.endsWith(".otf") || lowerName.endsWith(".ttf")) {
                stream = this.createInput(name);
                if (stream == null) {
                    System.err.println("The font \"" + name + "\" " + "is missing or inaccessible, make sure " + "the URL is valid or that the file has been " + "added to your sketch and is readable.");
                    return null;
                }
                baseFont = Font.createFont(0, this.createInput(name));
            } else {
                baseFont = PFont.findFont(name);
            }
            Font font = baseFont.deriveFont(size);
            if (stream != null) {
                bl = true;
                return new PFont(font, smooth, charset, bl);
            }
            bl = false;
            return new PFont(font, smooth, charset, bl);
        }
        catch (Exception e) {
            System.err.println("Problem createFont(" + name + ")");
            e.printStackTrace();
            return null;
        }
    }

    protected void checkParentFrame() {
        if (this.parentFrame == null) {
            Container comp = this.getParent();
            while (comp != null) {
                if (comp instanceof Frame) {
                    this.parentFrame = (Frame)comp;
                    break;
                }
                comp = comp.getParent();
            }
            if (this.parentFrame == null) {
                this.parentFrame = new Frame();
            }
        }
    }

    public String selectInput() {
        return this.selectInput("Select a file...");
    }

    public String selectInput(String prompt) {
        return this.selectFileImpl(prompt, 0);
    }

    public String selectOutput() {
        return this.selectOutput("Save as...");
    }

    public String selectOutput(String prompt) {
        return this.selectFileImpl(prompt, 1);
    }

    protected String selectFileImpl(final String prompt, final int mode) {
        this.checkParentFrame();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    FileDialog fileDialog = new FileDialog(PApplet.this.parentFrame, prompt, mode);
                    fileDialog.setVisible(true);
                    String directory = fileDialog.getDirectory();
                    String filename = fileDialog.getFile();
                    PApplet.this.selectedFile = filename == null ? null : new File(directory, filename);
                }
            });
            return this.selectedFile == null ? null : this.selectedFile.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String selectFolder() {
        return this.selectFolder("Select a folder...");
    }

    public String selectFolder(final String prompt) {
        this.checkParentFrame();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    if (platform == 2) {
                        FileDialog fileDialog = new FileDialog(PApplet.this.parentFrame, prompt, 0);
                        System.setProperty("apple.awt.fileDialogForDirectories", "true");
                        fileDialog.setVisible(true);
                        System.setProperty("apple.awt.fileDialogForDirectories", "false");
                        String filename = fileDialog.getFile();
                        PApplet.this.selectedFile = filename == null ? null : new File(fileDialog.getDirectory(), fileDialog.getFile());
                    } else {
                        JFileChooser fileChooser = new JFileChooser();
                        fileChooser.setDialogTitle(prompt);
                        fileChooser.setFileSelectionMode(1);
                        int returned = fileChooser.showOpenDialog(PApplet.this.parentFrame);
                        System.out.println(returned);
                        PApplet.this.selectedFile = returned == 1 ? null : fileChooser.getSelectedFile();
                    }
                }
            });
            return this.selectedFile == null ? null : this.selectedFile.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public BufferedReader createReader(String filename) {
        InputStream is;
        block5: {
            try {
                is = this.createInput(filename);
                if (is != null) break block5;
                System.err.println(String.valueOf(filename) + " does not exist or could not be read");
                return null;
            }
            catch (Exception e) {
                if (filename == null) {
                    System.err.println("Filename passed to reader() was null");
                } else {
                    System.err.println("Couldn't create a reader for " + filename);
                }
                return null;
            }
        }
        return PApplet.createReader(is);
    }

    public static BufferedReader createReader(File file) {
        try {
            InputStream is = new FileInputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            return PApplet.createReader(is);
        }
        catch (Exception e) {
            if (file == null) {
                throw new RuntimeException("File passed to createReader() was null");
            }
            e.printStackTrace();
            throw new RuntimeException("Couldn't create a reader for " + file.getAbsolutePath());
        }
    }

    public static BufferedReader createReader(InputStream input) {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(input, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new BufferedReader(isr);
    }

    public PrintWriter createWriter(String filename) {
        return PApplet.createWriter(this.saveFile(filename));
    }

    public static PrintWriter createWriter(File file) {
        try {
            PApplet.createPath(file);
            OutputStream output = new FileOutputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                output = new GZIPOutputStream(output);
            }
            return PApplet.createWriter(output);
        }
        catch (Exception e) {
            if (file == null) {
                throw new RuntimeException("File passed to createWriter() was null");
            }
            e.printStackTrace();
            throw new RuntimeException("Couldn't create a writer for " + file.getAbsolutePath());
        }
    }

    public static PrintWriter createWriter(OutputStream output) {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(output, "UTF-8");
            return new PrintWriter(osw);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public InputStream openStream(String filename) {
        return this.createInput(filename);
    }

    public InputStream createInput(String filename) {
        InputStream input = this.createInputRaw(filename);
        if (input != null && filename.toLowerCase().endsWith(".gz")) {
            try {
                return new GZIPInputStream(input);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return input;
    }

    public InputStream createInputRaw(String filename) {
        URLConnection conn;
        URL url;
        URL base2;
        String cn;
        File file2;
        InputStream stream;
        block38: {
            stream = null;
            if (filename == null) {
                return null;
            }
            if (filename.length() == 0) {
                return null;
            }
            if (filename.indexOf(":") != -1) {
                try {
                    URL url2 = new URL(filename);
                    stream = url2.openStream();
                    return stream;
                }
                catch (MalformedURLException url2) {
                }
                catch (FileNotFoundException url2) {
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            file2 = new File(this.dataPath(filename));
            if (!file2.exists()) {
                file2 = new File(this.sketchPath, filename);
            }
            if (!file2.isDirectory()) break block38;
            return null;
        }
        try {
            if (file2.exists()) {
                try {
                    String filePath = file2.getCanonicalPath();
                    String filenameActual = new File(filePath).getName();
                    String filenameShort = new File(filename).getName();
                    if (!filenameActual.equals(filenameShort)) {
                        throw new RuntimeException("This file is named " + filenameActual + " not " + filename + ". Rename the file " + "or change your code.");
                    }
                }
                catch (IOException filePath) {
                    // empty catch block
                }
            }
            if ((stream = new FileInputStream(file2)) != null) {
                return stream;
            }
        }
        catch (IOException file2) {
        }
        catch (SecurityException file2) {
            // empty catch block
        }
        ClassLoader cl = this.getClass().getClassLoader();
        stream = cl.getResourceAsStream("data/" + filename);
        if (stream != null && !(cn = stream.getClass().getName()).equals("sun.plugin.cache.EmptyInputStream")) {
            return stream;
        }
        stream = cl.getResourceAsStream(filename);
        if (stream != null && !(cn = stream.getClass().getName()).equals("sun.plugin.cache.EmptyInputStream")) {
            return stream;
        }
        try {
            base2 = this.getDocumentBase();
            if (base2 != null) {
                url = new URL(base2, filename);
                conn = url.openConnection();
                return conn.getInputStream();
            }
        }
        catch (Exception base2) {
            // empty catch block
        }
        try {
            base2 = this.getDocumentBase();
            if (base2 != null) {
                url = new URL(base2, "data/" + filename);
                conn = url.openConnection();
                return conn.getInputStream();
            }
        }
        catch (Exception base3) {
            // empty catch block
        }
        try {
            try {
                try {
                    stream = new FileInputStream(this.dataPath(filename));
                    if (stream != null) {
                        return stream;
                    }
                }
                catch (IOException base3) {
                    // empty catch block
                }
                try {
                    stream = new FileInputStream(this.sketchPath(filename));
                    if (stream != null) {
                        return stream;
                    }
                }
                catch (Exception base3) {
                    // empty catch block
                }
                try {
                    stream = new FileInputStream(filename);
                    if (stream != null) {
                        return stream;
                    }
                }
                catch (IOException base3) {
                }
            }
            catch (SecurityException base3) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static InputStream createInput(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File passed to createInput() was null");
        }
        try {
            FileInputStream input = new FileInputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                return new GZIPInputStream(input);
            }
            return input;
        }
        catch (IOException e) {
            System.err.println("Could not createInput() for " + file);
            e.printStackTrace();
            return null;
        }
    }

    public byte[] loadBytes(String filename) {
        InputStream is = this.createInput(filename);
        if (is != null) {
            return PApplet.loadBytes(is);
        }
        System.err.println("The file \"" + filename + "\" " + "is missing or inaccessible, make sure " + "the URL is valid or that the file has been " + "added to your sketch and is readable.");
        return null;
    }

    public static byte[] loadBytes(InputStream input) {
        try {
            BufferedInputStream bis = new BufferedInputStream(input);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int c = bis.read();
            while (c != -1) {
                out.write(c);
                c = bis.read();
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] loadBytes(File file) {
        InputStream is = PApplet.createInput(file);
        return PApplet.loadBytes(is);
    }

    public static String[] loadStrings(File file) {
        InputStream is = PApplet.createInput(file);
        if (is != null) {
            return PApplet.loadStrings(is);
        }
        return null;
    }

    public String[] loadStrings(String filename) {
        InputStream is = this.createInput(filename);
        if (is != null) {
            return PApplet.loadStrings(is);
        }
        System.err.println("The file \"" + filename + "\" " + "is missing or inaccessible, make sure " + "the URL is valid or that the file has been " + "added to your sketch and is readable.");
        return null;
    }

    public static String[] loadStrings(InputStream input) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            String[] lines = new String[100];
            int lineCount = 0;
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (lineCount == lines.length) {
                    String[] temp = new String[lineCount << 1];
                    System.arraycopy(lines, 0, temp, 0, lineCount);
                    lines = temp;
                }
                lines[lineCount++] = line;
            }
            reader.close();
            if (lineCount == lines.length) {
                return lines;
            }
            String[] output = new String[lineCount];
            System.arraycopy(lines, 0, output, 0, lineCount);
            return output;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public OutputStream createOutput(String filename) {
        return PApplet.createOutput(this.saveFile(filename));
    }

    public static OutputStream createOutput(File file) {
        try {
            PApplet.createPath(file);
            FileOutputStream fos = new FileOutputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                return new GZIPOutputStream(fos);
            }
            return fos;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean saveStream(String targetFilename, String sourceLocation) {
        return this.saveStream(this.saveFile(targetFilename), sourceLocation);
    }

    public boolean saveStream(File targetFile, String sourceLocation) {
        return PApplet.saveStream(targetFile, this.createInputRaw(sourceLocation));
    }

    public static boolean saveStream(File targetFile, InputStream sourceStream) {
        File tempFile = null;
        try {
            int bytesRead;
            File parentDir = targetFile.getParentFile();
            tempFile = File.createTempFile(targetFile.getName(), null, parentDir);
            BufferedInputStream bis = new BufferedInputStream(sourceStream, 16384);
            FileOutputStream fos = new FileOutputStream(tempFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            byte[] buffer = new byte[8192];
            while ((bytesRead = bis.read(buffer)) != -1) {
                bos.write(buffer, 0, bytesRead);
            }
            bos.flush();
            bos.close();
            bos = null;
            if (!tempFile.renameTo(targetFile)) {
                System.err.println("Could not rename temporary file " + tempFile.getAbsolutePath());
                return false;
            }
            return true;
        }
        catch (IOException e) {
            if (tempFile != null) {
                tempFile.delete();
            }
            e.printStackTrace();
            return false;
        }
    }

    public void saveBytes(String filename, byte[] buffer) {
        PApplet.saveBytes(this.saveFile(filename), buffer);
    }

    public static void saveBytes(File file, byte[] buffer) {
        File tempFile = null;
        try {
            File parentDir = file.getParentFile();
            tempFile = File.createTempFile(file.getName(), null, parentDir);
            OutputStream output = PApplet.createOutput(tempFile);
            PApplet.saveBytes(output, buffer);
            output.close();
            output = null;
            if (!tempFile.renameTo(file)) {
                System.err.println("Could not rename temporary file " + tempFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            System.err.println("error saving bytes to " + file);
            if (tempFile != null) {
                tempFile.delete();
            }
            e.printStackTrace();
        }
    }

    public static void saveBytes(OutputStream output, byte[] buffer) {
        try {
            output.write(buffer);
            output.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveStrings(String filename, String[] strings) {
        PApplet.saveStrings(this.saveFile(filename), strings);
    }

    public static void saveStrings(File file, String[] strings) {
        PApplet.saveStrings(PApplet.createOutput(file), strings);
    }

    public static void saveStrings(OutputStream output, String[] strings) {
        PrintWriter writer = PApplet.createWriter(output);
        int i = 0;
        while (i < strings.length) {
            writer.println(strings[i]);
            ++i;
        }
        writer.flush();
        writer.close();
    }

    public String sketchPath(String where) {
        if (this.sketchPath == null) {
            return where;
        }
        try {
            if (new File(where).isAbsolute()) {
                return where;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(this.sketchPath) + File.separator + where;
    }

    public File sketchFile(String where) {
        return new File(this.sketchPath(where));
    }

    public String savePath(String where) {
        if (where == null) {
            return null;
        }
        String filename = this.sketchPath(where);
        PApplet.createPath(filename);
        return filename;
    }

    public File saveFile(String where) {
        return new File(this.savePath(where));
    }

    public String dataPath(String where) {
        if (new File(where).isAbsolute()) {
            return where;
        }
        return String.valueOf(this.sketchPath) + File.separator + "data" + File.separator + where;
    }

    public File dataFile(String where) {
        return new File(this.dataPath(where));
    }

    public static void createPath(String path) {
        PApplet.createPath(new File(path));
    }

    public static void createPath(File file) {
        try {
            File unit;
            String parent = file.getParent();
            if (parent != null && !(unit = new File(parent)).exists()) {
                unit.mkdirs();
            }
        }
        catch (SecurityException se) {
            System.err.println("You don't have permissions to create " + file.getAbsolutePath());
        }
    }

    public static byte[] sort(byte[] what) {
        return PApplet.sort(what, what.length);
    }

    public static byte[] sort(byte[] what, int count) {
        byte[] outgoing = new byte[what.length];
        System.arraycopy(what, 0, outgoing, 0, what.length);
        Arrays.sort(outgoing, 0, count);
        return outgoing;
    }

    public static char[] sort(char[] what) {
        return PApplet.sort(what, what.length);
    }

    public static char[] sort(char[] what, int count) {
        char[] outgoing = new char[what.length];
        System.arraycopy(what, 0, outgoing, 0, what.length);
        Arrays.sort(outgoing, 0, count);
        return outgoing;
    }

    public static int[] sort(int[] what) {
        return PApplet.sort(what, what.length);
    }

    public static int[] sort(int[] what, int count) {
        int[] outgoing = new int[what.length];
        System.arraycopy(what, 0, outgoing, 0, what.length);
        Arrays.sort(outgoing, 0, count);
        return outgoing;
    }

    public static float[] sort(float[] what) {
        return PApplet.sort(what, what.length);
    }

    public static float[] sort(float[] what, int count) {
        float[] outgoing = new float[what.length];
        System.arraycopy(what, 0, outgoing, 0, what.length);
        Arrays.sort(outgoing, 0, count);
        return outgoing;
    }

    public static String[] sort(String[] what) {
        return PApplet.sort(what, what.length);
    }

    public static String[] sort(String[] what, int count) {
        Object[] outgoing = new String[what.length];
        System.arraycopy(what, 0, outgoing, 0, what.length);
        Arrays.sort(outgoing, 0, count);
        return outgoing;
    }

    public static void arrayCopy(Object src, int srcPosition, Object dst, int dstPosition, int length) {
        System.arraycopy(src, srcPosition, dst, dstPosition, length);
    }

    public static void arrayCopy(Object src, Object dst, int length) {
        System.arraycopy(src, 0, dst, 0, length);
    }

    public static void arrayCopy(Object src, Object dst) {
        System.arraycopy(src, 0, dst, 0, Array.getLength(src));
    }

    public static void arraycopy(Object src, int srcPosition, Object dst, int dstPosition, int length) {
        System.arraycopy(src, srcPosition, dst, dstPosition, length);
    }

    public static void arraycopy(Object src, Object dst, int length) {
        System.arraycopy(src, 0, dst, 0, length);
    }

    public static void arraycopy(Object src, Object dst) {
        System.arraycopy(src, 0, dst, 0, Array.getLength(src));
    }

    public static boolean[] expand(boolean[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static boolean[] expand(boolean[] list, int newSize) {
        boolean[] temp = new boolean[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static byte[] expand(byte[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static byte[] expand(byte[] list, int newSize) {
        byte[] temp = new byte[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static char[] expand(char[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static char[] expand(char[] list, int newSize) {
        char[] temp = new char[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static int[] expand(int[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static int[] expand(int[] list, int newSize) {
        int[] temp = new int[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static float[] expand(float[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static float[] expand(float[] list, int newSize) {
        float[] temp = new float[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static String[] expand(String[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static String[] expand(String[] list, int newSize) {
        String[] temp = new String[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static Object expand(Object array) {
        return PApplet.expand(array, Array.getLength(array) << 1);
    }

    public static Object expand(Object list, int newSize) {
        Class<?> type = list.getClass().getComponentType();
        Object temp = Array.newInstance(type, newSize);
        System.arraycopy(list, 0, temp, 0, Math.min(Array.getLength(list), newSize));
        return temp;
    }

    public static byte[] append(byte[] b, byte value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static char[] append(char[] b, char value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static int[] append(int[] b, int value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static float[] append(float[] b, float value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static String[] append(String[] b, String value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static Object append(Object b, Object value) {
        int length = Array.getLength(b);
        b = PApplet.expand(b, length + 1);
        Array.set(b, length, value);
        return b;
    }

    public static boolean[] shorten(boolean[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static byte[] shorten(byte[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static char[] shorten(char[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static int[] shorten(int[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static float[] shorten(float[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static String[] shorten(String[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static Object shorten(Object list) {
        int length = Array.getLength(list);
        return PApplet.subset(list, 0, length - 1);
    }

    public static final boolean[] splice(boolean[] list, boolean v, int index) {
        boolean[] outgoing = new boolean[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final boolean[] splice(boolean[] list, boolean[] v, int index) {
        boolean[] outgoing = new boolean[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final byte[] splice(byte[] list, byte v, int index) {
        byte[] outgoing = new byte[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final byte[] splice(byte[] list, byte[] v, int index) {
        byte[] outgoing = new byte[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final char[] splice(char[] list, char v, int index) {
        char[] outgoing = new char[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final char[] splice(char[] list, char[] v, int index) {
        char[] outgoing = new char[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final int[] splice(int[] list, int v, int index) {
        int[] outgoing = new int[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final int[] splice(int[] list, int[] v, int index) {
        int[] outgoing = new int[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final float[] splice(float[] list, float v, int index) {
        float[] outgoing = new float[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final float[] splice(float[] list, float[] v, int index) {
        float[] outgoing = new float[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final String[] splice(String[] list, String v, int index) {
        String[] outgoing = new String[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final String[] splice(String[] list, String[] v, int index) {
        String[] outgoing = new String[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final Object splice(Object list, Object v, int index) {
        Object[] outgoing = null;
        int length = Array.getLength(list);
        if (v.getClass().getName().charAt(0) == '[') {
            int vlength = Array.getLength(v);
            outgoing = new Object[length + vlength];
            System.arraycopy(list, 0, outgoing, 0, index);
            System.arraycopy(v, 0, outgoing, index, vlength);
            System.arraycopy(list, index, outgoing, index + vlength, length - index);
        } else {
            outgoing = new Object[length + 1];
            System.arraycopy(list, 0, outgoing, 0, index);
            Array.set(outgoing, index, v);
            System.arraycopy(list, index, outgoing, index + 1, length - index);
        }
        return outgoing;
    }

    public static boolean[] subset(boolean[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static boolean[] subset(boolean[] list, int start, int count) {
        boolean[] output = new boolean[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static byte[] subset(byte[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static byte[] subset(byte[] list, int start, int count) {
        byte[] output = new byte[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static char[] subset(char[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static char[] subset(char[] list, int start, int count) {
        char[] output = new char[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static int[] subset(int[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static int[] subset(int[] list, int start, int count) {
        int[] output = new int[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static float[] subset(float[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static float[] subset(float[] list, int start, int count) {
        float[] output = new float[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static String[] subset(String[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static String[] subset(String[] list, int start, int count) {
        String[] output = new String[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static Object subset(Object list, int start) {
        int length = Array.getLength(list);
        return PApplet.subset(list, start, length - start);
    }

    public static Object subset(Object list, int start, int count) {
        Class<?> type = list.getClass().getComponentType();
        Object outgoing = Array.newInstance(type, count);
        System.arraycopy(list, start, outgoing, 0, count);
        return outgoing;
    }

    public static boolean[] concat(boolean[] a, boolean[] b) {
        boolean[] c = new boolean[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static char[] concat(char[] a, char[] b) {
        char[] c = new char[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static int[] concat(int[] a, int[] b) {
        int[] c = new int[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static float[] concat(float[] a, float[] b) {
        float[] c = new float[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static String[] concat(String[] a, String[] b) {
        String[] c = new String[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static Object concat(Object a, Object b) {
        Class<?> type = a.getClass().getComponentType();
        int alength = Array.getLength(a);
        int blength = Array.getLength(b);
        Object outgoing = Array.newInstance(type, alength + blength);
        System.arraycopy(a, 0, outgoing, 0, alength);
        System.arraycopy(b, 0, outgoing, alength, blength);
        return outgoing;
    }

    public static boolean[] reverse(boolean[] list) {
        boolean[] outgoing = new boolean[list.length];
        int length1 = list.length - 1;
        int i = 0;
        while (i < list.length) {
            outgoing[i] = list[length1 - i];
            ++i;
        }
        return outgoing;
    }

    public static byte[] reverse(byte[] list) {
        byte[] outgoing = new byte[list.length];
        int length1 = list.length - 1;
        int i = 0;
        while (i < list.length) {
            outgoing[i] = list[length1 - i];
            ++i;
        }
        return outgoing;
    }

    public static char[] reverse(char[] list) {
        char[] outgoing = new char[list.length];
        int length1 = list.length - 1;
        int i = 0;
        while (i < list.length) {
            outgoing[i] = list[length1 - i];
            ++i;
        }
        return outgoing;
    }

    public static int[] reverse(int[] list) {
        int[] outgoing = new int[list.length];
        int length1 = list.length - 1;
        int i = 0;
        while (i < list.length) {
            outgoing[i] = list[length1 - i];
            ++i;
        }
        return outgoing;
    }

    public static float[] reverse(float[] list) {
        float[] outgoing = new float[list.length];
        int length1 = list.length - 1;
        int i = 0;
        while (i < list.length) {
            outgoing[i] = list[length1 - i];
            ++i;
        }
        return outgoing;
    }

    public static String[] reverse(String[] list) {
        String[] outgoing = new String[list.length];
        int length1 = list.length - 1;
        int i = 0;
        while (i < list.length) {
            outgoing[i] = list[length1 - i];
            ++i;
        }
        return outgoing;
    }

    public static Object reverse(Object list) {
        Class<?> type = list.getClass().getComponentType();
        int length = Array.getLength(list);
        Object outgoing = Array.newInstance(type, length);
        int i = 0;
        while (i < length) {
            Array.set(outgoing, i, Array.get(list, length - 1 - i));
            ++i;
        }
        return outgoing;
    }

    public static String trim(String str) {
        return str.replace('\u00a0', ' ').trim();
    }

    public static String[] trim(String[] array) {
        String[] outgoing = new String[array.length];
        int i = 0;
        while (i < array.length) {
            outgoing[i] = array[i].replace('\u00a0', ' ').trim();
            ++i;
        }
        return outgoing;
    }

    public static String join(String[] str, char separator) {
        return PApplet.join(str, String.valueOf(separator));
    }

    public static String join(String[] str, String separator) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < str.length) {
            if (i != 0) {
                buffer.append(separator);
            }
            buffer.append(str[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static String[] splitTokens(String what) {
        return PApplet.splitTokens(what, " \t\n\r\f\u00a0");
    }

    public static String[] splitTokens(String what, String delim) {
        StringTokenizer toker = new StringTokenizer(what, delim);
        String[] pieces = new String[toker.countTokens()];
        int index = 0;
        while (toker.hasMoreTokens()) {
            pieces[index++] = toker.nextToken();
        }
        return pieces;
    }

    public static String[] split(String what, char delim) {
        if (what == null) {
            return null;
        }
        char[] chars = what.toCharArray();
        int splitCount = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == delim) {
                ++splitCount;
            }
            ++i;
        }
        if (splitCount == 0) {
            String[] splits = new String[]{new String(what)};
            return splits;
        }
        String[] splits = new String[splitCount + 1];
        int splitIndex = 0;
        int startIndex = 0;
        int i2 = 0;
        while (i2 < chars.length) {
            if (chars[i2] == delim) {
                splits[splitIndex++] = new String(chars, startIndex, i2 - startIndex);
                startIndex = i2 + 1;
            }
            ++i2;
        }
        splits[splitIndex] = new String(chars, startIndex, chars.length - startIndex);
        return splits;
    }

    public static String[] split(String what, String delim) {
        int index;
        ArrayList<String> items = new ArrayList<String>();
        int offset = 0;
        while ((index = what.indexOf(delim, offset)) != -1) {
            items.add(what.substring(offset, index));
            offset = index + delim.length();
        }
        items.add(what.substring(offset));
        String[] outgoing = new String[items.size()];
        items.toArray(outgoing);
        return outgoing;
    }

    static Pattern matchPattern(String regexp) {
        Pattern p = null;
        if (matchPatterns == null) {
            matchPatterns = new HashMap();
        } else {
            p = matchPatterns.get(regexp);
        }
        if (p == null) {
            if (matchPatterns.size() == 10) {
                matchPatterns.clear();
            }
            p = Pattern.compile(regexp, 40);
            matchPatterns.put(regexp, p);
        }
        return p;
    }

    public static String[] match(String what, String regexp) {
        Pattern p = PApplet.matchPattern(regexp);
        Matcher m = p.matcher(what);
        if (m.find()) {
            int count = m.groupCount() + 1;
            String[] groups = new String[count];
            int i = 0;
            while (i < count) {
                groups[i] = m.group(i);
                ++i;
            }
            return groups;
        }
        return null;
    }

    public static String[][] matchAll(String what, String regexp) {
        int i;
        Pattern p = PApplet.matchPattern(regexp);
        Matcher m = p.matcher(what);
        ArrayList<String[]> results = new ArrayList<String[]>();
        int count = m.groupCount() + 1;
        while (m.find()) {
            String[] groups = new String[count];
            i = 0;
            while (i < count) {
                groups[i] = m.group(i);
                ++i;
            }
            results.add(groups);
        }
        if (results.isEmpty()) {
            return null;
        }
        String[][] matches = new String[results.size()][count];
        i = 0;
        while (i < matches.length) {
            matches[i] = (String[])results.get(i);
            ++i;
        }
        return matches;
    }

    public static final boolean parseBoolean(int what) {
        return what != 0;
    }

    public static final boolean parseBoolean(String what) {
        return new Boolean(what);
    }

    public static final boolean[] parseBoolean(byte[] what) {
        boolean[] outgoing = new boolean[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = what[i] != 0;
            ++i;
        }
        return outgoing;
    }

    public static final boolean[] parseBoolean(int[] what) {
        boolean[] outgoing = new boolean[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = what[i] != 0;
            ++i;
        }
        return outgoing;
    }

    public static final boolean[] parseBoolean(String[] what) {
        boolean[] outgoing = new boolean[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = new Boolean(what[i]);
            ++i;
        }
        return outgoing;
    }

    public static final byte parseByte(boolean what) {
        return what ? (byte)1 : 0;
    }

    public static final byte parseByte(char what) {
        return (byte)what;
    }

    public static final byte parseByte(int what) {
        return (byte)what;
    }

    public static final byte parseByte(float what) {
        return (byte)what;
    }

    public static final byte[] parseByte(boolean[] what) {
        byte[] outgoing = new byte[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = what[i] ? (byte)1 : 0;
            ++i;
        }
        return outgoing;
    }

    public static final byte[] parseByte(char[] what) {
        byte[] outgoing = new byte[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = (byte)what[i];
            ++i;
        }
        return outgoing;
    }

    public static final byte[] parseByte(int[] what) {
        byte[] outgoing = new byte[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = (byte)what[i];
            ++i;
        }
        return outgoing;
    }

    public static final byte[] parseByte(float[] what) {
        byte[] outgoing = new byte[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = (byte)what[i];
            ++i;
        }
        return outgoing;
    }

    public static final char parseChar(byte what) {
        return (char)(what & 0xFF);
    }

    public static final char parseChar(int what) {
        return (char)what;
    }

    public static final char[] parseChar(byte[] what) {
        char[] outgoing = new char[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = (char)(what[i] & 0xFF);
            ++i;
        }
        return outgoing;
    }

    public static final char[] parseChar(int[] what) {
        char[] outgoing = new char[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = (char)what[i];
            ++i;
        }
        return outgoing;
    }

    public static final int parseInt(boolean what) {
        return what ? 1 : 0;
    }

    public static final int parseInt(byte what) {
        return what & 0xFF;
    }

    public static final int parseInt(char what) {
        return what;
    }

    public static final int parseInt(float what) {
        return (int)what;
    }

    public static final int parseInt(String what) {
        return PApplet.parseInt(what, 0);
    }

    public static final int parseInt(String what, int otherwise) {
        try {
            int offset = what.indexOf(46);
            if (offset == -1) {
                return Integer.parseInt(what);
            }
            return Integer.parseInt(what.substring(0, offset));
        }
        catch (NumberFormatException numberFormatException) {
            return otherwise;
        }
    }

    public static final int[] parseInt(boolean[] what) {
        int[] list = new int[what.length];
        int i = 0;
        while (i < what.length) {
            list[i] = what[i] ? 1 : 0;
            ++i;
        }
        return list;
    }

    public static final int[] parseInt(byte[] what) {
        int[] list = new int[what.length];
        int i = 0;
        while (i < what.length) {
            list[i] = what[i] & 0xFF;
            ++i;
        }
        return list;
    }

    public static final int[] parseInt(char[] what) {
        int[] list = new int[what.length];
        int i = 0;
        while (i < what.length) {
            list[i] = what[i];
            ++i;
        }
        return list;
    }

    public static int[] parseInt(float[] what) {
        int[] inties = new int[what.length];
        int i = 0;
        while (i < what.length) {
            inties[i] = (int)what[i];
            ++i;
        }
        return inties;
    }

    public static int[] parseInt(String[] what) {
        return PApplet.parseInt(what, 0);
    }

    public static int[] parseInt(String[] what, int missing) {
        int[] output = new int[what.length];
        int i = 0;
        while (i < what.length) {
            try {
                output[i] = Integer.parseInt(what[i]);
            }
            catch (NumberFormatException e) {
                output[i] = missing;
            }
            ++i;
        }
        return output;
    }

    public static final float parseFloat(int what) {
        return what;
    }

    public static final float parseFloat(String what) {
        return PApplet.parseFloat(what, Float.NaN);
    }

    public static final float parseFloat(String what, float otherwise) {
        try {
            return new Float(what).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            return otherwise;
        }
    }

    public static final float[] parseByte(byte[] what) {
        float[] floaties = new float[what.length];
        int i = 0;
        while (i < what.length) {
            floaties[i] = what[i];
            ++i;
        }
        return floaties;
    }

    public static final float[] parseFloat(int[] what) {
        float[] floaties = new float[what.length];
        int i = 0;
        while (i < what.length) {
            floaties[i] = what[i];
            ++i;
        }
        return floaties;
    }

    public static final float[] parseFloat(String[] what) {
        return PApplet.parseFloat(what, Float.NaN);
    }

    public static final float[] parseFloat(String[] what, float missing) {
        float[] output = new float[what.length];
        int i = 0;
        while (i < what.length) {
            try {
                output[i] = new Float(what[i]).floatValue();
            }
            catch (NumberFormatException e) {
                output[i] = missing;
            }
            ++i;
        }
        return output;
    }

    public static final String str(boolean x) {
        return String.valueOf(x);
    }

    public static final String str(byte x) {
        return String.valueOf(x);
    }

    public static final String str(char x) {
        return String.valueOf(x);
    }

    public static final String str(int x) {
        return String.valueOf(x);
    }

    public static final String str(float x) {
        return String.valueOf(x);
    }

    public static final String[] str(boolean[] x) {
        String[] s = new String[x.length];
        int i = 0;
        while (i < x.length) {
            s[i] = String.valueOf(x[i]);
            ++i;
        }
        return s;
    }

    public static final String[] str(byte[] x) {
        String[] s = new String[x.length];
        int i = 0;
        while (i < x.length) {
            s[i] = String.valueOf(x[i]);
            ++i;
        }
        return s;
    }

    public static final String[] str(char[] x) {
        String[] s = new String[x.length];
        int i = 0;
        while (i < x.length) {
            s[i] = String.valueOf(x[i]);
            ++i;
        }
        return s;
    }

    public static final String[] str(int[] x) {
        String[] s = new String[x.length];
        int i = 0;
        while (i < x.length) {
            s[i] = String.valueOf(x[i]);
            ++i;
        }
        return s;
    }

    public static final String[] str(float[] x) {
        String[] s = new String[x.length];
        int i = 0;
        while (i < x.length) {
            s[i] = String.valueOf(x[i]);
            ++i;
        }
        return s;
    }

    public static String[] nf(int[] num, int digits) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nf(num[i], digits);
            ++i;
        }
        return formatted;
    }

    public static String nf(int num, int digits) {
        if (int_nf != null && int_nf_digits == digits && !int_nf_commas) {
            return int_nf.format(num);
        }
        int_nf = NumberFormat.getInstance();
        int_nf.setGroupingUsed(false);
        int_nf_commas = false;
        int_nf.setMinimumIntegerDigits(digits);
        int_nf_digits = digits;
        return int_nf.format(num);
    }

    public static String[] nfc(int[] num) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nfc(num[i]);
            ++i;
        }
        return formatted;
    }

    public static String nfc(int num) {
        if (int_nf != null && int_nf_digits == 0 && int_nf_commas) {
            return int_nf.format(num);
        }
        int_nf = NumberFormat.getInstance();
        int_nf.setGroupingUsed(true);
        int_nf_commas = true;
        int_nf.setMinimumIntegerDigits(0);
        int_nf_digits = 0;
        return int_nf.format(num);
    }

    public static String nfs(int num, int digits) {
        return num < 0 ? PApplet.nf(num, digits) : String.valueOf(' ') + PApplet.nf(num, digits);
    }

    public static String[] nfs(int[] num, int digits) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nfs(num[i], digits);
            ++i;
        }
        return formatted;
    }

    public static String nfp(int num, int digits) {
        return num < 0 ? PApplet.nf(num, digits) : String.valueOf('+') + PApplet.nf(num, digits);
    }

    public static String[] nfp(int[] num, int digits) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nfp(num[i], digits);
            ++i;
        }
        return formatted;
    }

    public static String[] nf(float[] num, int left, int right) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nf(num[i], left, right);
            ++i;
        }
        return formatted;
    }

    public static String nf(float num, int left, int right) {
        if (float_nf != null && float_nf_left == left && float_nf_right == right && !float_nf_commas) {
            return float_nf.format(num);
        }
        float_nf = NumberFormat.getInstance();
        float_nf.setGroupingUsed(false);
        float_nf_commas = false;
        if (left != 0) {
            float_nf.setMinimumIntegerDigits(left);
        }
        if (right != 0) {
            float_nf.setMinimumFractionDigits(right);
            float_nf.setMaximumFractionDigits(right);
        }
        float_nf_left = left;
        float_nf_right = right;
        return float_nf.format(num);
    }

    public static String[] nfc(float[] num, int right) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nfc(num[i], right);
            ++i;
        }
        return formatted;
    }

    public static String nfc(float num, int right) {
        if (float_nf != null && float_nf_left == 0 && float_nf_right == right && float_nf_commas) {
            return float_nf.format(num);
        }
        float_nf = NumberFormat.getInstance();
        float_nf.setGroupingUsed(true);
        float_nf_commas = true;
        if (right != 0) {
            float_nf.setMinimumFractionDigits(right);
            float_nf.setMaximumFractionDigits(right);
        }
        float_nf_left = 0;
        float_nf_right = right;
        return float_nf.format(num);
    }

    public static String[] nfs(float[] num, int left, int right) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nfs(num[i], left, right);
            ++i;
        }
        return formatted;
    }

    public static String nfs(float num, int left, int right) {
        return num < 0.0f ? PApplet.nf(num, left, right) : String.valueOf(' ') + PApplet.nf(num, left, right);
    }

    public static String[] nfp(float[] num, int left, int right) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nfp(num[i], left, right);
            ++i;
        }
        return formatted;
    }

    public static String nfp(float num, int left, int right) {
        return num < 0.0f ? PApplet.nf(num, left, right) : String.valueOf('+') + PApplet.nf(num, left, right);
    }

    public static final String hex(byte what) {
        return PApplet.hex(what, 2);
    }

    public static final String hex(char what) {
        return PApplet.hex(what, 4);
    }

    public static final String hex(int what) {
        return PApplet.hex(what, 8);
    }

    public static final String hex(int what, int digits) {
        String stuff = Integer.toHexString(what).toUpperCase();
        int length = stuff.length();
        if (length > digits) {
            return stuff.substring(length - digits);
        }
        if (length < digits) {
            return String.valueOf("00000000".substring(8 - (digits - length))) + stuff;
        }
        return stuff;
    }

    public static final int unhex(String what) {
        return (int)Long.parseLong(what, 16);
    }

    public static final String binary(byte what) {
        return PApplet.binary(what, 8);
    }

    public static final String binary(char what) {
        return PApplet.binary(what, 16);
    }

    public static final String binary(int what) {
        return Integer.toBinaryString(what);
    }

    public static final String binary(int what, int digits) {
        String stuff = Integer.toBinaryString(what);
        int length = stuff.length();
        if (length > digits) {
            return stuff.substring(length - digits);
        }
        if (length < digits) {
            int offset = 32 - (digits - length);
            return String.valueOf("00000000000000000000000000000000".substring(offset)) + stuff;
        }
        return stuff;
    }

    public static final int unbinary(String what) {
        return Integer.parseInt(what, 2);
    }

    public final int color(int gray) {
        if (this.g == null) {
            if (gray > 255) {
                gray = 255;
            } else if (gray < 0) {
                gray = 0;
            }
            return 0xFF000000 | gray << 16 | gray << 8 | gray;
        }
        return this.g.color(gray);
    }

    public final int color(float fgray) {
        if (this.g == null) {
            int gray = (int)fgray;
            if (gray > 255) {
                gray = 255;
            } else if (gray < 0) {
                gray = 0;
            }
            return 0xFF000000 | gray << 16 | gray << 8 | gray;
        }
        return this.g.color(fgray);
    }

    public final int color(int gray, int alpha) {
        if (this.g == null) {
            if (alpha > 255) {
                alpha = 255;
            } else if (alpha < 0) {
                alpha = 0;
            }
            if (gray > 255) {
                return alpha << 24 | gray & 0xFFFFFF;
            }
            return alpha << 24 | gray << 16 | gray << 8 | gray;
        }
        return this.g.color(gray, alpha);
    }

    public final int color(float fgray, float falpha) {
        if (this.g == null) {
            int gray = (int)fgray;
            int alpha = (int)falpha;
            if (gray > 255) {
                gray = 255;
            } else if (gray < 0) {
                gray = 0;
            }
            if (alpha > 255) {
                alpha = 255;
            } else if (alpha < 0) {
                alpha = 0;
            }
            return 0xFF000000 | gray << 16 | gray << 8 | gray;
        }
        return this.g.color(fgray, falpha);
    }

    public final int color(int x, int y, int z) {
        if (this.g == null) {
            if (x > 255) {
                x = 255;
            } else if (x < 0) {
                x = 0;
            }
            if (y > 255) {
                y = 255;
            } else if (y < 0) {
                y = 0;
            }
            if (z > 255) {
                z = 255;
            } else if (z < 0) {
                z = 0;
            }
            return 0xFF000000 | x << 16 | y << 8 | z;
        }
        return this.g.color(x, y, z);
    }

    public final int color(float x, float y, float z) {
        if (this.g == null) {
            if (x > 255.0f) {
                x = 255.0f;
            } else if (x < 0.0f) {
                x = 0.0f;
            }
            if (y > 255.0f) {
                y = 255.0f;
            } else if (y < 0.0f) {
                y = 0.0f;
            }
            if (z > 255.0f) {
                z = 255.0f;
            } else if (z < 0.0f) {
                z = 0.0f;
            }
            return 0xFF000000 | (int)x << 16 | (int)y << 8 | (int)z;
        }
        return this.g.color(x, y, z);
    }

    public final int color(int x, int y, int z, int a) {
        if (this.g == null) {
            if (a > 255) {
                a = 255;
            } else if (a < 0) {
                a = 0;
            }
            if (x > 255) {
                x = 255;
            } else if (x < 0) {
                x = 0;
            }
            if (y > 255) {
                y = 255;
            } else if (y < 0) {
                y = 0;
            }
            if (z > 255) {
                z = 255;
            } else if (z < 0) {
                z = 0;
            }
            return a << 24 | x << 16 | y << 8 | z;
        }
        return this.g.color(x, y, z, a);
    }

    public final int color(float x, float y, float z, float a) {
        if (this.g == null) {
            if (a > 255.0f) {
                a = 255.0f;
            } else if (a < 0.0f) {
                a = 0.0f;
            }
            if (x > 255.0f) {
                x = 255.0f;
            } else if (x < 0.0f) {
                x = 0.0f;
            }
            if (y > 255.0f) {
                y = 255.0f;
            } else if (y < 0.0f) {
                y = 0.0f;
            }
            if (z > 255.0f) {
                z = 255.0f;
            } else if (z < 0.0f) {
                z = 0.0f;
            }
            return (int)a << 24 | (int)x << 16 | (int)y << 8 | (int)z;
        }
        return this.g.color(x, y, z, a);
    }

    public void setupExternalMessages() {
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent e) {
                Point where = ((Frame)e.getSource()).getLocation();
                System.err.println("__MOVE__ " + where.x + " " + where.y);
                System.err.flush();
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PApplet.this.exit();
            }
        });
    }

    public void setupFrameResizeListener() {
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Frame farm;
                if (PApplet.this.frame.isResizable() && (farm = (Frame)e.getComponent()).isVisible()) {
                    Insets insets = farm.getInsets();
                    Dimension windowSize = farm.getSize();
                    int usableW = windowSize.width - insets.left - insets.right;
                    int usableH = windowSize.height - insets.top - insets.bottom;
                    PApplet.this.setBounds(insets.left, insets.top, usableW, usableH);
                }
            }
        });
    }

    public static void main(String[] args) {
        PApplet applet;
        if (platform == 2) {
            System.setProperty("apple.awt.graphics.UseQuartz", String.valueOf(useQuartz));
        }
        if (args.length < 1) {
            System.err.println("Usage: PApplet <appletname>");
            System.err.println("For additional options, see the Javadoc for PApplet");
            System.exit(1);
        }
        boolean external = false;
        int[] location = null;
        int[] editorLocation = null;
        String name = null;
        boolean present = false;
        boolean exclusive = false;
        Color backgroundColor = Color.BLACK;
        Color stopColor = Color.GRAY;
        GraphicsDevice displayDevice = null;
        boolean hideStop = false;
        String param = null;
        String value = null;
        String folder = null;
        try {
            folder = System.getProperty("user.dir");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int argIndex = 0;
        while (argIndex < args.length) {
            block46: {
                block44: {
                    block50: {
                        block49: {
                            block48: {
                                block47: {
                                    block45: {
                                        int equals = args[argIndex].indexOf(61);
                                        if (equals == -1) break block44;
                                        param = args[argIndex].substring(0, equals);
                                        value = args[argIndex].substring(equals + 1);
                                        if (!param.equals(ARGS_EDITOR_LOCATION)) break block45;
                                        external = true;
                                        editorLocation = PApplet.parseInt(PApplet.split(value, ','));
                                        break block46;
                                    }
                                    if (!param.equals(ARGS_DISPLAY)) break block47;
                                    int deviceIndex = Integer.parseInt(value) - 1;
                                    GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                                    GraphicsDevice[] devices = environment.getScreenDevices();
                                    if (deviceIndex >= 0 && deviceIndex < devices.length) {
                                        displayDevice = devices[deviceIndex];
                                    } else {
                                        System.err.println("Display " + value + " does not exist, " + "using the default display instead.");
                                    }
                                    break block46;
                                }
                                if (!param.equals(ARGS_BGCOLOR)) break block48;
                                if (value.charAt(0) == '#') {
                                    value = value.substring(1);
                                }
                                backgroundColor = new Color(Integer.parseInt(value, 16));
                                break block46;
                            }
                            if (!param.equals(ARGS_STOP_COLOR)) break block49;
                            if (value.charAt(0) == '#') {
                                value = value.substring(1);
                            }
                            stopColor = new Color(Integer.parseInt(value, 16));
                            break block46;
                        }
                        if (!param.equals(ARGS_SKETCH_FOLDER)) break block50;
                        folder = value;
                        break block46;
                    }
                    if (!param.equals(ARGS_LOCATION)) break block46;
                    location = PApplet.parseInt(PApplet.split(value, ','));
                    break block46;
                }
                if (args[argIndex].equals(ARGS_PRESENT)) {
                    present = true;
                } else if (args[argIndex].equals(ARGS_EXCLUSIVE)) {
                    exclusive = true;
                } else if (args[argIndex].equals(ARGS_HIDE_STOP)) {
                    hideStop = true;
                } else if (args[argIndex].equals(ARGS_EXTERNAL)) {
                    external = true;
                } else {
                    name = args[argIndex];
                    break;
                }
            }
            ++argIndex;
        }
        if (displayDevice == null) {
            GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            displayDevice = environment.getDefaultScreenDevice();
        }
        Frame frame = new Frame(displayDevice.getDefaultConfiguration());
        frame.setResizable(false);
        Image image = Toolkit.getDefaultToolkit().createImage(ICON_IMAGE);
        frame.setIconImage(image);
        frame.setTitle(name);
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(name);
            applet = (PApplet)c.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        applet.frame = frame;
        applet.sketchPath = folder;
        applet.args = PApplet.subset(args, 1);
        applet.external = external;
        Rectangle fullScreenRect = null;
        if (present) {
            frame.setUndecorated(true);
            frame.setBackground(backgroundColor);
            if (exclusive) {
                displayDevice.setFullScreenWindow(frame);
                frame.setExtendedState(6);
                fullScreenRect = frame.getBounds();
            } else {
                DisplayMode mode = displayDevice.getDisplayMode();
                fullScreenRect = new Rectangle(0, 0, mode.getWidth(), mode.getHeight());
                frame.setBounds(fullScreenRect);
                frame.setVisible(true);
            }
        }
        frame.setLayout(null);
        frame.add(applet);
        if (present) {
            frame.invalidate();
        } else {
            frame.pack();
        }
        applet.init();
        while (applet.defaultSize && !applet.finished) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException mode) {
                // empty catch block
            }
        }
        if (present) {
            frame.setBounds(fullScreenRect);
            applet.setBounds((fullScreenRect.width - applet.width) / 2, (fullScreenRect.height - applet.height) / 2, applet.width, applet.height);
            if (!hideStop) {
                Label label = new Label("stop");
                label.setForeground(stopColor);
                label.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent e) {
                        System.exit(0);
                    }
                });
                frame.add(label);
                Dimension labelSize = label.getPreferredSize();
                labelSize = new Dimension(100, labelSize.height);
                label.setSize(labelSize);
                label.setLocation(20, fullScreenRect.height - labelSize.height - 20);
            }
            if (external) {
                applet.setupExternalMessages();
            }
        } else {
            Insets insets = frame.getInsets();
            int windowW = Math.max(applet.width, 128) + insets.left + insets.right;
            int windowH = Math.max(applet.height, 128) + insets.top + insets.bottom;
            frame.setSize(windowW, windowH);
            if (location != null) {
                frame.setLocation(location[0], location[1]);
            } else if (external) {
                int locationX = editorLocation[0] - 20;
                int locationY = editorLocation[1];
                if (locationX - windowW > 10) {
                    frame.setLocation(locationX - windowW, locationY);
                } else {
                    locationX = editorLocation[0] + 66;
                    locationY = editorLocation[1] + 66;
                    if (locationX + windowW > applet.screenWidth - 33 || locationY + windowH > applet.screenHeight - 33) {
                        locationX = (applet.screenWidth - windowW) / 2;
                        locationY = (applet.screenHeight - windowH) / 2;
                    }
                    frame.setLocation(locationX, locationY);
                }
            } else {
                frame.setLocation((applet.screenWidth - applet.width) / 2, (applet.screenHeight - applet.height) / 2);
            }
            Point frameLoc = frame.getLocation();
            if (frameLoc.y < 0) {
                frame.setLocation(frameLoc.x, 30);
            }
            if (backgroundColor == Color.black) {
                backgroundColor = SystemColor.control;
            }
            frame.setBackground(backgroundColor);
            int usableWindowH = windowH - insets.top - insets.bottom;
            applet.setBounds((windowW - applet.width) / 2, insets.top + (usableWindowH - applet.height) / 2, applet.width, applet.height);
            if (external) {
                applet.setupExternalMessages();
            } else {
                frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
            }
            applet.setupFrameResizeListener();
            if (applet.displayable()) {
                frame.setVisible(true);
            }
        }
    }

    public PGraphics beginRecord(String renderer, String filename) {
        filename = this.insertFrame(filename);
        PGraphics rec = this.createGraphics(this.width, this.height, renderer, filename);
        this.beginRecord(rec);
        return rec;
    }

    public void beginRecord(PGraphics recorder) {
        this.recorder = recorder;
        recorder.beginDraw();
    }

    public void endRecord() {
        if (this.recorder != null) {
            this.recorder.endDraw();
            this.recorder.dispose();
            this.recorder = null;
        }
    }

    public PGraphics beginRaw(String renderer, String filename) {
        filename = this.insertFrame(filename);
        PGraphics rec = this.createGraphics(this.width, this.height, renderer, filename);
        this.g.beginRaw(rec);
        return rec;
    }

    public void beginRaw(PGraphics rawGraphics) {
        this.g.beginRaw(rawGraphics);
    }

    public void endRaw() {
        this.g.endRaw();
    }

    public void loadPixels() {
        this.g.loadPixels();
        this.pixels = this.g.pixels;
    }

    public void updatePixels() {
        this.g.updatePixels();
    }

    public void updatePixels(int x1, int y1, int x2, int y2) {
        this.g.updatePixels(x1, y1, x2, y2);
    }

    public void flush() {
        if (this.recorder != null) {
            this.recorder.flush();
        }
        this.g.flush();
    }

    public void hint(int which) {
        if (this.recorder != null) {
            this.recorder.hint(which);
        }
        this.g.hint(which);
    }

    public void beginShape() {
        if (this.recorder != null) {
            this.recorder.beginShape();
        }
        this.g.beginShape();
    }

    public void beginShape(int kind) {
        if (this.recorder != null) {
            this.recorder.beginShape(kind);
        }
        this.g.beginShape(kind);
    }

    public void edge(boolean edge) {
        if (this.recorder != null) {
            this.recorder.edge(edge);
        }
        this.g.edge(edge);
    }

    public void normal(float nx, float ny, float nz) {
        if (this.recorder != null) {
            this.recorder.normal(nx, ny, nz);
        }
        this.g.normal(nx, ny, nz);
    }

    public void textureMode(int mode) {
        if (this.recorder != null) {
            this.recorder.textureMode(mode);
        }
        this.g.textureMode(mode);
    }

    public void texture(PImage image) {
        if (this.recorder != null) {
            this.recorder.texture(image);
        }
        this.g.texture(image);
    }

    public void vertex(float x, float y) {
        if (this.recorder != null) {
            this.recorder.vertex(x, y);
        }
        this.g.vertex(x, y);
    }

    public void vertex(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.vertex(x, y, z);
        }
        this.g.vertex(x, y, z);
    }

    public void vertex(float[] v) {
        if (this.recorder != null) {
            this.recorder.vertex(v);
        }
        this.g.vertex(v);
    }

    public void vertex(float x, float y, float u, float v) {
        if (this.recorder != null) {
            this.recorder.vertex(x, y, u, v);
        }
        this.g.vertex(x, y, u, v);
    }

    public void vertex(float x, float y, float z, float u, float v) {
        if (this.recorder != null) {
            this.recorder.vertex(x, y, z, u, v);
        }
        this.g.vertex(x, y, z, u, v);
    }

    public void breakShape() {
        if (this.recorder != null) {
            this.recorder.breakShape();
        }
        this.g.breakShape();
    }

    public void endShape() {
        if (this.recorder != null) {
            this.recorder.endShape();
        }
        this.g.endShape();
    }

    public void endShape(int mode) {
        if (this.recorder != null) {
            this.recorder.endShape(mode);
        }
        this.g.endShape(mode);
    }

    public void bezierVertex(float x2, float y2, float x3, float y3, float x4, float y4) {
        if (this.recorder != null) {
            this.recorder.bezierVertex(x2, y2, x3, y3, x4, y4);
        }
        this.g.bezierVertex(x2, y2, x3, y3, x4, y4);
    }

    public void bezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        if (this.recorder != null) {
            this.recorder.bezierVertex(x2, y2, z2, x3, y3, z3, x4, y4, z4);
        }
        this.g.bezierVertex(x2, y2, z2, x3, y3, z3, x4, y4, z4);
    }

    public void curveVertex(float x, float y) {
        if (this.recorder != null) {
            this.recorder.curveVertex(x, y);
        }
        this.g.curveVertex(x, y);
    }

    public void curveVertex(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.curveVertex(x, y, z);
        }
        this.g.curveVertex(x, y, z);
    }

    public void point(float x, float y) {
        if (this.recorder != null) {
            this.recorder.point(x, y);
        }
        this.g.point(x, y);
    }

    public void point(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.point(x, y, z);
        }
        this.g.point(x, y, z);
    }

    public void line(float x1, float y1, float x2, float y2) {
        if (this.recorder != null) {
            this.recorder.line(x1, y1, x2, y2);
        }
        this.g.line(x1, y1, x2, y2);
    }

    public void line(float x1, float y1, float z1, float x2, float y2, float z2) {
        if (this.recorder != null) {
            this.recorder.line(x1, y1, z1, x2, y2, z2);
        }
        this.g.line(x1, y1, z1, x2, y2, z2);
    }

    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        if (this.recorder != null) {
            this.recorder.triangle(x1, y1, x2, y2, x3, y3);
        }
        this.g.triangle(x1, y1, x2, y2, x3, y3);
    }

    public void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        if (this.recorder != null) {
            this.recorder.quad(x1, y1, x2, y2, x3, y3, x4, y4);
        }
        this.g.quad(x1, y1, x2, y2, x3, y3, x4, y4);
    }

    public void rectMode(int mode) {
        if (this.recorder != null) {
            this.recorder.rectMode(mode);
        }
        this.g.rectMode(mode);
    }

    public void rect(float a, float b, float c, float d) {
        if (this.recorder != null) {
            this.recorder.rect(a, b, c, d);
        }
        this.g.rect(a, b, c, d);
    }

    public void rect(float a, float b, float c, float d, float hr, float vr) {
        if (this.recorder != null) {
            this.recorder.rect(a, b, c, d, hr, vr);
        }
        this.g.rect(a, b, c, d, hr, vr);
    }

    public void rect(float a, float b, float c, float d, float tl, float tr, float bl, float br) {
        if (this.recorder != null) {
            this.recorder.rect(a, b, c, d, tl, tr, bl, br);
        }
        this.g.rect(a, b, c, d, tl, tr, bl, br);
    }

    public void ellipseMode(int mode) {
        if (this.recorder != null) {
            this.recorder.ellipseMode(mode);
        }
        this.g.ellipseMode(mode);
    }

    public void ellipse(float a, float b, float c, float d) {
        if (this.recorder != null) {
            this.recorder.ellipse(a, b, c, d);
        }
        this.g.ellipse(a, b, c, d);
    }

    public void arc(float a, float b, float c, float d, float start, float stop) {
        if (this.recorder != null) {
            this.recorder.arc(a, b, c, d, start, stop);
        }
        this.g.arc(a, b, c, d, start, stop);
    }

    public void box(float size) {
        if (this.recorder != null) {
            this.recorder.box(size);
        }
        this.g.box(size);
    }

    public void box(float w, float h, float d) {
        if (this.recorder != null) {
            this.recorder.box(w, h, d);
        }
        this.g.box(w, h, d);
    }

    public void sphereDetail(int res) {
        if (this.recorder != null) {
            this.recorder.sphereDetail(res);
        }
        this.g.sphereDetail(res);
    }

    public void sphereDetail(int ures, int vres) {
        if (this.recorder != null) {
            this.recorder.sphereDetail(ures, vres);
        }
        this.g.sphereDetail(ures, vres);
    }

    public void sphere(float r) {
        if (this.recorder != null) {
            this.recorder.sphere(r);
        }
        this.g.sphere(r);
    }

    public float bezierPoint(float a, float b, float c, float d, float t) {
        return this.g.bezierPoint(a, b, c, d, t);
    }

    public float bezierTangent(float a, float b, float c, float d, float t) {
        return this.g.bezierTangent(a, b, c, d, t);
    }

    public void bezierDetail(int detail) {
        if (this.recorder != null) {
            this.recorder.bezierDetail(detail);
        }
        this.g.bezierDetail(detail);
    }

    public void bezier(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        if (this.recorder != null) {
            this.recorder.bezier(x1, y1, x2, y2, x3, y3, x4, y4);
        }
        this.g.bezier(x1, y1, x2, y2, x3, y3, x4, y4);
    }

    public void bezier(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        if (this.recorder != null) {
            this.recorder.bezier(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
        }
        this.g.bezier(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
    }

    public float curvePoint(float a, float b, float c, float d, float t) {
        return this.g.curvePoint(a, b, c, d, t);
    }

    public float curveTangent(float a, float b, float c, float d, float t) {
        return this.g.curveTangent(a, b, c, d, t);
    }

    public void curveDetail(int detail) {
        if (this.recorder != null) {
            this.recorder.curveDetail(detail);
        }
        this.g.curveDetail(detail);
    }

    public void curveTightness(float tightness) {
        if (this.recorder != null) {
            this.recorder.curveTightness(tightness);
        }
        this.g.curveTightness(tightness);
    }

    public void curve(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        if (this.recorder != null) {
            this.recorder.curve(x1, y1, x2, y2, x3, y3, x4, y4);
        }
        this.g.curve(x1, y1, x2, y2, x3, y3, x4, y4);
    }

    public void curve(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        if (this.recorder != null) {
            this.recorder.curve(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
        }
        this.g.curve(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
    }

    public void smooth() {
        if (this.recorder != null) {
            this.recorder.smooth();
        }
        this.g.smooth();
    }

    public void noSmooth() {
        if (this.recorder != null) {
            this.recorder.noSmooth();
        }
        this.g.noSmooth();
    }

    public void imageMode(int mode) {
        if (this.recorder != null) {
            this.recorder.imageMode(mode);
        }
        this.g.imageMode(mode);
    }

    public void image(PImage image, float x, float y) {
        if (this.recorder != null) {
            this.recorder.image(image, x, y);
        }
        this.g.image(image, x, y);
    }

    public void image(PImage image, float x, float y, float c, float d) {
        if (this.recorder != null) {
            this.recorder.image(image, x, y, c, d);
        }
        this.g.image(image, x, y, c, d);
    }

    public void image(PImage image, float a, float b, float c, float d, int u1, int v1, int u2, int v2) {
        if (this.recorder != null) {
            this.recorder.image(image, a, b, c, d, u1, v1, u2, v2);
        }
        this.g.image(image, a, b, c, d, u1, v1, u2, v2);
    }

    public void shapeMode(int mode) {
        if (this.recorder != null) {
            this.recorder.shapeMode(mode);
        }
        this.g.shapeMode(mode);
    }

    public void shape(PShape shape) {
        if (this.recorder != null) {
            this.recorder.shape(shape);
        }
        this.g.shape(shape);
    }

    public void shape(PShape shape, float x, float y) {
        if (this.recorder != null) {
            this.recorder.shape(shape, x, y);
        }
        this.g.shape(shape, x, y);
    }

    public void shape(PShape shape, float x, float y, float c, float d) {
        if (this.recorder != null) {
            this.recorder.shape(shape, x, y, c, d);
        }
        this.g.shape(shape, x, y, c, d);
    }

    public void textAlign(int align) {
        if (this.recorder != null) {
            this.recorder.textAlign(align);
        }
        this.g.textAlign(align);
    }

    public void textAlign(int alignX, int alignY) {
        if (this.recorder != null) {
            this.recorder.textAlign(alignX, alignY);
        }
        this.g.textAlign(alignX, alignY);
    }

    public float textAscent() {
        return this.g.textAscent();
    }

    public float textDescent() {
        return this.g.textDescent();
    }

    public void textFont(PFont which) {
        if (this.recorder != null) {
            this.recorder.textFont(which);
        }
        this.g.textFont(which);
    }

    public void textFont(PFont which, float size) {
        if (this.recorder != null) {
            this.recorder.textFont(which, size);
        }
        this.g.textFont(which, size);
    }

    public void textLeading(float leading) {
        if (this.recorder != null) {
            this.recorder.textLeading(leading);
        }
        this.g.textLeading(leading);
    }

    public void textMode(int mode) {
        if (this.recorder != null) {
            this.recorder.textMode(mode);
        }
        this.g.textMode(mode);
    }

    public void textSize(float size) {
        if (this.recorder != null) {
            this.recorder.textSize(size);
        }
        this.g.textSize(size);
    }

    public float textWidth(char c) {
        return this.g.textWidth(c);
    }

    public float textWidth(String str) {
        return this.g.textWidth(str);
    }

    public float textWidth(char[] chars, int start, int length) {
        return this.g.textWidth(chars, start, length);
    }

    public void text(char c) {
        if (this.recorder != null) {
            this.recorder.text(c);
        }
        this.g.text(c);
    }

    public void text(char c, float x, float y) {
        if (this.recorder != null) {
            this.recorder.text(c, x, y);
        }
        this.g.text(c, x, y);
    }

    public void text(char c, float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.text(c, x, y, z);
        }
        this.g.text(c, x, y, z);
    }

    public void text(String str) {
        if (this.recorder != null) {
            this.recorder.text(str);
        }
        this.g.text(str);
    }

    public void text(String str, float x, float y) {
        if (this.recorder != null) {
            this.recorder.text(str, x, y);
        }
        this.g.text(str, x, y);
    }

    public void text(char[] chars, int start, int stop, float x, float y) {
        if (this.recorder != null) {
            this.recorder.text(chars, start, stop, x, y);
        }
        this.g.text(chars, start, stop, x, y);
    }

    public void text(String str, float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.text(str, x, y, z);
        }
        this.g.text(str, x, y, z);
    }

    public void text(char[] chars, int start, int stop, float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.text(chars, start, stop, x, y, z);
        }
        this.g.text(chars, start, stop, x, y, z);
    }

    public void text(String str, float x1, float y1, float x2, float y2) {
        if (this.recorder != null) {
            this.recorder.text(str, x1, y1, x2, y2);
        }
        this.g.text(str, x1, y1, x2, y2);
    }

    public void text(String s, float x1, float y1, float x2, float y2, float z) {
        if (this.recorder != null) {
            this.recorder.text(s, x1, y1, x2, y2, z);
        }
        this.g.text(s, x1, y1, x2, y2, z);
    }

    public void text(int num, float x, float y) {
        if (this.recorder != null) {
            this.recorder.text(num, x, y);
        }
        this.g.text(num, x, y);
    }

    public void text(int num, float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.text(num, x, y, z);
        }
        this.g.text(num, x, y, z);
    }

    public void text(float num, float x, float y) {
        if (this.recorder != null) {
            this.recorder.text(num, x, y);
        }
        this.g.text(num, x, y);
    }

    public void text(float num, float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.text(num, x, y, z);
        }
        this.g.text(num, x, y, z);
    }

    public void pushMatrix() {
        if (this.recorder != null) {
            this.recorder.pushMatrix();
        }
        this.g.pushMatrix();
    }

    public void popMatrix() {
        if (this.recorder != null) {
            this.recorder.popMatrix();
        }
        this.g.popMatrix();
    }

    public void translate(float tx, float ty) {
        if (this.recorder != null) {
            this.recorder.translate(tx, ty);
        }
        this.g.translate(tx, ty);
    }

    public void translate(float tx, float ty, float tz) {
        if (this.recorder != null) {
            this.recorder.translate(tx, ty, tz);
        }
        this.g.translate(tx, ty, tz);
    }

    public void rotate(float angle) {
        if (this.recorder != null) {
            this.recorder.rotate(angle);
        }
        this.g.rotate(angle);
    }

    public void rotateX(float angle) {
        if (this.recorder != null) {
            this.recorder.rotateX(angle);
        }
        this.g.rotateX(angle);
    }

    public void rotateY(float angle) {
        if (this.recorder != null) {
            this.recorder.rotateY(angle);
        }
        this.g.rotateY(angle);
    }

    public void rotateZ(float angle) {
        if (this.recorder != null) {
            this.recorder.rotateZ(angle);
        }
        this.g.rotateZ(angle);
    }

    public void rotate(float angle, float vx, float vy, float vz) {
        if (this.recorder != null) {
            this.recorder.rotate(angle, vx, vy, vz);
        }
        this.g.rotate(angle, vx, vy, vz);
    }

    public void scale(float s) {
        if (this.recorder != null) {
            this.recorder.scale(s);
        }
        this.g.scale(s);
    }

    public void scale(float sx, float sy) {
        if (this.recorder != null) {
            this.recorder.scale(sx, sy);
        }
        this.g.scale(sx, sy);
    }

    public void scale(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.scale(x, y, z);
        }
        this.g.scale(x, y, z);
    }

    public void skewX(float angle) {
        if (this.recorder != null) {
            this.recorder.skewX(angle);
        }
        this.g.skewX(angle);
    }

    public void skewY(float angle) {
        if (this.recorder != null) {
            this.recorder.skewY(angle);
        }
        this.g.skewY(angle);
    }

    public void resetMatrix() {
        if (this.recorder != null) {
            this.recorder.resetMatrix();
        }
        this.g.resetMatrix();
    }

    public void applyMatrix(PMatrix source) {
        if (this.recorder != null) {
            this.recorder.applyMatrix(source);
        }
        this.g.applyMatrix(source);
    }

    public void applyMatrix(PMatrix2D source) {
        if (this.recorder != null) {
            this.recorder.applyMatrix(source);
        }
        this.g.applyMatrix(source);
    }

    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        if (this.recorder != null) {
            this.recorder.applyMatrix(n00, n01, n02, n10, n11, n12);
        }
        this.g.applyMatrix(n00, n01, n02, n10, n11, n12);
    }

    public void applyMatrix(PMatrix3D source) {
        if (this.recorder != null) {
            this.recorder.applyMatrix(source);
        }
        this.g.applyMatrix(source);
    }

    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        if (this.recorder != null) {
            this.recorder.applyMatrix(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
        }
        this.g.applyMatrix(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
    }

    public PMatrix getMatrix() {
        return this.g.getMatrix();
    }

    public PMatrix2D getMatrix(PMatrix2D target) {
        return this.g.getMatrix(target);
    }

    public PMatrix3D getMatrix(PMatrix3D target) {
        return this.g.getMatrix(target);
    }

    public void setMatrix(PMatrix source) {
        if (this.recorder != null) {
            this.recorder.setMatrix(source);
        }
        this.g.setMatrix(source);
    }

    public void setMatrix(PMatrix2D source) {
        if (this.recorder != null) {
            this.recorder.setMatrix(source);
        }
        this.g.setMatrix(source);
    }

    public void setMatrix(PMatrix3D source) {
        if (this.recorder != null) {
            this.recorder.setMatrix(source);
        }
        this.g.setMatrix(source);
    }

    public void printMatrix() {
        if (this.recorder != null) {
            this.recorder.printMatrix();
        }
        this.g.printMatrix();
    }

    public void beginCamera() {
        if (this.recorder != null) {
            this.recorder.beginCamera();
        }
        this.g.beginCamera();
    }

    public void endCamera() {
        if (this.recorder != null) {
            this.recorder.endCamera();
        }
        this.g.endCamera();
    }

    public void camera() {
        if (this.recorder != null) {
            this.recorder.camera();
        }
        this.g.camera();
    }

    public void camera(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        if (this.recorder != null) {
            this.recorder.camera(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ);
        }
        this.g.camera(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ);
    }

    public void printCamera() {
        if (this.recorder != null) {
            this.recorder.printCamera();
        }
        this.g.printCamera();
    }

    public void ortho() {
        if (this.recorder != null) {
            this.recorder.ortho();
        }
        this.g.ortho();
    }

    public void ortho(float left, float right, float bottom, float top, float near, float far) {
        if (this.recorder != null) {
            this.recorder.ortho(left, right, bottom, top, near, far);
        }
        this.g.ortho(left, right, bottom, top, near, far);
    }

    public void perspective() {
        if (this.recorder != null) {
            this.recorder.perspective();
        }
        this.g.perspective();
    }

    public void perspective(float fovy, float aspect, float zNear, float zFar) {
        if (this.recorder != null) {
            this.recorder.perspective(fovy, aspect, zNear, zFar);
        }
        this.g.perspective(fovy, aspect, zNear, zFar);
    }

    public void frustum(float left, float right, float bottom, float top, float near, float far) {
        if (this.recorder != null) {
            this.recorder.frustum(left, right, bottom, top, near, far);
        }
        this.g.frustum(left, right, bottom, top, near, far);
    }

    public void printProjection() {
        if (this.recorder != null) {
            this.recorder.printProjection();
        }
        this.g.printProjection();
    }

    public float screenX(float x, float y) {
        return this.g.screenX(x, y);
    }

    public float screenY(float x, float y) {
        return this.g.screenY(x, y);
    }

    public float screenX(float x, float y, float z) {
        return this.g.screenX(x, y, z);
    }

    public float screenY(float x, float y, float z) {
        return this.g.screenY(x, y, z);
    }

    public float screenZ(float x, float y, float z) {
        return this.g.screenZ(x, y, z);
    }

    public float modelX(float x, float y, float z) {
        return this.g.modelX(x, y, z);
    }

    public float modelY(float x, float y, float z) {
        return this.g.modelY(x, y, z);
    }

    public float modelZ(float x, float y, float z) {
        return this.g.modelZ(x, y, z);
    }

    public void pushStyle() {
        if (this.recorder != null) {
            this.recorder.pushStyle();
        }
        this.g.pushStyle();
    }

    public void popStyle() {
        if (this.recorder != null) {
            this.recorder.popStyle();
        }
        this.g.popStyle();
    }

    public void style(PStyle s) {
        if (this.recorder != null) {
            this.recorder.style(s);
        }
        this.g.style(s);
    }

    public void strokeWeight(float weight) {
        if (this.recorder != null) {
            this.recorder.strokeWeight(weight);
        }
        this.g.strokeWeight(weight);
    }

    public void strokeJoin(int join) {
        if (this.recorder != null) {
            this.recorder.strokeJoin(join);
        }
        this.g.strokeJoin(join);
    }

    public void strokeCap(int cap) {
        if (this.recorder != null) {
            this.recorder.strokeCap(cap);
        }
        this.g.strokeCap(cap);
    }

    public void noStroke() {
        if (this.recorder != null) {
            this.recorder.noStroke();
        }
        this.g.noStroke();
    }

    public void stroke(int rgb) {
        if (this.recorder != null) {
            this.recorder.stroke(rgb);
        }
        this.g.stroke(rgb);
    }

    public void stroke(int rgb, float alpha) {
        if (this.recorder != null) {
            this.recorder.stroke(rgb, alpha);
        }
        this.g.stroke(rgb, alpha);
    }

    public void stroke(float gray) {
        if (this.recorder != null) {
            this.recorder.stroke(gray);
        }
        this.g.stroke(gray);
    }

    public void stroke(float gray, float alpha) {
        if (this.recorder != null) {
            this.recorder.stroke(gray, alpha);
        }
        this.g.stroke(gray, alpha);
    }

    public void stroke(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.stroke(x, y, z);
        }
        this.g.stroke(x, y, z);
    }

    public void stroke(float x, float y, float z, float a) {
        if (this.recorder != null) {
            this.recorder.stroke(x, y, z, a);
        }
        this.g.stroke(x, y, z, a);
    }

    public void noTint() {
        if (this.recorder != null) {
            this.recorder.noTint();
        }
        this.g.noTint();
    }

    public void tint(int rgb) {
        if (this.recorder != null) {
            this.recorder.tint(rgb);
        }
        this.g.tint(rgb);
    }

    public void tint(int rgb, float alpha) {
        if (this.recorder != null) {
            this.recorder.tint(rgb, alpha);
        }
        this.g.tint(rgb, alpha);
    }

    public void tint(float gray) {
        if (this.recorder != null) {
            this.recorder.tint(gray);
        }
        this.g.tint(gray);
    }

    public void tint(float gray, float alpha) {
        if (this.recorder != null) {
            this.recorder.tint(gray, alpha);
        }
        this.g.tint(gray, alpha);
    }

    public void tint(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.tint(x, y, z);
        }
        this.g.tint(x, y, z);
    }

    public void tint(float x, float y, float z, float a) {
        if (this.recorder != null) {
            this.recorder.tint(x, y, z, a);
        }
        this.g.tint(x, y, z, a);
    }

    public void noFill() {
        if (this.recorder != null) {
            this.recorder.noFill();
        }
        this.g.noFill();
    }

    public void fill(int rgb) {
        if (this.recorder != null) {
            this.recorder.fill(rgb);
        }
        this.g.fill(rgb);
    }

    public void fill(int rgb, float alpha) {
        if (this.recorder != null) {
            this.recorder.fill(rgb, alpha);
        }
        this.g.fill(rgb, alpha);
    }

    public void fill(float gray) {
        if (this.recorder != null) {
            this.recorder.fill(gray);
        }
        this.g.fill(gray);
    }

    public void fill(float gray, float alpha) {
        if (this.recorder != null) {
            this.recorder.fill(gray, alpha);
        }
        this.g.fill(gray, alpha);
    }

    public void fill(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.fill(x, y, z);
        }
        this.g.fill(x, y, z);
    }

    public void fill(float x, float y, float z, float a) {
        if (this.recorder != null) {
            this.recorder.fill(x, y, z, a);
        }
        this.g.fill(x, y, z, a);
    }

    public void ambient(int rgb) {
        if (this.recorder != null) {
            this.recorder.ambient(rgb);
        }
        this.g.ambient(rgb);
    }

    public void ambient(float gray) {
        if (this.recorder != null) {
            this.recorder.ambient(gray);
        }
        this.g.ambient(gray);
    }

    public void ambient(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.ambient(x, y, z);
        }
        this.g.ambient(x, y, z);
    }

    public void specular(int rgb) {
        if (this.recorder != null) {
            this.recorder.specular(rgb);
        }
        this.g.specular(rgb);
    }

    public void specular(float gray) {
        if (this.recorder != null) {
            this.recorder.specular(gray);
        }
        this.g.specular(gray);
    }

    public void specular(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.specular(x, y, z);
        }
        this.g.specular(x, y, z);
    }

    public void shininess(float shine) {
        if (this.recorder != null) {
            this.recorder.shininess(shine);
        }
        this.g.shininess(shine);
    }

    public void emissive(int rgb) {
        if (this.recorder != null) {
            this.recorder.emissive(rgb);
        }
        this.g.emissive(rgb);
    }

    public void emissive(float gray) {
        if (this.recorder != null) {
            this.recorder.emissive(gray);
        }
        this.g.emissive(gray);
    }

    public void emissive(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.emissive(x, y, z);
        }
        this.g.emissive(x, y, z);
    }

    public void lights() {
        if (this.recorder != null) {
            this.recorder.lights();
        }
        this.g.lights();
    }

    public void noLights() {
        if (this.recorder != null) {
            this.recorder.noLights();
        }
        this.g.noLights();
    }

    public void ambientLight(float red, float green, float blue) {
        if (this.recorder != null) {
            this.recorder.ambientLight(red, green, blue);
        }
        this.g.ambientLight(red, green, blue);
    }

    public void ambientLight(float red, float green, float blue, float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.ambientLight(red, green, blue, x, y, z);
        }
        this.g.ambientLight(red, green, blue, x, y, z);
    }

    public void directionalLight(float red, float green, float blue, float nx, float ny, float nz) {
        if (this.recorder != null) {
            this.recorder.directionalLight(red, green, blue, nx, ny, nz);
        }
        this.g.directionalLight(red, green, blue, nx, ny, nz);
    }

    public void pointLight(float red, float green, float blue, float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.pointLight(red, green, blue, x, y, z);
        }
        this.g.pointLight(red, green, blue, x, y, z);
    }

    public void spotLight(float red, float green, float blue, float x, float y, float z, float nx, float ny, float nz, float angle, float concentration) {
        if (this.recorder != null) {
            this.recorder.spotLight(red, green, blue, x, y, z, nx, ny, nz, angle, concentration);
        }
        this.g.spotLight(red, green, blue, x, y, z, nx, ny, nz, angle, concentration);
    }

    public void lightFalloff(float constant, float linear, float quadratic) {
        if (this.recorder != null) {
            this.recorder.lightFalloff(constant, linear, quadratic);
        }
        this.g.lightFalloff(constant, linear, quadratic);
    }

    public void lightSpecular(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.lightSpecular(x, y, z);
        }
        this.g.lightSpecular(x, y, z);
    }

    public void background(int rgb) {
        if (this.recorder != null) {
            this.recorder.background(rgb);
        }
        this.g.background(rgb);
    }

    public void background(int rgb, float alpha) {
        if (this.recorder != null) {
            this.recorder.background(rgb, alpha);
        }
        this.g.background(rgb, alpha);
    }

    public void background(float gray) {
        if (this.recorder != null) {
            this.recorder.background(gray);
        }
        this.g.background(gray);
    }

    public void background(float gray, float alpha) {
        if (this.recorder != null) {
            this.recorder.background(gray, alpha);
        }
        this.g.background(gray, alpha);
    }

    public void background(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.background(x, y, z);
        }
        this.g.background(x, y, z);
    }

    public void background(float x, float y, float z, float a) {
        if (this.recorder != null) {
            this.recorder.background(x, y, z, a);
        }
        this.g.background(x, y, z, a);
    }

    public void background(PImage image) {
        if (this.recorder != null) {
            this.recorder.background(image);
        }
        this.g.background(image);
    }

    public void colorMode(int mode) {
        if (this.recorder != null) {
            this.recorder.colorMode(mode);
        }
        this.g.colorMode(mode);
    }

    public void colorMode(int mode, float max) {
        if (this.recorder != null) {
            this.recorder.colorMode(mode, max);
        }
        this.g.colorMode(mode, max);
    }

    public void colorMode(int mode, float maxX, float maxY, float maxZ) {
        if (this.recorder != null) {
            this.recorder.colorMode(mode, maxX, maxY, maxZ);
        }
        this.g.colorMode(mode, maxX, maxY, maxZ);
    }

    public void colorMode(int mode, float maxX, float maxY, float maxZ, float maxA) {
        if (this.recorder != null) {
            this.recorder.colorMode(mode, maxX, maxY, maxZ, maxA);
        }
        this.g.colorMode(mode, maxX, maxY, maxZ, maxA);
    }

    public final float alpha(int what) {
        return this.g.alpha(what);
    }

    public final float red(int what) {
        return this.g.red(what);
    }

    public final float green(int what) {
        return this.g.green(what);
    }

    public final float blue(int what) {
        return this.g.blue(what);
    }

    public final float hue(int what) {
        return this.g.hue(what);
    }

    public final float saturation(int what) {
        return this.g.saturation(what);
    }

    public final float brightness(int what) {
        return this.g.brightness(what);
    }

    public int lerpColor(int c1, int c2, float amt) {
        return this.g.lerpColor(c1, c2, amt);
    }

    public static int lerpColor(int c1, int c2, float amt, int mode) {
        return PGraphics.lerpColor(c1, c2, amt, mode);
    }

    public boolean displayable() {
        return this.g.displayable();
    }

    public void setCache(Object parent, Object storage) {
        if (this.recorder != null) {
            this.recorder.setCache(parent, storage);
        }
        this.g.setCache(parent, storage);
    }

    public Object getCache(Object parent) {
        return this.g.getCache(parent);
    }

    public void removeCache(Object parent) {
        if (this.recorder != null) {
            this.recorder.removeCache(parent);
        }
        this.g.removeCache(parent);
    }

    public int get(int x, int y) {
        return this.g.get(x, y);
    }

    public PImage get(int x, int y, int w, int h) {
        return this.g.get(x, y, w, h);
    }

    public PImage get() {
        return this.g.get();
    }

    public void set(int x, int y, int c) {
        if (this.recorder != null) {
            this.recorder.set(x, y, c);
        }
        this.g.set(x, y, c);
    }

    public void set(int x, int y, PImage src) {
        if (this.recorder != null) {
            this.recorder.set(x, y, src);
        }
        this.g.set(x, y, src);
    }

    public void mask(int[] maskArray) {
        if (this.recorder != null) {
            this.recorder.mask(maskArray);
        }
        this.g.mask(maskArray);
    }

    public void mask(PImage maskImg) {
        if (this.recorder != null) {
            this.recorder.mask(maskImg);
        }
        this.g.mask(maskImg);
    }

    public void filter(int kind) {
        if (this.recorder != null) {
            this.recorder.filter(kind);
        }
        this.g.filter(kind);
    }

    public void filter(int kind, float param) {
        if (this.recorder != null) {
            this.recorder.filter(kind, param);
        }
        this.g.filter(kind, param);
    }

    public void copy(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        if (this.recorder != null) {
            this.recorder.copy(sx, sy, sw, sh, dx, dy, dw, dh);
        }
        this.g.copy(sx, sy, sw, sh, dx, dy, dw, dh);
    }

    public void copy(PImage src, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        if (this.recorder != null) {
            this.recorder.copy(src, sx, sy, sw, sh, dx, dy, dw, dh);
        }
        this.g.copy(src, sx, sy, sw, sh, dx, dy, dw, dh);
    }

    public static int blendColor(int c1, int c2, int mode) {
        return PGraphics.blendColor(c1, c2, mode);
    }

    public void blend(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh, int mode) {
        if (this.recorder != null) {
            this.recorder.blend(sx, sy, sw, sh, dx, dy, dw, dh, mode);
        }
        this.g.blend(sx, sy, sw, sh, dx, dy, dw, dh, mode);
    }

    public void blend(PImage src, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh, int mode) {
        if (this.recorder != null) {
            this.recorder.blend(src, sx, sy, sw, sh, dx, dy, dw, dh, mode);
        }
        this.g.blend(src, sx, sy, sw, sh, dx, dy, dw, dh, mode);
    }

    class AsyncImageLoader
    extends Thread {
        String filename;
        String extension;
        PImage vessel;

        public AsyncImageLoader(String filename, String extension, PImage vessel) {
            this.filename = filename;
            this.extension = extension;
            this.vessel = vessel;
        }

        public void run() {
            while (PApplet.this.requestImageCount == PApplet.this.requestImageMax) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++PApplet.this.requestImageCount;
            PImage actual = PApplet.this.loadImage(this.filename, this.extension);
            if (actual == null) {
                this.vessel.width = -1;
                this.vessel.height = -1;
            } else {
                this.vessel.width = actual.width;
                this.vessel.height = actual.height;
                this.vessel.format = actual.format;
                this.vessel.pixels = actual.pixels;
            }
            --PApplet.this.requestImageCount;
        }
    }

    public class RegisteredMethods {
        int count;
        Object[] objects;
        Method[] methods;

        public void handle() {
            this.handle(new Object[0]);
        }

        public void handle(Object[] oargs) {
            int i = 0;
            while (i < this.count) {
                try {
                    this.methods[i].invoke(this.objects[i], oargs);
                }
                catch (Exception e) {
                    if (e instanceof InvocationTargetException) {
                        InvocationTargetException ite = (InvocationTargetException)e;
                        ite.getTargetException().printStackTrace();
                    }
                    e.printStackTrace();
                }
                ++i;
            }
        }

        public void add(Object object, Method method) {
            if (this.objects == null) {
                this.objects = new Object[5];
                this.methods = new Method[5];
            }
            if (this.count == this.objects.length) {
                this.objects = (Object[])PApplet.expand(this.objects);
                this.methods = (Method[])PApplet.expand(this.methods);
            }
            this.objects[this.count] = object;
            this.methods[this.count] = method;
            ++this.count;
        }

        public void remove(Object object, Method method) {
            int index = this.findIndex(object, method);
            if (index != -1) {
                --this.count;
                int i = index;
                while (i < this.count) {
                    this.objects[i] = this.objects[i + 1];
                    this.methods[i] = this.methods[i + 1];
                    ++i;
                }
                this.objects[this.count] = null;
                this.methods[this.count] = null;
            }
        }

        protected int findIndex(Object object, Method method) {
            int i = 0;
            while (i < this.count) {
                if (this.objects[i] == object && this.methods[i].equals(method)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    public static class RendererChangeException
    extends RuntimeException {
    }
}

