import java.io.InputStream;
import java.io.OutputStream;
import java.util.*;

import gnu.io.*;

public class SerialController implements SerialPortEventListener{

	SerialPort serialPort;
	
	Model model;
	View view;
	
	private static final String PORT_NAMES[] = { 
		"/dev/tty.usbserial-A4001Kzu", // Mac OS X
		//"/dev/ttyUSB0", // Linux
		//"COM3", // Windows
	};

	private static final int DATA_RATE = 9600;
	private static final int TIME_OUT = 4000;

	/** Buffered input stream from the port */
	private InputStream input;
	/** The output stream to the port */
	private OutputStream output;

	public void initialize() {
		CommPortIdentifier portId = null;
		Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();

		// iterate through, looking for the port
		while (portEnum.hasMoreElements()) {
			CommPortIdentifier currPortId = (CommPortIdentifier) portEnum.nextElement();
			for (String portName : PORT_NAMES) {
				if (currPortId.getName().equals(portName)) {
					portId = currPortId;
					break;
				}
			}
		}

		if (portId == null) {
			//System.out.println("Could not find serial port.");
			return;
		}

		try {
			// open serial port, and use class name for the appName.
			serialPort = (SerialPort) portId.open(this.getClass().getName(),
					TIME_OUT);

			// set port parameters
			serialPort.setSerialPortParams(DATA_RATE,
					SerialPort.DATABITS_8,
					SerialPort.STOPBITS_1,
					SerialPort.PARITY_NONE);

			// open the streams
			input = serialPort.getInputStream();
			output = serialPort.getOutputStream();

			// add event listeners
			serialPort.addEventListener(this);
			serialPort.notifyOnDataAvailable(true);
		} catch (Exception e) {
			//System.err.println(e.toString());
		}
	}

	public synchronized void close() {
		if (serialPort != null) {
			serialPort.removeEventListener();
			serialPort.close();
		}
	}

	@Override
	public void serialEvent(SerialPortEvent oEvent) {
		if (model.getxPos() >= 400) {
			model.setxPos(0);
			view.update(null, model);
		} else {
			// increment the horizontal position:
			model.setxPos(model.getxPos()+1);
			view.update(null, model);
		}

		if (oEvent.getEventType() == SerialPortEvent.DATA_AVAILABLE) {
			try {
				int available = input.available();
				byte chunk[] = new byte[available];
				input.read(chunk, 0, available);
				String inputSerialData=(new String(chunk));
				try{
					float temp=Float.parseFloat(inputSerialData);
					model.setBarlength(temp);
				}
				catch (NumberFormatException e) {
					//System.out.println("Error Inside Controller: "+e.getMessage());
				}

			} catch (Exception e) {
				//System.err.println(e.toString());
			}

		}
		// Ignore all the other eventTypes, but you should consider the other ones.

	}

	public void addModel(Model m){
		//System.out.println("Controller: adding model");
		this.model = m;
	} //addModel()

	public void addView(View  v){
		this.view = v;
	} //addView()

}
