import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.*;
import javax.swing.*;

public class EnergyDiagramPanel extends CustomPanel {

	private int X_position; // the bar's X-position on screen
	private float LineHeight;  // the bar's height

	public EnergyDiagramPanel(Color c, Dimension d) {
		super(c,d);
		X_position=0;
		LineHeight=0;
	}

	public void paintComponent(Graphics g) {
		//super.paintComponent(g); //Un-comment if you want to have just one line each time and delete previous lines. 

		if (X_position == 0   ||  X_position == 400) {
			super.paintComponent(g); // if reached to the end of Panel, delete previous lines and start from X position=0
		}

		Graphics2D g2d = (Graphics2D) g;
		g2d.setColor(Color.blue);
		g2d.drawLine((int) X_position, (int) getHeight(), (int) X_position, // Draw the bar
				(int) (getHeight() - LineHeight));
	}

	public static class CloseListener extends WindowAdapter {
		public void windowClosing(WindowEvent e) {
			e.getWindow().setVisible(false);
			System.exit(0);
		} //windowClosing()
	} //CloseListener


	public int getX_position() {
		return X_position;
	}

	public void setX_position(int x_position) {
		X_position = x_position;
	}

	public float getLineHeight() {
		return LineHeight;
	}

	public void setLineHeight(float lineHeight) {
		LineHeight = lineHeight;
	}

}
