import java.awt.*;
import javax.swing.*;
import processing.core.*;
import processing.serial.*;

public class SerialController extends PApplet{ 
	
	static Serial myPort; // The serial port
	private int time; // This class calculates the graph bars' horizontal positions 
	private float barlength; // This class calculates the length of the bars
	Model myModel;
	View myView;
	private static final int DATA_RATE = 9600;
	private static final int MAXTIME = 400;

	public void setup() {
		time=0;
		barlength=0;
		
		myView = new View ();
		myModel = new Model();
		
		this.setSize(new Dimension(1, 1));	

		myPort = new Serial(this, Serial.list()[1], DATA_RATE);
		myPort.bufferUntil('\n');
	}

	public void draw() {

	}

	public void serialEvent(Serial myPort) {
		// get the ASCII string:
		String inputSerialData = myPort.readStringUntil('\n');

		if (inputSerialData != null) {
			inputSerialData = trim(inputSerialData);			
		}
		// at the edge of the screen, go back to the beginning:

		if (time >= MAXTIME) {
			time=0; 	// Time passed. Start again.

		} else {
			// time increments. Model will increment the horizontal position.
			time++;
		}

		myModel.update(time,inputSerialData);
		myView.update(null, myModel);		
	}

}
