/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.ColorPicker;
import controlP5.ControlP5;
import controlP5.ControllerInterface;
import controlP5.ControllerLayoutElement;
import controlP5.DropdownList;
import controlP5.ListBox;
import controlP5.RadioButton;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ControllerLayout {
    private ControlP5 cp5;
    public static final Logger logger = Logger.getLogger(ControllerLayout.class.getName());

    ControllerLayout(ControlP5 controlP5) {
        this.cp5 = controlP5;
    }

    public void save(String string) {
        string = this.cp5.checkPropertiesPath(string);
        Class[] classArray = new Class[]{RadioButton.class, ListBox.class, ColorPicker.class, DropdownList.class};
        HashSet<ControllerLayoutElement> hashSet = new HashSet<ControllerLayoutElement>();
        for (ControllerInterface<?> object : this.cp5.getList()) {
            if (Arrays.asList(classArray).contains(object.getParent().getClass())) continue;
            hashSet.add(new ControllerLayoutElement(object));
            System.out.print(object.getAddress());
            System.out.print(" (" + object.getName() + ") ");
            System.out.print("\tpos:" + object.getPosition().x + "," + object.getPosition().y);
            System.out.print("\tdim:" + object.getWidth() + "," + object.getHeight());
            System.out.print("\tparent:" + object.getParent());
            System.out.println("\tclass:" + object.getClass().getSimpleName());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            logger.info("Saving layout-items to " + string);
            objectOutputStream.writeInt(hashSet.size());
            for (ControllerLayoutElement controllerLayoutElement : hashSet) {
                objectOutputStream.writeObject(controllerLayoutElement);
            }
            objectOutputStream.flush();
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            logger.warning("Exception during serialization: " + exception);
        }
    }

    protected boolean isClassAssignableFromSuperclass(Class<?> clazz, Class<?> clazz2) {
        Class<?> clazz3 = clazz.getSuperclass();
        while (clazz3.getSuperclass() != null) {
            if (clazz3.isAssignableFrom(clazz2)) {
                return true;
            }
            clazz3 = clazz3.getSuperclass();
        }
        return false;
    }

    public void load(String string) {
        string = this.cp5.checkPropertiesPath(string);
        ArrayList<ControllerLayoutElement> arrayList = new ArrayList<ControllerLayoutElement>();
        try {
            Iterator iterator = new FileInputStream(string);
            ObjectInputStream object = new ObjectInputStream((InputStream)((Object)iterator));
            int n = object.readInt();
            logger.info("loading " + n + " layout-items." + ((FileInputStream)((Object)iterator)).getFD());
            for (int i = 0; i < n; ++i) {
                try {
                    ControllerLayoutElement controllerLayoutElement = (ControllerLayoutElement)object.readObject();
                    arrayList.add(controllerLayoutElement);
                    continue;
                }
                catch (Exception exception) {
                    logger.warning("skipping a property, " + exception);
                }
            }
            object.close();
        }
        catch (Exception exception) {
            logger.warning("Exception during deserialization: " + exception);
        }
        for (ControllerLayoutElement controllerLayoutElement : arrayList) {
        }
        for (ControllerLayoutElement controllerLayoutElement : arrayList) {
        }
    }

    static {
        HashMap<Class<CColor>, Class<Serializable>> hashMap = new HashMap<Class<CColor>, Class<Serializable>>();
        hashMap.put(Integer.class, Integer.TYPE);
        hashMap.put(Float.class, Float.TYPE);
        hashMap.put(Boolean.class, Boolean.TYPE);
        hashMap.put(Character.class, Character.TYPE);
        hashMap.put(Long.class, Long.TYPE);
        hashMap.put(Double.class, Double.TYPE);
        hashMap.put(Byte.class, Byte.TYPE);
        hashMap.put(PVector.class, PVector.class);
        hashMap.put(CColor.class, CColor.class);
    }
}

