/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import controlP5.Label;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slider2D
extends Controller<Slider2D> {
    protected int cursorWidth = 10;
    protected int cursorHeight = 10;
    protected float cursorX;
    protected float cursorY;
    protected float _myMinX;
    protected float _myMinY;
    protected float _myMaxX;
    protected float _myMaxY;
    public boolean isCrosshairs = true;
    private String _myValueLabelSeparator = ",";

    public Slider2D(ControlP5 controlP5, String string) {
        this(controlP5, (ControllerGroup<?>)controlP5.getDefaultTab(), string, 0, 0, 99, 9);
        controlP5.register(controlP5.papplet, string, this);
    }

    protected Slider2D(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this._myArrayValue = new float[]{0.0f, 0.0f};
        this._myMinX = 0.0f;
        this._myMinY = 0.0f;
        this._myMaxX = n3;
        this._myMaxY = n4;
        this.getCaptionLabel().setPadding(0, Label.paddingY).align(37, 13);
        this.getValueLabel().setPadding(0, Label.paddingY).align(39, 13);
    }

    @Override
    @ControlP5.Invisible
    public Slider2D updateInternalEvents(PApplet pApplet) {
        if (this.isInside() && !this.cp5.isAltDown()) {
            float f = PApplet.constrain((float)((float)this._myControlWindow.mouseX - (this._myParent.getAbsolutePosition().x + this.position.x)), (float)0.0f, (float)(this.width - this.cursorWidth));
            float f2 = PApplet.constrain((float)((float)this._myControlWindow.mouseY - (this._myParent.getAbsolutePosition().y + this.position.y)), (float)0.0f, (float)(this.height - this.cursorHeight));
            if (this.isMousePressed) {
                this.cursorX = f;
                this.cursorY = f2;
                this.updateValue();
            }
        }
        return this;
    }

    Slider2D updateValue() {
        return this.setValue(0.0f);
    }

    public Slider2D setMinX(float f) {
        this._myMinX = f;
        return this.updateValue();
    }

    public Slider2D setMinY(float f) {
        this._myMinY = f;
        return this.updateValue();
    }

    public Slider2D setMaxX(float f) {
        this._myMaxX = f;
        return this.updateValue();
    }

    public Slider2D setMaxY(float f) {
        this._myMaxY = f;
        return this.updateValue();
    }

    public float getMinX() {
        return this._myMinX;
    }

    public float getMinY() {
        return this._myMinY;
    }

    public float getMaxX() {
        return this._myMaxX;
    }

    public float getMaxY() {
        return this._myMaxY;
    }

    public float getCursorX() {
        return this.cursorX;
    }

    public float getCursorY() {
        return this.cursorY;
    }

    public float getCursorWidth() {
        return this.cursorWidth;
    }

    public float getCursorHeight() {
        return this.cursorHeight;
    }

    public Slider2D disableCrosshair() {
        this.isCrosshairs = false;
        return this;
    }

    public Slider2D enableCrosshair() {
        this.isCrosshairs = false;
        return this;
    }

    @Override
    public Slider2D setArrayValue(float[] fArray) {
        this._myArrayValue = fArray;
        float f = (float)(this.width - this.cursorWidth) / (this._myMaxX - this._myMinX);
        float f2 = (float)(this.height - this.cursorHeight) / (this._myMaxY - this._myMinY);
        this.cursorX = PApplet.constrain((float)(fArray[0] * f), (float)0.0f, (float)(this.width - this.cursorWidth));
        this.cursorY = PApplet.constrain((float)(fArray[1] * f2), (float)0.0f, (float)(this.height - this.cursorHeight));
        return this.updateValue();
    }

    @Override
    public float[] getArrayValue() {
        return this._myArrayValue;
    }

    @Override
    public Slider2D setValue(float f) {
        this._myArrayValue[0] = this.cursorX / ((float)(this.width - this.cursorWidth) / (float)this.width);
        this._myArrayValue[1] = this.cursorY / ((float)(this.height - this.cursorHeight) / (float)this.height);
        this._myArrayValue[0] = PApplet.map((float)this._myArrayValue[0], (float)0.0f, (float)this.width, (float)this._myMinX, (float)this._myMaxX);
        this._myArrayValue[1] = PApplet.map((float)this._myArrayValue[1], (float)0.0f, (float)this.height, (float)this._myMinY, (float)this._myMaxY);
        this._myValueLabel.set(this.adjustValue(this._myArrayValue[0], 0) + this._myValueLabelSeparator + this.adjustValue(this._myArrayValue[1], 0));
        this.broadcast(2);
        return this;
    }

    public Slider2D shuffle() {
        float f = (float)Math.random();
        float f2 = (float)Math.random();
        this._myArrayValue[0] = f * (float)this.width;
        this._myArrayValue[0] = f2 * (float)this.height;
        return this.setValue(0.0f);
    }

    public void setValueLabelSeparator(String string) {
        this._myValueLabelSeparator = string;
    }

    @Override
    @ControlP5.Invisible
    public Slider2D updateDisplayMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myControllerView = new Slider2DView();
                break;
            }
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Slider2DView
    implements ControllerView<Slider2D> {
        Slider2DView() {
        }

        @Override
        public void display(PApplet pApplet, Slider2D slider2D) {
            pApplet.noStroke();
            if (slider2D.isInside()) {
                pApplet.fill(slider2D.getColor().getForeground());
            } else {
                pApplet.fill(slider2D.getColor().getBackground());
            }
            pApplet.rect(0.0f, 0.0f, (float)Slider2D.this.getWidth(), (float)Slider2D.this.getHeight());
            if (Slider2D.this.isCrosshairs) {
                if (slider2D.isInside()) {
                    pApplet.fill(slider2D.getColor().getBackground());
                } else {
                    pApplet.fill(slider2D.getColor().getForeground());
                }
                pApplet.rect(0.0f, (float)((int)(Slider2D.this.getCursorY() + Slider2D.this.getCursorHeight() / 2.0f)), (float)Slider2D.this.getWidth(), 1.0f);
                pApplet.rect((float)((int)(Slider2D.this.getCursorX() + Slider2D.this.getCursorWidth() / 2.0f)), 0.0f, 1.0f, (float)Slider2D.this.getHeight());
            }
            pApplet.fill(slider2D.getColor().getActive());
            pApplet.rect((float)((int)Slider2D.this.getCursorX()), (float)((int)Slider2D.this.getCursorY()), (float)((int)Slider2D.this.getCursorWidth()), (float)((int)Slider2D.this.getCursorHeight()));
            Slider2D.this.getCaptionLabel().draw(pApplet, 0, 0, slider2D);
            Slider2D.this.getValueLabel().draw(pApplet, 0, 0, slider2D);
        }
    }
}

