/*
 * Decompiled with CFR 0.152.
 */
package yu.org.goodoldai.air.wb.mdr.odm.property;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import yu.org.goodoldai.air.model.odm.OdmPackage;
import yu.org.goodoldai.air.model.odm.Ontology;
import yu.org.goodoldai.air.model.odm.OntologyClass;
import yu.org.goodoldai.air.model.odm.ResourceClass;
import yu.org.goodoldai.air.wb.core.adaptable.IAdaptableFactory;
import yu.org.goodoldai.air.wb.core.adaptable.IAdaptableFactoryProvider;
import yu.org.goodoldai.air.wb.core.adaptable.IAdaptableObject;
import yu.org.goodoldai.air.wb.mdr.core.AirMDRCore;
import yu.org.goodoldai.air.wb.mdr.odm.adaptable.IOntologyAdaptable;
import yu.org.goodoldai.air.wb.mdr.odm.property.ResourcePropertySource;
import yu.org.goodoldai.air.wb.ui.core.property.MultipleAdaptableObjectsPropertyDescriptor;
import yu.org.goodoldai.air.wb.ui.core.property.SingleAdaptableObjectPropertyDescriptor;

public class OntologyPropertySource
extends ResourcePropertySource {
    public static final String ONTOLOGY = "Ontology";
    public static final String PRIOR_VERSION = "yu.org.goodoldai.air.model.odm.Ontology.priorVersion";
    public static final String PRIOR_VERSION_LABEL = "prior version";
    public static final String BACKWARD_COMPATIBLE_WITH = "yu.org.goodoldai.air.model.odm.Ontology.backwardCompatibleWith";
    public static final String BACKWARD_COMPATIBLE_WITH_LABEL = "backward compatible with";
    public static final String INCOMPATIBLE_WITH = "yu.org.goodoldai.air.model.odm.Ontology.inompatibleWith";
    public static final String INCOMPATIBLE_WITH_LABEL = "incompatible with";
    public static final String IMPORTS = "yu.org.goodoldai.air.model.odm.Ontology.imports";
    public static final String IMPORTS_LABEL = "imports";
    public static final String CONTAINED_RESOURCES = "yu.org.goodoldai.air.model.odm.Ontology.containedResources";
    public static final String CONTAINED_RESOURCES_LABEL = "contained resources";

    public OntologyPropertySource(IOntologyAdaptable ontologyAdaptable) {
        super(ontologyAdaptable);
    }

    protected Map definePropertyDescriptors() {
        Map propertyDescriptors = super.definePropertyDescriptors();
        String category = ONTOLOGY;
        IAdaptableFactory typecentricFactory = this.getAdaptableFactoryManager().getAdaptableFactory(AirMDRCore.TYPECENTRIC_ID);
        OntologyClass ontologyClass = ((OdmPackage)((Ontology)this.getAdaptableObject().getElement()).refImmediatePackage()).getOntology();
        IAdaptableObject ontologyClassAdaptable = typecentricFactory.adapt((Object)ontologyClass);
        ((IAdaptableFactoryProvider)ontologyClassAdaptable).setAdaptableFactory(this.getAdaptableFactory());
        ResourceClass resourceClass = ((OdmPackage)((Ontology)this.getAdaptableObject().getElement()).refImmediatePackage()).getResource();
        IAdaptableObject resourceClassAdaptable = typecentricFactory.adapt((Object)resourceClass);
        ((IAdaptableFactoryProvider)resourceClassAdaptable).setAdaptableFactory(this.getAdaptableFactory());
        SingleAdaptableObjectPropertyDescriptor descriptor = new SingleAdaptableObjectPropertyDescriptor((Object)PRIOR_VERSION, PRIOR_VERSION_LABEL, (IAdaptable)ontologyClassAdaptable, "Select prior version of this Ontology.");
        descriptor.setAlwaysIncompatible(false);
        descriptor.setCategory(category);
        propertyDescriptors.put(PRIOR_VERSION, descriptor);
        IAdaptableObject[] backwardCompatibleAdaptables = ((Collection)this.getPropertyValue(BACKWARD_COMPATIBLE_WITH)).toArray(new IAdaptableObject[0]);
        descriptor = new MultipleAdaptableObjectsPropertyDescriptor((Object)BACKWARD_COMPATIBLE_WITH, BACKWARD_COMPATIBLE_WITH_LABEL, backwardCompatibleAdaptables, (IAdaptable)ontologyClassAdaptable, "Select Ontologies that this ontology is backward compatible with.");
        descriptor.setAlwaysIncompatible(false);
        descriptor.setCategory(category);
        propertyDescriptors.put(BACKWARD_COMPATIBLE_WITH, descriptor);
        IAdaptableObject[] incompatibleAdaptables = ((Collection)this.getPropertyValue(INCOMPATIBLE_WITH)).toArray(new IAdaptableObject[0]);
        descriptor = new MultipleAdaptableObjectsPropertyDescriptor((Object)INCOMPATIBLE_WITH, INCOMPATIBLE_WITH_LABEL, incompatibleAdaptables, (IAdaptable)ontologyClassAdaptable, "Select Ontologies that this ontology is not compatible with.");
        descriptor.setAlwaysIncompatible(false);
        descriptor.setCategory(category);
        propertyDescriptors.put(INCOMPATIBLE_WITH, descriptor);
        IAdaptableObject[] importsAdaptables = ((Collection)this.getPropertyValue(IMPORTS)).toArray(new IAdaptableObject[0]);
        descriptor = new MultipleAdaptableObjectsPropertyDescriptor((Object)IMPORTS, IMPORTS_LABEL, importsAdaptables, (IAdaptable)ontologyClassAdaptable, "Select Ontologies that this ontology imports.");
        descriptor.setAlwaysIncompatible(false);
        descriptor.setCategory(category);
        propertyDescriptors.put(IMPORTS, descriptor);
        IAdaptableObject[] containedResourcesAdaptables = ((Collection)this.getPropertyValue(CONTAINED_RESOURCES)).toArray(new IAdaptableObject[0]);
        descriptor = new MultipleAdaptableObjectsPropertyDescriptor((Object)CONTAINED_RESOURCES, CONTAINED_RESOURCES_LABEL, containedResourcesAdaptables, (IAdaptable)resourceClassAdaptable, "Select Resources that will be included in this Ontology.");
        descriptor.setAlwaysIncompatible(false);
        descriptor.setCategory(category);
        propertyDescriptors.put(CONTAINED_RESOURCES, descriptor);
        return propertyDescriptors;
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(PRIOR_VERSION)) {
            return this.adapt(((Ontology)this.getAdaptableObject().getElement()).getPriorVersion());
        }
        if (id.equals(BACKWARD_COMPATIBLE_WITH)) {
            return this.adaptAll(((Ontology)this.getAdaptableObject().getElement()).getBackwardCompatibleWith());
        }
        if (id.equals(INCOMPATIBLE_WITH)) {
            return this.adaptAll(((Ontology)this.getAdaptableObject().getElement()).getIncompatibleWith());
        }
        if (id.equals(IMPORTS)) {
            return this.adaptAll(((Ontology)this.getAdaptableObject().getElement()).getImports());
        }
        if (id.equals(CONTAINED_RESOURCES)) {
            return this.adaptAll(((Ontology)this.getAdaptableObject().getElement()).getContainedResources());
        }
        return super.getPropertyValue(id);
    }

    public void setTransactionPropertyValue(Object id, Object value) {
        if (id.equals(PRIOR_VERSION)) {
            ((Ontology)this.getAdaptableObject().getElement()).setPriorVersion((Ontology)((IAdaptableObject)value).getElement());
        }
        if (id.equals(BACKWARD_COMPATIBLE_WITH)) {
            Collection backwardCompatibleWith = this.unadaptAll((Collection)value);
            ((Ontology)this.getAdaptableObject().getElement()).getBackwardCompatibleWith().retainAll(backwardCompatibleWith);
            ((Ontology)this.getAdaptableObject().getElement()).getBackwardCompatibleWith().addAll(backwardCompatibleWith);
        }
        if (id.equals(INCOMPATIBLE_WITH)) {
            Collection incompatibleWith = this.unadaptAll((Collection)value);
            ((Ontology)this.getAdaptableObject().getElement()).getIncompatibleWith().retainAll(incompatibleWith);
            ((Ontology)this.getAdaptableObject().getElement()).getIncompatibleWith().addAll(incompatibleWith);
        }
        if (id.equals(IMPORTS)) {
            Collection imports = this.unadaptAll((Collection)value);
            ((Ontology)this.getAdaptableObject().getElement()).getImports().retainAll(imports);
            ((Ontology)this.getAdaptableObject().getElement()).getImports().addAll(imports);
        }
        if (id.equals(CONTAINED_RESOURCES)) {
            Collection containedResources = this.unadaptAll((Collection)value);
            ((Ontology)this.getAdaptableObject().getElement()).getContainedResources().retainAll(containedResources);
            ((Ontology)this.getAdaptableObject().getElement()).getContainedResources().addAll(containedResources);
        }
        super.setTransactionPropertyValue(id, value);
    }
}

