/*
 * Decompiled with CFR 0.152.
 */
package yu.org.goodoldai.air.wb.mdr.core.internals;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ListenerList;
import yu.org.goodoldai.air.wb.core.IAdaptablesRegistrator;
import yu.org.goodoldai.air.wb.core.IAdaptersRegistrator;
import yu.org.goodoldai.air.wb.core.adaptable.IAdaptableFactory;
import yu.org.goodoldai.air.wb.core.adaptable.IAdaptableFactoryManager;
import yu.org.goodoldai.air.wb.core.adaptable.IAdaptableObject;
import yu.org.goodoldai.air.wb.core.adaptable.common.AdaptableFactory;
import yu.org.goodoldai.air.wb.core.adaptable.common.AdaptableFactoryManager;
import yu.org.goodoldai.air.wb.core.adaptable.events.AdaptableObjectEvent;
import yu.org.goodoldai.air.wb.core.adaptable.events.IAdaptableObjectListener;
import yu.org.goodoldai.air.wb.mdr.core.adaptable.repository.IAirMDRepositoryAdaptable;

public class AirMDRCorePlugin
extends Plugin {
    private static final String LISTENER_ID = "yu.org.goodoldai.air.wb.mdr.core.listeners";
    private static final String ADAPTERS_ID = "yu.org.goodoldai.air.wb.mdr.core.adapters";
    private static final String CLASS_LOADERS_ID = "yu.org.goodoldai.air.wb.mdr.core.classloaders";
    public static final String ICON_PATH = "icons/";
    private static final String ADAPTABLES_ID = "yu.org.goodoldai.air.wb.mdr.core.adaptables";
    private IAdaptableFactoryManager adaptableFactoryManager = new AdaptableFactoryManager();
    private static AirMDRCorePlugin instance;
    private ResourceBundle resourceBundle;
    private ListenerList listeners;
    private Collection adapters;
    private IAirMDRepositoryAdaptable repositoryAdaptable;

    public AirMDRCorePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        instance = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("yu.org.goodoldai.air.wb.mdr.core.resources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static AirMDRCorePlugin getDefault() {
        return instance;
    }

    public IAdaptableFactoryManager getAdaptableFactoryManager() {
        return this.adaptableFactoryManager;
    }

    private ListenerList getListeners() {
        if (this.listeners == null) {
            this.listeners = this.computeListeners();
        }
        return this.listeners;
    }

    private ListenerList computeListeners() {
        IPluginRegistry registry = Platform.getPluginRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(LISTENER_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        ListenerList results = new ListenerList();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                try {
                    Object listener = elements[j].createExecutableExtension("class");
                    if (listener instanceof IAdaptableObjectListener) {
                        results.add(listener);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        return results;
    }

    public void addListener(IAdaptableObjectListener listener) {
        this.getListeners().add((Object)listener);
    }

    public void removeListener(IAdaptableObjectListener listener) {
        this.getListeners().remove((Object)listener);
    }

    private Collection getAdapters() {
        if (this.adapters == null) {
            this.adapters = this.computeAdapters();
        }
        return this.adapters;
    }

    private Collection computeAdapters() {
        IPluginRegistry registry = Platform.getPluginRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(ADAPTERS_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        ArrayList<Object> results = new ArrayList<Object>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                try {
                    Object adaptersRegistrator = elements[j].createExecutableExtension("class");
                    if (adaptersRegistrator instanceof IAdaptersRegistrator) {
                        results.add(adaptersRegistrator);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        return results;
    }

    public void changeRepository() {
        Object[] listeners = this.getListeners().getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IAdaptableObjectListener)listeners[i]).change(new AdaptableObjectEvent((IAdaptableObject)this.getRepositoryAdaptable()));
            ++i;
        }
    }

    public IAirMDRepositoryAdaptable getRepositoryAdaptable() {
        return this.repositoryAdaptable;
    }

    public void setRepositoryAdaptable(IAirMDRepositoryAdaptable repositoryAdaptable) {
        this.repositoryAdaptable = repositoryAdaptable;
        this.changeRepository();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = AirMDRCorePlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        try {
            URL installURL = AirMDRCorePlugin.getDefault().getDescriptor().getInstallURL();
            URL url = new URL(installURL, ICON_PATH + name);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void startup() throws CoreException {
        super.startup();
        this.initAdaptables();
        this.initAdapters();
    }

    private void initAdapters() {
        Collection adaptersRegistratorList = this.getAdapters();
        Object[] adaptersRegistrators = adaptersRegistratorList.toArray();
        int i = 0;
        while (i < adaptersRegistrators.length) {
            ((IAdaptersRegistrator)adaptersRegistrators[i]).registerAdapters();
            ++i;
        }
    }

    private void initAdaptables() {
        IPluginRegistry registry = Platform.getPluginRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(ADAPTABLES_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                try {
                    Object adaptablesRegistrator = elements[j].createExecutableExtension("class");
                    String factoryId = elements[j].getAttributeAsIs("factoryId");
                    if (adaptablesRegistrator instanceof IAdaptablesRegistrator) {
                        IAdaptableFactory adaptableFactory = this.getAdaptableFactoryManager().getAdaptableFactory(factoryId);
                        if (adaptableFactory == null) {
                            adaptableFactory = new AdaptableFactory(factoryId);
                            this.getAdaptableFactoryManager().addAdaptableFactory(adaptableFactory);
                        }
                        ((IAdaptablesRegistrator)adaptablesRegistrator).registerAdaptables(adaptableFactory);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
    }
}

