/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.model.AggregationKindEnum;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Attribute;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.Feature;
import javax.jmi.model.GeneralizableElement;
import javax.jmi.model.Import;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofPackage;
import javax.jmi.model.Namespace;
import javax.jmi.model.Operation;
import javax.jmi.model.Reference;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import javax.jmi.model.Tag;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.XmiReader;
import org.netbeans.api.mdr.CreationFailedException;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.mdr.events.ExtentEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.handlers.ImmutableList;
import org.netbeans.mdr.handlers.InstanceHandler;
import org.netbeans.mdr.handlers.gen.TagSupport;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.BootReader;
import org.netbeans.mdr.storagemodel.DatatypeDescriptor;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableAssociation;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.storagemodel.StorablePackage;
import org.netbeans.mdr.storagemodel.TransientStorableAssociation;
import org.netbeans.mdr.storagemodel.TransientStorableClass;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;
import org.netbeans.mdr.util.MountFailedException;
import org.openide.util.Lookup;

public class NBMDRepositoryImpl
implements MDRepository {
    private static final URL MOF_XML_URL = (class$javax$jmi$model$ModelPackage == null ? (class$javax$jmi$model$ModelPackage = NBMDRepositoryImpl.class$("javax.jmi.model.ModelPackage")) : class$javax$jmi$model$ModelPackage).getResource("resources/mof.xml");
    private static final URL BOOTMOF_XML_URL = (class$javax$jmi$model$ModelPackage == null ? (class$javax$jmi$model$ModelPackage = NBMDRepositoryImpl.class$("javax.jmi.model.ModelPackage")) : class$javax$jmi$model$ModelPackage).getResource("resources/mof.xml");
    private static final String TAGID_INDEX = "org.netbeans.attributeIndex";
    private static final String PARAM_STORAGE_CLASS = "storage";
    private static final String TRANSIENT_TAG_ID = "org.netbeans.mdr.transient";
    private static final String TAG_VALUE_TRUE = "true";
    public static final String BOOT_MOF = "BootMOF";
    public static final String PURE_MOF = "MOF";
    private MdrStorage mdrStorage = null;
    private Map classProxies = null;
    private Map associationProxies = null;
    private Map classProxiesMofIds = null;
    private final Map parameters;
    static /* synthetic */ Class class$javax$jmi$model$ModelPackage;
    static /* synthetic */ Class class$javax$jmi$xmi$XmiReader;

    public NBMDRepositoryImpl() {
        String storageClass = System.getProperty("org.netbeans.mdr.storagemodel.StorageFactoryClassName", "org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeFactory");
        String storageFile = System.getProperty("org.netbeans.mdr.persistence.Dir");
        Logger.getDefault().log("Storage factory: " + storageClass);
        this.parameters = new HashMap();
        this.parameters.put(PARAM_STORAGE_CLASS, storageClass);
        this.parameters.put("org.netbeans.mdr.persistence.btreeimpl.filename", storageFile);
    }

    public NBMDRepositoryImpl(Map parameters) {
        Logger.getDefault().log("Creating MDRepository implementation ...");
        this.parameters = parameters;
    }

    public void addListener(MDRChangeListener listener) {
        this.addListener(listener, 0xFFFFFFF);
    }

    public void addListener(MDRChangeListener listener, int mask) {
        this.initCheck();
        this.mdrStorage.getEventNotifier().REPOSITORY.addListener(listener, mask, this.mdrStorage);
    }

    public void removeListener(MDRChangeListener listener) {
        this.initCheck();
        this.mdrStorage.getEventNotifier().REPOSITORY.removeListener(listener, this.mdrStorage);
    }

    public void removeListener(MDRChangeListener listener, int mask) {
        this.initCheck();
        this.mdrStorage.getEventNotifier().REPOSITORY.removeListener(listener, mask, this.mdrStorage);
    }

    public void beginTrans(boolean writeAccess) {
        this.initCheck();
        this.mdrStorage.getRepositoryMutex().enter(writeAccess);
    }

    public void endTrans() {
        this.initCheck();
        this.mdrStorage.getRepositoryMutex().leave(false);
    }

    public void endTrans(boolean rollback) {
        this.initCheck();
        this.mdrStorage.getRepositoryMutex().leave(rollback);
    }

    public RefPackage createExtent(String substName) throws CreationFailedException {
        return this.createExtent(substName, null);
    }

    public RefPackage createExtent(String substName, RefObject metaPackage) throws CreationFailedException {
        return this.createExtent(substName, metaPackage, null);
    }

    public RefPackage createExtent(String substName, RefObject metaPackage, RefPackage[] existingInstances) throws CreationFailedException {
        return this.createExtent(substName, metaPackage, existingInstances, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefPackage getExtent(String name) {
        this.initCheck();
        try {
            StorablePackage pkg;
            this.beginTrans(false);
            try {
                pkg = this.mdrStorage.getContextOutermostPackage(name);
            }
            catch (NullPointerException e) {
                pkg = null;
            }
            catch (StorageBadRequestException e) {
                pkg = null;
            }
            catch (StorageException e) {
                throw new DebugException("Storage exception: " + e);
            }
            RefPackage refPackage = (RefPackage)BaseObjectHandler.getHandler(pkg);
            Object var7_7 = null;
            this.endTrans();
            return refPackage;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.endTrans();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getExtentNames() {
        this.initCheck();
        String[] result = new String[]{};
        try {
            try {
                this.beginTrans(false);
                String[] stringArray = result = this.mdrStorage.getContexts().toArray(result);
                Object var4_4 = null;
                this.endTrans();
                return stringArray;
            }
            catch (StorageException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.endTrans();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefBaseObject getByMofId(String mofId) {
        this.initCheck();
        try {
            try {
                this.beginTrans(false);
                StorableBaseObject storable = this.mdrStorage.getObject(MOFID.fromString(mofId));
                RefBaseObject refBaseObject = BaseObjectHandler.getHandler(storable);
                Object var5_6 = null;
                this.endTrans();
                return refBaseObject;
            }
            catch (StorageException e) {
                RefBaseObject refBaseObject = null;
                Object var5_7 = null;
                this.endTrans();
                return refBaseObject;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.endTrans();
            throw throwable;
        }
    }

    public synchronized void shutdown() {
        if (this.mdrStorage != null) {
            try {
                try {
                    this.mdrStorage.shutDown();
                }
                catch (StorageException e) {
                    throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
                }
                Object var3_1 = null;
                this.mdrStorage = null;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.mdrStorage = null;
                throw throwable;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("IDE MOF Repository");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefPackage createExtent(String substName, RefObject metaPackage, RefPackage[] existingInstances, String storageId) throws CreationFailedException {
        RefPackage result;
        this.initCheck();
        boolean fail = true;
        if (metaPackage == null) {
            metaPackage = this.getMOFModelPackage();
        }
        ExtentEvent event = new ExtentEvent((Object)this, 0x8010001, substName, metaPackage, (Collection)new ImmutableList(existingInstances));
        try {
            this.beginTrans(true);
            if (this.getExtent(substName) != null) {
                throw new CreationFailedException("Package extent named '" + substName + "' already exists.");
            }
            this.mdrStorage.getEventNotifier().REPOSITORY.firePlannedChange(this.mdrStorage, (MDRChangeEvent)event);
            HashMap instancesToCluster = new HashMap();
            this.classProxies = new HashMap();
            this.associationProxies = new HashMap();
            this.classProxiesMofIds = new HashMap();
            if (existingInstances != null) {
                int i = 0;
                while (i < existingInstances.length) {
                    this.collectPackageInstances(existingInstances[i], instancesToCluster);
                    ++i;
                }
            }
            try {
                this.instantiatePackage(substName, null, (MofPackage)metaPackage, instancesToCluster, storageId, false);
            }
            catch (RuntimeException e) {
                throw (CreationFailedException)Logger.getDefault().annotate((Throwable)new CreationFailedException("Cannot instantiate package because of unexpected exception: " + e), (Throwable)e);
            }
            this.classProxies = null;
            this.associationProxies = null;
            this.classProxiesMofIds = null;
            result = this.getExtent(substName);
            if (result == null) {
                throw new CreationFailedException("Cannot find created package.");
            }
            fail = false;
            Object var11_11 = null;
            this.endTrans(fail);
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.endTrans(fail);
            throw throwable;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String mountStorage(String storageFactoryClass, Map properties) throws MountFailedException {
        boolean failed = true;
        try {
            try {
                this.beginTrans(true);
                String storageId = this.mdrStorage.mountStorage(storageFactoryClass, properties);
                failed = false;
                String string = storageId;
                Object var7_7 = null;
                this.endTrans(failed);
                return string;
            }
            catch (Exception e) {
                throw new MountFailedException("Partition mount failed.", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.endTrans(failed);
            throw throwable;
        }
    }

    public void unmountStorage(String storageId) {
        boolean failed = true;
        try {
            try {
                this.beginTrans(true);
                Collection c = this.mdrStorage.getContexts(storageId);
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    String extentName = (String)it.next();
                    RefPackage pkg = this.getExtent(extentName);
                    ExtentEvent event = new ExtentEvent((Object)pkg, 134283266, extentName, pkg.refMetaObject(), null);
                    this.mdrStorage.getEventNotifier().PACKAGE.firePlannedChange(pkg, (MDRChangeEvent)event);
                }
                this.mdrStorage.unmountStorage(storageId);
                failed = false;
            }
            catch (StorageException e) {
                throw new DebugException("Unmounting failed: " + e.toString());
            }
            Object var9_9 = null;
            this.endTrans(failed);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.endTrans(failed);
            throw throwable;
        }
    }

    public String getMOFInstanceName() {
        return PURE_MOF;
    }

    public String getParameter(String name) {
        return (String)this.parameters.get(name);
    }

    private MofPackage getMOFModelPackage() {
        ModelPackage mofPackage = (ModelPackage)this.getExtent(this.getMOFInstanceName());
        Iterator it = mofPackage.getMofPackage().refAllOfClass().iterator();
        while (it.hasNext()) {
            MofPackage result = (MofPackage)it.next();
            if (!result.getName().equals("Model")) continue;
            return result;
        }
        return null;
    }

    private synchronized void initCheck() {
        if (this.mdrStorage == null) {
            String storageClass = (String)this.parameters.get(PARAM_STORAGE_CLASS);
            this.mdrStorage = new MdrStorage(this, storageClass, this.parameters);
            try {
                Logger.getDefault().log("initializing...");
                if (!this.mdrStorage.init()) {
                    Logger.getDefault().log("booting...");
                    this.boot();
                }
                return;
            }
            catch (StorageException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException("Fatal error: Repository boot/initialization failed with message: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void collectPackageInstances(RefPackage pkg, Map packages) throws CreationFailedException {
        RefPackage result = packages.put(((BaseObjectHandler)pkg.refMetaObject())._getDelegate().getMofId(), pkg);
        if (result != null && !result.equals(pkg)) {
            throw new CreationFailedException("The provided list of existing package instances contains duplicities.");
        }
        Iterator it = pkg.refAllPackages().iterator();
        while (it.hasNext()) {
            RefPackage nested = (RefPackage)it.next();
            this.collectPackageInstances(nested, packages);
        }
    }

    private RefPackage instantiatePackage(String substName, StorablePackage immediatePackage, MofPackage metaPackage, Map clusteredInstances, String storageId, boolean clustered) {
        StorablePackage newPackage = this.createPackageHandler(metaPackage, immediatePackage, substName, storageId, clustered);
        RefPackage result = (RefPackage)BaseObjectHandler.getHandler(newPackage);
        Logger.getDefault().log("new package: " + newPackage.getMofId() + ", metapackage: " + metaPackage.refMofId());
        HashSet localAssocProxies = new HashSet();
        HashMap localClassProxies = new HashMap();
        this.instantiatePackageContent(metaPackage, newPackage, clusteredInstances, localClassProxies, localAssocProxies, storageId);
        this.resolveSuperclasses(localClassProxies);
        return result;
    }

    private void resolveSuperclasses(Map localClassProxies) {
        HashMap<MofClass, LinkedList<Tag>> indexes = new HashMap<MofClass, LinkedList<Tag>>();
        if (!localClassProxies.isEmpty()) {
            MofClass mofClass = (MofClass)localClassProxies.keySet().iterator().next();
            ModelPackage modelPackage = (ModelPackage)mofClass.refOutermostPackage();
            Iterator iter = modelPackage.getTag().refAllOfClass().iterator();
            while (iter.hasNext()) {
                Tag tag = (Tag)iter.next();
                if (!TAGID_INDEX.equals(tag.getTagId())) continue;
                Iterator elements = tag.getElements().iterator();
                MofClass tempOwner = null;
                MofClass owner = null;
                boolean oneClass = true;
                while (elements.hasNext()) {
                    ModelElement elem = (ModelElement)elements.next();
                    if (elem instanceof MofClass) {
                        oneClass = true;
                        owner = (MofClass)elem;
                        break;
                    }
                    if (elem instanceof Attribute) {
                        tempOwner = (MofClass)((Attribute)elem).getContainer();
                    } else if (elem instanceof AssociationEnd) {
                        tempOwner = (MofClass)((AssociationEnd)elem).otherEnd().getType();
                    }
                    if (owner == null && tempOwner != null) {
                        owner = tempOwner;
                        continue;
                    }
                    boolean bl = oneClass = oneClass && owner == tempOwner;
                }
                if (owner == null || !oneClass) continue;
                LinkedList<Tag> tags = (LinkedList<Tag>)indexes.get(owner);
                if (tags == null) {
                    tags = new LinkedList<Tag>();
                    indexes.put(owner, tags);
                }
                tags.add(tag);
            }
        }
        Iterator it = localClassProxies.keySet().iterator();
        while (it.hasNext()) {
            MofClass cls = (MofClass)it.next();
            StorableClass sc = (StorableClass)localClassProxies.get(cls);
            Iterator supers = cls.getSupertypes().iterator();
            while (supers.hasNext()) {
                Object superMeta = supers.next();
                StorableClass current = (StorableClass)this.classProxies.get(superMeta);
                if (current == null) {
                    throw new DebugException("Package definition is incomplete: class " + cls.getName() + " super = " + superMeta);
                }
                sc.addSuperclass(current.getMofId());
                current.addSubclass(sc.getMofId());
            }
            Iterator contents = cls.getContents().iterator();
            while (contents.hasNext()) {
                ModelElement me = (ModelElement)contents.next();
                if (!(me instanceof Reference)) continue;
                AssociationEnd end = ((Reference)me).getExposedEnd();
                sc.addReferenceDescriptor(((BaseObjectHandler)me)._getDelegate().getMofId(), me.getName(), (MOFID)this.associationProxies.get(((BaseObjectHandler)end.getContainer())._getDelegate().getMofId()), end.getName());
            }
            List indexTags = (List)indexes.get(cls);
            if (indexTags == null) continue;
            try {
                sc.buildAdditionalIndexes(indexTags, this.associationProxies);
            }
            catch (StorageException e) {
                throw new DebugException("Storage exception: " + e);
            }
        }
    }

    private void instantiatePackageContent(MofPackage metaPackage, StorablePackage newPackage, Map clusteredInstances, Map localClassProxies, Set localAssocProxies, String storageId) {
        Iterator superTypes = metaPackage.allSupertypes().iterator();
        boolean thisTypeNotProcessed = true;
        while (thisTypeNotProcessed || superTypes.hasNext()) {
            Iterator it;
            if (thisTypeNotProcessed) {
                it = metaPackage.getContents().iterator();
                thisTypeNotProcessed = false;
            } else {
                it = ((MofPackage)superTypes.next()).getContents().iterator();
            }
            while (it.hasNext()) {
                Object o = it.next();
                ModelElement element = (ModelElement)o;
                if (element instanceof MofClass) {
                    this.createClassProxyHandler((MofClass)element, newPackage, localClassProxies);
                    continue;
                }
                if (element instanceof Association) {
                    boolean indexedB;
                    Class typeB;
                    Class typeA;
                    Association assoc = (Association)element;
                    List content = assoc.getContents();
                    int i = 0;
                    AssociationEnd[] ends = new AssociationEnd[2];
                    Iterator cit = content.iterator();
                    while (i < 2 && cit.hasNext()) {
                        ModelElement containedElement = (ModelElement)cit.next();
                        if (!(containedElement instanceof AssociationEnd)) continue;
                        ends[i++] = (AssociationEnd)containedElement;
                    }
                    int minA = ends[0].getMultiplicity().getLower();
                    int maxA = ends[0].getMultiplicity().getUpper();
                    int minB = ends[1].getMultiplicity().getLower();
                    int maxB = ends[1].getMultiplicity().getUpper();
                    try {
                        typeA = BaseObjectHandler.resolveInterface(TagSupport.getDataTypeName((StorableObject)((InstanceHandler)ends[0].getType())._getDelegate()));
                        typeB = BaseObjectHandler.resolveInterface(TagSupport.getDataTypeName((StorableObject)((InstanceHandler)ends[1].getType())._getDelegate()));
                    }
                    catch (Exception e) {
                        throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
                    }
                    boolean orderA = ends[0].getMultiplicity().isOrdered();
                    boolean orderB = ends[1].getMultiplicity().isOrdered();
                    boolean uniqueA = ends[0].getMultiplicity().isUnique();
                    boolean uniqueB = ends[1].getMultiplicity().isUnique();
                    boolean aggrA = ends[0].getAggregation().equals((Object)AggregationKindEnum.COMPOSITE);
                    boolean aggrB = ends[1].getAggregation().equals((Object)AggregationKindEnum.COMPOSITE);
                    boolean indexedA = TagSupport.getTagValue((StorableObject)((BaseObjectHandler)ends[0])._getDelegate(), TAGID_INDEX) != null;
                    boolean bl = indexedB = TagSupport.getTagValue((StorableObject)((BaseObjectHandler)ends[1])._getDelegate(), TAGID_INDEX) != null;
                    if (TagSupport.getTagValue((StorableObject)((BaseObjectHandler)ends[0].getType())._getDelegate(), TRANSIENT_TAG_ID, "").equals(TAG_VALUE_TRUE) || TagSupport.getTagValue((StorableObject)((BaseObjectHandler)ends[1].getType())._getDelegate(), TRANSIENT_TAG_ID, "").equals(TAG_VALUE_TRUE)) {
                        this.createTransientAssociationHandler((Association)element, newPackage, ends[0].getName(), ((BaseObjectHandler)ends[0])._getDelegate().getMofId(), ends[1].getName(), ((BaseObjectHandler)ends[1])._getDelegate().getMofId(), typeA, typeB, minA, maxA, minB, maxB, orderA, orderB, uniqueA, uniqueB, aggrA, aggrB, localAssocProxies);
                        continue;
                    }
                    this.createAssociationHandler((Association)element, newPackage, ends[0].getName(), ((BaseObjectHandler)ends[0])._getDelegate().getMofId(), ends[1].getName(), ((BaseObjectHandler)ends[1])._getDelegate().getMofId(), typeA, typeB, minA, maxA, minB, maxB, orderA, orderB, uniqueA, uniqueB, aggrA, aggrB, indexedA, indexedB, localAssocProxies);
                    continue;
                }
                if (element instanceof MofPackage) {
                    StorablePackage pkg = this.createPackageHandler((MofPackage)element, newPackage, null, storageId, false);
                    this.instantiatePackageContent((MofPackage)element, pkg, clusteredInstances, localClassProxies, localAssocProxies, storageId);
                    continue;
                }
                if (!(element instanceof Import)) continue;
                Import imp = (Import)element;
                Namespace metaElement = imp.getImportedNamespace();
                if (metaElement instanceof MofPackage) {
                    MofPackage metaPkg = (MofPackage)metaElement;
                    this.collectDTDescriptors(storageId, (GeneralizableElement)metaPkg, new HashSet());
                    if (!imp.isClustered()) continue;
                    RefPackage pkg = (RefPackage)clusteredInstances.get(((BaseObjectHandler)metaPkg)._getDelegate().getMofId());
                    if (pkg == null) {
                        pkg = this.instantiatePackage(null, newPackage, metaPkg, clusteredInstances, storageId, true);
                        clusteredInstances.put(((BaseObjectHandler)metaPkg)._getDelegate().getMofId(), pkg);
                    } else {
                        this.collectAllProxies(pkg);
                    }
                    try {
                        newPackage.clusterPackage(imp.getName(), ((BaseObjectHandler)pkg)._getDelegate().getMofId());
                        continue;
                    }
                    catch (StorageException e) {
                        throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
                    }
                }
                if (metaElement instanceof EnumerationType) {
                    this.createDTDescriptor(storageId, (EnumerationType)metaElement);
                    continue;
                }
                if (metaElement instanceof StructureType) {
                    this.createDTDescriptor(storageId, (StructureType)metaElement);
                    continue;
                }
                if (!(metaElement instanceof MofClass)) continue;
                this.collectDTDescriptors(storageId, (GeneralizableElement)((MofClass)metaElement), new HashSet());
            }
        }
    }

    private void collectDTDescriptors(String storageId, GeneralizableElement metaElement, Set visited) {
        Iterator superTypes = metaElement.allSupertypes().iterator();
        boolean thisTypeNotProcessed = true;
        while (thisTypeNotProcessed || superTypes.hasNext()) {
            Iterator it;
            if (thisTypeNotProcessed) {
                it = metaElement.getContents().iterator();
                thisTypeNotProcessed = false;
            } else {
                GeneralizableElement ge = (GeneralizableElement)superTypes.next();
                if (!visited.add(ge)) continue;
                it = ge.getContents().iterator();
            }
            this.collectDTDescriptors(storageId, it, visited);
        }
    }

    private void collectDTDescriptors(String storageId, Iterator it, Set visited) {
        while (it.hasNext()) {
            Object element = it.next();
            if (element instanceof MofPackage || element instanceof MofClass) {
                if (!visited.add(element)) continue;
                this.collectDTDescriptors(storageId, (GeneralizableElement)element, visited);
                continue;
            }
            if (element instanceof EnumerationType) {
                this.createDTDescriptor(storageId, (EnumerationType)element);
                continue;
            }
            if (!(element instanceof StructureType)) continue;
            this.createDTDescriptor(storageId, (StructureType)element);
        }
    }

    private void collectAllProxies(RefPackage pkg) {
        Iterator it = pkg.refAllAssociations().iterator();
        while (it.hasNext()) {
            RefAssociation assoc = (RefAssociation)it.next();
            if (this.associationProxies.put(((BaseObjectHandler)assoc.refMetaObject())._getDelegate().getMofId(), ((BaseObjectHandler)assoc)._getDelegate().getMofId()) == null) continue;
            return;
        }
        Iterator it2 = pkg.refAllClasses().iterator();
        while (it2.hasNext()) {
            RefClass cls = (RefClass)it2.next();
            if (this.classProxiesMofIds.put(((BaseObjectHandler)cls.refMetaObject())._getDelegate().getMofId(), ((BaseObjectHandler)cls)._getDelegate().getMofId()) != null) {
                return;
            }
            this.classProxies.put((MofClass)cls.refMetaObject(), ((BaseObjectHandler)cls)._getDelegate());
        }
        Iterator it3 = pkg.refAllPackages().iterator();
        while (it3.hasNext()) {
            this.collectAllProxies((RefPackage)it3.next());
        }
    }

    private StorablePackage createPackageHandler(MofPackage metaObject, StorablePackage immediatePackage, String context, String storageId, boolean clustered) {
        try {
            HashMap<String, DatatypeDescriptor> datatypes = new HashMap<String, DatatypeDescriptor>();
            Iterator supers = null;
            while (supers == null || supers.hasNext()) {
                MofPackage metaPackage;
                if (supers == null) {
                    supers = metaObject.allSupertypes().iterator();
                    metaPackage = metaObject;
                } else {
                    metaPackage = (MofPackage)supers.next();
                }
                Iterator it = metaPackage.getContents().iterator();
                while (it.hasNext()) {
                    ModelElement element = (ModelElement)it.next();
                    if (element instanceof EnumerationType) {
                        datatypes.put(element.getName(), this.createDTDescriptor(storageId, (EnumerationType)element));
                        continue;
                    }
                    if (!(element instanceof StructureType)) continue;
                    datatypes.put(element.getName(), this.createDTDescriptor(storageId, (StructureType)element));
                }
            }
            StorablePackage result = null;
            result = storageId != null ? new StorablePackage(this.mdrStorage, immediatePackage == null ? null : immediatePackage.getMofId(), ((BaseObjectHandler)metaObject)._getDelegate().getMofId(), context, datatypes, storageId) : new StorablePackage(this.mdrStorage, immediatePackage == null ? null : immediatePackage.getMofId(), ((BaseObjectHandler)metaObject)._getDelegate().getMofId(), context, datatypes);
            if (immediatePackage != null && !clustered) {
                immediatePackage.addPackage(metaObject.getName(), result.getMofId());
            }
            return result;
        }
        catch (StorageException e) {
            throw new DebugException("Storage exception: " + e.getMessage());
        }
    }

    private DatatypeDescriptor createDTDescriptor(String storageId, EnumerationType enumerationType) {
        ArrayList members = new ArrayList(enumerationType.getLabels());
        String ifcName = TagSupport.getTypeFullName((StorableObject)((BaseObjectHandler)enumerationType)._getDelegate());
        return new DatatypeDescriptor(this.mdrStorage, members, ifcName, storageId);
    }

    private DatatypeDescriptor createDTDescriptor(String storageId, StructureType struct) {
        ArrayList<String> members = new ArrayList<String>();
        ArrayList<Class> memberTypes = new ArrayList<Class>();
        Iterator it2 = struct.getContents().iterator();
        while (it2.hasNext()) {
            ModelElement me = (ModelElement)it2.next();
            if (!(me instanceof StructureField)) continue;
            members.add(me.getName());
            try {
                memberTypes.add(BaseObjectHandler.resolveInterface(TagSupport.getDataTypeName((StorableObject)((BaseObjectHandler)((StructureField)me).getType())._getDelegate())));
            }
            catch (ClassNotFoundException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }
        String ifcName = TagSupport.getTypeFullName((StorableObject)((BaseObjectHandler)struct)._getDelegate());
        return new DatatypeDescriptor(this.mdrStorage, struct.getQualifiedName(), members, memberTypes, ifcName, storageId);
    }

    private StorableClass createClassProxyHandler(MofClass metaObject, StorablePackage immediatePackage, Map localClassProxies) {
        boolean classDerived = false;
        boolean instanceDerived = false;
        boolean isDerived = false;
        try {
            ArrayList<StorableClass.AttributeDescriptor> attrDescs = new ArrayList<StorableClass.AttributeDescriptor>();
            ArrayList<StorableClass.AttributeDescriptor> clAttrDescs = new ArrayList<StorableClass.AttributeDescriptor>();
            HashMap<String, DatatypeDescriptor> datatypes = new HashMap<String, DatatypeDescriptor>();
            Iterator it = metaObject.getContents().iterator();
            while (it.hasNext()) {
                ModelElement element = (ModelElement)it.next();
                if (element instanceof Attribute) {
                    Attribute attr = (Attribute)element;
                    isDerived = attr.isDerived();
                    if (!isDerived) {
                        Class type;
                        try {
                            type = BaseObjectHandler.resolveInterface(TagSupport.getDataTypeName((StorableObject)((InstanceHandler)attr.getType())._getDelegate()));
                        }
                        catch (Exception e) {
                            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
                        }
                        StorableClass.AttributeDescriptor desc = new StorableClass.AttributeDescriptor(this.mdrStorage, ((BaseObjectHandler)attr)._getDelegate().getMofId(), attr.getName(), type, attr.getMultiplicity().getLower(), attr.getMultiplicity().getUpper(), attr.getMultiplicity().isUnique(), attr.getMultiplicity().isOrdered(), attr.isChangeable(), MdrStorage.getStorageIdFromMofId(immediatePackage.getMofId()));
                        if (ScopeKindEnum.INSTANCE_LEVEL.equals((Object)attr.getScope())) {
                            attrDescs.add(desc);
                        } else {
                            clAttrDescs.add(desc);
                        }
                    }
                } else if (element instanceof Operation) {
                    isDerived = true;
                } else {
                    if (element instanceof EnumerationType) {
                        ArrayList members = new ArrayList(((EnumerationType)element).getLabels());
                        String ifcName = TagSupport.getTypeFullName((StorableObject)((BaseObjectHandler)element)._getDelegate());
                        datatypes.put(element.getName(), new DatatypeDescriptor(this.mdrStorage, members, ifcName, MdrStorage.getStorageIdFromMofId(immediatePackage.getMofId())));
                    } else if (element instanceof StructureType) {
                        ArrayList<String> members = new ArrayList<String>();
                        ArrayList<Class> memberTypes = new ArrayList<Class>();
                        Iterator it2 = ((StructureType)element).getContents().iterator();
                        while (it2.hasNext()) {
                            ModelElement me = (ModelElement)it2.next();
                            if (!(me instanceof StructureField)) continue;
                            members.add(me.getName());
                            try {
                                memberTypes.add(BaseObjectHandler.resolveInterface(TagSupport.getDataTypeName((StorableObject)((BaseObjectHandler)((StructureField)me).getType())._getDelegate())));
                            }
                            catch (ClassNotFoundException e) {
                                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
                            }
                        }
                        String ifcName = TagSupport.getTypeFullName((StorableObject)((BaseObjectHandler)element)._getDelegate());
                        datatypes.put(element.getName(), new DatatypeDescriptor(this.mdrStorage, element.getQualifiedName(), members, memberTypes, ifcName, MdrStorage.getStorageIdFromMofId(immediatePackage.getMofId())));
                    }
                    isDerived = false;
                }
                if (!isDerived) continue;
                if (((Feature)element).getScope().equals((Object)ScopeKindEnum.CLASSIFIER_LEVEL)) {
                    classDerived = true;
                    continue;
                }
                instanceDerived = true;
            }
            String tagValue = TagSupport.getTagValue((StorableObject)((BaseObjectHandler)metaObject)._getDelegate(), TRANSIENT_TAG_ID, "");
            StorableClass storable = tagValue.equals(TAG_VALUE_TRUE) ? new TransientStorableClass(this.mdrStorage, immediatePackage.getMofId(), ((BaseObjectHandler)metaObject)._getDelegate().getMofId(), attrDescs, clAttrDescs, datatypes, classDerived, instanceDerived, metaObject.isSingleton(), metaObject.isAbstract()) : new StorableClass(this.mdrStorage, immediatePackage.getMofId(), ((BaseObjectHandler)metaObject)._getDelegate().getMofId(), attrDescs, clAttrDescs, datatypes, classDerived, instanceDerived, metaObject.isSingleton(), metaObject.isAbstract());
            immediatePackage.addClass(metaObject.getName(), storable.getMofId());
            this.classProxies.put(metaObject, storable);
            this.classProxiesMofIds.put(((BaseObjectHandler)metaObject)._getDelegate().getMofId(), storable.getMofId());
            localClassProxies.put(metaObject, storable);
            return storable;
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    private StorableAssociation createAssociationHandler(Association metaObject, StorablePackage immediatePackage, String assocationEnd1, MOFID assocEnd1MofId, String assocationEnd2, MOFID assocEnd2MofId, Class type1, Class type2, int min1, int max1, int min2, int max2, boolean isOrdered1, boolean isOrdered2, boolean isUnique1, boolean isUnique2, boolean isAggr1, boolean isAggr2, boolean isIndexed1, boolean isIndexed2, Set localAssocProxies) {
        try {
            StorableAssociation result = new StorableAssociation(this.mdrStorage, immediatePackage.getMofId(), ((BaseObjectHandler)metaObject)._getDelegate().getMofId(), assocationEnd1, assocEnd1MofId, assocationEnd2, assocEnd2MofId, type1, type2, min1, max1, min2, max2, isOrdered1, isOrdered2, isUnique1, isUnique2, isAggr1, isAggr2, isIndexed1, isIndexed2);
            immediatePackage.addAssociation(metaObject.getName(), result.getMofId());
            this.associationProxies.put(((BaseObjectHandler)metaObject)._getDelegate().getMofId(), result.getMofId());
            localAssocProxies.add(result.getMofId());
            return result;
        }
        catch (StorageException e) {
            throw new DebugException("Storage exception: " + e);
        }
    }

    private StorableAssociation createTransientAssociationHandler(Association metaObject, StorablePackage immediatePackage, String assocationEnd1, MOFID assocEnd1MofId, String assocationEnd2, MOFID assocEnd2MofId, Class type1, Class type2, int min1, int max1, int min2, int max2, boolean isOrdered1, boolean isOrdered2, boolean isUnique1, boolean isUnique2, boolean isAggr1, boolean isAggr2, Set localAssocProxies) {
        try {
            TransientStorableAssociation result = new TransientStorableAssociation(this.mdrStorage, immediatePackage.getMofId(), ((BaseObjectHandler)metaObject)._getDelegate().getMofId(), assocationEnd1, assocEnd1MofId, assocationEnd2, assocEnd2MofId, type1, type2, min1, max1, min2, max2, isOrdered1, isOrdered2, isUnique1, isUnique2, isAggr1, isAggr2);
            immediatePackage.addAssociation(metaObject.getName(), result.getMofId());
            this.associationProxies.put(((BaseObjectHandler)metaObject)._getDelegate().getMofId(), result.getMofId());
            localAssocProxies.add(result.getMofId());
            return result;
        }
        catch (StorageException e) {
            throw new DebugException("Storage exception: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void boot() {
        boolean fail = true;
        Logger.getDefault().log("Booting repository ...");
        this.mdrStorage.setBooting(true);
        try {
            try {
                this.beginTrans(true);
                this.installFakeMof();
                this.installPureMof();
                fail = false;
            }
            catch (Throwable e) {
                Logger.getDefault().notify(1, e);
                Object var4_3 = null;
                this.mdrStorage.setBooting(false);
                this.endTrans(fail);
            }
            Object var4_2 = null;
            this.mdrStorage.setBooting(false);
            this.endTrans(fail);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.mdrStorage.setBooting(false);
            this.endTrans(fail);
            throw throwable;
        }
    }

    private void installFakeMof() {
        Logger.getDefault().log("Creating boot MOF metamodel ...");
        this.createBootMOF();
        if (this.getExtent(BOOT_MOF) == null) {
            throw new DebugException("Cannot create instance of BOOT_MOF: Fatal error during bootstrapping.");
        }
    }

    private void installPureMof() {
        Logger.getDefault().log("Installing pure MOF Metamodel ... ");
        try {
            Logger.getDefault().log("Parsing MOF model to DOM represtentation ....");
            ModelPackage modelPackage = (ModelPackage)this.createExtent(PURE_MOF, (RefObject)this.getBMModelPackage());
            XmiReader xmiReader = (XmiReader)Lookup.getDefault().lookup(class$javax$jmi$xmi$XmiReader == null ? (class$javax$jmi$xmi$XmiReader = NBMDRepositoryImpl.class$("javax.jmi.xmi.XmiReader")) : class$javax$jmi$xmi$XmiReader);
            xmiReader.read(MOF_XML_URL.toString(), (RefPackage)modelPackage);
            this.mdrStorage.rebuildMofContext();
        }
        catch (Exception e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException("Boot failed."), (Throwable)e);
        }
    }

    private MofPackage getBMModelPackage() {
        Iterator it = ((ModelPackage)this.getExtent(BOOT_MOF)).getMofPackage().refAllOfClass().iterator();
        while (it.hasNext()) {
            MofPackage result = (MofPackage)it.next();
            if (!result.getName().equals("Model")) continue;
            return result;
        }
        return null;
    }

    private void createBootMOF() {
        try {
            BootReader br = new BootReader(this.mdrStorage, BOOTMOF_XML_URL);
            br.read();
        }
        catch (Exception e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException("Unable to read MOF XMI: " + e.getMessage()), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TAGID_INDEX = TAGID_INDEX;
        PARAM_STORAGE_CLASS = PARAM_STORAGE_CLASS;
        TRANSIENT_TAG_ID = TRANSIENT_TAG_ID;
        TAG_VALUE_TRUE = TAG_VALUE_TRUE;
        BOOT_MOF = BOOT_MOF;
        PURE_MOF = PURE_MOF;
    }
}

