/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.handlers;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import javax.jmi.reflect.RefAssociationLink;
import javax.jmi.reflect.RefObject;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.storagemodel.AssociationLink;

class AssociationLinkWrapper
implements RefAssociationLink {
    private static final IdentityCache identityCache = new IdentityCache();
    private final AssociationLink innerLink;

    private AssociationLinkWrapper(AssociationLink innerLink) {
        this.innerLink = innerLink;
    }

    AssociationLink getInnerLink() {
        return this.innerLink;
    }

    public RefObject refFirstEnd() {
        return (RefObject)BaseObjectHandler.getHandler(this.innerLink.getFirstEnd());
    }

    public RefObject refSecondEnd() {
        return (RefObject)BaseObjectHandler.getHandler(this.innerLink.getSecondEnd());
    }

    public boolean equals(Object other) {
        if (other instanceof AssociationLinkWrapper) {
            return this == other;
        }
        return other instanceof RefAssociationLink && ((RefAssociationLink)other).refFirstEnd().equals((Object)this.refFirstEnd()) && ((RefAssociationLink)other).refSecondEnd().equals((Object)this.refSecondEnd());
    }

    public int hashCode() {
        return (this.innerLink.getFirstEnd().getMofId().toString() + this.innerLink.getSecondEnd().getMofId().toString()).hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RefAssociationLink wrapLink(AssociationLink innerLink) {
        if (innerLink == null) {
            return null;
        }
        String linkID = innerLink.getFirstEnd().getMofId().toString() + ":" + innerLink.getSecondEnd().getMofId().toString();
        IdentityCache identityCache = AssociationLinkWrapper.identityCache;
        synchronized (identityCache) {
            RefAssociationLink result = (RefAssociationLink)AssociationLinkWrapper.identityCache.get(linkID);
            if (result == null) {
                result = new AssociationLinkWrapper(innerLink);
                AssociationLinkWrapper.identityCache.put(linkID, result);
            }
            RefAssociationLink refAssociationLink = result;
            return refAssociationLink;
        }
    }

    private static class IdentityCache
    extends HashMap {
        private final ReferenceQueue queue = new ReferenceQueue();

        private IdentityCache() {
        }

        /*
         * WARNING - void declaration
         */
        private void cleanUp() {
            LinkReference reference;
            while ((reference = (LinkReference)this.queue.poll()) != null) {
                void var1_1;
                this.remove(var1_1.getProxyMofId());
            }
        }

        public Object put(Object key, Object value) {
            this.cleanUp();
            LinkReference result = super.put(key, new LinkReference((String)key, (RefAssociationLink)value));
            if (result != null) {
                return result.get();
            }
            return result;
        }

        public Object get(Object key) {
            this.cleanUp();
            Object result = super.get(key);
            if (result != null) {
                return ((LinkReference)result).get();
            }
            return result;
        }

        private class LinkReference
        extends WeakReference {
            private String mofId;

            public LinkReference(String key, RefAssociationLink link) {
                super(link, IdentityCache.this.queue);
                this.mofId = key;
            }

            public String getProxyMofId() {
                return this.mofId;
            }
        }
    }
}

