/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.handlers;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.jmi.model.ModelPackage;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import org.netbeans.api.mdr.MDRObject;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.mdr.handlers.ClassLoaderProvider;
import org.netbeans.mdr.handlers.MDRClassLoader;
import org.netbeans.mdr.handlers.gen.HandlerGenerator;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.storagemodel.StorablePackage;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.ImplClass;
import org.netbeans.mdr.util.Logger;

public abstract class BaseObjectHandler
extends ImplClass
implements MDRObject {
    private static final Map facilityCache = new FacilityCache();
    private static final Hashtable classCache = new Hashtable();
    private static MDRClassLoader defaultLoader = null;
    private static ClassLoaderProvider provider = null;
    private final MOFID mofId;
    private final MdrStorage mdrStorage;
    private StorableBaseObject storable;
    static /* synthetic */ Class class$org$netbeans$mdr$storagemodel$TransientStorableClass;
    static /* synthetic */ Class class$org$netbeans$mdr$storagemodel$StorableClass;
    static /* synthetic */ Class class$org$netbeans$mdr$storagemodel$TransientStorableObject;
    static /* synthetic */ Class class$org$netbeans$mdr$storagemodel$StorableObject;
    static /* synthetic */ Class class$org$netbeans$mdr$storagemodel$TransientStorableAssociation;
    static /* synthetic */ Class class$org$netbeans$mdr$storagemodel$StorableAssociation;

    public static synchronized void setClassLoaderProvider(ClassLoaderProvider provider) {
        BaseObjectHandler.provider = provider;
    }

    public static synchronized MDRClassLoader getDefaultClassLoader() {
        if (defaultLoader == null) {
            defaultLoader = new MDRClassLoader(provider);
        }
        return defaultLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class getHandlerClass(MDRClassLoader loader, Class ifc, StorableBaseObject s) throws IllegalArgumentException {
        ImplClass.check(loader, ifc);
        Map cache = ImplClass.getLoaderCache(loader);
        String className = ImplClass.getName(ifc);
        Class result = ImplClass.getFromCache(cache, ifc, className);
        if (result == null) {
            try {
                byte[] handlerClassFile = HandlerGenerator.generateHandler(className, ifc, s);
                result = loader.defineClass(className, handlerClassFile);
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                ImplClass.releaseCache(cache, result, className);
                throw throwable;
            }
            ImplClass.releaseCache(cache, result, className);
            {
            }
        }
        return result;
    }

    private static Class resolveClass(StorableBaseObject s) {
        try {
            StorableObject metaObject = s.getMetaObject();
            return BaseObjectHandler.getDefaultClassLoader().resolveInterface(metaObject, !(s instanceof StorableObject));
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    public static void _freeCache() {
        facilityCache.clear();
        classCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RefBaseObject getHandler(StorableBaseObject s) throws IllegalArgumentException {
        if (s == null) {
            return null;
        }
        Map map = facilityCache;
        synchronized (map) {
            RefBaseObject refBO = (RefBaseObject)facilityCache.get(s.getMofId());
            if (refBO != null) {
                return refBO;
            }
        }
        Class ifc = BaseObjectHandler.resolveClass(s);
        return BaseObjectHandler.getHandler(s, ifc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RefBaseObject getHandler(StorableBaseObject s, Class ifc) throws IllegalArgumentException {
        if (s == null) {
            return null;
        }
        MDRClassLoader loader = BaseObjectHandler.getDefaultClassLoader();
        Class cl = BaseObjectHandler.getHandlerClass(loader, ifc, s);
        try {
            Class cls = s.getClass();
            if (cls.equals(class$org$netbeans$mdr$storagemodel$TransientStorableClass == null ? (class$org$netbeans$mdr$storagemodel$TransientStorableClass = BaseObjectHandler.class$("org.netbeans.mdr.storagemodel.TransientStorableClass")) : class$org$netbeans$mdr$storagemodel$TransientStorableClass)) {
                cls = class$org$netbeans$mdr$storagemodel$StorableClass == null ? (class$org$netbeans$mdr$storagemodel$StorableClass = BaseObjectHandler.class$("org.netbeans.mdr.storagemodel.StorableClass")) : class$org$netbeans$mdr$storagemodel$StorableClass;
            } else if (cls.equals(class$org$netbeans$mdr$storagemodel$TransientStorableObject == null ? (class$org$netbeans$mdr$storagemodel$TransientStorableObject = BaseObjectHandler.class$("org.netbeans.mdr.storagemodel.TransientStorableObject")) : class$org$netbeans$mdr$storagemodel$TransientStorableObject)) {
                cls = class$org$netbeans$mdr$storagemodel$StorableObject == null ? (class$org$netbeans$mdr$storagemodel$StorableObject = BaseObjectHandler.class$("org.netbeans.mdr.storagemodel.StorableObject")) : class$org$netbeans$mdr$storagemodel$StorableObject;
            } else if (cls.equals(class$org$netbeans$mdr$storagemodel$TransientStorableAssociation == null ? (class$org$netbeans$mdr$storagemodel$TransientStorableAssociation = BaseObjectHandler.class$("org.netbeans.mdr.storagemodel.TransientStorableAssociation")) : class$org$netbeans$mdr$storagemodel$TransientStorableAssociation)) {
                cls = class$org$netbeans$mdr$storagemodel$StorableAssociation == null ? (class$org$netbeans$mdr$storagemodel$StorableAssociation = BaseObjectHandler.class$("org.netbeans.mdr.storagemodel.StorableAssociation")) : class$org$netbeans$mdr$storagemodel$StorableAssociation;
            }
            Constructor cons = cl.getConstructor(cls);
            Map map = facilityCache;
            synchronized (map) {
                Object oldRecord = facilityCache.get(s.getMofId());
                if (oldRecord == null) {
                    oldRecord = cons.newInstance(s);
                    facilityCache.put(s.getMofId(), oldRecord);
                }
                BaseObjectHandler baseObjectHandler = (BaseObjectHandler)oldRecord;
                return baseObjectHandler;
            }
        }
        catch (NoSuchMethodException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    public static Class resolveInterface(String ifcName) throws ClassNotFoundException {
        try {
            return Class.forName(ifcName, true, BaseObjectHandler.getDefaultClassLoader());
        }
        catch (RuntimeException e) {
            Logger.getDefault().annotate((Throwable)e, "ClassLoader: " + BaseObjectHandler.getDefaultClassLoader());
            Logger.getDefault().annotate((Throwable)e, "ClassName: " + ifcName);
            throw e;
        }
        catch (Error e) {
            Logger.getDefault().annotate((Throwable)e, "ClassLoader: " + BaseObjectHandler.getDefaultClassLoader());
            Logger.getDefault().annotate((Throwable)e, "ClassName: " + ifcName);
            throw e;
        }
    }

    public static Class resolveImplementation(String implName) throws ClassNotFoundException {
        try {
            return Class.forName(implName, true, BaseObjectHandler.getDefaultClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Error e) {
            Logger.getDefault().annotate((Throwable)e, "ClassLoader: " + BaseObjectHandler.getDefaultClassLoader());
            Logger.getDefault().annotate((Throwable)e, "ClassName: " + implName);
            throw e;
        }
        catch (RuntimeException e) {
            Logger.getDefault().annotate((Throwable)e, "ClassLoader: " + BaseObjectHandler.getDefaultClassLoader());
            Logger.getDefault().annotate((Throwable)e, "ClassName: " + implName);
            throw e;
        }
    }

    protected BaseObjectHandler(StorableBaseObject storable) {
        this.mofId = storable.getMofId();
        this.mdrStorage = storable.getMdrStorage();
        try {
            this.storable = storable instanceof StorableObject && ((StorableObject)storable).getClassProxy().isTransient() ? storable : null;
        }
        catch (StorageException se) {
            this.storable = null;
        }
    }

    protected final void _lock() {
        this._lock(true);
    }

    protected final void _lock(boolean write) {
        this.mdrStorage.getRepositoryMutex().enter(write);
    }

    protected final void _unlock() {
        this.mdrStorage.getRepositoryMutex().leave();
    }

    protected final void _unlock(boolean fail) {
        this.mdrStorage.getRepositoryMutex().leave(fail);
    }

    public final MDRepository repository() {
        return this.mdrStorage.getRepository();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof BaseObjectHandler) {
            return this == obj;
        }
        return obj instanceof RefBaseObject && ((BaseObjectHandler)obj).mofId.equals(this.mofId);
    }

    public String toString() {
        String outP;
        String metaId;
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(".") + 1);
        try {
            metaId = this._getDelegate().getMetaObject().getMofId().toString();
        }
        catch (Exception e) {
            metaId = "(not available)";
        }
        try {
            outP = this._getDelegate().getOutermostPackage().getMofId().toString();
        }
        catch (Exception e) {
            outP = "(not available)";
        }
        return className + "  ID: " + this.refMofId() + "  MID: " + metaId + "  OPCKG: " + outP;
    }

    public final int hashCode() {
        return this.mofId.hashCode();
    }

    public final RefObject refMetaObject() {
        try {
            return (RefObject)BaseObjectHandler.getHandler(this._getDelegate().getMetaObject());
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    public final RefPackage refImmediatePackage() {
        try {
            return (RefPackage)BaseObjectHandler.getHandler(this._getDelegate().getImmediatePackage());
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    public final RefPackage refOutermostPackage() {
        try {
            StorablePackage pkg = this._getDelegate().getOutermostPackage();
            if (pkg.getMofId().equals(this._getDelegate().getMofId())) {
                return (RefPackage)this;
            }
            return (RefPackage)BaseObjectHandler.getHandler(pkg);
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    public final String refMofId() {
        return this.mofId.toString();
    }

    public final Collection refVerifyConstraints(boolean deepVerify) {
        if (deepVerify) {
            return this._recursiveVerify(new ArrayList(), new HashSet());
        }
        return this._verify(new ArrayList());
    }

    public final StorableBaseObject _getDelegate() {
        try {
            if (this.storable != null) {
                return this.storable;
            }
            return this.mdrStorage.getObject(this.mofId);
        }
        catch (StorageBadRequestException e) {
            throw new InvalidObjectException(null, "Object with MOFID " + this.mofId + " no longer exists.");
        }
        catch (StorageException e) {
            throw new DebugException(e.toString());
        }
    }

    protected final MdrStorage _getMdrStorage() {
        return this.mdrStorage;
    }

    protected abstract Collection _recursiveVerify(Collection var1, Set var2);

    protected abstract Collection _verify(Collection var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FacilityCache
    extends HashMap {
        private final ReferenceQueue queue = new ReferenceQueue();

        private FacilityCache() {
        }

        /*
         * WARNING - void declaration
         */
        private void cleanUp() {
            HandlerReference reference;
            while ((reference = (HandlerReference)this.queue.poll()) != null) {
                void var1_1;
                this.remove(var1_1.getProxyMofId());
            }
        }

        public Object put(Object key, Object value) {
            this.cleanUp();
            HandlerReference result = super.put(key, new HandlerReference((BaseObjectHandler)value));
            if (result != null) {
                return result.get();
            }
            return result;
        }

        public Object get(Object key) {
            this.cleanUp();
            Object result = super.get(key);
            if (result != null) {
                return ((HandlerReference)result).get();
            }
            return result;
        }

        private class HandlerReference
        extends WeakReference {
            private MOFID mofId;
            private RefBaseObject baseObject;

            public HandlerReference(BaseObjectHandler handler) {
                super(handler, FacilityCache.this.queue);
                this.mofId = handler._getDelegate().getMofId();
                this.baseObject = handler.refOutermostPackage() instanceof ModelPackage ? handler : null;
            }

            public MOFID getProxyMofId() {
                return this.mofId;
            }
        }
    }
}

