/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.handlers;

import java.lang.reflect.Field;
import java.util.Hashtable;
import javax.jmi.reflect.InvalidNameException;
import javax.jmi.reflect.RefEnum;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.handlers.gen.TagSupport;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;

public final class EnumResolver {
    private static final String ENUMIMPL_SUFFIX = "Enum";
    private static final Hashtable enumCache;

    private static Class getEnumClass(Class ifc) throws IllegalArgumentException {
        try {
            String rawName = ifc.getName() + ENUMIMPL_SUFFIX;
            return BaseObjectHandler.resolveInterface(rawName);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Invalid inteface: " + ifc);
        }
    }

    public static synchronized RefEnum resolveEnum(String ifcName, String label) {
        String enumKey = label + ":" + ifcName;
        RefEnum refEnum = (RefEnum)enumCache.get(enumKey);
        if (refEnum == null) {
            try {
                Class cl = BaseObjectHandler.resolveInterface(ifcName + ENUMIMPL_SUFFIX);
                Field f = cl.getField(TagSupport.mapEnumLiteral(label));
                refEnum = (RefEnum)f.get(null);
                enumCache.put(enumKey, refEnum);
            }
            catch (NoSuchFieldException e) {
                throw new InvalidNameException(label, "Invalid literal name '" + label + "' for enumeration " + ifcName);
            }
            catch (Exception e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }
        return refEnum;
    }

    static {
        ENUMIMPL_SUFFIX = ENUMIMPL_SUFFIX;
        enumCache = new Hashtable(50);
    }
}

