/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence;

import org.netbeans.mdr.persistence.Storage;

public final class MOFID {
    public static final int LENGTH = 8;
    public static final int STRING_LENGTH = 16;
    private long serialNumber;
    private String string = null;
    private String storageId = null;
    private static char[] makeStringBuffer;
    private static int[] longwords;

    public MOFID(Storage storage) {
        this.storageId = storage.getStorageId();
        this.serialNumber = storage.getSerialNumber();
    }

    public MOFID(long serialNumber, String storageId) {
        this.serialNumber = serialNumber;
        if (storageId == null) {
            throw new IllegalArgumentException();
        }
        this.storageId = storageId;
    }

    public long getSerialNumber() {
        return this.serialNumber;
    }

    public String getStorageID() {
        return this.storageId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MOFID)) {
            return false;
        }
        if (this.serialNumber != ((MOFID)o).serialNumber) {
            return false;
        }
        return this.getStorageID().equals(((MOFID)o).getStorageID());
    }

    public int hashCode() {
        return (int)this.serialNumber;
    }

    public static synchronized String makeString(String prefix, long id) {
        int size = prefix.length();
        int totalSize = size + 1 + 16;
        if (makeStringBuffer == null || makeStringBuffer.length < totalSize) {
            makeStringBuffer = new char[totalSize];
        }
        prefix.getChars(0, size, makeStringBuffer, 0);
        MOFID.makeStringBuffer[size] = 58;
        MOFID.fromLong(id, makeStringBuffer, size + 1);
        return new String(makeStringBuffer, 0, totalSize);
    }

    public String toString() {
        if (this.string == null) {
            this.string = MOFID.makeString(this.storageId, this.serialNumber);
        }
        return this.string;
    }

    public static synchronized void fromLong(long value, char[] buffer, int offset) {
        if (longwords == null) {
            longwords = new int[2];
        }
        MOFID.longwords[0] = (int)(value >> 32 & 0xFFFFFFFFFFFFFFFFL);
        MOFID.longwords[1] = (int)(value & 0xFFFFFFFFFFFFFFFFL);
        int j = 0;
        while (j < 2) {
            int shift = 28;
            while (shift >= 0) {
                int b = longwords[j] >> shift & 0xF;
                b = b <= 9 ? (b += 48) : (b += 55);
                buffer[offset++] = (char)b;
                shift -= 4;
            }
            ++j;
        }
    }

    public static MOFID fromString(String mofId) {
        int pos = mofId.lastIndexOf(58);
        if (pos >= 0) {
            try {
                return new MOFID(Long.parseLong(mofId.substring(pos + 1), 16), mofId.substring(0, pos));
            }
            catch (NumberFormatException e) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        LENGTH = 8;
        STRING_LENGTH = 16;
    }
}

