/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.MultivaluedOrderedIndex;
import org.netbeans.mdr.persistence.ObjectResolver;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.StorageException;

public interface Storage {
    public String getName();

    public String getStorageId();

    public long getSerialNumber();

    public MOFID readMOFID(InputStream var1) throws StorageException;

    public void writeMOFID(OutputStream var1, MOFID var2) throws StorageException;

    public SinglevaluedIndex getPrimaryIndex() throws StorageException;

    public boolean exists() throws StorageException;

    public boolean delete() throws StorageException;

    public void create(boolean var1, ObjectResolver var2) throws StorageException;

    public void open(boolean var1, ObjectResolver var2) throws StorageException;

    public void close() throws StorageException;

    public SinglevaluedIndex createSinglevaluedIndex(String var1, EntryType var2, EntryType var3) throws StorageException;

    public MultivaluedOrderedIndex createMultivaluedOrderedIndex(String var1, EntryType var2, EntryType var3, boolean var4) throws StorageException;

    public MultivaluedIndex createMultivaluedIndex(String var1, EntryType var2, EntryType var3, boolean var4) throws StorageException;

    public Index getIndex(String var1) throws StorageException;

    public SinglevaluedIndex getSinglevaluedIndex(String var1) throws StorageException;

    public MultivaluedIndex getMultivaluedIndex(String var1) throws StorageException;

    public MultivaluedOrderedIndex getMultivaluedOrderedIndex(String var1) throws StorageException;

    public void dropIndex(String var1) throws StorageException;

    public void objectStateWillChange(Object var1) throws StorageException;

    public void objectStateChanged(Object var1) throws StorageException;

    public void commitChanges() throws StorageException;

    public void rollBackChanges() throws StorageException;

    public void shutDown() throws StorageException;

    public static class EntryType {
        public static EntryType MOFID = new EntryType(){

            public String toString() {
                return "MOFID";
            }

            public byte encode() {
                return 1;
            }
        };
        public static EntryType STREAMABLE = new EntryType(){

            public String toString() {
                return "STREAMABLE";
            }

            public byte encode() {
                return 2;
            }
        };
        public static EntryType STRING = new EntryType(){

            public String toString() {
                return "STRING";
            }

            public byte encode() {
                return 3;
            }
        };
        public static EntryType INT = new EntryType(){

            public String toString() {
                return "INT";
            }

            public byte encode() {
                return 4;
            }
        };

        public static Collection getEntryTypes() {
            ArrayList<EntryType> al = new ArrayList<EntryType>();
            al.add(MOFID);
            al.add(STREAMABLE);
            al.add(STRING);
            al.add(INT);
            return al;
        }

        public static EntryType decodeEntryType(String name) {
            Iterator it = EntryType.getEntryTypes().iterator();
            while (it.hasNext()) {
                EntryType et = (EntryType)it.next();
                if (!name.equals(et.toString())) continue;
                return et;
            }
            return null;
        }

        public byte encode() {
            return 0;
        }

        public static EntryType decodeEntryType(byte code) {
            Iterator it = EntryType.getEntryTypes().iterator();
            while (it.hasNext()) {
                EntryType et = (EntryType)it.next();
                if (code != et.encode()) continue;
                return et;
            }
            return null;
        }
    }
}

