/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.netbeans.mdr.persistence.RuntimeStorageException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.Btree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePageSource;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.SearchResult;

public class BtreeIterator
implements Iterator {
    protected Btree btree;
    protected SearchResult current;
    protected BtreePageSource pageSource;
    protected int modCount;

    BtreeIterator(Btree btree) {
        try {
            block4: {
                try {
                    this.btree = btree;
                    this.pageSource = btree.pageSource;
                    btree.beginRead();
                    this.modCount = btree.modCount;
                    this.current = btree.getFirst();
                    if (this.current.entryNum < 0) break block4;
                    --this.current.entryNum;
                }
                catch (StorageException e) {
                    throw new RuntimeStorageException(e);
                }
            }
            Object var4_2 = null;
            btree.endRead();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            btree.endRead();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasNext() {
        boolean bl;
        try {
            try {
                this.btree.beginRead();
                this.checkModCount();
                if (!BtreePage.hasNext(null, this.current)) {
                    this.pageSource.unpinPage(this.current.page);
                    this.current.page = null;
                    boolean bl2 = false;
                    Object var3_4 = null;
                    this.btree.endRead();
                    return bl2;
                }
                bl = true;
            }
            catch (StorageException e) {
                throw new RuntimeStorageException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.btree.endRead();
            throw throwable;
        }
        Object var3_5 = null;
        this.btree.endRead();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object next() throws NoSuchElementException {
        if (this.current.page == null) {
            throw new NoSuchElementException();
        }
        try {
            try {
                this.btree.beginRead();
                this.checkModCount();
                BtreePage oldPage = this.current.page;
                BtreePage.getNext(null, this.current);
                if (this.current.page != oldPage) {
                    this.pageSource.unpinPage(oldPage);
                }
                if (!this.current.matched) throw new NoSuchElementException();
                Object object = this.getCurrentItem();
                Object var4_4 = null;
                this.btree.endRead();
                return object;
            }
            catch (StorageException e) {
                throw new RuntimeStorageException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.btree.endRead();
            throw throwable;
        }
    }

    Object getCurrentItem() throws StorageException {
        return this.btree.dataInfo.fromBuffer(this.current.page.getData(this.current.entryNum));
    }

    void checkModCount() {
        if (this.btree.modCount > this.modCount) {
            throw new ConcurrentModificationException("Index " + this.btree.getName() + " has been modified since iterator was created.");
        }
    }

    protected void finalize() {
        if (this.current.page != null) {
            this.pageSource.unpinPage(this.current.page);
            this.current.page = null;
        }
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

