/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.netbeans.mdr.persistence.MultivaluedOrderedIndex;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePageSource;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.MultivaluedBtree;

public class MultivaluedOrderedBtree
extends MultivaluedBtree
implements MultivaluedOrderedIndex {
    public MultivaluedOrderedBtree(String name, Storage.EntryType keyType, Storage.EntryType dataType, boolean uniqueValues, BtreePageSource pageSource) throws StorageException {
        super(name, keyType, dataType, uniqueValues, pageSource);
    }

    public MultivaluedOrderedBtree() {
    }

    public List getItemsOrdered(Object key) throws StorageException {
        return (List)this.getItems(key);
    }

    public Collection getObjectsOrdered(Object key, SinglevaluedIndex repos) throws StorageException {
        return this.getObjects(key, repos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object key, int index, Object data) throws StorageException {
        this.beginWrite();
        try {
            if (index < 0) {
                this.failed = true;
            } else {
                this.failed = false;
                this.btreePut(key, data, (byte)0, index);
                this.updateKeyModCount(key);
            }
            if (this.failed) {
                throw new StorageBadRequestException(MessageFormat.format("Index {0} is out of range for key {1}", new Integer(index), key));
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.endWrite();
            throw throwable;
        }
        this.endWrite();
    }

    public void add(Object key, Object data) throws StorageException {
        this.add(key, Integer.MAX_VALUE, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object key, int index) throws StorageException {
        boolean bl;
        this.beginWrite();
        try {
            byte[] keyBuffer = this.keyInfo.toBuffer(key);
            if (keyBuffer == null) {
                throw new StorageBadRequestException(MessageFormat.format("Invalid key type for this index: {0} received, {1} expected", key.getClass().getName(), this.keyInfo.typeName()));
            }
            BtreePage root = this.pageSource.getPage(this.rootPageId, this);
            boolean result = root.remove(keyBuffer, index);
            if (result) {
                this.updateKeyModCount(key);
            }
            this.pageSource.unpinPage(root);
            bl = result;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endWrite();
            throw throwable;
        }
        this.endWrite();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(Object key, int index, Object data) throws StorageException {
        this.beginWrite();
        try {
            this.failed = false;
            this.btreePut(key, data, (byte)1, index);
            this.updateKeyModCount(key);
            if (this.failed) {
                throw new StorageBadRequestException(MessageFormat.format("Index {0} is out of range for key {1}", new Integer(index), key));
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.endWrite();
            throw throwable;
        }
        this.endWrite();
    }
}

