/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.Btree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreeCollection;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePageSource;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.SearchResult;
import org.netbeans.mdr.util.MapEntryImpl;

public class SinglevaluedBtree
extends Btree
implements SinglevaluedIndex {
    public SinglevaluedBtree(String name, Storage.EntryType keyType, Storage.EntryType dataType, BtreePageSource pageSource) throws StorageException {
        super(name, keyType, dataType, pageSource);
    }

    protected void init() throws StorageException {
        this.uniqueKeys = true;
        this.uniqueValues = false;
        super.init();
    }

    public SinglevaluedBtree() {
    }

    public Object getIfExists(Object key) throws StorageException {
        return this.getIfExistsInternal(key, null);
    }

    public Object getObjectIfExists(Object key, SinglevaluedIndex repos) throws StorageException {
        return this.getIfExistsInternal(key, repos);
    }

    private Object getIfExistsInternal(Object key, SinglevaluedIndex repos) throws StorageException {
        this.beginRead();
        try {
            byte[] keyBuffer = this.keyInfo.toBuffer(key);
            if (keyBuffer == null) {
                throw new StorageBadRequestException(MessageFormat.format("Invalid key type for this index: {0} received, {1} expected", key.getClass().getName(), this.keyInfo.typeName()));
            }
            BtreePage root = this.pageSource.getPage(this.rootPageId, this);
            byte[] dataBuffer = root.get(keyBuffer);
            Object result = dataBuffer != null ? (repos == null ? this.dataInfo.fromBuffer(dataBuffer) : this.dataInfo.objectFromBuffer(dataBuffer, repos)) : null;
            this.pageSource.unpinPage(root);
            Object object = result;
            Object var9_8 = null;
            this.endRead();
            return object;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.endRead();
            throw throwable;
        }
    }

    public Object get(Object key) throws StorageException {
        this.beginRead();
        try {
            Object result = this.getIfExists(key);
            if (result == null) {
                throw new StorageBadRequestException(MessageFormat.format("Key {0} not found in index", key));
            }
            Object object = result;
            Object var5_4 = null;
            this.endRead();
            return object;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.endRead();
            throw throwable;
        }
    }

    public Object getObject(Object key, SinglevaluedIndex repos) throws StorageException {
        this.beginRead();
        try {
            Object result = this.getObjectIfExists(key, repos);
            if (result == null) {
                throw new StorageBadRequestException(MessageFormat.format("Key {0} not found in index", key));
            }
            Object object = result;
            Object var6_5 = null;
            this.endRead();
            return object;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.endRead();
            throw throwable;
        }
    }

    public boolean put(Object key, Object data) throws StorageException {
        this.beginWrite();
        try {
            this.replaced = false;
            this.btreePut(key, data, (byte)2, 0);
            boolean bl = this.replaced;
            Object var5_4 = null;
            this.endWrite();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.endWrite();
            throw throwable;
        }
    }

    public void replace(Object key, Object data) throws StorageException {
        this.beginWrite();
        try {
            this.failed = false;
            this.btreePut(key, data, (byte)1, 0);
            if (this.failed) {
                throw new StorageBadRequestException(MessageFormat.format("Key {0} not found in index", key));
            }
            Object var4_3 = null;
            this.endWrite();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.endWrite();
            throw throwable;
        }
    }

    public Collection values() throws StorageException {
        return new BtreeCollection(this);
    }

    public synchronized Collection queryByKeyPrefix(Object prefix, SinglevaluedIndex primaryIndex) throws StorageException {
        if (this.keyType != Storage.EntryType.STRING) {
            throw new UnsupportedOperationException("Key type must be EntryType.STRING");
        }
        LinkedList<MapEntryImpl> result = new LinkedList<MapEntryImpl>();
        byte[] prefixBytes = this.keyInfo.toBuffer(prefix);
        SearchResult location = this.getLocation(prefixBytes);
        if (location.entryNum == location.page.numEntries()) {
            BtreePage.getNext(null, location);
        }
        while (location.entryNum < location.page.numEntries() && SinglevaluedBtree.isPrefix(prefixBytes, location.page.getKey(location.entryNum))) {
            byte[] key = location.page.getKey(location.entryNum);
            byte[] data = location.page.getData(location.entryNum);
            MapEntryImpl entry = new MapEntryImpl(this.keyInfo.objectFromBuffer(key, primaryIndex), this.dataInfo.objectFromBuffer(data, primaryIndex));
            result.add(entry);
            BtreePage.getNext(null, location);
        }
        return result;
    }

    static boolean isPrefix(byte[] prefix, byte[] key) {
        if (prefix.length > key.length) {
            return false;
        }
        int x = 0;
        while (x < prefix.length) {
            if (prefix[x] != key[x]) {
                return false;
            }
            ++x;
        }
        return true;
    }
}

