/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.StoragePersistentDataException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeDataFile;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeExtent;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPageInputStream;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.DeletedBtreeExtent;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.IntHolder;
import org.netbeans.mdr.util.Logger;

abstract class ActiveBtreeExtent
extends BtreeExtent {
    int dataLength;
    int dataStart;

    ActiveBtreeExtent(DeletedBtreeExtent del) {
        super(del);
        this.headerIsDirty = true;
    }

    ActiveBtreeExtent(BtreeDataFile file, int chunkNum, short numChunks) {
        super(file, chunkNum, numChunks);
    }

    abstract int getMyDataLength();

    abstract int setMyDataLength(int var1);

    abstract int getAvailableDataLength();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void writeData(byte[] dataBuffer, int dataOffset) throws StorageException {
        block7: {
            toCopy = this.dataLength;
            offst = new IntHolder();
            numChunks = (this.dataStart + toCopy - 1) / 32 + 1;
            if (numChunks > this.chunks) {
                se = new StoragePersistentDataException("Number of chunks does not match.");
                Logger.getDefault().annotate((Throwable)se, "Bad number of chunks: ----------------------");
                Logger.getDefault().annotate((Throwable)se, "start chunk number: " + this.myChunkNum);
                Logger.getDefault().annotate((Throwable)se, "#chunks: " + this.chunks + " computed #chunks: " + numChunks);
                Logger.getDefault().annotate((Throwable)se, "dataLength: " + this.dataLength + " dataSart: " + this.dataStart);
                throw se;
            }
            pages = this.owner.getChunks(this.myChunkNum, numChunks, offst);
            try {
                pageNum = 0;
                pageSize = pages[0].contents.length;
                offset = offst.getValue() + this.dataStart;
                while (offset >= pageSize) {
                    ++pageNum;
                    offset -= pageSize;
                }
                while (toCopy > 0) {
                    thisPage = Math.min(pageSize - offset, toCopy);
                    pages[pageNum].setWritable();
                    System.arraycopy(dataBuffer, dataOffset, pages[pageNum].contents, offset, thisPage);
                    dataOffset += thisPage;
                    toCopy -= thisPage;
                    ++pageNum;
                    offset = 0;
                }
                var12_12 = null;
                i = 0;
                ** while (i < pages.length)
            }
            catch (Throwable var11_16) {
                var12_13 = null;
                i = 0;
                ** while (i < pages.length)
            }
lbl-1000:
            // 1 sources

            {
                pages[i].unpin();
                ++i;
                continue;
lbl39:
                // 1 sources

                break block7;
            }
lbl-1000:
            // 1 sources

            {
                pages[i].unpin();
                ++i;
                continue;
            }
lbl48:
            // 1 sources

            throw var11_16;
        }
    }

    void addToStream(CachedPageInputStream strm) throws StorageException {
        IntHolder offst = new IntHolder();
        int toAppend = this.getMyDataLength();
        int numChunks = (this.dataStart + toAppend - 1) / 32 + 1;
        CachedPage[] pages = this.owner.getChunks(this.myChunkNum, numChunks, offst);
        if (numChunks > this.chunks) {
            StoragePersistentDataException se = new StoragePersistentDataException("Number of chunks does not match.");
            Logger.getDefault().annotate((Throwable)se, "Bad number of chunks: ----------------------");
            Logger.getDefault().annotate((Throwable)se, "start chunk number: " + this.myChunkNum);
            Logger.getDefault().annotate((Throwable)se, "#chunks: " + this.chunks + " computed #chunks: " + numChunks);
            Logger.getDefault().annotate((Throwable)se, "dataLength: " + this.dataLength + " dataSart: " + this.dataStart);
            throw se;
        }
        int pageNum = 0;
        int pageSize = pages[0].contents.length;
        int offset = offst.getValue() + this.dataStart;
        while (offset >= pageSize) {
            ++pageNum;
            offset -= pageSize;
        }
        while (pageNum < pages.length) {
            int thisPage = Math.min(pageSize - offset, toAppend);
            strm.addPage(pages[pageNum], offset, thisPage);
            offset = 0;
            toAppend -= thisPage;
            ++pageNum;
        }
        while (pageNum < pages.length) {
            pages[pageNum].unpin();
            ++pageNum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getCRC() throws StorageException {
        CachedPageInputStream dstrm = new CachedPageInputStream();
        FilterInputStream cis = null;
        try {
            long l;
            block8: {
                block7: {
                    try {
                        this.addToStream(dstrm);
                        cis = new CheckedInputStream(dstrm, new CRC32());
                        while (((CheckedInputStream)cis).read() >= 0) {
                        }
                        l = ((CheckedInputStream)cis).getChecksum().getValue();
                        Object var6_5 = null;
                        if (cis == null) break block7;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (cis != null) {
                            cis.close();
                        } else {
                            dstrm.close();
                        }
                        throw throwable;
                    }
                    cis.close();
                    break block8;
                }
                dstrm.close();
            }
            return l;
        }
        catch (IOException exc) {
            throw new StorageIOException(exc);
        }
    }

    abstract boolean isMaximum();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(int level, PrintWriter strm) throws StorageException {
        super.dump(level, strm);
        boolean dumpData = (level & 4) != 0;
        boolean showCheckSum = (level & 8) != 0;
        strm.println("" + this.dataLength + " data bytes");
        if (dumpData) {
            CachedPageInputStream dstrm = new CachedPageInputStream();
            try {
                try {
                    this.addToStream(dstrm);
                    if (dumpData) {
                        BtreeExtent.dumpBytesAsHex(dstrm, strm, "\t");
                        strm.println();
                    }
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    dstrm.close();
                    throw throwable;
                }
                dstrm.close();
                {
                }
            }
            catch (IOException exc) {
                throw new StorageIOException(exc);
            }
        }
        if (showCheckSum) {
            strm.println("Data checksum: " + this.getCRC());
            strm.println();
        }
    }
}

