/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.MultivaluedOrderedIndex;
import org.netbeans.mdr.persistence.ObjectResolver;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.EntryTypeInfo;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.MofidGenerator;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.MultivaluedBtree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.MultivaluedOrderedBtree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.SinglevaluedBtree;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeDatabase;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeMDRSource;
import org.netbeans.mdr.util.Logger;

public class BtreeStorage
implements Storage {
    private static final String COUNTER_KEY = "counter";
    private static final String MAP1_INDEX_PREFIX = "storageIds:";
    private static final String MAP2_INDEX_PREFIX = "storageCodes:";
    private BtreeDatabase btreeDB;
    private transient EntryTypeInfo mofIdEntryTypeInfo;
    private transient int mofIdClassCode;
    private transient byte[] buffer = new byte[8];
    MofidGenerator gen;
    private String btreeDBName;
    private String shortName;
    private ObjectResolver resolver;
    private SinglevaluedIndex storageIdsMap;
    private SinglevaluedIndex storageCodesMap;
    private int storageNumbersCounter;
    private HashMap tempMap = null;
    private HashMap tempMap2 = null;
    static /* synthetic */ Class class$org$netbeans$mdr$persistence$SinglevaluedIndex;
    static /* synthetic */ Class class$org$netbeans$mdr$persistence$MultivaluedIndex;
    static /* synthetic */ Class class$org$netbeans$mdr$persistence$MultivaluedOrderedIndex;

    public BtreeStorage(String name) {
        Logger.getDefault().log("DATABSE: " + name);
        this.btreeDBName = name;
        this.shortName = new File(name).getName();
    }

    public String getName() {
        return this.btreeDBName;
    }

    public String getStorageId() {
        return this.gen.getMofidPrefix();
    }

    public long getSerialNumber() {
        return this.gen.getNextMofid();
    }

    public boolean exists() {
        return BtreeDatabase.exists(this.btreeDBName);
    }

    public boolean delete() throws StorageException {
        this.checkRepositoryClosed();
        return BtreeDatabase.delete(this.btreeDBName);
    }

    public synchronized void create(boolean replace, ObjectResolver resolver) throws StorageException {
        this.checkRepositoryClosed();
        if (this.exists()) {
            if (replace) {
                if (!this.delete()) {
                    throw new StorageBadRequestException(MessageFormat.format("Unable to delete btree repository {0}", this.btreeDBName));
                }
            } else {
                throw new StorageBadRequestException(MessageFormat.format("Btree repository {0} already exists", this.btreeDBName));
            }
        }
        this.resolver = resolver;
        this.btreeDB = new BtreeDatabase(this.btreeDBName, this, true);
        this.gen = this.btreeDB.getMofidGenerator();
        this.storageIdsMap = this.createSinglevaluedIndex(MAP1_INDEX_PREFIX + this.shortName, Storage.EntryType.STRING, Storage.EntryType.INT);
        this.storageCodesMap = this.createSinglevaluedIndex(MAP2_INDEX_PREFIX + this.shortName, Storage.EntryType.INT, Storage.EntryType.STRING);
    }

    public synchronized void open(boolean createIfNoExist, ObjectResolver resolver) throws StorageException {
        this.checkRepositoryClosed();
        if (this.exists()) {
            this.resolver = resolver;
            this.btreeDB = new BtreeDatabase(this.btreeDBName, this, false);
            this.gen = this.btreeDB.getMofidGenerator();
            this.storageIdsMap = this.getSinglevaluedIndex(MAP1_INDEX_PREFIX + this.shortName);
            this.storageCodesMap = this.getSinglevaluedIndex(MAP2_INDEX_PREFIX + this.shortName);
            return;
        }
        if (createIfNoExist) {
            this.create(false, resolver);
            return;
        }
        throw new StorageBadRequestException(MessageFormat.format("Btree repository {0} does not exist", this.btreeDBName));
    }

    public synchronized void close() throws StorageException {
        this.checkRepositoryOpen();
        this.btreeDB.close();
        this.btreeDB = null;
        this.gen = null;
        this.tempMap = null;
    }

    public SinglevaluedIndex getPrimaryIndex() throws StorageException {
        this.checkRepositoryOpen();
        return this.btreeDB;
    }

    public synchronized SinglevaluedIndex createSinglevaluedIndex(String name, Storage.EntryType keyType, Storage.EntryType valueType) throws StorageException {
        this.checkRepositoryOpen();
        SinglevaluedBtree index = new SinglevaluedBtree(name, keyType, valueType, new BtreeMDRSource(this, 2048));
        this.btreeDB.addIndex(name, index, new MOFID(this));
        return index;
    }

    public synchronized MultivaluedOrderedIndex createMultivaluedOrderedIndex(String name, Storage.EntryType keyType, Storage.EntryType valueType, boolean unique) throws StorageException {
        this.checkRepositoryOpen();
        MultivaluedOrderedBtree index = new MultivaluedOrderedBtree(name, keyType, valueType, unique, new BtreeMDRSource(this, 2048));
        this.btreeDB.addIndex(name, index, new MOFID(this));
        return index;
    }

    public synchronized MultivaluedIndex createMultivaluedIndex(String name, Storage.EntryType keyType, Storage.EntryType valueType, boolean unique) throws StorageException {
        this.checkRepositoryOpen();
        MultivaluedBtree index = new MultivaluedBtree(name, keyType, valueType, unique, new BtreeMDRSource(this, 2048));
        this.btreeDB.addIndex(name, index, new MOFID(this));
        return index;
    }

    public synchronized Index getIndex(String name) throws StorageException {
        this.checkRepositoryOpen();
        return (Index)this.btreeDB.fetchIndex(name);
    }

    public synchronized SinglevaluedIndex getSinglevaluedIndex(String name) throws StorageException {
        Index idx = this.getIndex(name);
        this.checkIndexType(idx, name, class$org$netbeans$mdr$persistence$SinglevaluedIndex == null ? (class$org$netbeans$mdr$persistence$SinglevaluedIndex = BtreeStorage.class$("org.netbeans.mdr.persistence.SinglevaluedIndex")) : class$org$netbeans$mdr$persistence$SinglevaluedIndex);
        return (SinglevaluedIndex)idx;
    }

    public synchronized MultivaluedIndex getMultivaluedIndex(String name) throws StorageException {
        Index idx = this.getIndex(name);
        this.checkIndexType(idx, name, class$org$netbeans$mdr$persistence$MultivaluedIndex == null ? (class$org$netbeans$mdr$persistence$MultivaluedIndex = BtreeStorage.class$("org.netbeans.mdr.persistence.MultivaluedIndex")) : class$org$netbeans$mdr$persistence$MultivaluedIndex);
        return (MultivaluedIndex)idx;
    }

    public synchronized MultivaluedOrderedIndex getMultivaluedOrderedIndex(String name) throws StorageException {
        Index idx = this.getIndex(name);
        this.checkIndexType(idx, name, class$org$netbeans$mdr$persistence$MultivaluedOrderedIndex == null ? (class$org$netbeans$mdr$persistence$MultivaluedOrderedIndex = BtreeStorage.class$("org.netbeans.mdr.persistence.MultivaluedOrderedIndex")) : class$org$netbeans$mdr$persistence$MultivaluedOrderedIndex);
        return (MultivaluedOrderedIndex)idx;
    }

    public synchronized void dropIndex(String name) throws StorageException {
        this.checkRepositoryOpen();
        this.btreeDB.dropIndex(name);
    }

    public void objectStateWillChange(Object key) throws StorageException {
    }

    public synchronized void objectStateChanged(Object key) throws StorageException {
        this.checkRepositoryOpen();
        this.btreeDB.objectStateChanged(key);
    }

    public synchronized void commitChanges() throws StorageException {
        this.checkRepositoryOpen();
        this.btreeDB.commitChanges();
    }

    public synchronized void rollBackChanges() throws StorageException {
        this.checkRepositoryOpen();
        this.btreeDB.rollbackChanges();
        this.close();
        this.open(false, this.resolver);
    }

    public synchronized void shutDown() throws StorageException {
        this.checkRepositoryOpen();
        this.btreeDB.shutDown();
    }

    public boolean supportsMultipleStorableIndexes() {
        return false;
    }

    public void writeMOFID(OutputStream outputStream, MOFID mofId) throws StorageException {
        DataOutputStream out = null;
        out = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        long mofidData = mofId.getSerialNumber();
        String storageId = mofId.getStorageID();
        int s = this.getStorageId().equals(storageId) ? 0 : ("00000000-0000-0000-0000-000000000000".equals(storageId) ? 1 : (int)((short)this.storageIdToNumber(storageId)));
        mofidData |= (long)s << 48;
        try {
            while (mofidData != 0L) {
                int b = (int)mofidData & 0x7F;
                if ((mofidData >>>= 7) != 0L) {
                    b |= 0x80;
                }
                out.write(b);
            }
        }
        catch (IOException e) {
            throw (StorageException)Logger.getDefault().annotate((Throwable)new StorageIOException(e), (Throwable)e);
        }
    }

    public final void writeMOFIDData(OutputStream out, MOFID mofid) throws StorageException {
        try {
            out.write(this.getMOFIDData(mofid));
        }
        catch (IOException ioException) {
            throw new StorageIOException(ioException);
        }
    }

    public final byte[] getMOFIDData(MOFID mofid) throws StorageException {
        if (this.mofIdEntryTypeInfo == null) {
            this.mofIdEntryTypeInfo = EntryTypeInfo.getEntryTypeInfo(Storage.EntryType.MOFID, this);
        }
        return this.mofIdEntryTypeInfo.toBuffer(mofid);
    }

    public MOFID readMOFID(InputStream inputStream) throws StorageException {
        DataInputStream in = null;
        in = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        long mofidData = 0L;
        try {
            String storageId;
            int b;
            int i = 0;
            do {
                b = in.read();
                mofidData |= (long)(b & 0x7F) << i * 7;
                ++i;
            } while ((b & 0x80) != 0);
            int storageNumber = (int)(mofidData >> 48);
            switch (storageNumber) {
                case 1: {
                    storageId = "00000000-0000-0000-0000-000000000000";
                    break;
                }
                case 0: {
                    storageId = this.getStorageId();
                    break;
                }
                default: {
                    storageId = this.numberToStorageId(storageNumber);
                }
            }
            return new MOFID(mofidData & 0xFFFFFFFFFFFFL, storageId);
        }
        catch (IOException e) {
            throw (StorageException)Logger.getDefault().annotate((Throwable)new StorageIOException(e), (Throwable)e);
        }
    }

    public final MOFID readMOFIDData(InputStream in) throws StorageException {
        if (this.mofIdEntryTypeInfo == null) {
            this.mofIdEntryTypeInfo = EntryTypeInfo.getEntryTypeInfo(Storage.EntryType.MOFID, this);
        }
        try {
            in.read(this.buffer);
            return (MOFID)this.mofIdEntryTypeInfo.fromBuffer(this.buffer);
        }
        catch (IOException ioException) {
            throw new StorageIOException(ioException);
        }
    }

    public MofidGenerator getMofidGenerator() {
        return this.btreeDB.getMofidGenerator();
    }

    public Map getMofidMap() {
        return this.btreeDB.getMofidMap();
    }

    private void initStorageIdsMap() throws StorageException {
        Object value = this.storageIdsMap.getIfExists(COUNTER_KEY);
        if (value == null) {
            this.storageNumbersCounter = 2;
            value = new Integer(this.storageNumbersCounter);
            this.storageIdsMap.put(COUNTER_KEY, value);
        }
        this.storageNumbersCounter = (Integer)value;
        this.tempMap = new HashMap();
        this.tempMap2 = new HashMap();
    }

    public synchronized int storageIdToNumber(String storageId) throws StorageException {
        Object value;
        if (this.tempMap == null) {
            this.initStorageIdsMap();
        }
        if ((value = this.tempMap.get(storageId)) == null) {
            value = this.storageIdsMap.getIfExists(storageId);
            if (value == null) {
                ++this.storageNumbersCounter;
                value = new Integer(this.storageNumbersCounter);
                this.storageIdsMap.replace(COUNTER_KEY, value);
                this.storageIdsMap.put(storageId, value);
                this.storageCodesMap.put(value, storageId);
            }
            this.tempMap.put(storageId, value);
        }
        return (Integer)value;
    }

    public synchronized String numberToStorageId(int number) throws StorageException {
        Integer code;
        Object value;
        if (this.tempMap == null) {
            this.initStorageIdsMap();
        }
        if ((value = this.tempMap2.get(code = new Integer(number))) == null) {
            value = this.storageCodesMap.get(code);
            if (value == null) {
                throw new StorageBadRequestException("Unknown storage code requested: " + number);
            }
            this.tempMap2.put(code, value);
        }
        return (String)value;
    }

    public Object resolveObject(MOFID key) throws StorageException {
        return this.resolver.resolve(key.getStorageID(), key);
    }

    private void checkIndexType(Object idx, String idxName, Class idxType) throws StorageException {
        if (!idxType.isInstance(idx)) {
            throw new StorageBadRequestException(MessageFormat.format("{0} is not a {1}", idxName, idxType.getName()));
        }
    }

    private void checkRepositoryClosed() throws StorageException {
        if (this.btreeDB != null) {
            throw new StorageBadRequestException(MessageFormat.format("The btree repository {0} is already open", this.btreeDBName));
        }
    }

    private void checkRepositoryOpen() throws StorageException {
        if (this.btreeDB == null) {
            throw new StorageBadRequestException(MessageFormat.format("The btree repository {0} is not open", this.btreeDBName));
        }
    }

    private void notSupported() throws StorageException {
        throw new StorageBadRequestException("Secondary indices are not supported!");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        COUNTER_KEY = COUNTER_KEY;
        MAP1_INDEX_PREFIX = MAP1_INDEX_PREFIX;
        MAP2_INDEX_PREFIX = MAP2_INDEX_PREFIX;
    }
}

