/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.UnsupportedEncodingException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.IntHolder;

public class Converter {
    private static final String ENCODING = "UTF-8";

    public static final void writeByte(byte[] array, IntHolder offset, byte data) {
        offset.setValue(Converter.writeByte(array, offset.getValue(), data));
    }

    public static final int writeByte(byte[] array, int offset, byte data) {
        array[offset++] = data;
        return offset;
    }

    public static final void writeShort(byte[] array, IntHolder offset, short data) {
        offset.setValue(Converter.writeShort(array, offset.getValue(), data));
    }

    public static final int writeShort(byte[] array, int offset, short data) {
        array[offset++] = (byte)(data >> 8 & 0xFF);
        array[offset++] = (byte)(data & 0xFF);
        return offset;
    }

    public static final void writeInt(byte[] array, IntHolder offset, int data) {
        offset.setValue(Converter.writeInt(array, offset.getValue(), data));
    }

    public static final int writeInt(byte[] array, int offset, int data) {
        array[offset++] = (byte)(data >> 24 & 0xFF);
        array[offset++] = (byte)(data >> 16 & 0xFF);
        array[offset++] = (byte)(data >> 8 & 0xFF);
        array[offset++] = (byte)(data & 0xFF);
        return offset;
    }

    public static final void writeLong(byte[] array, IntHolder offset, long data) {
        offset.setValue(Converter.writeLong(array, offset.getValue(), data));
    }

    public static final int writeLong(byte[] array, int offset, long data) {
        array[offset++] = (byte)(data >>> 56 & 0xFFL);
        array[offset++] = (byte)(data >>> 48 & 0xFFL);
        array[offset++] = (byte)(data >>> 40 & 0xFFL);
        array[offset++] = (byte)(data >>> 32 & 0xFFL);
        array[offset++] = (byte)(data >>> 24 & 0xFFL);
        array[offset++] = (byte)(data >>> 16 & 0xFFL);
        array[offset++] = (byte)(data >>> 8 & 0xFFL);
        array[offset++] = (byte)(data & 0xFFL);
        return offset;
    }

    public static final void writeString(byte[] array, IntHolder offset, String data) {
        offset.setValue(Converter.writeString(array, offset.getValue(), data));
    }

    public static final int writeString(byte[] array, int offset, String data) {
        byte[] enc = Converter.convertStringToUTF8(data);
        offset = Converter.writeShort(array, offset, (short)enc.length);
        if (enc.length > 0) {
            System.arraycopy(enc, 0, array, offset, enc.length);
        }
        return offset + enc.length;
    }

    public static final byte[] convertStringToUTF8(String str) {
        byte[] result = null;
        try {
            result = str.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported!");
        }
        return result;
    }

    public static final byte readByte(byte[] array, IntHolder offset) {
        int offst = offset.getValue();
        byte data = Converter.readByte(array, offst);
        offset.setValue(offst + 1);
        return data;
    }

    public static final byte readByte(byte[] array, int offst) {
        byte data = array[offst];
        return data;
    }

    public static final short readShort(byte[] array, IntHolder offset) {
        int offst = offset.getValue();
        short data = Converter.readShort(array, offst);
        offset.setValue(offst + 2);
        return data;
    }

    public static final short readShort(byte[] array, int offst) {
        short data = (short)((short)array[offst++] & 0xFF);
        data = (short)(data << 8);
        data = (short)(data | (short)array[offst] & 0xFF);
        return data;
    }

    public static final int readInt(byte[] array, IntHolder offset) {
        int offst = offset.getValue();
        int data = Converter.readInt(array, offst);
        offset.setValue(offst + 4);
        return data;
    }

    public static final int readInt(byte[] array, int offst) {
        int data = array[offst++] & 0xFF;
        int i = 0;
        while (i < 3) {
            data <<= 8;
            data |= array[offst++] & 0xFF;
            ++i;
        }
        return data;
    }

    public static final long readLong(byte[] array, IntHolder offset) {
        int offst = offset.getValue();
        long data = Converter.readLong(array, offst);
        offset.setValue(offst + 8);
        return data;
    }

    public static final long readLong(byte[] array, int offst) {
        long data = (long)array[offst++] & 0xFFL;
        int i = 0;
        while (i < 7) {
            data <<= 8;
            data |= (long)array[offst++] & 0xFFL;
            ++i;
        }
        return data;
    }

    public static final String readString(byte[] array, IntHolder offset) {
        return Converter.readString(array, offset.getValue(), offset);
    }

    public static final String readString(byte[] array, int offset) {
        return Converter.readString(array, offset, null);
    }

    private static String readString(byte[] array, int offset, IntHolder newOffset) {
        String str;
        short arrSize = Converter.readShort(array, offset);
        if (arrSize == 0) {
            str = new String();
        } else {
            byte[] enc = new byte[arrSize];
            System.arraycopy(array, offset + 2, enc, 0, arrSize);
            str = Converter.convertUTF8ToString(enc);
        }
        if (newOffset != null) {
            newOffset.setValue(offset + 2 + arrSize);
        }
        return str;
    }

    public static final String convertUTF8ToString(byte[] buffer) {
        String result = null;
        try {
            result = new String(buffer, ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported!");
        }
        return result;
    }

    static {
        ENCODING = ENCODING;
    }
}

