/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.util.AbstractSequentialList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class IntrusiveList
extends AbstractSequentialList
implements List {
    private Member head;
    private int mySize;
    private int modLevel;

    public IntrusiveList() {
        this.head.previous = this.head.next = (this.head = new Member());
        this.modLevel = 0;
    }

    public void addFirst(Member m) {
        this.addAfter(m, this.head);
    }

    public void addLast(Member m) {
        this.addAfter(m, this.head.previous);
    }

    public void remove(Member m) {
        this.checkOwner(m);
        m.previous.next = m.next;
        m.next.previous = m.previous;
        m.next = null;
        m.previous = null;
        m.owner = null;
        --this.mySize;
        ++this.modLevel;
    }

    public Member removeFirst() {
        Member m = this.head.next;
        if (m == this.head) {
            return null;
        }
        this.remove(m);
        return m;
    }

    public Member removeLast() {
        Member m = this.head.previous;
        if (m == this.head) {
            return null;
        }
        this.remove(m);
        return m;
    }

    public int size() {
        return this.mySize;
    }

    public ListIterator listIterator(int index) {
        return new ListItr(this.modLevel, index);
    }

    private void addAfter(Member toAdd, Member afterMe) {
        this.checkUnowned(toAdd);
        toAdd.next = afterMe.next;
        toAdd.previous = afterMe;
        toAdd.next.previous = toAdd;
        toAdd.previous.next = toAdd;
        toAdd.owner = this;
        ++this.mySize;
        ++this.modLevel;
    }

    private void checkOwner(Member m) {
        if (m.owner != this) {
            throw new IllegalArgumentException("The object is not a member of the list!");
        }
    }

    private void checkUnowned(Member m) {
        if (m.owner != null) {
            throw new IllegalArgumentException("The object is already a member of some list!");
        }
    }

    public static class Member {
        IntrusiveList owner;
        Member previous;
        Member next;
    }

    class ListItr
    implements ListIterator {
        private Member nextMember;
        private Member lastReturned;
        private int nextIndex;
        private int itrModLevel;
        boolean forward;

        ListItr(int level, int index) {
            if (index < 0 || index > IntrusiveList.this.mySize) {
                throw new IndexOutOfBoundsException();
            }
            Member start = IntrusiveList.this.head;
            int i = 0;
            while (i < index) {
                start = start.next;
                ++i;
            }
            this.nextMember = start.next;
            this.lastReturned = null;
            this.nextIndex = index;
            this.itrModLevel = level;
        }

        public boolean hasNext() {
            this.checkLevel();
            return this.nextMember != IntrusiveList.this.head;
        }

        public boolean hasPrevious() {
            this.checkLevel();
            return this.nextMember.previous != IntrusiveList.this.head;
        }

        public int nextIndex() {
            this.checkLevel();
            return this.nextIndex;
        }

        public int previousIndex() {
            this.checkLevel();
            return this.nextIndex - 1;
        }

        public Object next() {
            this.checkLevel();
            if (this.nextMember == IntrusiveList.this.head) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextMember;
            this.nextMember = this.nextMember.next;
            ++this.nextIndex;
            this.forward = true;
            return this.lastReturned;
        }

        public Object previous() {
            this.checkLevel();
            if (this.nextMember.previous == IntrusiveList.this.head) {
                throw new NoSuchElementException();
            }
            this.nextMember = this.lastReturned = this.nextMember.previous;
            --this.nextIndex;
            this.forward = false;
            return this.lastReturned;
        }

        public void remove() {
            this.checkLevel();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.nextMember = this.lastReturned.next;
            IntrusiveList.this.remove(this.lastReturned);
            this.lastReturned = null;
            if (this.forward) {
                --this.nextIndex;
            }
            this.itrModLevel = IntrusiveList.this.modLevel;
        }

        public void set(Object o) {
            this.checkLevel();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            Member m = (Member)o;
            IntrusiveList.this.addAfter(m, this.lastReturned);
            IntrusiveList.this.remove(this.lastReturned);
            this.lastReturned = m;
            this.nextMember = this.forward ? m.next : m;
            this.itrModLevel = IntrusiveList.this.modLevel;
        }

        public void add(Object o) {
            this.checkLevel();
            Member m = (Member)o;
            IntrusiveList.this.addAfter(m, this.nextMember.previous);
            ++this.nextIndex;
            this.lastReturned = null;
            this.itrModLevel = IntrusiveList.this.modLevel;
        }

        private void checkLevel() {
            if (this.itrModLevel != IntrusiveList.this.modLevel) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

