/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.BitSet;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileCache;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.MapPage;

class LogFile {
    private int pageSize;
    private int numFiles;
    private String fileName;
    private RandomAccessFile file;
    private BitSet[] pageBitmaps;
    private MapPage currentMap;
    private FileCache cache;
    long fileId;
    private int beforeWriteFailure = -1;
    private int afterCommitFailure = -1;
    private int recoveryFailure = -1;

    LogFile(FileCache fCache, String name, int pgSz, int files, long id) throws StorageException {
        this.cache = fCache;
        this.pageSize = pgSz;
        this.fileName = name;
        this.numFiles = files;
        this.fileId = id;
        this.pageBitmaps = new BitSet[files];
        int i = 0;
        while (i < files) {
            this.pageBitmaps[i] = new BitSet();
            ++i;
        }
        if (new File(name).exists()) {
            this.recover();
        }
    }

    private boolean isPageLogged(CachedPage page) {
        return this.pageBitmaps[page.key.fileIndex].get(page.key.offset / this.pageSize);
    }

    private void createPhysicalLog() throws StorageException {
        try {
            this.file = new RandomAccessFile(this.fileName, "rw");
            this.file.setLength(0L);
            this.writeMap();
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    void addPageToLog(CachedPage page) throws StorageException {
        if (page.key.offset >= this.currentMap.getEOF(page.key.fileIndex)) {
            return;
        }
        if (this.isPageLogged(page)) {
            return;
        }
        if (this.file == null) {
            this.createPhysicalLog();
        }
        try {
            this.file.seek(this.currentMap.nextPageOffset());
            this.file.write(page.contents);
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
        this.beforeWriteFailure = this.cache.checkForForcedFailure("org.netbeans.mdr.persistence.btreeimpl.btreestorage.LogFile.beforeWriteFailure", this.beforeWriteFailure);
        this.pageBitmaps[page.key.fileIndex].set(page.key.offset / this.pageSize);
        this.currentMap.add(page);
        if (this.currentMap.isFull()) {
            this.writeMap();
        }
        this.cache.holdForLog(page);
    }

    private void writeMap() throws StorageException {
        this.flushFile();
        this.currentMap.write(this.file);
        this.flushFile();
        if (this.currentMap.isFull()) {
            this.currentMap = new MapPage(this.currentMap);
        }
    }

    private void flushFile() throws StorageException {
        try {
            this.file.getFD().sync();
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    void flush() throws StorageException {
        this.writeMap();
        this.cache.logWasFlushed();
    }

    void begin(RandomAccessFile[] files, long timeStamp, long newTimeStamp) throws StorageException {
        this.file = null;
        this.currentMap = new MapPage(this.pageSize, this.numFiles, 0);
        this.currentMap.setEOFs(files);
        int i = 0;
        while (i < this.numFiles) {
            this.pageBitmaps[i].xor(this.pageBitmaps[i]);
            ++i;
        }
        this.currentMap.setTimeStamps(timeStamp, newTimeStamp);
        this.currentMap.setFileID(this.fileId);
    }

    void commit() throws StorageException {
        try {
            if (this.file != null) {
                this.file.close();
                new File(this.fileName).delete();
            }
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
        this.file = null;
        this.afterCommitFailure = this.cache.checkForForcedFailure("org.netbeans.mdr.persistence.btreeimpl.btreestorage.LogFile.afterCommitFailure", this.afterCommitFailure);
    }

    void close() throws StorageException {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    int fileSize() {
        return this.currentMap.nextPageOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void recover() throws StorageException {
        RandomAccessFile[] files = null;
        RandomAccessFile logFile = null;
        try {
            try {
                logFile = new RandomAccessFile(this.fileName, "r");
                files = this.cache.getFiles();
                if (files.length != this.numFiles) {
                    throw new StorageBadRequestException(MessageFormat.format("Log file contains {0} files; {1} were requested", new Integer(this.numFiles), new Integer(files.length)));
                }
                boolean offset = false;
                int numPages = (int)logFile.length() / this.pageSize;
                if (numPages > 0) {
                    byte[] pageBuffer = new byte[this.pageSize];
                    MapPage page = new MapPage(logFile, 0, this.pageSize);
                    page.checkParameters(this.pageSize, this.numFiles);
                    int i = 0;
                    while (i < this.numFiles) {
                        page.checkFileHeader(files[i]);
                        ++i;
                    }
                    while (true) {
                        page.recover(files, logFile, numPages, pageBuffer);
                        this.recoveryFailure = this.cache.checkForForcedFailure("org.netbeans.mdr.persistence.btreeimpl.btreestorage.LogFile.recoveryFailure", this.recoveryFailure);
                        MapPage newPage = page.getNext(logFile, numPages);
                        if (newPage == null || newPage.isEmpty()) break;
                        page = newPage;
                    }
                    page.truncateFiles(files);
                    logFile.close();
                    new File(this.fileName).delete();
                }
                Object var10_10 = null;
                if (logFile == null) return;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (logFile == null) throw throwable;
                logFile.close();
                throw throwable;
            }
            logFile.close();
            return;
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }
}

