/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofPackageClass;
import javax.jmi.model.NameNotFoundException;
import javax.jmi.model.Namespace;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import org.netbeans.api.mdr.events.ExtentEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.MultivaluedOrderedIndex;
import org.netbeans.mdr.persistence.ObjectResolver;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageClient;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageFactory;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.persistence.memoryimpl.StorageFactoryImpl;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.storagemodel.StorablePackage;
import org.netbeans.mdr.storagemodel.transientimpl.TransientStorage;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.EventNotifier;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.mdr.util.Logger;
import org.netbeans.mdr.util.MOFConstants;
import org.netbeans.mdr.util.TransactionMutex;

public class MdrStorage
implements MOFConstants,
ObjectResolver {
    private static final int STORAGE_VERSION = 19;
    static final String IDX_OBJECTS_BY_CLASSES = "ObjectsByClasses";
    private static final String IDX_MDR_STORAGE_PROPERTIES = "Properties";
    private static final String IDX_END1_CLASSES_BY_ASSOCIATIONS = "End1ClassesByAssociations";
    private static final String IDX_END2_CLASSES_BY_ASSOCIATIONS = "End2ClassesByAssociations";
    private static final String IDX_CONTEXTS = "Contexts";
    private static final String PREFIX_ATTR_INDEX = "ai:";
    private static final String PREFIX_ATTR_INDEXES_BY_NAME = "aibn:";
    private static final String PREFIX_ATTR_INDEXES_CLASS_PROXY = "aicp:";
    private static final String PREFIX_ASSOC_END = "ae:";
    public static final String MOF_TOP_PACKAGE = "TOPMOST_PACKAGE";
    public static final String VALUES_ID = "VALUES_ID";
    private static final Hashtable instances;
    private Storage bootStorage;
    private MOFID bootNullMofId;
    private HashMap storages = new HashMap();
    private HashMap nullMofId = new HashMap();
    private HashMap objects = new HashMap();
    private HashMap objByCls = new HashMap();
    private HashMap contexts = new HashMap();
    private HashMap properties = new HashMap();
    private HashMap valuesObjects = new HashMap();
    private final NBMDRepositoryImpl repository;
    private final TransactionMutex repositoryMutex;
    private final EventNotifier eventNotifier;
    private TransientStorage transientStorage;
    private boolean booting;
    private Collection bootClasses = null;
    private Collection bootObjects = null;
    private Collection bootAssociations = null;
    static /* synthetic */ Class class$org$netbeans$mdr$persistence$StorageFactory;

    public static MdrStorage getInstance(Storage storage) {
        return (MdrStorage)instances.get(storage);
    }

    public TransactionMutex getRepositoryMutex() {
        return this.repositoryMutex;
    }

    public EventNotifier getEventNotifier() {
        return this.eventNotifier;
    }

    public NBMDRepositoryImpl getRepository() {
        return this.repository;
    }

    public void setBooting(boolean flag) {
        this.booting = flag;
    }

    public boolean isBooting() {
        return this.booting;
    }

    public MdrStorage(NBMDRepositoryImpl repository, String storageClass, Map properties) {
        this.repository = repository;
        StorageFactory storageFactory = null;
        try {
            Class<?> storageFactoryClass = Class.forName(storageClass);
            if (!(class$org$netbeans$mdr$persistence$StorageFactory == null ? (class$org$netbeans$mdr$persistence$StorageFactory = MdrStorage.class$("org.netbeans.mdr.persistence.StorageFactory")) : class$org$netbeans$mdr$persistence$StorageFactory).isAssignableFrom(storageFactoryClass)) {
                throw new Exception("class " + storageClass + " does not implement StorageFactory");
            }
            storageFactory = (StorageFactory)storageFactoryClass.newInstance();
        }
        catch (Exception e) {
            Logger.getDefault().notify(1, (Throwable)e);
            Logger.getDefault().log("using: org.netbeans.mdr.persistence.memoryimpl.StorageFactoryImpl");
            storageFactory = new StorageFactoryImpl();
        }
        try {
            this.bootStorage = storageFactory.createStorage(properties);
            this.bootNullMofId = storageFactory.createNullMOFID();
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException("Failed accessing storage factory."), (Throwable)e);
        }
        this.eventNotifier = new EventNotifier();
        this.repositoryMutex = new TransactionMutex(this, this.eventNotifier, repository);
    }

    public String mountStorage(String storageFactoryClass, Map properties) throws StorageException, InstantiationException, ClassNotFoundException, IllegalAccessException {
        return this.mountStorage(Class.forName(storageFactoryClass), properties);
    }

    public String mountStorage(Class storageFactoryClass, Map properties) throws StorageException, InstantiationException, IllegalAccessException {
        if ((class$org$netbeans$mdr$persistence$StorageFactory == null ? (class$org$netbeans$mdr$persistence$StorageFactory = MdrStorage.class$("org.netbeans.mdr.persistence.StorageFactory")) : class$org$netbeans$mdr$persistence$StorageFactory).isAssignableFrom(storageFactoryClass)) {
            StorageFactory storageFactory = (StorageFactory)storageFactoryClass.newInstance();
            Storage st = storageFactory.createStorage(properties);
            MOFID nullMofId = storageFactory.createNullMOFID();
            this.init(st, nullMofId, false);
            return st.getStorageId();
        }
        return null;
    }

    public void unmountStorage(String storageId) throws StorageException {
        Storage selStorage = (Storage)this.storages.get(storageId);
        if (selStorage == null) {
            return;
        }
        selStorage.shutDown();
        instances.remove(selStorage);
        this.nullMofId.remove(storageId);
        this.objects.remove(storageId);
        this.objByCls.remove(storageId);
        this.contexts.remove(storageId);
    }

    public boolean init() throws StorageException {
        return this.init(this.bootStorage, this.bootNullMofId, true);
    }

    public boolean init(Storage storage, MOFID nullMofId, boolean defaultStorage) throws StorageException {
        boolean result;
        String storageId = null;
        try {
            storage.open(false, this);
            storageId = storage.getStorageId();
            this.initializeIndexes(storage, defaultStorage, false);
            result = true;
        }
        catch (Exception e) {
            Logger.getDefault().notify(1, (Throwable)e);
            try {
                storage.close();
            }
            catch (StorageException ex) {
                // empty catch block
            }
            storage.create(true, this);
            storageId = storage.getStorageId();
            SinglevaluedIndex objectsIndex = storage.getPrimaryIndex();
            this.objects.put(storageId, objectsIndex);
            this.contexts.put(storageId, storage.createSinglevaluedIndex("Contexts19", Storage.EntryType.STRING, Storage.EntryType.MOFID));
            this.objByCls.put(storageId, storage.createMultivaluedIndex(IDX_OBJECTS_BY_CLASSES, Storage.EntryType.MOFID, Storage.EntryType.MOFID, false));
            SinglevaluedIndex propertiesIndex = storage.createSinglevaluedIndex(IDX_MDR_STORAGE_PROPERTIES, Storage.EntryType.STRING, Storage.EntryType.MOFID);
            propertiesIndex.put("Model.AssociationEnd", nullMofId);
            propertiesIndex.put("Model.Attribute", nullMofId);
            propertiesIndex.put("Model.Reference", nullMofId);
            propertiesIndex.put("Model.Operation", nullMofId);
            MOFID valuesID = new MOFID(storage);
            propertiesIndex.put(VALUES_ID, valuesID);
            this.properties.put(storageId, propertiesIndex);
            ValuesObject valuesObject = new ValuesObject(storage, valuesID);
            this.valuesObjects.put(storageId, valuesObject);
            objectsIndex.add(valuesID, valuesObject);
            storage.objectStateChanged(valuesID);
            result = !defaultStorage;
        }
        instances.put(storage, this);
        this.nullMofId.put(storageId, nullMofId);
        this.storages.put(storageId, storage);
        return result;
    }

    private void initializeIndexes(Storage storage, boolean defaultStorage, boolean rollBack) throws StorageException {
        String storageId = storage.getStorageId();
        SinglevaluedIndex objectsIndex = storage.getPrimaryIndex();
        MultivaluedIndex objByClsIndex = storage.getMultivaluedIndex(IDX_OBJECTS_BY_CLASSES);
        SinglevaluedIndex contextsIndex = storage.getSinglevaluedIndex("Contexts19");
        if (objByClsIndex == null || objectsIndex == null || contextsIndex == null) {
            throw new DebugException("Different storage version.");
        }
        if (!defaultStorage && !rollBack) {
            Iterator it = contextsIndex.keySet().iterator();
            while (it.hasNext()) {
                String extentName = (String)it.next();
                ExtentEvent event = new ExtentEvent((Object)this.repository, 0x8010001, extentName, null, null, false);
                this.getEventNotifier().REPOSITORY.firePlannedChange(this, (MDRChangeEvent)event);
            }
        }
        this.objects.put(storageId, objectsIndex);
        this.contexts.put(storageId, contextsIndex);
        this.objByCls.put(storageId, objByClsIndex);
        SinglevaluedIndex props = storage.getSinglevaluedIndex(IDX_MDR_STORAGE_PROPERTIES);
        if (props == null) {
            throw new DebugException("Different storage version.");
        }
        this.properties.put(storageId, props);
        this.valuesObjects.put(storageId, objectsIndex.get(props.get(VALUES_ID)));
    }

    public void commit() throws StorageException {
        this.save();
    }

    public synchronized void rollback() throws StorageException {
        Iterator it = this.storages.values().iterator();
        while (it.hasNext()) {
            Storage storage = (Storage)it.next();
            storage.rollBackChanges();
            if (storage == this.transientStorage) continue;
            this.initializeIndexes(storage, storage == this.bootStorage, true);
        }
    }

    public synchronized void save() throws StorageException {
        Iterator it = this.storages.values().iterator();
        while (it.hasNext()) {
            Storage storage = (Storage)it.next();
            storage.commitChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() throws StorageException {
        try {
            Iterator it = this.storages.values().iterator();
            while (it.hasNext()) {
                Storage s = (Storage)it.next();
                s.shutDown();
            }
            Object var4_3 = null;
            this.eventNotifier.shutdown();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.eventNotifier.shutdown();
            throw throwable;
        }
    }

    MOFID getProperty(String key) {
        return this.getProperty(this.bootStorage.getStorageId(), key);
    }

    MOFID getProperty(String storageId, String key) {
        try {
            SinglevaluedIndex propertiesIndex = this.getPropertiesIndexByStorageId(storageId);
            if (propertiesIndex == null) {
                throw new DebugException("No such storage");
            }
            return (MOFID)propertiesIndex.get(key);
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    void setProperty(String key, MOFID value) {
        this.setProperty(this.bootStorage.getStorageId(), key, value);
    }

    void setProperty(String storageId, String key, MOFID value) {
        try {
            SinglevaluedIndex propertiesIndex = this.getPropertiesIndexByStorageId(storageId);
            if (propertiesIndex == null) {
                throw new DebugException("No such storage");
            }
            propertiesIndex.put(key, value);
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    public ValuesObject values(MOFID mofId) {
        String storageId = MdrStorage.getStorageIdFromMofId(mofId);
        return this.storageValues(storageId);
    }

    public ValuesObject storageValues(String storageId) {
        if (storageId == null) {
            storageId = this.bootStorage.getStorageId();
        }
        return (ValuesObject)this.valuesObjects.get(storageId);
    }

    public StorableBaseObject getObject(MOFID mofid) throws StorageException {
        if (mofid == null) {
            return null;
        }
        SinglevaluedIndex objectsIndex = this.getObjectsIndexByMofId(mofid);
        if (objectsIndex == null) {
            return null;
        }
        return (StorableBaseObject)objectsIndex.get(mofid);
    }

    public StorableBaseObject getObjectFromIndexIfExists(SinglevaluedIndex index, Object key) throws StorageException {
        Object mofId = index.getIfExists(key);
        if (!(mofId instanceof MOFID)) {
            return null;
        }
        SinglevaluedIndex objectsIndex = this.getObjectsIndexByMofId((MOFID)mofId);
        if (objectsIndex == null) {
            return null;
        }
        return (StorableBaseObject)objectsIndex.getIfExists(mofId);
    }

    public Collection getObjectsFromIndex(MultivaluedIndex index, Object key) throws StorageException {
        SinglevaluedIndex objectsIndex = this.getObjectsIndexByMofId((MOFID)key);
        if (objectsIndex == null) {
            throw new DebugException("Invalid key");
        }
        if (index instanceof MultivaluedOrderedIndex) {
            return ((MultivaluedOrderedIndex)index).getObjectsOrdered(key, objectsIndex);
        }
        return index.getObjects(key, objectsIndex);
    }

    void addObject(StorableBaseObject object) throws StorageException {
        MOFID mofId = object.getMofId();
        SinglevaluedIndex objectsIndex = this.getObjectsIndexByMofId(mofId);
        if (objectsIndex == null) {
            throw new DebugException("Storage not found");
        }
        objectsIndex.add(mofId, object);
    }

    void removeObject(StorableBaseObject object) throws StorageException {
        MOFID mofId = object.getMofId();
        this.removeObject(mofId);
    }

    void removeObject(MOFID mofId) throws StorageException {
        SinglevaluedIndex objectsIndex = this.getObjectsIndexByMofId(mofId);
        if (objectsIndex == null) {
            throw new DebugException("Storage not found");
        }
        objectsIndex.remove(mofId);
    }

    void addInstance(StorableObject object) throws StorageException {
        this.addObject(object);
        MOFID mofId = object.getMofId();
        String storageId = MdrStorage.getStorageIdFromMofId(mofId);
        if (storageId == null) {
            throw new DebugException("Invalid MOF ID");
        }
        MultivaluedIndex objByClsIndex = (MultivaluedIndex)this.objByCls.get(storageId);
        if (objByClsIndex == null) {
            throw new DebugException("Storage not found");
        }
        objByClsIndex.add(object.getClassProxyId(), mofId);
    }

    void removeInstance(StorableObject object) throws StorageException {
        MOFID mofId = object.getMofId();
        MOFID classProxyMofId = object.getClassProxyId();
        this.removeInstance(mofId, classProxyMofId);
    }

    void removeInstance(MOFID mofId, MOFID classProxyMofId) throws StorageException {
        this.removeObject(mofId);
        MultivaluedIndex objByClsIndex = this.getObjectsByClassesByMofId(mofId);
        if (objByClsIndex == null) {
            throw new DebugException("Storage not found");
        }
        objByClsIndex.remove(classProxyMofId, mofId);
    }

    public MultivaluedIndex getInstancesIndex(StorableClass classProxy) {
        return this.getInstancesIndex(classProxy.getMofId());
    }

    public MultivaluedIndex getInstancesIndex(MOFID classProxyId) {
        String storageId = MdrStorage.getStorageIdFromMofId(classProxyId);
        if (storageId == null) {
            throw new DebugException("Invalid MOF ID");
        }
        MultivaluedIndex objByClsIndex = (MultivaluedIndex)this.objByCls.get(storageId);
        if (objByClsIndex == null) {
            throw new DebugException("Storage not found");
        }
        return objByClsIndex;
    }

    public Collection getInstancesIds(MOFID classProxyId) throws StorageException {
        String storageId = MdrStorage.getStorageIdFromMofId(classProxyId);
        if (storageId == null) {
            throw new DebugException("Invalid MOF ID");
        }
        MultivaluedIndex objByClsIndex = (MultivaluedIndex)this.objByCls.get(storageId);
        if (objByClsIndex == null) {
            throw new DebugException("Storage not found");
        }
        return objByClsIndex.getItems(classProxyId);
    }

    void createContext(String name, MOFID mofId) throws StorageException {
        String storageId = MdrStorage.getStorageIdFromMofId(mofId);
        if (storageId == null) {
            throw new DebugException("Invalid MOF ID");
        }
        Storage storage = (Storage)this.storages.get(storageId);
        if (storage == null) {
            throw new DebugException("Storage not found");
        }
        storage.createSinglevaluedIndex(PREFIX_ATTR_INDEXES_BY_NAME + mofId.toString(), Storage.EntryType.STRING, Storage.EntryType.STRING);
        storage.createSinglevaluedIndex(PREFIX_ATTR_INDEXES_CLASS_PROXY + mofId.toString(), Storage.EntryType.STRING, Storage.EntryType.MOFID);
        if (name != null) {
            SinglevaluedIndex contextsIndex = (SinglevaluedIndex)this.contexts.get(storageId);
            if (contextsIndex == null) {
                throw new DebugException("Storage not found");
            }
            contextsIndex.put(name, mofId);
        }
    }

    void dropContext(String name, MOFID mofId) throws StorageException {
        String storageId = MdrStorage.getStorageIdFromMofId(mofId);
        if (storageId == null) {
            throw new DebugException("Invalid MOF ID");
        }
        Storage storage = (Storage)this.storages.get(storageId);
        if (storage == null) {
            throw new DebugException("Storage not found");
        }
        Iterator it = storage.getSinglevaluedIndex(PREFIX_ATTR_INDEXES_BY_NAME + mofId.toString()).values().iterator();
        while (it.hasNext()) {
            storage.dropIndex(this.getAdditionalIndexName(mofId, (String)it.next()));
        }
        storage.dropIndex(PREFIX_ATTR_INDEXES_BY_NAME + mofId.toString());
        storage.dropIndex(PREFIX_ATTR_INDEXES_CLASS_PROXY + mofId.toString());
        if (name != null) {
            SinglevaluedIndex contextsIndex = (SinglevaluedIndex)this.contexts.get(storageId);
            if (contextsIndex == null) {
                throw new DebugException("Storage not found");
            }
            contextsIndex.remove(name);
        }
    }

    public Collection getContexts() throws StorageException {
        HashSet result = new HashSet();
        Iterator it = this.contexts.values().iterator();
        while (it.hasNext()) {
            SinglevaluedIndex sv = (SinglevaluedIndex)it.next();
            result.addAll(sv.keySet());
        }
        return result;
    }

    public Collection getContexts(String storageId) throws StorageException {
        SinglevaluedIndex context = (SinglevaluedIndex)this.contexts.get(storageId);
        if (context == null) {
            throw new IllegalArgumentException();
        }
        HashSet result = new HashSet();
        result.addAll(context.keySet());
        return result;
    }

    public StorablePackage getContextOutermostPackage(String context) throws StorageException {
        Object id = null;
        Iterator it = this.contexts.values().iterator();
        while (it.hasNext()) {
            SinglevaluedIndex contextsIndex = (SinglevaluedIndex)it.next();
            id = contextsIndex.getIfExists(context);
            if (id == null) continue;
            return (StorablePackage)this.getObject((MOFID)id);
        }
        return null;
    }

    public void createAdditionalIndex(MOFID context, String indexName, MOFID proxyId) throws StorageException {
        Storage storage = this.getStorageByMofId(context);
        if (storage == null) {
            throw new DebugException("Storage not found");
        }
        storage.getSinglevaluedIndex(PREFIX_ATTR_INDEXES_BY_NAME + context.toString()).put(indexName, indexName);
        storage.getSinglevaluedIndex(PREFIX_ATTR_INDEXES_CLASS_PROXY + context.toString()).put(indexName, proxyId);
        storage.createMultivaluedIndex(this.getAdditionalIndexName(context, indexName), Storage.EntryType.STRING, Storage.EntryType.MOFID, false);
    }

    private MultivaluedIndex getAdditionalIndex(MOFID context, String indexName) {
        try {
            Storage storage = this.getStorageByMofId(context);
            if (storage == null) {
                throw new DebugException("Storage not found");
            }
            return storage.getMultivaluedIndex(this.getAdditionalIndexName(context, indexName));
        }
        catch (StorageException e) {
            return null;
        }
    }

    private StorableClass getIndexClassProxy(MOFID context, String indexName) {
        try {
            Storage storage = this.getStorageByMofId(context);
            if (storage == null) {
                throw new DebugException("Storage not found");
            }
            return (StorableClass)this.getObject((MOFID)storage.getSinglevaluedIndex(PREFIX_ATTR_INDEXES_CLASS_PROXY + context.toString()).get(indexName));
        }
        catch (StorageException e) {
            return null;
        }
    }

    MultivaluedIndex acquireAdditionalIndex(MOFID context, String indexName) {
        MultivaluedIndex result = this.getAdditionalIndex(context, indexName);
        return result;
    }

    void releaseAdditionalIndex() {
    }

    public Collection objectsFromAdditionalIndex(MOFID context, String indexName, String value) {
        try {
            SinglevaluedIndex objectsIndex = this.getObjectsIndexByMofId(context);
            return this.getAdditionalIndex(context, this.resolveAttrMofId(context, indexName)).getObjects(value, objectsIndex);
        }
        catch (StorageException e) {
            return null;
        }
    }

    public Collection getItemsFromAdditionalIndex(MOFID context, String indexName, Object value) {
        try {
            StorableClass sc = this.getIndexClassProxy(context, indexName);
            if (sc == null) {
                throw new DebugException("Index " + indexName + " does not exist in the specified context.");
            }
            StorableClass.IndexDescriptor desc = sc.getAdditionalIndex(indexName);
            String valueToString = StorableObject.valueToKey(value, desc.getFields());
            return this.getAdditionalIndex(context, this.resolveAttrMofId(context, indexName)).getItems(valueToString);
        }
        catch (StorageException e) {
            return null;
        }
    }

    public Collection getObjectsFromAdditionalIndex(MOFID context, String indexName, Object value) {
        try {
            StorableClass sc = this.getIndexClassProxy(context, indexName);
            if (sc == null) {
                throw new DebugException("Index " + indexName + " does not exist in the specified context.");
            }
            StorableClass.IndexDescriptor desc = sc.getAdditionalIndex(indexName);
            String valueToString = StorableObject.valueToKey(value, desc.getFields());
            SinglevaluedIndex objectsIndex = this.getObjectsIndexByMofId(context);
            return this.getAdditionalIndex(context, this.resolveAttrMofId(context, indexName)).getObjects(valueToString, objectsIndex);
        }
        catch (StorageException e) {
            return null;
        }
    }

    public Collection queryAdditionalIndex(MOFID context, String indexName, Map map) {
        try {
            StorableClass sc = this.getIndexClassProxy(context, indexName);
            if (sc == null) {
                throw new DebugException("Index " + indexName + " does not exist in the specified context.");
            }
            StorableClass.IndexDescriptor desc = sc.getAdditionalIndex(indexName);
            String valueToString = StorableObject.valuesToKey(map, desc.getFields());
            SinglevaluedIndex objectsIndex = this.getObjectsIndexByMofId(context);
            return this.getAdditionalIndex(context, this.resolveAttrMofId(context, indexName)).getObjects(valueToString, objectsIndex);
        }
        catch (StorageException e) {
            return null;
        }
    }

    private String resolveAttrMofId(MOFID context, String indexName) throws StorageException {
        Storage storage = this.getStorageByMofId(context);
        return (String)storage.getSinglevaluedIndex(PREFIX_ATTR_INDEXES_BY_NAME + context.toString()).get(indexName);
    }

    private String getAdditionalIndexName(MOFID context, String indexName) {
        return PREFIX_ATTR_INDEX + context.toString() + ":" + indexName;
    }

    void addBootObject(MOFID mofId) {
        if (this.bootObjects == null) {
            this.bootObjects = new ArrayList();
        }
        this.bootObjects.add(mofId);
    }

    void addBootClass(MOFID mofId) {
        this.addBootObject(mofId);
        if (this.bootClasses == null) {
            this.bootClasses = new ArrayList();
        }
        this.bootClasses.add(mofId);
    }

    void addBootAssociation(MOFID mofId) {
        this.addBootObject(mofId);
        if (this.bootAssociations == null) {
            this.bootAssociations = new ArrayList();
        }
        this.bootAssociations.add(mofId);
    }

    void dropBoot() throws StorageException {
        String name = "BootMOF";
        MOFID extent = this.getContextOutermostPackage(name).getMofId();
        String storageId = MdrStorage.getStorageIdFromMofId(extent);
        MultivaluedIndex objByClsIndex = (MultivaluedIndex)this.objByCls.get(storageId);
        SinglevaluedIndex objectsIndex = (SinglevaluedIndex)this.objects.get(storageId);
        SinglevaluedIndex contextsIndex = (SinglevaluedIndex)this.contexts.get(storageId);
        Storage storage = (Storage)this.storages.get(storageId);
        if (objByClsIndex == null || objectsIndex == null || contextsIndex == null || storage == null) {
            throw new DebugException("Illegal MdrStorage state");
        }
        Iterator it = this.bootClasses.iterator();
        while (it.hasNext()) {
            objByClsIndex.remove((MOFID)it.next());
        }
        Iterator it2 = this.bootObjects.iterator();
        while (it2.hasNext()) {
            objectsIndex.remove(it2.next());
        }
        Iterator it3 = this.bootAssociations.iterator();
        while (it3.hasNext()) {
            MOFID mofId = (MOFID)it3.next();
            storage.dropIndex(this.getContextAssocEndIndexName(extent, mofId, 1));
            storage.dropIndex(this.getContextAssocEndIndexName(extent, mofId, 2));
        }
        storage.dropIndex(PREFIX_ATTR_INDEXES_BY_NAME + extent.toString());
        storage.dropIndex(PREFIX_ATTR_INDEXES_CLASS_PROXY + extent.toString());
        contextsIndex.remove(name);
        this.bootObjects = null;
        this.bootClasses = null;
        BaseObjectHandler._freeCache();
    }

    void replaceMeta(Hashtable table, RefBaseObject object) throws StorageException {
        StorableBaseObject sObject = this.getObject(((BaseObjectHandler)object)._getDelegate().getMofId());
        sObject.replaceValues(table);
    }

    private RefObject qnToObject(RefPackage pkg, List qualifiedName) {
        ModelPackage mofPackage = (ModelPackage)pkg;
        MofPackageClass pc = mofPackage.getMofPackage();
        Iterator it = qualifiedName.iterator();
        ModelElement object = this.getPackageElement((RefClass)pc, (String)it.next());
        try {
            while (it.hasNext()) {
                object = ((Namespace)object).lookupElement((String)it.next());
            }
        }
        catch (NameNotFoundException e) {
            object = null;
        }
        return object;
    }

    private ModelElement getPackageElement(RefClass pc, String name) {
        ModelElement object = null;
        ModelElement result = null;
        Iterator it = pc.refAllOfClass().iterator();
        result = (ModelElement)it.next();
        while (it.hasNext()) {
            object = (ModelElement)it.next();
            if (!name.equals(object.getName())) continue;
            result = object;
            break;
        }
        return result;
    }

    private List objectToQN(RefObject object) {
        return ((ModelElement)object).getQualifiedName();
    }

    public void rebuildMofContext() {
        try {
            RefObject pureObject;
            RefClass classProxy;
            RefPackage bootMOF = (RefPackage)BaseObjectHandler.getHandler(this.getContextOutermostPackage("BootMOF"));
            RefPackage pureMOF = (RefPackage)BaseObjectHandler.getHandler(this.getContextOutermostPackage("MOF"));
            Hashtable<MOFID, MOFID> fromTo = new Hashtable<MOFID, MOFID>();
            fromTo.put(((BaseObjectHandler)bootMOF)._getDelegate().getMofId(), ((BaseObjectHandler)pureMOF)._getDelegate().getMofId());
            Iterator classes = pureMOF.refAllClasses().iterator();
            while (classes.hasNext()) {
                classProxy = (RefClass)classes.next();
                Iterator instances = classProxy.refAllOfClass().iterator();
                while (instances.hasNext()) {
                    pureObject = (RefObject)instances.next();
                    RefObject bootObject = this.qnToObject(bootMOF, this.objectToQN(pureObject));
                    if (bootObject == null) continue;
                    fromTo.put(((BaseObjectHandler)bootObject)._getDelegate().getMofId(), ((BaseObjectHandler)pureObject)._getDelegate().getMofId());
                }
            }
            this.replaceMeta(fromTo, (RefBaseObject)pureMOF);
            Iterator classes2 = pureMOF.refAllClasses().iterator();
            while (classes2.hasNext()) {
                classProxy = (RefClass)classes2.next();
                this.replaceMeta(fromTo, (RefBaseObject)classProxy);
                Iterator instances = classProxy.refAllOfClass().iterator();
                while (instances.hasNext()) {
                    pureObject = (RefObject)instances.next();
                    this.replaceMeta(fromTo, (RefBaseObject)pureObject);
                }
            }
            Iterator associations = pureMOF.refAllAssociations().iterator();
            while (associations.hasNext()) {
                this.replaceMeta(fromTo, (RefBaseObject)((RefAssociation)associations.next()));
            }
            this.rebuildMetas("MOF", fromTo);
            this.dropBoot();
        }
        catch (Exception e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    void rebuildMetas(String mofContext, Map table) throws StorageException {
        Iterator it = new HashSet(((SinglevaluedIndex)this.properties.get(this.bootStorage.getStorageId())).keySet()).iterator();
        while (it.hasNext()) {
            Object key = it.next();
            MOFID value = this.getProperty((String)key);
            MOFID newValue = this.bootNullMofId.equals(value) ? (MOFID)table.get(key) : (MOFID)table.get(value);
            if (newValue == null) continue;
            this.setProperty((String)key, newValue);
        }
    }

    public MOFID generateMOFID(MOFID immediatePackageId) throws StorageException {
        Object st = null;
        if (immediatePackageId == null) {
            return this.generateMOFID(this.bootStorage);
        }
        return this.generateMOFID(this.getStorageByMofId(immediatePackageId));
    }

    public MOFID generateMOFID(String storageId) throws StorageException {
        Storage st = (Storage)this.storages.get(storageId);
        if (st == null && "GC".equals(storageId)) {
            st = this.getTransientStorage();
        }
        return this.generateMOFID(st);
    }

    private MOFID generateMOFID(Storage storage) throws StorageException {
        if (storage == null) {
            throw new IllegalArgumentException("Wrong storage id");
        }
        return new MOFID(storage);
    }

    public void objectStateWillChange(MOFID mofId) throws StorageException {
        Storage storage = this.getStorageByMofId(mofId);
        if (storage == null) {
            throw new DebugException("Storage not found");
        }
        storage.objectStateWillChange(mofId);
    }

    public void objectStateChanged(MOFID mofId) throws StorageException {
        Storage storage = this.getStorageByMofId(mofId);
        if (storage == null) {
            throw new DebugException("Storage not found");
        }
        storage.objectStateChanged(mofId);
    }

    public Index getIndex(MOFID context, MOFID assocMofId, int end) throws StorageException {
        Storage storage = this.getStorageByMofId(context);
        if (storage == null) {
            throw new DebugException("Storage not found");
        }
        String indexName = this.getContextAssocEndIndexName(context, assocMofId, end);
        return storage.getIndex(indexName);
    }

    SinglevaluedIndex createSinglevaluedIndex(MOFID context, MOFID assocMofId, int end, Storage.EntryType keyType, Storage.EntryType valueType) throws StorageException {
        Storage storage = this.getStorageByMofId(context);
        if (storage == null) {
            throw new DebugException("Storage not found");
        }
        String indexName = this.getContextAssocEndIndexName(context, assocMofId, end);
        return storage.createSinglevaluedIndex(indexName, keyType, valueType);
    }

    MultivaluedOrderedIndex createMultivaluedOrderedIndex(MOFID context, MOFID assoccMofId, int end, Storage.EntryType keyType, Storage.EntryType valueType, boolean unique) throws StorageException {
        Storage storage = this.getStorageByMofId(context);
        if (storage == null) {
            throw new DebugException("Storage not found");
        }
        String indexName = this.getContextAssocEndIndexName(context, assoccMofId, end);
        return storage.createMultivaluedOrderedIndex(indexName, keyType, valueType, unique);
    }

    MultivaluedIndex createMultivaluedIndex(MOFID context, MOFID assoccMofId, int end, Storage.EntryType keyType, Storage.EntryType valueType, boolean unique) throws StorageException {
        Storage storage = this.getStorageByMofId(context);
        if (storage == null) {
            throw new DebugException("Storage not found");
        }
        String indexName = this.getContextAssocEndIndexName(context, assoccMofId, end);
        return storage.createMultivaluedIndex(indexName, keyType, valueType, unique);
    }

    void dropIndex(MOFID context, MOFID assoccMofId, int end) throws StorageException {
        Storage storage = this.getStorageByMofId(context);
        if (storage == null) {
            throw new DebugException("Storage not found");
        }
        String indexName = this.getContextAssocEndIndexName(context, assoccMofId, end);
        storage.dropIndex(indexName);
    }

    private String getContextAssocEndIndexName(MOFID context, MOFID assocMofId, int end) {
        return PREFIX_ASSOC_END + context.toString() + ":" + assocMofId.toString() + end;
    }

    public Storage getStorageByMofId(MOFID mofId) {
        String storageId = MdrStorage.getStorageIdFromMofId(mofId);
        return this.getStorageById(storageId);
    }

    public Storage getStorageById(String storageId) {
        if (storageId == null) {
            return null;
        }
        return (Storage)this.storages.get(storageId);
    }

    private SinglevaluedIndex getObjectsIndexByMofId(MOFID mofId) {
        String storageId = MdrStorage.getStorageIdFromMofId(mofId);
        if (storageId == null) {
            return null;
        }
        return (SinglevaluedIndex)this.objects.get(storageId);
    }

    private MultivaluedIndex getObjectsByClassesByMofId(MOFID mofId) {
        String storageId = MdrStorage.getStorageIdFromMofId(mofId);
        if (storageId == null) {
            return null;
        }
        return (MultivaluedIndex)this.objByCls.get(storageId);
    }

    private SinglevaluedIndex getPropertiesIndexByStorageId(String storageId) {
        return (SinglevaluedIndex)this.properties.get(storageId);
    }

    public static String getStorageIdFromMofId(MOFID mofId) {
        return mofId.getStorageID();
    }

    public Object resolve(String storageID, Object key) throws StorageException {
        SinglevaluedIndex objectsIndex = (SinglevaluedIndex)this.objects.get(storageID);
        if (objectsIndex == null) {
            return null;
        }
        return objectsIndex.get(key);
    }

    public synchronized Storage getTransientStorage() throws StorageException {
        if (this.transientStorage == null) {
            this.transientStorage = new TransientStorage("TransientStorage");
            this.transientStorage.create(false, this);
            this.objects.put("GC", this.transientStorage.getPrimaryIndex());
            this.objByCls.put("GC", this.transientStorage.createMultivaluedIndex(IDX_OBJECTS_BY_CLASSES, Storage.EntryType.MOFID, Storage.EntryType.MOFID, false));
            this.transientStorage.commitChanges();
            this.storages.put("GC", this.transientStorage);
        }
        return this.transientStorage;
    }

    public static boolean isTransientMofId(MOFID mofId) {
        String storageID = MdrStorage.getStorageIdFromMofId(mofId);
        return "GC".equals(storageID);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        STORAGE_VERSION = 19;
        IDX_OBJECTS_BY_CLASSES = IDX_OBJECTS_BY_CLASSES;
        IDX_MDR_STORAGE_PROPERTIES = IDX_MDR_STORAGE_PROPERTIES;
        IDX_END1_CLASSES_BY_ASSOCIATIONS = IDX_END1_CLASSES_BY_ASSOCIATIONS;
        IDX_END2_CLASSES_BY_ASSOCIATIONS = IDX_END2_CLASSES_BY_ASSOCIATIONS;
        IDX_CONTEXTS = IDX_CONTEXTS;
        PREFIX_ATTR_INDEX = PREFIX_ATTR_INDEX;
        PREFIX_ATTR_INDEXES_BY_NAME = PREFIX_ATTR_INDEXES_BY_NAME;
        PREFIX_ATTR_INDEXES_CLASS_PROXY = PREFIX_ATTR_INDEXES_CLASS_PROXY;
        PREFIX_ASSOC_END = PREFIX_ASSOC_END;
        MOF_TOP_PACKAGE = MOF_TOP_PACKAGE;
        VALUES_ID = VALUES_ID;
        instances = new Hashtable();
    }

    public static class ValuesObject
    implements Streamable,
    StorageClient {
        private Storage storage;
        private MOFID id;
        private List list = new ArrayList();
        private final transient Map map = new HashMap();

        public ValuesObject() {
        }

        private ValuesObject(Storage storage, MOFID id) {
            this.storage = storage;
            this.id = id;
        }

        public void setStorage(Storage storage) {
            this.storage = storage;
        }

        public int store(Object value) {
            if (value == null) {
                return 0;
            }
            try {
                this.storage.objectStateWillChange(this.id);
                Integer index = new Integer(this.map.size());
                Integer old = this.map.put(value, index);
                if (old != null) {
                    this.map.put(value, old);
                    index = old;
                } else {
                    this.list.add(value);
                    this.storage.objectStateChanged(this.id);
                }
                return index + 1;
            }
            catch (StorageException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }

        public Object resolve(int index) {
            if (index == 0) {
                return null;
            }
            return this.list.get(index - 1);
        }

        public int indexOf(Object value) {
            if (value == null) {
                return 0;
            }
            Integer result = (Integer)this.map.get(value);
            if (result == null) {
                throw new DebugException("Value not found: " + value);
            }
            return result + 1;
        }

        public void read(InputStream inputStream) throws StorageException {
            try {
                this.id = IOUtils.readMOFID(inputStream, this.storage);
                this.list = (List)IOUtils.read(inputStream);
                int i = 0;
                while (i < this.list.size()) {
                    this.map.put(this.list.get(i), new Integer(i));
                    ++i;
                }
            }
            catch (IOException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }

        public void write(OutputStream outputStream) throws StorageException {
            try {
                IOUtils.writeMOFID(outputStream, this.id, this.storage);
                IOUtils.write(outputStream, this.list);
            }
            catch (IOException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }
    }
}

