/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jmi.model.Association;
import javax.jmi.reflect.ClosureViolationException;
import javax.jmi.reflect.CompositionCycleException;
import javax.jmi.reflect.CompositionViolationException;
import javax.jmi.reflect.JmiException;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.WrongSizeException;
import org.netbeans.mdr.handlers.AssociationHandler;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableAssociation;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableFeatured;
import org.netbeans.mdr.storagemodel.StorablePackage;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.mdr.util.Logger;

public class StorableObject
extends StorableFeatured
implements Streamable {
    protected Object[] values;
    static final String INDEX_KEY_DELIMITER = "@";
    static final String INDEX_KEY_DELIMITER_2 = "#";
    static final String NULL_VALUE_SUBSTITUTE = "NULL";
    private MOFID classProxyId;
    private transient StorableClass classProxy = null;
    private MOFID attribComposite = null;

    protected void replaceValues(Map table) {
        this.objectWillChange();
        super.replaceValues(table);
        this.objectChanged();
    }

    public StorableObject(MdrStorage mdrStorage, MOFID immediatePackage, MOFID meta, MOFID classProxy) throws StorageException {
        this(mdrStorage, immediatePackage, meta, classProxy, null, null);
    }

    public StorableObject(MdrStorage mdrStorage, MOFID immediatePackage, MOFID meta, MOFID classProxy, Object[] params) throws StorageException {
        this(mdrStorage, immediatePackage, meta, classProxy, params, null);
    }

    public StorableObject(MdrStorage mdrStorage, MOFID immediatePackage, MOFID meta, MOFID classProxy, Object[] params, String storageId) throws StorageException {
        super(mdrStorage, immediatePackage, meta, storageId);
        this.classProxyId = classProxy;
        this.classProxy = (StorableClass)mdrStorage.getObject(this.classProxyId);
        if (params != null) {
            this.check();
            int i = 0;
            while (i < params.length) {
                StorableClass.AttributeDescriptor desc = this.getClassProxy().getAttrDesc(i);
                this.values[i] = this.getInitialValue(desc, params[i]);
                ++i;
            }
        }
        this.addInstance();
        if (params != null) {
            this.modifyIndex(this.getClassProxy().getIndexDescriptors(), false);
        }
        this.initFinished = true;
    }

    public StorableObject() {
    }

    public void setAttribute(String featureName, Object value) throws StorageException {
        if (value == null) {
            Logger.getDefault().notify(1, (Throwable)new DebugException());
        }
        this.setAttribute(this.getClassProxy().getAttrIndex(featureName), value);
    }

    public void setAttribute(int attrIndex, Object value) throws StorageException {
        this.check();
        StorableClass.AttributeDescriptor attribute = this.getClassProxy().getAttrDesc(attrIndex);
        Object oldValue = this.values[attrIndex];
        this.objectWillChange();
        this.values[attrIndex] = value;
        if (!attribute.isMultivalued() && value instanceof RefObject) {
            StorableObject storableObj = (StorableObject)((BaseObjectHandler)value)._getDelegate();
            storableObj.setComposite(this.getMofId(), storableObj.getMofId(), attribute.getMofId());
            if (oldValue != null) {
                storableObj = (StorableObject)((BaseObjectHandler)oldValue)._getDelegate();
                storableObj.clearComposite();
            }
        }
        this.modifyIndex(attrIndex, oldValue, value);
        this.objectChanged();
    }

    public Object getAttribute(String featureName) throws StorageException {
        return this.getAttribute(this.getClassProxy().getAttrIndex(featureName));
    }

    public Object getAttribute(int attrIndex) throws StorageException {
        this.check();
        return this.values[attrIndex];
    }

    public void verify(Collection violations) throws StorageException {
        int count = this.getClassProxy().getAttrCount();
        int i = 0;
        while (i < count) {
            StorableClass.AttributeDescriptor desc = this.getClassProxy().getAttrDesc(i);
            Object result = this.getAttribute(i);
            if (desc.getMaxSize() == 1 && desc.getMinSize() == 1 && result == null || desc.getMaxSize() != 1 && ((Collection)result).size() < desc.getMinSize()) {
                violations.add(new WrongSizeException((RefObject)BaseObjectHandler.getHandler(this.getMdrStorage().getObject(desc.getMofId()))));
            }
            ++i;
        }
        Iterator it = this.getClassProxy().getAllReferenceDescriptors().iterator();
        while (it.hasNext()) {
            StorableClass.ReferenceDescriptor desc = (StorableClass.ReferenceDescriptor)it.next();
            desc.getAssociation().verifyEnd(violations, desc.getEndName(), this.getMofId());
        }
    }

    void addReference(String referenceName, MOFID referencedObjectId) throws StorageException {
        MOFID objA;
        MOFID objB;
        StorableClass.ReferenceDescriptor reference = this.getClassProxy().getReferenceDescriptor(referenceName);
        StorableAssociation assocObj = (StorableAssociation)this.getMdrStorage().getObject(reference.getAssociationId());
        if (reference.getEndName().equals(assocObj.getEnd1Name())) {
            objB = referencedObjectId;
            objA = this.getMofId();
        } else {
            objA = referencedObjectId;
            objB = this.getMofId();
        }
        assocObj.addLink(objA, objB);
    }

    public Object getReference(String referenceName) throws StorageException {
        StorableClass.ReferenceDescriptor reference = this.getClassProxy().getReferenceDescriptor(referenceName);
        StorableAssociation asocObj1 = (StorableAssociation)this.getMdrStorage().getObject(reference.getAssociationId());
        return asocObj1.queryObjects(reference.getEndName(), this.getMofId());
    }

    protected void check() throws StorageException {
        if (this.values == null) {
            this.values = new Object[this.getClassProxy().getAttrCount()];
        }
    }

    public StorableFeatured getImmediateComposite() throws StorageException {
        Object composite = null;
        if (this.attribComposite != null) {
            StorableFeatured sf = (StorableFeatured)this.getMdrStorage().getObject(this.attribComposite);
            return sf;
        }
        return null;
    }

    public StorableFeatured getOutermostComposite() throws StorageException {
        StorableFeatured result = this.getImmediateComposite();
        StorableFeatured composite = this;
        while (result != null) {
            composite = result;
            result = result instanceof StorableObject ? ((StorableObject)result).getImmediateComposite() : null;
        }
        return composite;
    }

    void clearComposite() throws StorageException {
        this.setComposite((MOFID)null, null, null);
    }

    void setComposite(MOFID composite, MOFID objectId, MOFID elementId) throws StorageException {
        this.setComposite(this.getMdrStorage().getObject(composite), objectId, elementId);
    }

    void setComposite(StorableBaseObject composite, MOFID objectId, MOFID elementId) throws StorageException {
        this.objectWillChange();
        if (composite == null) {
            this.attribComposite = null;
        } else {
            MOFID id = composite.getMofId();
            if (id != this.attribComposite) {
                if (this.attribComposite != null) {
                    throw new CompositionViolationException((Object)BaseObjectHandler.getHandler(this), (RefObject)BaseObjectHandler.getHandler(this.getMdrStorage().getObject(elementId)));
                }
                if (composite instanceof StorableObject && ((StorableObject)composite).getOutermostComposite().equals(this)) {
                    throw new CompositionCycleException((Object)BaseObjectHandler.getHandler(this.getMdrStorage().getObject(objectId)), (RefObject)BaseObjectHandler.getHandler(this.getMdrStorage().getObject(elementId)));
                }
                if (!composite.getOutermostPackageId().equals(this.getOutermostPackageId())) {
                    throw new ClosureViolationException((Object)BaseObjectHandler.getHandler(this.getMdrStorage().getObject(objectId)), (RefObject)BaseObjectHandler.getHandler(this.getMdrStorage().getObject(elementId)));
                }
                this.attribComposite = id;
            }
        }
        this.objectChanged();
    }

    public void delete() throws StorageException {
        this.deleteAttributes();
        this.deleteLinksAndComponents();
        this.modifyIndex(this.getClassProxy().getIndexDescriptors(), true);
        this.getMdrStorage().removeInstance(this);
    }

    protected void deleteLinksAndComponents() throws StorageException {
        HashSet<StorablePackage> visited = new HashSet<StorablePackage>();
        LinkedList<StorablePackage> pckgs = new LinkedList<StorablePackage>();
        pckgs.add(this.getOutermostPackage());
        while (!pckgs.isEmpty()) {
            StorablePackage pckg = (StorablePackage)pckgs.removeFirst();
            if (visited.add(pckg)) {
                RefObject thisObject = (RefObject)BaseObjectHandler.getHandler(this);
                Iterator it = pckg.getAllAssociations().iterator();
                while (it.hasNext()) {
                    RefObject obj;
                    Iterator itt;
                    Object temp;
                    StorableAssociation assocStorable = (StorableAssociation)it.next();
                    AssociationHandler assoc = (AssociationHandler)BaseObjectHandler.getHandler(assocStorable);
                    if (((Association)assoc.refMetaObject()).isDerived()) continue;
                    boolean isAggregateA = assocStorable.isAggregateA();
                    boolean isAggregateB = assocStorable.isAggregateB();
                    try {
                        temp = assoc._query(assocStorable.getEnd2Name(), thisObject);
                    }
                    catch (ClassCastException e) {
                        temp = null;
                    }
                    catch (JmiException e) {
                        temp = assoc._handleQuery(assocStorable.getEnd2Name(), thisObject);
                    }
                    if (temp != null) {
                        if (temp instanceof Collection) {
                            itt = ((Collection)temp).iterator();
                            while (itt.hasNext()) {
                                obj = (RefObject)itt.next();
                                itt.remove();
                                if (!isAggregateB) continue;
                                obj.refDelete();
                            }
                        } else {
                            assoc.refRemoveLink((RefObject)temp, thisObject);
                            if (isAggregateB) {
                                ((RefObject)temp).refDelete();
                            }
                        }
                    }
                    try {
                        temp = assoc._query(assocStorable.getEnd1Name(), thisObject);
                    }
                    catch (ClassCastException e) {
                        temp = null;
                    }
                    catch (JmiException e) {
                        temp = assoc._handleQuery(assocStorable.getEnd1Name(), thisObject);
                    }
                    if (temp == null) continue;
                    if (temp instanceof Collection) {
                        itt = ((Collection)temp).iterator();
                        while (itt.hasNext()) {
                            obj = (RefObject)itt.next();
                            itt.remove();
                            if (!isAggregateA) continue;
                            obj.refDelete();
                        }
                        continue;
                    }
                    assoc.refRemoveLink(thisObject, (RefObject)temp);
                    if (!isAggregateA) continue;
                    ((RefObject)temp).refDelete();
                }
            }
            pckgs.addAll(pckg.getAllPackages());
        }
    }

    public MOFID getClassProxyId() {
        return this.classProxyId;
    }

    public StorableClass getClassProxy() throws StorageException {
        return this.classProxy;
    }

    public void write(OutputStream outputStream) {
        super.write(outputStream);
        try {
            IOUtils.write(outputStream, this.classProxyId, this);
            IOUtils.write(outputStream, this.attribComposite, this);
            if (this.values == null) {
                IOUtils.writeInt(outputStream, 0);
            } else {
                IOUtils.writeInt(outputStream, this.values.length + 1);
                int i = 0;
                while (i < this.values.length) {
                    IOUtils.write(outputStream, this.values[i], this);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            Logger.getDefault().notify(1, (Throwable)e);
        }
    }

    public void read(InputStream inputStream) {
        super.read(inputStream);
        try {
            this.classProxyId = (MOFID)IOUtils.read(inputStream, this);
            this.attribComposite = (MOFID)IOUtils.read(inputStream, this);
        }
        catch (IOException e) {
            throw (RuntimeException)Logger.getDefault().annotate((Throwable)new RuntimeException(e.getMessage()), (Throwable)e);
        }
        try {
            this.classProxy = (StorableClass)this.getMdrStorage().getObject(this.classProxyId);
            this.meta = this.classProxy.getMetaObjectId();
            this.immediatePackage = this.classProxy.getImmediatePackageId();
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
        try {
            int objCount = IOUtils.readInt(inputStream);
            if (objCount != 0) {
                int count = objCount - 1;
                this.values = new Object[count];
                int i = 0;
                while (i < count) {
                    this.values[i] = IOUtils.read(inputStream, this, this.getClassProxy().getAttrDesc(i).getType().getName());
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    protected void addInstance() throws StorageException {
        this.getMdrStorage().addInstance(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void modifyIndex(int attrIdx, Object oldValue, Object newValue) throws StorageException {
        MultivaluedIndex attrIndex = null;
        StorableClass proxy = this.getClassProxy();
        StorableClass.AttributeDescriptor attrDesc = proxy.getAttrDesc(attrIdx);
        MOFID attribId = attrDesc.getMofId();
        if (attrDesc.isIndexed()) {
            Iterator iter = proxy.getIndexes(attribId).iterator();
            MOFID outermostPackageId = this.getOutermostPackageId();
            MOFID mofId = this.getMofId();
            while (iter.hasNext()) {
                Object var21_20;
                block16: {
                    block15: {
                        block14: {
                            StorableClass.IndexDescriptor indexDesc = (StorableClass.IndexDescriptor)iter.next();
                            try {
                                attrIndex = this.getMdrStorage().acquireAdditionalIndex(outermostPackageId, indexDesc.getName());
                                if (attrIndex == null) {
                                    var21_20 = null;
                                    if (attrIndex == null) return;
                                    this.getMdrStorage().releaseAdditionalIndex();
                                    return;
                                }
                                if (oldValue == null && newValue == null) {
                                    break block14;
                                }
                                if (oldValue != null && oldValue.equals(newValue)) {
                                    break block15;
                                }
                                StorableClass.IndexDescriptor.Field[] fields = indexDesc.getFields();
                                int currPosition = -1;
                                int x = 0;
                                while (x < fields.length) {
                                    if (fields[x] instanceof StorableClass.IndexDescriptor.Attrib && ((StorableClass.IndexDescriptor.Attrib)fields[x]).getId().equals(attribId)) {
                                        currPosition = x;
                                        break;
                                    }
                                    ++x;
                                }
                                String oldValStr = StorableObject.objectToString(oldValue, fields[currPosition].isOrdered());
                                String newValStr = StorableObject.objectToString(newValue, fields[currPosition].isOrdered());
                                String prefix = this.valuesToKey(fields, 0, currPosition - 1);
                                String suffix = this.valuesToKey(fields, currPosition + 1, fields.length - 1);
                                StringBuffer buf = new StringBuffer();
                                if (prefix.length() > 0) {
                                    buf.append(prefix);
                                    buf.append(INDEX_KEY_DELIMITER);
                                }
                                buf.append(oldValStr);
                                if (suffix.length() > 0) {
                                    buf.append(INDEX_KEY_DELIMITER);
                                    buf.append(suffix);
                                }
                                attrIndex.remove(buf.toString(), mofId);
                                buf = new StringBuffer();
                                if (prefix.length() > 0) {
                                    buf.append(prefix);
                                    buf.append(INDEX_KEY_DELIMITER);
                                }
                                buf.append(newValStr);
                                if (suffix.length() > 0) {
                                    buf.append(INDEX_KEY_DELIMITER);
                                    buf.append(suffix);
                                }
                                attrIndex.add(buf.toString(), mofId);
                                break block16;
                            }
                            catch (Throwable throwable) {
                                var21_20 = null;
                                if (attrIndex != null) {
                                    this.getMdrStorage().releaseAdditionalIndex();
                                }
                                throw throwable;
                            }
                        }
                        var21_20 = null;
                        if (attrIndex == null) return;
                        this.getMdrStorage().releaseAdditionalIndex();
                        return;
                    }
                    var21_20 = null;
                    if (attrIndex == null) return;
                    this.getMdrStorage().releaseAdditionalIndex();
                    return;
                }
                var21_20 = null;
                if (attrIndex == null) continue;
                this.getMdrStorage().releaseAdditionalIndex();
            }
        }
    }

    protected void deleteAttributes() throws StorageException {
        int i = 0;
        while (i < this.values.length) {
            if (this.values[i] instanceof RefObject) {
                ((RefObject)this.values[i]).refDelete();
            } else if (this.values[i] instanceof Collection) {
                Iterator it = ((Collection)this.values[i]).iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof RefObject)) break;
                    it.remove();
                    ((RefObject)obj).refDelete();
                }
            }
            ++i;
        }
    }

    void addToIndex(MOFID id) {
        try {
            StorableClass proxy = this.getClassProxy();
            this.modifyIndex(proxy.getIndexes(id), false);
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    void removeFromIndex(MOFID id) {
        try {
            StorableClass proxy = this.getClassProxy();
            this.modifyIndex(proxy.getIndexes(id), true);
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyIndex(List descriptors, boolean remove) throws StorageException {
        if (descriptors == null) {
            return;
        }
        MultivaluedIndex attrIndex = null;
        MOFID outermostPackageId = this.getOutermostPackageId();
        MOFID mofId = this.getMofId();
        Iterator iter = descriptors.iterator();
        while (iter.hasNext()) {
            Object var10_9;
            StorableClass.IndexDescriptor desc = (StorableClass.IndexDescriptor)iter.next();
            StorableClass.IndexDescriptor.Field[] fields = desc.getFields();
            try {
                attrIndex = this.getMdrStorage().acquireAdditionalIndex(outermostPackageId, desc.getName());
                if (remove) {
                    attrIndex.remove(this.valuesToKey(fields, 0, fields.length - 1), mofId);
                } else {
                    attrIndex.add(this.valuesToKey(fields, 0, fields.length - 1), mofId);
                }
                var10_9 = null;
                if (attrIndex == null) continue;
                this.getMdrStorage().releaseAdditionalIndex();
            }
            catch (Throwable throwable) {
                var10_9 = null;
                if (attrIndex != null) {
                    this.getMdrStorage().releaseAdditionalIndex();
                }
                throw throwable;
            }
        }
    }

    private static String objectToString(Object o, boolean isOrdered) {
        if (o == null) {
            return NULL_VALUE_SUBSTITUTE;
        }
        if (o instanceof RefObject) {
            return ((RefObject)o).refMofId();
        }
        if (o instanceof StorableObject) {
            return ((StorableObject)o).getMofId().toString();
        }
        if (o instanceof Collection) {
            StringBuffer buf = new StringBuffer();
            Iterator iter = ((Collection)o).iterator();
            LinkedList<String> list = new LinkedList<String>();
            while (iter.hasNext()) {
                list.add(StorableObject.objectToString(iter.next(), true));
            }
            if (!isOrdered) {
                Collections.sort(list);
            }
            if ((iter = list.iterator()).hasNext()) {
                buf.append(iter.next());
            }
            while (iter.hasNext()) {
                buf.append(INDEX_KEY_DELIMITER);
                buf.append(iter.next());
            }
            return buf.toString();
        }
        return o.toString();
    }

    private String valuesToKey(StorableClass.IndexDescriptor.Field[] fields, int pos_1, int pos_2) throws StorageException {
        StringBuffer buf = new StringBuffer();
        int x = pos_1;
        while (x <= pos_2) {
            String res;
            if (fields[x] instanceof StorableClass.IndexDescriptor.Attrib) {
                String name = ((StorableClass.IndexDescriptor.Attrib)fields[x]).getName();
                res = StorableObject.objectToString(this.values[this.getClassProxy().getAttrIndex(name)], fields[x].isOrdered());
            } else {
                StorableClass.IndexDescriptor.AssocEnd endDesc = (StorableClass.IndexDescriptor.AssocEnd)fields[x];
                StorableAssociation sa = (StorableAssociation)this.getMdrStorage().getObject(endDesc.getAssociation());
                String otherEndName = sa.getEnd1Name();
                if (otherEndName.equals(endDesc.getName())) {
                    otherEndName = sa.getEnd2Name();
                }
                res = StorableObject.objectToString(sa.queryObjects(otherEndName, this.getMofId()), fields[x].isOrdered());
            }
            buf.append(res);
            if (x < pos_2) {
                buf.append(INDEX_KEY_DELIMITER_2);
            }
            ++x;
        }
        return buf.toString();
    }

    public static String valuesToKey(Map map, StorableClass.IndexDescriptor.Field[] fields) {
        StringBuffer buf = new StringBuffer();
        if (map.size() != fields.length) {
            throw new DebugException("Wrong query on additional index, incorrect number of passed parameters.");
        }
        int x = 0;
        while (x < fields.length) {
            String name = fields[x].getName();
            if (!map.containsKey(name)) {
                throw new DebugException("Wrong query on additional index, value of field " + name + " not specified.");
            }
            Object value = map.get(name);
            String str = StorableObject.objectToString(value, fields[x].isOrdered());
            buf.append(str);
            if (x < fields.length - 1) {
                buf.append(INDEX_KEY_DELIMITER_2);
            }
            ++x;
        }
        return buf.toString();
    }

    public static String valueToKey(Object value, StorableClass.IndexDescriptor.Field[] fields) {
        if (fields.length != 1) {
            throw new DebugException("Wrong query on additional index, more than one parameter expected.");
        }
        return StorableObject.objectToString(value, fields[0].isOrdered());
    }

    static {
        INDEX_KEY_DELIMITER = INDEX_KEY_DELIMITER;
        INDEX_KEY_DELIMITER_2 = INDEX_KEY_DELIMITER_2;
        NULL_VALUE_SUBSTITUTE = NULL_VALUE_SUBSTITUTE;
    }
}

