/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefStruct;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.handlers.EnumResolver;
import org.netbeans.mdr.handlers.StructImpl;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.AttrCollection;
import org.netbeans.mdr.storagemodel.AttrImmutList;
import org.netbeans.mdr.storagemodel.AttrImmutUList;
import org.netbeans.mdr.storagemodel.AttrList;
import org.netbeans.mdr.storagemodel.AttrSet;
import org.netbeans.mdr.storagemodel.AttrUList;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableFeatured;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;
import org.netbeans.mdr.util.ValueWrapper;

public class IOUtils {
    private static final int T_NULL = 0;
    private static final int T_STRING = 1;
    private static final int T_BOOLEAN = 2;
    private static final int T_MAP = 3;
    private static final int T_INTEGER = 4;
    private static final int T_COLLECTION = 5;
    private static final int T_STRUCT = 6;
    private static final int T_ENUM = 7;
    private static final int T_MOF_REFERENCE = 10;
    private static final int T_LIST_IMMUTABLE = 11;
    private static final int T_LIST_MUTABLE = 12;
    private static final int T_LIST_U_IMMUTABLE = 13;
    private static final int T_LIST_U_MUTABLE = 14;
    private static final int T_COLL_U_MUTABLE = 15;
    private static final int T_COLL_MUTABLE = 16;
    private static final int T_CLASS = 17;
    private static final int T_FLOAT = 18;
    private static final int T_DOUBLE = 19;
    private static final int T_OBJECT = 20;
    private static final int T_LONG = 21;
    private static final int T_SHORT = 22;
    private static final int T_MOFID = 23;

    public static void write(OutputStream outputStream, Object object) throws IOException {
        IOUtils.write(outputStream, object, null);
    }

    public static void writeInt(OutputStream outputStream, int val) throws IOException {
        if (((byte)val & 0x7F) == val) {
            outputStream.write((byte)val);
        } else if (((byte)(val >>> 8) & 0xFF) == val >>> 8) {
            outputStream.write(150);
            outputStream.write((byte)(val & 0xFF));
            outputStream.write((byte)((val & 0xFF00) >>> 8));
        } else {
            outputStream.write(132);
            outputStream.write((byte)(val & 0xFF));
            outputStream.write((byte)((val & 0xFF00) >>> 8));
            outputStream.write((byte)((val & 0xFF0000) >>> 16));
            outputStream.write((byte)(val >>> 24 & 0xFF));
        }
    }

    public static void writeLong(OutputStream outputStream, long val) throws IOException {
        if ((long)((byte)val & 0x7F) == val) {
            outputStream.write((byte)val);
        } else if ((long)((byte)(val >>> 24) & 0xFF) == val >>> 24) {
            outputStream.write(132);
            outputStream.write((byte)(val & 0xFFL));
            outputStream.write((byte)((val & 0xFF00L) >>> 8));
            outputStream.write((byte)((val & 0xFF0000L) >>> 16));
            outputStream.write((byte)(val >>> 24 & 0xFFL));
        } else {
            outputStream.write(149);
            outputStream.write((byte)(val & 0xFFL));
            outputStream.write((byte)((val & 0xFF00L) >>> 8));
            outputStream.write((byte)(val >>> 16 & 0xFFL));
            outputStream.write((byte)(val >>> 24 & 0xFFL));
            outputStream.write((byte)(val >>> 32 & 0xFFL));
            outputStream.write((byte)(val >>> 40 & 0xFFL));
            outputStream.write((byte)(val >>> 48 & 0xFFL));
            outputStream.write((byte)(val >>> 56 & 0xFFL));
        }
    }

    public static void writeBoolean(OutputStream outputStream, boolean val) throws IOException {
        outputStream.write(val ? 1 : 0);
    }

    public static void writeString(OutputStream outputStream, String val) throws IOException {
        if (val == null) {
            IOUtils.writeInt(outputStream, 0);
            return;
        }
        int len = val.length();
        IOUtils.writeInt(outputStream, len + 1);
        int i = 0;
        while (i < len) {
            char ch = val.charAt(i);
            if (ch <= '\u007f') {
                outputStream.write((byte)ch);
            } else if (ch <= '\u07ff') {
                outputStream.write((byte)(0xC0 | ch >> 6));
                outputStream.write((byte)(0x80 | ch & 0x3F));
            } else {
                outputStream.write((byte)(0xE0 | ch >> 12));
                outputStream.write((byte)(0x80 | ch >> 6 & 0x3F));
                outputStream.write((byte)(0x80 | ch & 0x3F));
            }
            ++i;
        }
    }

    public static void writeMOFID(OutputStream outputStream, MOFID mofId, MdrStorage mdrStorage, MOFID storableID) throws IOException {
        Storage storage = mdrStorage.getStorageByMofId(storableID);
        IOUtils.writeMOFID(outputStream, mofId, storage);
    }

    public static void writeMOFID(OutputStream outputStream, MOFID mofId, Storage storage) throws IOException {
        try {
            storage.writeMOFID(outputStream, mofId);
        }
        catch (StorageException se) {
            throw new IOException();
        }
    }

    public static void write(OutputStream outputStream, Object object, StorableBaseObject storable) throws IOException {
        if (object == null) {
            outputStream.write(0);
        } else if (object instanceof String) {
            outputStream.write(1);
            IOUtils.writeString(outputStream, (String)object);
        } else if (object instanceof Integer) {
            int val = (Integer)object;
            outputStream.write(4);
            IOUtils.writeInt(outputStream, val);
        } else if (object instanceof Boolean) {
            outputStream.write(2);
            IOUtils.writeBoolean(outputStream, (Boolean)object);
        } else if (object instanceof Float) {
            outputStream.write(18);
            IOUtils.writeInt(outputStream, Float.floatToIntBits(((Float)object).floatValue()));
        } else if (object instanceof Double) {
            outputStream.write(19);
            IOUtils.writeLong(outputStream, Double.doubleToLongBits((Double)object));
        } else if (object instanceof Long) {
            outputStream.write(21);
            IOUtils.writeLong(outputStream, (Long)object);
        } else if (object instanceof Map) {
            outputStream.write(3);
            Map temp = (Map)object;
            IOUtils.writeInt(outputStream, temp.size());
            Iterator it = temp.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                IOUtils.write(outputStream, key, storable);
                IOUtils.write(outputStream, temp.get(key), storable);
            }
        } else if (object instanceof AttrCollection) {
            if (object instanceof AttrUList) {
                outputStream.write(14);
            } else if (object instanceof AttrList) {
                outputStream.write(12);
            } else if (object instanceof AttrSet) {
                outputStream.write(15);
            } else {
                outputStream.write(16);
            }
            ((AttrCollection)object).write(outputStream);
        } else if (object instanceof AttrImmutList) {
            MdrStorage storage = storable.getMdrStorage();
            if (storage == null) {
                Logger.getDefault().notify(1, (Throwable)new DebugException());
            }
            if (object instanceof AttrImmutUList) {
                outputStream.write(13);
            } else {
                outputStream.write(11);
            }
            ((AttrImmutList)object).write(outputStream, storable);
        } else if (object instanceof Collection) {
            outputStream.write(5);
            Collection col = (Collection)object;
            IOUtils.writeInt(outputStream, col.size());
            Iterator it = col.iterator();
            while (it.hasNext()) {
                IOUtils.write(outputStream, it.next(), storable);
            }
        } else if (object instanceof RefStruct) {
            outputStream.write(6);
            RefStruct struct = (RefStruct)object;
            MdrStorage storage = storable.getMdrStorage();
            if (storage == null) {
                Logger.getDefault().notify(1, (Throwable)new DebugException());
            }
            IOUtils.writeInt(outputStream, storage.values(storable.getMofId()).indexOf(struct.refTypeName()));
            List fields = struct.refFieldNames();
            IOUtils.writeInt(outputStream, fields.size());
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                String field = (String)it.next();
                IOUtils.writeInt(outputStream, storage.values(storable.getMofId()).indexOf(field));
                IOUtils.write(outputStream, struct.refGetValue(field), storable);
            }
        } else if (object instanceof RefEnum) {
            MdrStorage storage = storable.getMdrStorage();
            if (storage == null) {
                Logger.getDefault().notify(1, (Throwable)new DebugException());
            }
            outputStream.write(7);
            IOUtils.writeInt(outputStream, storage.values(storable.getMofId()).indexOf(object.toString()));
        } else {
            if (object instanceof StorableClass.AttributeDescriptor) {
                throw new DebugException("AttributeDescriptor should serialized elswhere.");
            }
            if (object instanceof StorableClass.ReferenceDescriptor) {
                outputStream.write(10);
                IOUtils.writeMOFID(outputStream, ((StorableClass.ReferenceDescriptor)object).getMofId(), storable.getMdrStorage(), storable.getMofId());
                IOUtils.writeMOFID(outputStream, ((StorableClass.ReferenceDescriptor)object).getAssociationId(), storable.getMdrStorage(), storable.getMofId());
                IOUtils.writeString(outputStream, ((StorableClass.ReferenceDescriptor)object).getEndName());
            } else if (object instanceof RefObject) {
                outputStream.write(20);
                IOUtils.writeMOFID(outputStream, ((BaseObjectHandler)object)._getDelegate().getMofId(), storable.getMdrStorage(), storable.getMofId());
            } else if (object instanceof Class) {
                MdrStorage storage = storable.getMdrStorage();
                if (storage == null) {
                    Logger.getDefault().notify(1, (Throwable)new DebugException());
                }
                outputStream.write(17);
                IOUtils.writeInt(outputStream, storage.values(storable.getMofId()).indexOf(((Class)object).getName()));
            } else if (object instanceof MOFID) {
                outputStream.write(23);
                IOUtils.writeMOFID(outputStream, (MOFID)object, storable.getMdrStorage(), storable.getMofId());
            } else if (object instanceof ValueWrapper) {
                IOUtils.write(outputStream, ((ValueWrapper)object).getValue(), storable);
            } else {
                throw new IOException("Unsupported type of object (object must be serializable): " + object.getClass().getName());
            }
        }
    }

    public static Object read(InputStream inputStream) throws IOException {
        return IOUtils.read(inputStream, null, null);
    }

    public static Object read(InputStream inputStream, StorableBaseObject storable) throws IOException {
        return IOUtils.read(inputStream, storable, null);
    }

    public static boolean readBoolean(InputStream is) throws IOException {
        return is.read() == 1;
    }

    public static int readInt(InputStream is) throws IOException {
        return IOUtils.readInt(is, is.read());
    }

    static int readInt(InputStream inputStream, int type) throws IOException {
        if (type <= 127) {
            return type;
        }
        switch (type) {
            case 150: {
                int ch1 = inputStream.read();
                int ch2 = inputStream.read();
                return ch2 << 8 | ch1;
            }
            case 132: {
                int ch1 = inputStream.read();
                int ch2 = inputStream.read();
                int ch3 = inputStream.read();
                int ch4 = inputStream.read();
                return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
            }
        }
        throw new IOException("Unknown int format: " + type);
    }

    public static long readLong(InputStream inputStream) throws IOException {
        int t = inputStream.read();
        if (t <= 127) {
            return t;
        }
        switch (t) {
            case 132: {
                int ch1 = inputStream.read();
                int ch2 = inputStream.read();
                int ch3 = inputStream.read();
                int ch4 = inputStream.read();
                return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
            }
            case 149: {
                long ch1 = inputStream.read();
                long ch2 = inputStream.read();
                long ch3 = inputStream.read();
                long ch4 = inputStream.read();
                long v_low = ch4 << 24 | ch3 << 16 | ch2 << 8 | ch1;
                ch1 = inputStream.read();
                ch2 = inputStream.read();
                ch3 = inputStream.read();
                ch4 = inputStream.read();
                long v_high = ch4 << 24 | ch3 << 16 | ch2 << 8 | ch1;
                return v_high << 32 | v_low;
            }
        }
        throw new IOException("Unknown int format: " + t);
    }

    public static String readString(InputStream inputStream) throws IOException {
        int length = IOUtils.readInt(inputStream);
        if (length == 0) {
            return null;
        }
        if (--length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(length);
        do {
            int b;
            if ((b = inputStream.read() & 0xFF) >= 224) {
                b = (b & 0xF) << 12;
                b |= (inputStream.read() & 0x3F) << 6;
                b |= inputStream.read() & 0x3F;
            } else if (b >= 192) {
                b = (b & 0x1F) << 6;
                b |= inputStream.read() & 0x3F;
            }
            sb.append((char)b);
        } while (--length > 0);
        return new String(sb);
    }

    public static MOFID readMOFID(InputStream inputStream, MdrStorage mdrStorage, MOFID storableID) throws IOException {
        Storage storage = mdrStorage.getStorageByMofId(storableID);
        return IOUtils.readMOFID(inputStream, storage);
    }

    public static MOFID readMOFID(InputStream inputStream, Storage storage) throws IOException {
        try {
            return storage.readMOFID(inputStream);
        }
        catch (StorageException se) {
            throw new IOException();
        }
    }

    public static Object read(InputStream inputStream, StorableBaseObject storable, String className) throws IOException {
        int type = inputStream.read();
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return IOUtils.readString(inputStream);
            }
            case 4: {
                return new Integer(IOUtils.readInt(inputStream));
            }
            case 21: {
                return new Long(IOUtils.readLong(inputStream));
            }
            case 18: {
                return new Float(Float.intBitsToFloat(IOUtils.readInt(inputStream)));
            }
            case 19: {
                return new Double(Double.longBitsToDouble(IOUtils.readLong(inputStream)));
            }
            case 2: {
                return IOUtils.readBoolean(inputStream) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                int size = IOUtils.readInt(inputStream);
                HashMap<Object, Object> result = new HashMap<Object, Object>(size);
                int i = 0;
                while (i < size) {
                    result.put(IOUtils.read(inputStream, storable), IOUtils.read(inputStream, storable));
                    ++i;
                }
                return result;
            }
            case 11: 
            case 13: {
                if (storable == null) {
                    Logger.getDefault().notify(1, (Throwable)new DebugException());
                }
                AttrImmutList result = type == 11 ? new AttrImmutList() : new AttrImmutUList();
                result.read(inputStream, storable);
                return result;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                AttrCollection result = type == 12 ? new AttrList() : (type == 14 ? new AttrUList() : (type == 16 ? new AttrCollection() : new AttrSet()));
                result.read(inputStream, (StorableFeatured)storable);
                return result;
            }
            case 5: {
                int size = IOUtils.readInt(inputStream);
                ArrayList<Object> result = new ArrayList<Object>(size);
                int i = 0;
                while (i < size) {
                    result.add(IOUtils.read(inputStream, storable));
                    ++i;
                }
                return result;
            }
            case 6: {
                Class clazz;
                if (storable == null) {
                    Logger.getDefault().notify(1, (Throwable)new DebugException());
                }
                MdrStorage storage = storable.getMdrStorage();
                List qualifiedName = (List)storage.values(storable.getMofId()).resolve(IOUtils.readInt(inputStream));
                int size = IOUtils.readInt(inputStream);
                ArrayList<Object> fields = new ArrayList<Object>(size);
                HashMap<Object, Object> values = new HashMap<Object, Object>(size, 1.0f);
                int i = 0;
                while (i < size) {
                    Object field = storage.values(storable.getMofId()).resolve(IOUtils.readInt(inputStream));
                    fields.add(field);
                    values.put(field, IOUtils.read(inputStream));
                    ++i;
                }
                try {
                    clazz = BaseObjectHandler.resolveInterface(className);
                }
                catch (ClassNotFoundException e) {
                    throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
                }
                return StructImpl.newInstance(clazz, fields, values, qualifiedName);
            }
            case 7: {
                if (storable == null) {
                    Logger.getDefault().notify(1, (Throwable)new DebugException());
                }
                return EnumResolver.resolveEnum(className, (String)storable.getMdrStorage().values(storable.getMofId()).resolve(IOUtils.readInt(inputStream)));
            }
            case 10: {
                if (storable == null) {
                    Logger.getDefault().notify(1, (Throwable)new DebugException());
                }
                StorableClass storableClass = (StorableClass)storable;
                storableClass.getClass();
                return storableClass.new StorableClass.ReferenceDescriptor(IOUtils.readMOFID(inputStream, storable.getMdrStorage(), storable.getMofId()), IOUtils.readMOFID(inputStream, storable.getMdrStorage(), storable.getMofId()), IOUtils.readString(inputStream));
            }
            case 17: {
                if (storable == null) {
                    Logger.getDefault().notify(1, (Throwable)new DebugException());
                }
                try {
                    return BaseObjectHandler.resolveInterface((String)storable.getMdrStorage().values(storable.getMofId()).resolve(IOUtils.readInt(inputStream)));
                }
                catch (ClassNotFoundException e) {
                    throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
                }
            }
            case 20: {
                if (storable == null) {
                    Logger.getDefault().notify(1, (Throwable)new DebugException());
                }
                try {
                    return BaseObjectHandler.getHandler(storable.getMdrStorage().getObject(IOUtils.readMOFID(inputStream, storable.getMdrStorage(), storable.getMofId())));
                }
                catch (StorageException e) {
                    throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
                }
            }
            case 23: {
                return IOUtils.readMOFID(inputStream, storable.getMdrStorage(), storable.getMofId());
            }
        }
        throw new IOException("Object type not recognized: " + type);
    }

    static {
        T_NULL = 0;
        T_STRING = 1;
        T_BOOLEAN = 2;
        T_MAP = 3;
        T_INTEGER = 4;
        T_COLLECTION = 5;
        T_STRUCT = 6;
        T_ENUM = 7;
        T_MOF_REFERENCE = 10;
        T_LIST_IMMUTABLE = 11;
        T_LIST_MUTABLE = 12;
        T_LIST_U_IMMUTABLE = 13;
        T_LIST_U_MUTABLE = 14;
        T_COLL_U_MUTABLE = 15;
        T_COLL_MUTABLE = 16;
        T_CLASS = 17;
        T_FLOAT = 18;
        T_DOUBLE = 19;
        T_OBJECT = 20;
        T_LONG = 21;
        T_SHORT = 22;
        T_MOFID = 23;
    }
}

