/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.security.AllPermission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class ImplClass {
    protected static final String classNameSuffix = "$Impl";
    private static final ProtectionDomain pd;
    private static final Map loaderToCache;
    private static final Object pendingGenerationMarker;

    public static String getClassNameSuffix() {
        return classNameSuffix;
    }

    protected static void check(ClassLoader loader, Class ifc) throws IllegalArgumentException {
        Class<?> interfaceClass = null;
        try {
            interfaceClass = Class.forName(ifc.getName(), false, loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (interfaceClass != ifc) {
            throw new IllegalArgumentException(ifc + " is not visible from class loader");
        }
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException(interfaceClass.getName() + " is not an interface");
        }
    }

    protected static String getName(Class ifc) {
        return ifc.getName() + classNameSuffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map getLoaderCache(ClassLoader loader) {
        HashMap cache;
        Map map = loaderToCache;
        synchronized (map) {
            cache = (HashMap)loaderToCache.get(loader);
            if (cache == null) {
                cache = new HashMap(3);
                loaderToCache.put(loader, cache);
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Class getFromCache(Map cache, Class ifc, String className) {
        Class implClass = null;
        Map map = cache;
        synchronized (map) {
            while (true) {
                Object value;
                if ((value = cache.get(className)) instanceof Reference) {
                    implClass = (Class)((Reference)value).get();
                }
                if (implClass != null) {
                    return implClass;
                }
                if (value != pendingGenerationMarker) {
                    cache.put(className, pendingGenerationMarker);
                    return null;
                }
                try {
                    cache.wait();
                }
                catch (InterruptedException e) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void releaseCache(Map cache, Class implClass, String className) {
        Map map = cache;
        synchronized (map) {
            if (implClass != null) {
                cache.put(className, new WeakReference<Class>(implClass));
            } else {
                cache.remove(className);
            }
            cache.notifyAll();
        }
    }

    static {
        classNameSuffix = classNameSuffix;
        loaderToCache = new WeakHashMap(3);
        pendingGenerationMarker = new Object();
        Permissions pc = new Permissions();
        ((PermissionCollection)pc).add(new AllPermission());
        pd = new ProtectionDomain(null, pc);
    }
}

