/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ImplGenerator {
    public static final int JAVA_MAGIC = -889275714;
    public static final int JAVA_DEFAULT_VERSION = 45;
    public static final int JAVA_DEFAULT_MINOR_VERSION = 3;
    public static final int CONSTANT_UTF8 = 1;
    public static final int CONSTANT_INTEGER = 3;
    public static final int CONSTANT_FLOAT = 4;
    public static final int CONSTANT_LONG = 5;
    public static final int CONSTANT_DOUBLE = 6;
    public static final int CONSTANT_CLASS = 7;
    public static final int CONSTANT_STRING = 8;
    public static final int CONSTANT_FIELD = 9;
    public static final int CONSTANT_METHOD = 10;
    public static final int CONSTANT_INTERFACEMETHOD = 11;
    public static final int CONSTANT_NAMEANDTYPE = 12;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    int T_BYTE = 8;
    public static final int opc_aconst_null = 1;
    public static final int opc_iconst_0 = 3;
    public static final int opc_lconst_0 = 9;
    public static final int opc_fconst_0 = 11;
    public static final int opc_dconst_0 = 14;
    public static final int opc_bipush = 16;
    public static final int opc_sipush = 17;
    public static final int opc_ldc = 18;
    public static final int opc_ldc_w = 19;
    public static final int opc_iload = 21;
    public static final int opc_lload = 22;
    public static final int opc_fload = 23;
    public static final int opc_dload = 24;
    public static final int opc_aload = 25;
    public static final int opc_iload_0 = 26;
    public static final int opc_lload_0 = 30;
    public static final int opc_fload_0 = 34;
    public static final int opc_dload_0 = 38;
    public static final int opc_aload_0 = 42;
    public static final int opc_aaload = 50;
    public static final int opc_istore = 54;
    public static final int opc_lstore = 55;
    public static final int opc_fstore = 56;
    public static final int opc_dstore = 57;
    public static final int opc_astore = 58;
    public static final int opc_istore_0 = 59;
    public static final int opc_lstore_0 = 63;
    public static final int opc_fstore_0 = 67;
    public static final int opc_dstore_0 = 71;
    public static final int opc_astore_0 = 75;
    public static final int opc_aastore = 83;
    public static final int opc_bastore = 84;
    public static final int opc_pop = 87;
    public static final int opc_dup = 89;
    public static final int opc_ifeq = 153;
    public static final int opc_jsr = 168;
    public static final int opc_ret = 169;
    public static final int opc_ireturn = 172;
    public static final int opc_lreturn = 173;
    public static final int opc_freturn = 174;
    public static final int opc_dreturn = 175;
    public static final int opc_areturn = 176;
    public static final int opc_return = 177;
    public static final int opc_getstatic = 178;
    public static final int opc_putstatic = 179;
    public static final int opc_invokevirtual = 182;
    public static final int opc_invokespecial = 183;
    public static final int opc_invokestatic = 184;
    public static final int opc_new = 187;
    public static final int opc_newarray = 188;
    public static final int opc_anewarray = 189;
    public static final int opc_athrow = 191;
    public static final int opc_checkcast = 192;
    public static final int opc_wide = 196;
    public static final int opc_ifnull = 198;
    protected static final String FIELD_PREFIX = "field$";
    protected Class superclass;
    protected String superclassName;
    protected String className;
    protected Class ifc;
    protected ConstantPool cp = new ConstantPool();
    protected HashSet fields = new HashSet();
    protected List methods = new ArrayList();
    protected Map classMethods = new HashMap(11);

    protected ImplGenerator(String className, Class ifc, Class handlerClass) {
        this.className = className;
        this.ifc = ifc;
        this.superclass = handlerClass;
        this.superclassName = ImplGenerator.dotToSlash(this.superclass.getName());
    }

    protected final byte[] generateClassFile() {
        HashSet methodSet = new HashSet();
        Method[] methods = this.getMethodsToImplement();
        int i = 0;
        while (i < methods.length) {
            this.addClassMethod(methods[i], this.ifc);
            ++i;
        }
        try {
            this.methods.add(this.generateConstructor());
            Iterator it = this.classMethods.values().iterator();
            while (it.hasNext()) {
                ClassMethod cm = (ClassMethod)it.next();
                this.methods.add(cm.generateMethod());
            }
            this.methods.add(this.generateStaticInitializer());
        }
        catch (IOException e) {
            throw new InternalError("unexpected I/O Exception");
        }
        this.cp.getClass(ImplGenerator.dotToSlash(this.className));
        this.cp.getClass(ImplGenerator.dotToSlash(this.superclass.getName()));
        this.cp.getClass(ImplGenerator.dotToSlash(this.ifc.getName()));
        this.cp.setReadOnly();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        try {
            dout.writeInt(-889275714);
            dout.writeShort(3);
            dout.writeShort(45);
            this.cp.write(dout);
            dout.writeShort(49);
            dout.writeShort(this.cp.getClass(ImplGenerator.dotToSlash(this.className)));
            dout.writeShort(this.cp.getClass(ImplGenerator.dotToSlash(this.superclass.getName())));
            dout.writeShort(1);
            dout.writeShort(this.cp.getClass(ImplGenerator.dotToSlash(this.ifc.getName())));
            dout.writeShort(this.fields.size());
            Iterator it = this.fields.iterator();
            while (it.hasNext()) {
                FieldInfo f = (FieldInfo)it.next();
                f.write(dout);
            }
            dout.writeShort(this.methods.size());
            Iterator it2 = this.methods.iterator();
            while (it2.hasNext()) {
                MethodInfo m = (MethodInfo)it2.next();
                m.write(dout);
            }
            dout.writeShort(0);
        }
        catch (IOException e) {
            throw new InternalError("unexpected I/O Exception");
        }
        return bout.toByteArray();
    }

    protected void addClassMethod(Method m, Class fromClass) {
        String name = m.getName();
        Class[] parameterTypes = m.getParameterTypes();
        String key = name + ImplGenerator.getParameterDescriptors(parameterTypes);
        if (this.classMethods.get(key) == null) {
            ClassMethod cm = this.getClassMethod(m, fromClass);
            this.classMethods.put(key, cm);
        }
    }

    protected abstract Method[] getMethodsToImplement();

    protected ClassMethod getClassMethod(Method m, Class fromClass) {
        throw new InternalError("Unrecognized method: " + m.getName() + " from class: " + fromClass.getName());
    }

    protected abstract MethodInfo generateConstructor() throws IOException;

    protected MethodInfo generateStaticInitializer() throws IOException {
        MethodInfo minfo = new MethodInfo("<clinit>", "()V", 8);
        int localSlot0 = 1;
        DataOutputStream out = new DataOutputStream(minfo.code);
        Iterator it = this.classMethods.values().iterator();
        while (it.hasNext()) {
            ClassMethod cm = (ClassMethod)it.next();
            cm.codeFieldInitialization(out);
        }
        out.writeByte(177);
        minfo.maxStack = (short)10;
        minfo.maxLocals = (short)(localSlot0 + 1);
        minfo.declaredExceptions = new short[0];
        return minfo;
    }

    protected void code_iload(int lvar, DataOutputStream out) throws IOException {
        this.codeLocalLoadStore(lvar, 21, 26, out);
    }

    protected void code_lload(int lvar, DataOutputStream out) throws IOException {
        this.codeLocalLoadStore(lvar, 22, 30, out);
    }

    protected void code_fload(int lvar, DataOutputStream out) throws IOException {
        this.codeLocalLoadStore(lvar, 23, 34, out);
    }

    protected void code_dload(int lvar, DataOutputStream out) throws IOException {
        this.codeLocalLoadStore(lvar, 24, 38, out);
    }

    protected void code_aload(int lvar, DataOutputStream out) throws IOException {
        this.codeLocalLoadStore(lvar, 25, 42, out);
    }

    protected void code_istore(int lvar, DataOutputStream out) throws IOException {
        this.codeLocalLoadStore(lvar, 54, 59, out);
    }

    protected void code_lstore(int lvar, DataOutputStream out) throws IOException {
        this.codeLocalLoadStore(lvar, 55, 63, out);
    }

    protected void code_fstore(int lvar, DataOutputStream out) throws IOException {
        this.codeLocalLoadStore(lvar, 56, 67, out);
    }

    protected void code_dstore(int lvar, DataOutputStream out) throws IOException {
        this.codeLocalLoadStore(lvar, 57, 71, out);
    }

    protected void code_astore(int lvar, DataOutputStream out) throws IOException {
        this.codeLocalLoadStore(lvar, 58, 75, out);
    }

    protected void codeLocalLoadStore(int lvar, int opcode, int opcode_0, DataOutputStream out) throws IOException {
        ImplGenerator.assertTrue(lvar >= 0 && lvar <= 65535);
        if (lvar <= 3) {
            out.writeByte(opcode_0 + lvar);
        } else if (lvar <= 255) {
            out.writeByte(opcode);
            out.writeByte(lvar & 0xFF);
        } else {
            out.writeByte(196);
            out.writeByte(opcode);
            out.writeShort(lvar & 0xFFFF);
        }
    }

    protected void code_ldc(int index, DataOutputStream out) throws IOException {
        ImplGenerator.assertTrue(index >= 0 && index <= 65535);
        if (index <= 255) {
            out.writeByte(18);
            out.writeByte(index & 0xFF);
        } else {
            out.writeByte(19);
            out.writeShort(index & 0xFFFF);
        }
    }

    protected void code_ipush(int value, DataOutputStream out) throws IOException {
        if (value >= -1 && value <= 5) {
            out.writeByte(3 + value);
        } else if (value >= -128 && value <= 127) {
            out.writeByte(16);
            out.writeByte(value & 0xFF);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            out.writeByte(17);
            out.writeShort(value & 0xFFFF);
        } else {
            ImplGenerator.assertTrue(false);
        }
    }

    protected void codeClassForName(Class cl, DataOutputStream out) throws IOException {
        this.code_ldc(this.cp.getString(cl.getName()), out);
        out.writeByte(184);
        out.writeShort(this.cp.getMethodRef("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;"));
    }

    protected static String strip(String methodName, String prefix) {
        return methodName.substring(prefix.length());
    }

    protected static String strip(String methodName, String prefix, String suffix) {
        return methodName.substring(prefix.length(), methodName.length() - suffix.length());
    }

    protected static String firstUpper(String text) {
        try {
            return text.substring(0, 1).toUpperCase() + text.substring(1);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    protected static String firstLower(String text) {
        try {
            return text.substring(0, 1).toLowerCase() + text.substring(1);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    protected static void assertTrue(boolean assertion) {
        if (!assertion) {
            throw new InternalError("assertion failure");
        }
    }

    protected static String dotToSlash(String name) {
        return name.replace('.', '/');
    }

    protected static String getMethodDescriptor(Class[] parameterTypes, Class returnType) {
        return ImplGenerator.getParameterDescriptors(parameterTypes) + (returnType == Void.TYPE ? "V" : ImplGenerator.getFieldType(returnType));
    }

    protected static String getParameterDescriptors(Class[] parameterTypes) {
        StringBuffer desc = new StringBuffer("(");
        int i = 0;
        while (i < parameterTypes.length) {
            desc.append(ImplGenerator.getFieldType(parameterTypes[i]));
            ++i;
        }
        desc.append(')');
        return desc.toString();
    }

    protected static String getFieldType(Class type) {
        if (type.isPrimitive()) {
            return PrimitiveTypeInfo.get((Class)type).baseTypeString;
        }
        if (type.isArray()) {
            return type.getName().replace('.', '/');
        }
        return "L" + ImplGenerator.dotToSlash(type.getName()) + ";";
    }

    protected static int getWordsPerType(Class type) {
        if (type == Long.TYPE || type == Double.TYPE) {
            return 2;
        }
        return 1;
    }

    static {
        JAVA_MAGIC = -889275714;
        JAVA_DEFAULT_VERSION = 45;
        JAVA_DEFAULT_MINOR_VERSION = 3;
        CONSTANT_UTF8 = 1;
        CONSTANT_INTEGER = 3;
        CONSTANT_FLOAT = 4;
        CONSTANT_LONG = 5;
        CONSTANT_DOUBLE = 6;
        CONSTANT_CLASS = 7;
        CONSTANT_STRING = 8;
        CONSTANT_FIELD = 9;
        CONSTANT_METHOD = 10;
        CONSTANT_INTERFACEMETHOD = 11;
        CONSTANT_NAMEANDTYPE = 12;
        ACC_PUBLIC = 1;
        ACC_PRIVATE = 2;
        ACC_PROTECTED = 4;
        ACC_STATIC = 8;
        ACC_FINAL = 16;
        ACC_SUPER = 32;
        opc_aconst_null = 1;
        opc_iconst_0 = 3;
        opc_lconst_0 = 9;
        opc_fconst_0 = 11;
        opc_dconst_0 = 14;
        opc_bipush = 16;
        opc_sipush = 17;
        opc_ldc = 18;
        opc_ldc_w = 19;
        opc_iload = 21;
        opc_lload = 22;
        opc_fload = 23;
        opc_dload = 24;
        opc_aload = 25;
        opc_iload_0 = 26;
        opc_lload_0 = 30;
        opc_fload_0 = 34;
        opc_dload_0 = 38;
        opc_aload_0 = 42;
        opc_aaload = 50;
        opc_istore = 54;
        opc_lstore = 55;
        opc_fstore = 56;
        opc_dstore = 57;
        opc_astore = 58;
        opc_istore_0 = 59;
        opc_lstore_0 = 63;
        opc_fstore_0 = 67;
        opc_dstore_0 = 71;
        opc_astore_0 = 75;
        opc_aastore = 83;
        opc_bastore = 84;
        opc_pop = 87;
        opc_dup = 89;
        opc_ifeq = 153;
        opc_jsr = 168;
        opc_ret = 169;
        opc_ireturn = 172;
        opc_lreturn = 173;
        opc_freturn = 174;
        opc_dreturn = 175;
        opc_areturn = 176;
        opc_return = 177;
        opc_getstatic = 178;
        opc_putstatic = 179;
        opc_invokevirtual = 182;
        opc_invokespecial = 183;
        opc_invokestatic = 184;
        opc_new = 187;
        opc_newarray = 188;
        opc_anewarray = 189;
        opc_athrow = 191;
        opc_checkcast = 192;
        opc_wide = 196;
        opc_ifnull = 198;
        FIELD_PREFIX = FIELD_PREFIX;
    }

    protected static class ConstantPool {
        private List pool = new ArrayList(32);
        private Map map = new HashMap(16);
        private boolean readOnly = false;

        protected ConstantPool() {
        }

        public short getUtf8(String s) {
            if (s == null) {
                throw new NullPointerException();
            }
            return this.getValue(s);
        }

        public short getInteger(int i) {
            return this.getValue(new Integer(i));
        }

        public short getFloat(float f) {
            return this.getValue(new Float(f));
        }

        public short getLong(long l) {
            return this.getValue(new Long(l));
        }

        public short getDouble(double d) {
            return this.getValue(new Double(d));
        }

        public short getClass(String name) {
            short utf8Index = this.getUtf8(name);
            return this.getIndirect(new IndirectEntry(7, utf8Index));
        }

        public short getString(String s) {
            short utf8Index = this.getUtf8(s);
            return this.getIndirect(new IndirectEntry(8, utf8Index));
        }

        public short getFieldRef(String className, String name, String descriptor) {
            short classIndex = this.getClass(className);
            short nameAndTypeIndex = this.getNameAndType(name, descriptor);
            return this.getIndirect(new IndirectEntry(9, classIndex, nameAndTypeIndex));
        }

        public short getMethodRef(String className, String name, String descriptor) {
            short classIndex = this.getClass(className);
            short nameAndTypeIndex = this.getNameAndType(name, descriptor);
            return this.getIndirect(new IndirectEntry(10, classIndex, nameAndTypeIndex));
        }

        public short getInterfaceMethodRef(String className, String name, String descriptor) {
            short classIndex = this.getClass(className);
            short nameAndTypeIndex = this.getNameAndType(name, descriptor);
            return this.getIndirect(new IndirectEntry(11, classIndex, nameAndTypeIndex));
        }

        public short getNameAndType(String name, String descriptor) {
            short nameIndex = this.getUtf8(name);
            short descriptorIndex = this.getUtf8(descriptor);
            return this.getIndirect(new IndirectEntry(12, nameIndex, descriptorIndex));
        }

        public void setReadOnly() {
            this.readOnly = true;
        }

        public void write(OutputStream out) throws IOException {
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeShort(this.pool.size() + 1);
            Iterator iter = this.pool.iterator();
            while (iter.hasNext()) {
                Entry e = (Entry)iter.next();
                e.write(dataOut);
            }
        }

        private short addEntry(Entry entry) {
            this.pool.add(entry);
            return (short)this.pool.size();
        }

        private short getValue(Object key) {
            Short index = (Short)this.map.get(key);
            if (index != null) {
                return index;
            }
            if (this.readOnly) {
                throw new InternalError("late constant pool addition: " + key);
            }
            short i = this.addEntry(new ValueEntry(key));
            this.map.put(key, new Short(i));
            return i;
        }

        private short getIndirect(IndirectEntry e) {
            Short index = (Short)this.map.get(e);
            if (index != null) {
                return index;
            }
            if (this.readOnly) {
                throw new InternalError("late constant pool addition");
            }
            short i = this.addEntry(e);
            this.map.put(e, new Short(i));
            return i;
        }

        private static class IndirectEntry
        extends Entry {
            private int tag;
            private short index0;
            private short index1;

            public IndirectEntry(int tag, short index) {
                this.tag = tag;
                this.index0 = index;
                this.index1 = 0;
            }

            public IndirectEntry(int tag, short index0, short index1) {
                this.tag = tag;
                this.index0 = index0;
                this.index1 = index1;
            }

            public void write(DataOutputStream out) throws IOException {
                out.writeByte(this.tag);
                out.writeShort(this.index0);
                if (this.tag == 9 || this.tag == 10 || this.tag == 11 || this.tag == 12) {
                    out.writeShort(this.index1);
                }
            }

            public int hashCode() {
                return this.tag + this.index0 + this.index1;
            }

            public boolean equals(Object obj) {
                if (obj instanceof IndirectEntry) {
                    IndirectEntry other = (IndirectEntry)obj;
                    if (this.tag == other.tag && this.index0 == other.index0 && this.index1 == other.index1) {
                        return true;
                    }
                }
                return false;
            }
        }

        private static class ValueEntry
        extends Entry {
            private Object value;

            public ValueEntry(Object value) {
                this.value = value;
            }

            public void write(DataOutputStream out) throws IOException {
                if (this.value instanceof String) {
                    out.writeByte(1);
                    out.writeUTF((String)this.value);
                } else if (this.value instanceof Integer) {
                    out.writeByte(3);
                    out.writeInt((Integer)this.value);
                } else if (this.value instanceof Float) {
                    out.writeByte(4);
                    out.writeFloat(((Float)this.value).floatValue());
                } else if (this.value instanceof Long) {
                    out.writeByte(5);
                    out.writeLong((Long)this.value);
                } else if (this.value instanceof Double) {
                    out.writeDouble(6.0);
                    out.writeDouble((Double)this.value);
                } else {
                    throw new InternalError("bogus value entry: " + this.value);
                }
            }
        }

        private static abstract class Entry {
            private Entry() {
            }

            public abstract void write(DataOutputStream var1) throws IOException;
        }
    }

    protected static class PrimitiveTypeInfo {
        public String baseTypeString;
        public String wrapperClassName;
        public String wrapperConstructorDesc;
        public String unwrapMethodName;
        public String unwrapMethodDesc;
        private static Map table = new HashMap(11);

        private PrimitiveTypeInfo(String baseTypeString, String wrapperClassName, String wrapperConstructorDesc, String unwrapMethodName, String unwrapMethodDesc) {
            this.baseTypeString = baseTypeString;
            this.wrapperClassName = wrapperClassName;
            this.wrapperConstructorDesc = wrapperConstructorDesc;
            this.unwrapMethodName = unwrapMethodName;
            this.unwrapMethodDesc = unwrapMethodDesc;
        }

        public static PrimitiveTypeInfo get(Class cl) {
            return (PrimitiveTypeInfo)table.get(cl);
        }

        static {
            table.put(Integer.TYPE, new PrimitiveTypeInfo("I", "java/lang/Integer", "(I)V", "intValue", "()I"));
            table.put(Boolean.TYPE, new PrimitiveTypeInfo("Z", "java/lang/Boolean", "(Z)V", "booleanValue", "()Z"));
            table.put(Byte.TYPE, new PrimitiveTypeInfo("B", "java/lang/Byte", "(B)V", "byteValue", "()B"));
            table.put(Character.TYPE, new PrimitiveTypeInfo("C", "java/lang/Char", "(C)V", "charValue", "()C"));
            table.put(Short.TYPE, new PrimitiveTypeInfo("S", "java/lang/Short", "(S)V", "shortValue", "()S"));
            table.put(Long.TYPE, new PrimitiveTypeInfo("J", "java/lang/Long", "(J)V", "longValue", "()J"));
            table.put(Float.TYPE, new PrimitiveTypeInfo("F", "java/lang/Float", "(F)V", "floatValue", "()F"));
            table.put(Double.TYPE, new PrimitiveTypeInfo("D", "java/lang/Double", "(D)V", "doubleValue", "()D"));
        }
    }

    protected class ClassMethod {
        public String methodName;
        public Class[] parameterTypes;
        public Class returnType;
        public Class[] exceptionTypes;
        public Class fromClass;
        public String methodFieldName;
        public short delegateMethod;
        private boolean hasField;

        public ClassMethod(Method method, short delegate, String methodFieldName) {
            this.methodName = method.getName();
            this.parameterTypes = method.getParameterTypes();
            this.returnType = method.getReturnType();
            this.exceptionTypes = method.getExceptionTypes();
            this.fromClass = method.getDeclaringClass();
            if (methodFieldName == null) {
                this.methodFieldName = null;
                this.hasField = false;
            } else {
                this.methodFieldName = ImplGenerator.FIELD_PREFIX + methodFieldName;
                this.hasField = ImplGenerator.this.fields.add(new FieldInfo(this.methodFieldName, "Ljava/lang/String;", 10));
            }
            this.delegateMethod = delegate;
        }

        public MethodInfo generateMethod() throws IOException {
            String desc = ImplGenerator.getMethodDescriptor(this.parameterTypes, this.returnType);
            MethodInfo minfo = new MethodInfo(this.methodName, desc, 17);
            int[] parameterSlot = new int[this.parameterTypes.length];
            int nextSlot = 1;
            int i = 0;
            while (i < parameterSlot.length) {
                parameterSlot[i] = nextSlot;
                nextSlot += ImplGenerator.getWordsPerType(this.parameterTypes[i]);
                ++i;
            }
            int localSlot0 = nextSlot;
            DataOutputStream out = new DataOutputStream(minfo.code);
            ImplGenerator.this.code_aload(0, out);
            if (this.methodFieldName != null) {
                out.writeByte(89);
                out.writeByte(178);
                out.writeShort(ImplGenerator.this.cp.getFieldRef(ImplGenerator.dotToSlash(ImplGenerator.this.className), this.methodFieldName, "Ljava/lang/String;"));
            }
            int i2 = 0;
            while (i2 < this.parameterTypes.length) {
                this.codeWrapArgument(this.parameterTypes[i2], parameterSlot[i2], out);
                ++i2;
            }
            out.writeByte(183);
            out.writeShort(this.delegateMethod);
            if (this.returnType == Void.TYPE) {
                out.writeByte(177);
            } else {
                this.codeUnwrapReturnValue(this.returnType, out);
            }
            minfo.maxStack = (short)10;
            minfo.maxLocals = (short)(localSlot0 + 1);
            minfo.declaredExceptions = new short[0];
            return minfo;
        }

        public void codeWrapArgument(Class type, int slot, DataOutputStream out) throws IOException {
            if (type.isPrimitive()) {
                PrimitiveTypeInfo prim = PrimitiveTypeInfo.get(type);
                out.writeByte(187);
                out.writeShort(ImplGenerator.this.cp.getClass(prim.wrapperClassName));
                out.writeByte(89);
                if (type == Integer.TYPE || type == Boolean.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Short.TYPE) {
                    ImplGenerator.this.code_iload(slot, out);
                } else if (type == Long.TYPE) {
                    ImplGenerator.this.code_lload(slot, out);
                } else if (type == Float.TYPE) {
                    ImplGenerator.this.code_fload(slot, out);
                } else if (type == Double.TYPE) {
                    ImplGenerator.this.code_dload(slot, out);
                } else {
                    ImplGenerator.assertTrue(false);
                }
                out.writeByte(183);
                out.writeShort(ImplGenerator.this.cp.getMethodRef(prim.wrapperClassName, "<init>", prim.wrapperConstructorDesc));
            } else {
                ImplGenerator.this.code_aload(slot, out);
            }
        }

        public void codeUnwrapReturnValue(Class type, DataOutputStream out) throws IOException {
            if (type.isPrimitive()) {
                PrimitiveTypeInfo prim = PrimitiveTypeInfo.get(type);
                out.writeByte(89);
                out.writeByte(198);
                out.writeShort(10);
                out.writeByte(192);
                out.writeShort(ImplGenerator.this.cp.getClass(prim.wrapperClassName));
                out.writeByte(182);
                out.writeShort(ImplGenerator.this.cp.getMethodRef(prim.wrapperClassName, prim.unwrapMethodName, prim.unwrapMethodDesc));
                if (type == Integer.TYPE || type == Boolean.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Short.TYPE) {
                    out.writeByte(172);
                    out.writeByte(3);
                    out.writeByte(172);
                } else if (type == Long.TYPE) {
                    out.writeByte(173);
                    out.writeByte(9);
                    out.writeByte(173);
                } else if (type == Float.TYPE) {
                    out.writeByte(174);
                    out.writeByte(11);
                    out.writeByte(174);
                } else if (type == Double.TYPE) {
                    out.writeByte(175);
                    out.writeByte(14);
                    out.writeByte(175);
                } else {
                    ImplGenerator.assertTrue(false);
                }
            } else {
                out.writeByte(192);
                out.writeShort(ImplGenerator.this.cp.getClass(ImplGenerator.dotToSlash(type.getName())));
                out.writeByte(176);
            }
        }

        public int getBytesForUnwrapReturn(Class type) {
            if (type.isPrimitive()) {
                return 13;
            }
            return 4;
        }

        public void codeFieldInitialization(DataOutputStream out) throws IOException {
            if (this.hasField) {
                out.writeByte(187);
                out.writeShort(ImplGenerator.this.cp.getClass("java/lang/String"));
                out.writeByte(89);
                byte[] bytes = ImplGenerator.strip(this.methodFieldName, ImplGenerator.FIELD_PREFIX).getBytes();
                ImplGenerator.this.code_ipush(bytes.length, out);
                out.writeByte(188);
                out.writeByte(ImplGenerator.this.T_BYTE);
                int i = 0;
                while (i < bytes.length) {
                    out.writeByte(89);
                    ImplGenerator.this.code_ipush(i, out);
                    ImplGenerator.this.code_ipush(bytes[i], out);
                    out.writeByte(84);
                    ++i;
                }
                out.writeByte(183);
                out.writeShort(ImplGenerator.this.cp.getMethodRef("java/lang/String", "<init>", "([B)V"));
                out.writeByte(179);
                out.writeShort(ImplGenerator.this.cp.getFieldRef(ImplGenerator.dotToSlash(ImplGenerator.this.className), this.methodFieldName, "Ljava/lang/String;"));
            }
        }
    }

    protected final class MethodInfo {
        public int accessFlags;
        public String name;
        public String descriptor;
        public short maxStack;
        public short maxLocals;
        public ByteArrayOutputStream code = new ByteArrayOutputStream();
        public List exceptionTable = new ArrayList();
        public short[] declaredExceptions;

        public MethodInfo(String name, String descriptor, int accessFlags) {
            this.name = name;
            this.descriptor = descriptor;
            this.accessFlags = accessFlags;
            ImplGenerator.this.cp.getUtf8(name);
            ImplGenerator.this.cp.getUtf8(descriptor);
            ImplGenerator.this.cp.getUtf8("Code");
            ImplGenerator.this.cp.getUtf8("Exceptions");
        }

        public void write(DataOutputStream out) throws IOException {
            out.writeShort(this.accessFlags);
            out.writeShort(ImplGenerator.this.cp.getUtf8(this.name));
            out.writeShort(ImplGenerator.this.cp.getUtf8(this.descriptor));
            out.writeShort(2);
            out.writeShort(ImplGenerator.this.cp.getUtf8("Code"));
            out.writeInt(12 + this.code.size() + 8 * this.exceptionTable.size());
            out.writeShort(this.maxStack);
            out.writeShort(this.maxLocals);
            out.writeInt(this.code.size());
            this.code.writeTo(out);
            out.writeShort(this.exceptionTable.size());
            Iterator iter = this.exceptionTable.iterator();
            while (iter.hasNext()) {
                ExceptionTableEntry e = (ExceptionTableEntry)iter.next();
                out.writeShort(e.startPc);
                out.writeShort(e.endPc);
                out.writeShort(e.handlerPc);
                out.writeShort(e.catchType);
            }
            out.writeShort(0);
            out.writeShort(ImplGenerator.this.cp.getUtf8("Exceptions"));
            out.writeInt(2 + 2 * this.declaredExceptions.length);
            out.writeShort(this.declaredExceptions.length);
            int i = 0;
            while (i < this.declaredExceptions.length) {
                out.writeShort(this.declaredExceptions[i]);
                ++i;
            }
        }
    }

    protected static final class ExceptionTableEntry {
        public short startPc;
        public short endPc;
        public short handlerPc;
        public short catchType;

        public ExceptionTableEntry(short startPc, short endPc, short handlerPc, short catchType) {
            this.startPc = startPc;
            this.endPc = endPc;
            this.handlerPc = handlerPc;
            this.catchType = catchType;
        }
    }

    protected final class FieldInfo {
        public int accessFlags;
        public String name;
        public String descriptor;

        public FieldInfo(String name, String descriptor, int accessFlags) {
            this.name = name;
            this.descriptor = descriptor;
            this.accessFlags = accessFlags;
            ImplGenerator.this.cp.getUtf8(name);
            ImplGenerator.this.cp.getUtf8(descriptor);
        }

        public final void write(DataOutputStream out) throws IOException {
            out.writeShort(this.accessFlags);
            out.writeShort(ImplGenerator.this.cp.getUtf8(this.name));
            out.writeShort(ImplGenerator.this.cp.getUtf8(this.descriptor));
            out.writeShort(0);
        }

        public boolean equals(Object o) {
            if (o instanceof FieldInfo) {
                return ((FieldInfo)o).name.equalsIgnoreCase(this.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.toUpperCase().hashCode();
        }
    }
}

