/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.util;

import java.util.HashMap;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.TransactionEvent;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.EventNotifier;
import org.netbeans.mdr.util.Logger;

public class TransactionMutex {
    private Thread writer = null;
    private volatile int counter = 0;
    private final HashMap readers = new HashMap(10);
    private volatile boolean fail = false;
    private final MdrStorage storage;
    private final EventNotifier notifier;
    private final NBMDRepositoryImpl repository;

    public TransactionMutex(MdrStorage storage, EventNotifier notifier, NBMDRepositoryImpl repository) {
        this.storage = storage;
        this.notifier = notifier;
        this.repository = repository;
    }

    public boolean willFail() {
        return this.fail;
    }

    public boolean pendingChanges() {
        return this.counter > 0;
    }

    public synchronized void enter(boolean writeAccess) {
        Thread thread = Thread.currentThread();
        while (this.counter > 0 && this.writer != thread || writeAccess && !this.readers.isEmpty()) {
            if (this.readers.get(thread) != null) {
                throw new DebugException("Writable lock nested in read-only lock.");
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Logger.getDefault().notify(1, (Throwable)e);
            }
        }
        if (writeAccess || this.counter > 0) {
            if (this.counter == 0) {
                this.writer = thread;
                TransactionEvent event = new TransactionEvent((MDRepository)this.repository, 0x110001);
                this.notifier.REPOSITORY.firePlannedChange(this.storage, (MDRChangeEvent)event);
            }
            ++this.counter;
        } else {
            Counter rCount = (Counter)this.readers.get(thread);
            if (rCount == null) {
                this.readers.put(thread, new Counter());
            } else {
                rCount.inc();
            }
        }
    }

    public synchronized void leave() {
        this.leave(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void leave(boolean fail) {
        try {
            if (this.counter > 0) {
                this.fail |= fail;
                if (--this.counter == 0) {
                    try {
                        block15: {
                            try {
                                TransactionEvent event = new TransactionEvent((MDRepository)this.repository, 0x110002);
                                this.notifier.REPOSITORY.firePlannedChange(this.storage, (MDRChangeEvent)event);
                                if (this.fail) {
                                    this.notifier.fireCancelled();
                                    this.storage.rollback();
                                    break block15;
                                }
                                this.notifier.fireChanged();
                                this.storage.commit();
                            }
                            catch (StorageException e) {
                                try {
                                    Logger.getDefault().notify(1, (Throwable)e);
                                    this.storage.rollback();
                                }
                                catch (StorageException fatal) {
                                    throw new DebugException("Fatal I/O error: " + fatal.toString());
                                }
                                Object var5_6 = null;
                                this.writer = null;
                                this.fail = false;
                            }
                        }
                        Object var5_5 = null;
                        this.writer = null;
                        this.fail = false;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        this.writer = null;
                        this.fail = false;
                        throw throwable;
                    }
                }
            } else {
                Thread thread = Thread.currentThread();
                Counter rCount = (Counter)this.readers.get(thread);
                if (rCount == null) {
                    throw new DebugException("Error: leave() without enter().");
                }
                if (rCount.dec() == 0) {
                    this.readers.remove(thread);
                }
                if (fail) {
                    throw new DebugException("Cannot fail when in read mode.");
                }
            }
            Object var7_11 = null;
            this.notifyAll();
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            this.notifyAll();
            throw throwable;
        }
    }

    private static class Counter {
        private int value = 1;

        public int intValue() {
            return this.value;
        }

        public int dec() {
            if (this.value <= 0) {
                throw new DebugException("Couter underflow: " + this.value);
            }
            return --this.value;
        }

        public int inc() {
            return ++this.value;
        }
    }
}

