/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XmiUtils {
    private static HashMap namespaces = new HashMap();

    public static String getXmiAttrValueAsString(Node node, String attributeName) {
        String result = null;
        if (node != null && (result = XmiUtils.getAttributeValueAsString(node, XmiUtils.getShortName(attributeName))) == null) {
            result = XmiUtils.getElementValueAsString(node, attributeName);
        }
        return result;
    }

    public static List getXmiMultiValueAsString(Node node, String attributeName) {
        List result = null;
        if (node != null) {
            return XmiUtils.getElementValueAsStringList(node, attributeName);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static List getXmiRefValue(Node node, String attributeName) {
        block7: {
            value = new ArrayList<String>();
            if (node == null) break block7;
            attr = XmiUtils.getAttributeValueAsString(node, XmiUtils.getShortName(attributeName));
            if (attr != null) ** GOTO lbl20
            refNode = XmiUtils.getChildNode(node, attributeName);
            if (refNode == null) break block7;
            values = refNode.getChildNodes();
            i = 0;
            while (i < values.getLength()) {
                if (!XmiUtils.isTextNode(values.item(i))) {
                    value.add(XmiUtils.getAttributeValueAsString(values.item(i), "xmi.idref"));
                }
                ++i;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                if (refNode > 0) {
                    value.add(attr.substring(0, (int)refNode));
                }
                attr = attr.substring((int)(refNode + true));
lbl20:
                // 2 sources

                ** while ((pos = attr.indexOf((int)32)) > -1)
            }
lbl21:
            // 1 sources

            value.add(attr);
        }
        return value;
    }

    public static String getAttributeValueAsString(Node node, String attributeName) {
        Node attribute;
        String result = null;
        if (node != null && node.hasAttributes() && (attribute = node.getAttributes().getNamedItem(attributeName)) != null) {
            result = attribute.getNodeValue();
        }
        return result;
    }

    public static String getElementValueAsString(Node node, String attributeName) {
        Node attributeNode;
        String result = null;
        if (node != null && (attributeNode = XmiUtils.getChildNode(node, attributeName)) != null) {
            result = (attributeNode = attributeNode.getFirstChild()) == null ? "" : attributeNode.getNodeValue();
        }
        return result;
    }

    public static List getElementValueAsStringList(Node node, String attributeName) {
        List l;
        ArrayList<String> result = null;
        if (node != null && (l = XmiUtils.getChildNodeList(node, attributeName)) != null) {
            result = new ArrayList<String>(l.size());
            Iterator it = l.iterator();
            while (it.hasNext()) {
                Node attributeNode = ((Node)it.next()).getFirstChild();
                if (attributeNode == null) {
                    result.add("");
                    continue;
                }
                result.add(attributeNode.getNodeValue());
            }
        }
        return result;
    }

    public static List getChildNodeList(Node parentNode, String childNodeName) {
        LinkedList<Node> result = null;
        if (parentNode != null && childNodeName != null) {
            NodeList children = parentNode.getChildNodes();
            int cnt = 0;
            while (cnt < children.getLength()) {
                Node child = children.item(cnt);
                if (childNodeName.equals(XmiUtils.resolveFullName(child))) {
                    if (result == null) {
                        result = new LinkedList<Node>();
                    }
                    result.add(child);
                }
                ++cnt;
            }
        }
        return result;
    }

    public static Node getChildNode(Node parentNode, String childNodeName) {
        Node result = null;
        if (parentNode != null && childNodeName != null) {
            NodeList children = parentNode.getChildNodes();
            int cnt = 0;
            while (cnt < children.getLength()) {
                Node child = children.item(cnt);
                if (childNodeName.equals(XmiUtils.resolveFullName(child))) {
                    result = child;
                    break;
                }
                ++cnt;
            }
        }
        return result;
    }

    public static String resolveFullName(Node element) {
        if (XmiUtils.isXmiNode(element)) {
            return element.getNodeName();
        }
        return XmiUtils.resolveFullNameAsString(element.getNodeName());
    }

    public static String resolveFullNameAsString(String fullName) {
        if (fullName != null) {
            int index = fullName.indexOf(58);
            if (index > 0) {
                return namespaces.get(fullName.substring(0, index)) + "." + fullName.substring(index + 1);
            }
            return fullName;
        }
        return null;
    }

    public static String getShortName(String fullyQualifiedName) {
        String result = fullyQualifiedName;
        if (fullyQualifiedName != null && fullyQualifiedName.toUpperCase().indexOf("XMI.") > -1) {
            return fullyQualifiedName;
        }
        if (result != null && result.indexOf(":") > -1) {
            result = result.substring(result.indexOf(":") + 1);
        }
        if (result != null && result.indexOf(".") > -1) {
            result = result.substring(result.lastIndexOf(".") + 1);
        }
        return result;
    }

    public static boolean isTextNode(Node node) {
        boolean result = false;
        if (node != null) {
            result = node.getNodeName().equals("#text") || node.getNodeName().equals("#comment");
        }
        return result;
    }

    public static boolean isXmiNavigationNode(Node node) {
        boolean result = false;
        if (node != null) {
            result = node.getNodeName().equals("xmi.id") || result;
            result = node.getNodeName().equals("xmi.uuid") || result;
            result = node.getNodeName().equals("xmi.label") || result;
            result = node.getNodeName().equals("xmi.idref") || result;
        }
        return result;
    }

    public static boolean isXmiNode(Node node) {
        boolean result = false;
        if (node != null) {
            result |= XmiUtils.isXmiNavigationNode(node);
            result |= node.getNodeName().equals("XMI.any");
        }
        return result;
    }

    static {
        namespaces.put("Model", "Model");
        namespaces.put("UML", "Model_Management");
        namespaces.put("CWMOLAP", "Olap");
        namespaces.put("CWMTFM", "Transformation");
        namespaces.put("CWM", "BusinessInformation");
        namespaces.put("CWMRDB", "Relational");
    }

    public static class XmiNodeIterator {
        private Node node = null;
        private String attrName;
        private String attrValue;
        private String nodeName;
        private NodeList childNodes = null;
        private Node currentNode = null;
        private int index = 0;

        public XmiNodeIterator(Node node, String nodeName) {
            this.attrName = null;
            this.attrValue = null;
            this.nodeName = nodeName;
            this.node = node;
            this.childNodes = node.getChildNodes();
            this.findNext();
        }

        public XmiNodeIterator(Node node, String attrName, String attrValue) {
            this.attrName = attrName;
            this.attrValue = attrValue;
            this.nodeName = null;
            this.node = node;
            this.childNodes = node.getChildNodes();
            this.findNext();
        }

        public XmiNodeIterator(Node node) {
            this(node, null, null);
        }

        public boolean hasNext() {
            return this.currentNode != null;
        }

        public Node next() {
            Node result = this.currentNode;
            this.findNext();
            return result;
        }

        private void findNext() {
            int i = this.index;
            while (i < this.childNodes.getLength()) {
                Node sn = this.childNodes.item(i);
                if (!XmiUtils.isTextNode(sn) && (this.attrName == null || XmiUtils.getXmiAttrValueAsString(sn, this.attrName) != null && XmiUtils.getXmiAttrValueAsString(sn, this.attrName).equals(this.attrValue)) && (this.nodeName == null || XmiUtils.resolveFullName(sn).substring(this.nodeName.lastIndexOf(46) + 1).equals(this.nodeName.substring(this.nodeName.lastIndexOf(46) + 1)))) {
                    this.currentNode = sn;
                    this.index = i + 1;
                    return;
                }
                ++i;
            }
            this.currentNode = null;
            this.index = this.childNodes.getLength();
        }
    }
}

