/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakSet;

public abstract class ErrorManager {
    public static final int UNKNOWN = 0;
    public static final int INFORMATIONAL = 1;
    public static final int WARNING = 16;
    public static final int USER = 256;
    public static final int EXCEPTION = 4096;
    public static final int ERROR = 65536;
    private static DelegatingErrorManager current;
    static /* synthetic */ Class class$org$openide$ErrorManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorManager getDefault() {
        Class clazz = class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = ErrorManager.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager;
        synchronized (clazz) {
            if (current != null) {
                return current;
            }
        }
        return ErrorManager.getDefaultDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DelegatingErrorManager getDefaultDelegate() {
        DelegatingErrorManager delegatingErrorManager = new DelegatingErrorManager("");
        delegatingErrorManager.initialize();
        Class clazz = class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = ErrorManager.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager;
        synchronized (clazz) {
            if (current == null) {
                current = delegatingErrorManager;
                ErrorManager.current.r.addLookupListener(current);
            }
        }
        return current;
    }

    public abstract Throwable attachAnnotations(Throwable var1, Annotation[] var2);

    public abstract Annotation[] findAnnotations(Throwable var1);

    public abstract Throwable annotate(Throwable var1, int var2, String var3, String var4, Throwable var5, Date var6);

    public abstract void notify(int var1, Throwable var2);

    public final void notify(Throwable throwable) {
        this.notify(0, throwable);
    }

    public abstract void log(int var1, String var2);

    public final void log(String string) {
        this.log(1, string);
    }

    public boolean isLoggable(int n) {
        return true;
    }

    public abstract ErrorManager getInstance(String var1);

    public final Throwable annotate(Throwable throwable, String string) {
        return this.annotate(throwable, 4096, null, string, null, null);
    }

    public final Throwable annotate(Throwable throwable, Throwable throwable2) {
        return this.annotate(throwable, 4096, null, null, throwable2, null);
    }

    public final Throwable copyAnnotation(Throwable throwable, Throwable throwable2) {
        return this.annotate(throwable, 0, null, null, throwable2, null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface Annotation {
        public String getMessage();

        public String getLocalizedMessage();

        public Throwable getStackTrace();

        public Date getDate();

        public int getSeverity();
    }

    private static class DelegatingErrorManager
    extends ErrorManager
    implements LookupListener {
        private String name = null;
        private Set delegates = new HashSet();
        private WeakSet createdByMe = new WeakSet();
        Lookup.Result r;

        public DelegatingErrorManager(String string) {
            this.name = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ErrorManager getInstance(String string) {
            if (string == null || "".equals(string)) {
                return this;
            }
            DelegatingErrorManager delegatingErrorManager = new DelegatingErrorManager(string);
            DelegatingErrorManager delegatingErrorManager2 = this;
            synchronized (delegatingErrorManager2) {
                this.attachNewDelegates(delegatingErrorManager, string);
                this.createdByMe.add(delegatingErrorManager);
            }
            return delegatingErrorManager;
        }

        public Throwable attachAnnotations(Throwable throwable, Annotation[] annotationArray) {
            Iterator iterator = this.delegates.iterator();
            while (iterator.hasNext()) {
                ErrorManager errorManager = (ErrorManager)iterator.next();
                errorManager.attachAnnotations(throwable, annotationArray);
            }
            return throwable;
        }

        public Annotation[] findAnnotations(Throwable throwable) {
            Iterator iterator = this.delegates.iterator();
            while (iterator.hasNext()) {
                ErrorManager errorManager = (ErrorManager)iterator.next();
                Annotation[] annotationArray = errorManager.findAnnotations(throwable);
                if (annotationArray == null || annotationArray.length <= 0) continue;
                return annotationArray;
            }
            return new Annotation[0];
        }

        public Throwable annotate(Throwable throwable, int n, String string, String string2, Throwable throwable2, Date date) {
            Iterator iterator = this.delegates.iterator();
            while (iterator.hasNext()) {
                ErrorManager errorManager = (ErrorManager)iterator.next();
                errorManager.annotate(throwable, n, string, string2, throwable2, date);
            }
            return throwable;
        }

        public void notify(int n, Throwable throwable) {
            if (this.delegates.isEmpty()) {
                throwable.printStackTrace();
            }
            Iterator iterator = this.delegates.iterator();
            while (iterator.hasNext()) {
                ErrorManager errorManager = (ErrorManager)iterator.next();
                errorManager.notify(n, throwable);
            }
        }

        public void log(int n, String string) {
            if (this.delegates.isEmpty()) {
                System.err.println("Log: " + n + " msg: " + string);
            }
            Iterator iterator = this.delegates.iterator();
            while (iterator.hasNext()) {
                ErrorManager errorManager = (ErrorManager)iterator.next();
                errorManager.log(n, string);
            }
        }

        public boolean isLoggable(int n) {
            if (this.delegates.isEmpty()) {
                return true;
            }
            Iterator iterator = this.delegates.iterator();
            while (iterator.hasNext()) {
                ErrorManager errorManager = (ErrorManager)iterator.next();
                if (!errorManager.isLoggable(n)) continue;
                return true;
            }
            return false;
        }

        public synchronized void setDelegates(Collection collection) {
            HashSet hashSet = new HashSet(collection);
            Iterator iterator = this.createdByMe.iterator();
            while (iterator.hasNext()) {
                DelegatingErrorManager delegatingErrorManager = (DelegatingErrorManager)iterator.next();
                this.attachNewDelegates(delegatingErrorManager, delegatingErrorManager.getName());
            }
            this.delegates = hashSet;
        }

        private String getName() {
            return this.name;
        }

        private void attachNewDelegates(DelegatingErrorManager delegatingErrorManager, String string) {
            HashSet<ErrorManager> hashSet = new HashSet<ErrorManager>();
            Iterator iterator = this.delegates.iterator();
            while (iterator.hasNext()) {
                ErrorManager errorManager = (ErrorManager)iterator.next();
                hashSet.add(errorManager.getInstance(string));
            }
            delegatingErrorManager.setDelegates(hashSet);
        }

        public void initialize() {
            this.r = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = ErrorManager.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager));
            Collection collection = this.r.allInstances();
            this.setDelegates(collection);
        }

        public void resultChanged(LookupEvent lookupEvent) {
            if (this.r != null) {
                Collection collection = this.r.allInstances();
                this.setDelegates(collection);
            }
        }
    }
}

