/*
 * Decompiled with CFR 0.152.
 */
package yu.org.goodoldai.air.wb.ui.mdr.odm.wizards.pages;

import javax.jmi.reflect.RefClass;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import yu.org.goodoldai.air.model.odm.OdmPackage;
import yu.org.goodoldai.air.model.odm.OntologyClass;
import yu.org.goodoldai.air.wb.core.adaptable.IAdaptableFactory;
import yu.org.goodoldai.air.wb.core.adaptable.IAdaptableFactoryProvider;
import yu.org.goodoldai.air.wb.core.adaptable.IAdaptableObject;
import yu.org.goodoldai.air.wb.mdr.core.adaptable.reflect.IRefClassAdaptable;
import yu.org.goodoldai.air.wb.mdr.odm.adaptable.IOntologyAdaptable;
import yu.org.goodoldai.air.wb.ui.core.dialogs.wizard.dialogfields.DialogField;
import yu.org.goodoldai.air.wb.ui.core.dialogs.wizard.dialogfields.IDialogFieldListener;
import yu.org.goodoldai.air.wb.ui.core.dialogs.wizard.dialogfields.IStringButtonAdapter;
import yu.org.goodoldai.air.wb.ui.core.dialogs.wizard.dialogfields.StringButtonDialogField;
import yu.org.goodoldai.air.wb.ui.core.dialogs.wizard.dialogfields.StringDialogField;
import yu.org.goodoldai.air.wb.ui.core.dialogs.wizard.pages.NewRefObjectWizardPage;
import yu.org.goodoldai.air.wb.ui.core.util.LayoutUtil;

public abstract class NewResourceWizardPage
extends NewRefObjectWizardPage {
    private String id;
    private String label = "";
    private String comment = "";
    private IOntologyAdaptable ontologyAdaptable;
    private static final String PAGE_NAME = "NewResourceWizardPage";
    StringDialogField idDialogField = new StringDialogField();
    StringDialogField labelDialogField;
    StringDialogField commentDialogField;
    private StringButtonDialogField ontologyDialogField;

    public NewResourceWizardPage(IRefClassAdaptable refClassAdaptable, IAdaptableFactory typecentricFactory) {
        super(PAGE_NAME, refClassAdaptable, typecentricFactory);
        this.idDialogField.setDialogFieldListener((IDialogFieldListener)new IdFieldAdapter());
        this.idDialogField.setLabelText("Resource Id");
        this.labelDialogField = new StringDialogField();
        this.labelDialogField.setDialogFieldListener((IDialogFieldListener)new LabelFieldAdapter());
        this.labelDialogField.setLabelText("Resource Label");
        this.commentDialogField = new StringDialogField();
        this.commentDialogField.setDialogFieldListener((IDialogFieldListener)new CommentFieldAdapter());
        this.commentDialogField.setLabelText("Resource Comment");
        this.ontologyDialogField = new StringButtonDialogField((IStringButtonAdapter)new OntologyFieldAdapter());
        this.ontologyDialogField.setLabelText("Ontology that contains this Resource");
        this.ontologyDialogField.setButtonLabel("Select Ontology");
        this.setPageComplete(false);
    }

    protected void addOntologyDialogField(Composite parent, Composite composite, int nColumns) {
        this.ontologyDialogField.doFillIntoGrid(composite, nColumns);
        LayoutUtil.setWidthHint((Control)this.ontologyDialogField.getTextControl(null), (int)this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.ontologyDialogField.getTextControl(null));
        this.ontologyDialogField.getTextControl(parent).setEditable(false);
    }

    protected void addCommentDilogfield(Composite composite, int nColumns) {
        this.commentDialogField.doFillIntoGrid(composite, nColumns);
        LayoutUtil.setWidthHint((Control)this.commentDialogField.getTextControl(null), (int)this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.commentDialogField.getTextControl(null));
    }

    protected void addLabelDialogField(Composite composite, int nColumns) {
        this.labelDialogField.doFillIntoGrid(composite, nColumns);
        LayoutUtil.setWidthHint((Control)this.labelDialogField.getTextControl(null), (int)this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.labelDialogField.getTextControl(null));
    }

    protected void addIdDialogField(Composite composite, int nColumns) {
        this.idDialogField.doFillIntoGrid(composite, nColumns);
        LayoutUtil.setWidthHint((Control)this.idDialogField.getTextControl(null), (int)this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.idDialogField.getTextControl(null));
    }

    private void ontologyChangeControlPressed(DialogField field) {
        OntologyClass ontologyClass = ((OdmPackage)((RefClass)this.getRefClassAdaptable().getElement()).refImmediatePackage()).getOntology();
        IAdaptableObject ontologyClassAdaptable = this.getTypecentricFactory().adapt((Object)ontologyClass);
        ((IAdaptableFactoryProvider)ontologyClassAdaptable).setAdaptableFactory(((IAdaptableFactoryProvider)this.getRefClassAdaptable()).getAdaptableFactory());
        if (!this.getContentProvider().hasChildren((Object)ontologyClassAdaptable)) {
            MessageDialog.openInformation(null, (String)"There are no available elements to select from.", (String)"You have tried to select an element from a list. However, there are no elements in a model that suit your request.");
            return;
        }
        ListDialog dialog = new ListDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setContentProvider((IStructuredContentProvider)this.getContentProvider());
        dialog.setLabelProvider(this.getLabelProvider());
        dialog.setInput((Object)ontologyClassAdaptable);
        dialog.setTitle("Select Ontology");
        if (dialog.open() != 1) {
            this.setOntologyAdaptable((IOntologyAdaptable)dialog.getResult()[0]);
            this.setPageComplete(this.isPageCompleted());
        }
    }

    public IOntologyAdaptable getOntologyAdaptable() {
        return this.ontologyAdaptable;
    }

    public void setOntologyAdaptable(IOntologyAdaptable adaptable) {
        this.ontologyAdaptable = adaptable;
        this.ontologyDialogField.setText(this.getLabelProvider().getText((Object)adaptable));
        this.setPageComplete(this.isPageCompleted());
    }

    public String getComment() {
        return this.comment;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setComment(String string) {
        this.comment = string;
        this.commentDialogField.setText(string);
        this.setPageComplete(this.isPageCompleted());
    }

    public void setId(String string) {
        this.id = string;
        this.idDialogField.setText(string);
        this.setPageComplete(this.isPageCompleted());
    }

    public void setLabel(String string) {
        this.label = string;
        this.labelDialogField.setText(string);
        this.setPageComplete(this.isPageCompleted());
    }

    protected boolean isPageCompleted() {
        return this.isIdCompleted() && this.isLabelCompleted() && this.isCommentCompleted() && this.isOntologyCompleted();
    }

    protected boolean isIdCompleted() {
        return this.id != null && !this.id.equals("");
    }

    protected boolean isLabelCompleted() {
        return true;
    }

    protected boolean isCommentCompleted() {
        return true;
    }

    protected boolean isOntologyCompleted() {
        return this.ontologyAdaptable != null;
    }

    protected void addDialogFields(Composite parent, Composite composite, int nColumns) {
        this.addIdDialogField(composite, nColumns);
        this.addLabelDialogField(composite, nColumns);
        this.addCommentDilogfield(composite, nColumns);
        this.addOntologyDialogField(parent, composite, nColumns);
    }

    private class OntologyFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        OntologyFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            NewResourceWizardPage.this.ontologyChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
        }
    }

    private class IdFieldAdapter
    implements IDialogFieldListener {
        IdFieldAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            NewResourceWizardPage.this.id = ((StringDialogField)field).getText();
            NewResourceWizardPage.this.setPageComplete(NewResourceWizardPage.this.isPageCompleted());
        }
    }

    private class LabelFieldAdapter
    implements IDialogFieldListener {
        LabelFieldAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            NewResourceWizardPage.this.label = ((StringDialogField)field).getText();
            NewResourceWizardPage.this.setPageComplete(NewResourceWizardPage.this.isPageCompleted());
        }
    }

    private class CommentFieldAdapter
    implements IDialogFieldListener {
        CommentFieldAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            NewResourceWizardPage.this.comment = ((StringDialogField)field).getText();
            NewResourceWizardPage.this.setPageComplete(NewResourceWizardPage.this.isPageCompleted());
        }
    }
}

