/*
 * Decompiled with CFR 0.152.
 */
package yu.org.goodoldai.air.wb.ui.mdr.explorer;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.part.ViewPart;
import yu.org.goodoldai.air.mdr.impl.AirMDRepositoryImpl;
import yu.org.goodoldai.air.wb.core.provider.WorkbenchContentProvider;
import yu.org.goodoldai.air.wb.core.provider.WorkbenchLabelProvider;
import yu.org.goodoldai.air.wb.mdr.core.AirMDRCore;
import yu.org.goodoldai.air.wb.mdr.core.adaptable.repository.IAirMDRepositoryAdaptable;
import yu.org.goodoldai.air.wb.ui.mdr.explorer.ExplorerMDRProvider;

public class ExplorerViewPart
extends ViewPart {
    private TreeViewer viewer;

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        IAirMDRepositoryAdaptable repositoryAdaptable = (IAirMDRepositoryAdaptable)AirMDRCore.getAdaptableFactoryManager().adapt((Object)new AirMDRepositoryImpl(), AirMDRCore.CLASSCENTRIC_ID);
        AirMDRCore.setRepositoryAdaptable((IAirMDRepositoryAdaptable)repositoryAdaptable);
        Tree tree = new Tree(parent, 66308);
        this.viewer = new TreeViewer(tree);
        this.getViewer().setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.getViewer().setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.getViewer().setUseHashlookup(true);
        this.getViewer().setInput((Object)ExplorerMDRProvider.getDefault().getRepositoryAdaptable());
        this.getViewer().expandToLevel(2);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.createContextMenu();
        this.createToolbar();
    }

    protected void createToolbar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IContributionItem)new Separator("vtexplorer"));
        toolbarManager.add((IContributionItem)new Separator("vtexplorer-end"));
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ExplorerViewPart.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, this.getSite().getSelectionProvider());
    }

    private void fillContextMenu(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator("pmmetamodel"));
        menuManager.add((IContributionItem)new Separator("pmmetamodel-end"));
        menuManager.add((IContributionItem)new Separator("pmxmi"));
        menuManager.add((IContributionItem)new Separator("pmxmi-end"));
        menuManager.add((IContributionItem)new Separator("pmgenerate"));
        menuManager.add((IContributionItem)new Separator("pmgenerate-end"));
        menuManager.add((IContributionItem)new Separator("pmedit"));
        menuManager.add((IContributionItem)new Separator("pmedit-end"));
        menuManager.add((IContributionItem)new Separator("pmview"));
        menuManager.add((IContributionItem)new Separator("pmview-end"));
        menuManager.add((IContributionItem)new Separator("pmproperties"));
        menuManager.add((IContributionItem)new Separator("pmproperties-end"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("additions-end"));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }
}

