/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.ErrorManager;

public class Logger
extends ErrorManager {
    private static final String PROP_MIN_SEVERITY = "org.netbeans.lib.jmi.Logger";
    private static final String PROP_LOG_FILE = "org.netbeans.lib.jmi.Logger.fileName";
    private static ErrorManager defaultManager = null;
    private static final Map map = new WeakHashMap(11);
    private final LogWriter logWriter;
    private final int minLogSeverity;
    private final String name;

    public static synchronized ErrorManager getDefault() {
        if (defaultManager == null) {
            defaultManager = ErrorManager.getDefault().getInstance(PROP_MIN_SEVERITY);
        }
        return defaultManager;
    }

    public Logger() {
        this.name = null;
        this.minLogSeverity = 2;
        String fileName = System.getProperty(PROP_LOG_FILE);
        if (fileName == null) {
            this.logWriter = new LogWriter(System.err);
        } else if (fileName.equals("")) {
            this.logWriter = new LogWriter();
        } else {
            LogWriter writer;
            try {
                writer = new LogWriter(new FileOutputStream(fileName));
            }
            catch (FileNotFoundException e) {
                writer = new LogWriter(System.err);
                this.notify(e);
            }
            this.logWriter = writer;
        }
    }

    public Logger(String name, int minSeverity, LogWriter logWriter) {
        this.name = name;
        this.minLogSeverity = minSeverity;
        this.logWriter = logWriter;
    }

    public Throwable annotate(Throwable t, int severity, String message, String localizedMessage, Throwable stackTrace, Date date) {
        ArrayList<Ann> annotations = (ArrayList<Ann>)map.get(t);
        if (annotations == null) {
            annotations = new ArrayList<Ann>();
            map.put(t, annotations);
        }
        annotations.add(0, new Ann(severity, message, localizedMessage, stackTrace, date));
        return t;
    }

    public Throwable attachAnnotations(Throwable t, ErrorManager.Annotation[] arr) {
        ArrayList<ErrorManager.Annotation> annotations = (ArrayList<ErrorManager.Annotation>)map.get(t);
        if (annotations == null) {
            annotations = new ArrayList<ErrorManager.Annotation>(arr.length + 5);
            map.put(t, annotations);
        }
        annotations.addAll(0, Arrays.asList(arr));
        return t;
    }

    public ErrorManager.Annotation[] findAnnotations(Throwable t) {
        List annotations = (List)map.get(t);
        if (annotations != null) {
            return annotations.toArray(new ErrorManager.Annotation[annotations.size()]);
        }
        return null;
    }

    public ErrorManager getInstance(String name) {
        String loggerName;
        String prop = loggerName = this.name == null ? name : this.name + "." + name;
        int minLogSeverity = this.minLogSeverity;
        while (prop != null) {
            String value = System.getProperty(prop);
            if (value != null) {
                try {
                    minLogSeverity = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    this.notify(16, nfe);
                }
                break;
            }
            int idx = prop.lastIndexOf(46);
            prop = idx == -1 ? null : prop.substring(0, idx);
        }
        return new Logger(loggerName, minLogSeverity, this.logWriter);
    }

    public void log(int severity, String s) {
        if (this.isLoggable(severity)) {
            if (this.name != null) {
                this.logWriter.printlnIndented("[" + this.name + "] " + s);
            } else {
                this.logWriter.printlnIndented(s);
            }
            this.logWriter.flush();
        }
    }

    public boolean isLoggable(int severity) {
        return severity >= this.minLogSeverity;
    }

    public boolean isNotifiable(int severity) {
        return this.isLoggable(severity + 1);
    }

    public void notify(int severity, Throwable t) {
        this.notify(severity, t, new HashSet());
    }

    private void notify(int severity, Throwable t, Set visited) {
        String level;
        if (!this.isNotifiable(severity)) {
            return;
        }
        if (!visited.add(t)) {
            return;
        }
        ErrorManager.Annotation[] ann = this.findAnnotations(t);
        String string = level = severity == 1 ? "INFORMATIONAL " : "";
        if (this.name != null) {
            level = "[" + this.name + "] " + level;
        }
        this.logWriter.printlnIndented(level + "*********** Exception occurred ************ at " + new Date());
        t.printStackTrace(this.logWriter);
        if (ann != null) {
            this.logWriter.printlnIndented("ANNOTATIONS:");
            this.logWriter.indent();
            int i = 0;
            while (i < ann.length) {
                this.logAnnotation(ann[i], visited);
                ++i;
            }
            this.logWriter.unindent();
        }
        this.logWriter.flush();
    }

    private void logAnnotation(ErrorManager.Annotation ann, Set visited) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("[" + ann.getDate() + "] ");
        if (ann.getSeverity() == 1) {
            sb.append("INFORMATIONAL ");
        }
        if (ann.getLocalizedMessage() == null) {
            if (ann.getMessage() == null) {
                if (ann.getStackTrace() != null) {
                    sb.append("Exception occurred:");
                }
            } else {
                sb.append(ann.getMessage());
            }
        } else {
            sb.append(ann.getLocalizedMessage());
        }
        this.logWriter.printlnIndented(sb.toString());
        if (ann.getStackTrace() != null) {
            this.notify(ann.getSeverity(), ann.getStackTrace(), visited);
        }
    }

    private static class LogWriter
    extends PrintWriter {
        private static final String TAB = "    ";
        private int indent = 0;

        public LogWriter() {
            super(new EmptyStream());
        }

        public LogWriter(OutputStream stream) {
            super(stream);
        }

        public void printIndented(String str) {
            int i = 0;
            while (i < this.indent) {
                this.print(TAB);
                ++i;
            }
            this.print(str);
        }

        public void printlnIndented(String str) {
            this.print(str);
            this.println();
        }

        public void indent() {
            ++this.indent;
        }

        public void unindent() {
            --this.indent;
        }
    }

    private static class EmptyStream
    extends OutputStream {
        private EmptyStream() {
        }

        public void write(int b) throws IOException {
        }
    }

    private static class Ann
    implements ErrorManager.Annotation {
        private final int severity;
        private final String message;
        private final String localizedMessage;
        private final Throwable stackTrace;
        private final Date date;

        public Ann(int severity, String message, String localizedMessage, Throwable stackTrace, Date date) {
            this.severity = severity;
            this.message = message;
            this.localizedMessage = localizedMessage;
            this.stackTrace = stackTrace;
            this.date = date;
        }

        public String getMessage() {
            return this.message;
        }

        public String getLocalizedMessage() {
            return this.localizedMessage;
        }

        public Throwable getStackTrace() {
            return this.stackTrace;
        }

        public Date getDate() {
            return this.date;
        }

        public int getSeverity() {
            return this.severity;
        }
    }
}

