/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofPackage;
import javax.jmi.model.Tag;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.XmiReader;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.lib.jmi.util.Logger;
import org.openide.util.Lookup;

public class MetamodelManager {
    protected final MDRepository repository;
    private final Class cls;
    private Map cache = null;
    private ModelPackage extent = null;
    static /* synthetic */ Class class$javax$jmi$xmi$XmiReader;

    public MetamodelManager(MDRepository repository, Class cls) {
        this.repository = repository;
        this.cls = cls;
    }

    public synchronized MofPackage findRootPackage(String packageName) {
        if (this.extent == null) {
            this.update();
        }
        if (this.cache == null) {
            this.cache = new HashMap();
            Iterator it = this.extent.getMofPackage().refAllOfClass().iterator();
            while (it.hasNext()) {
                MofPackage pkg = (MofPackage)it.next();
                if (pkg.getContainer() != null) continue;
                this.cache.put(pkg.getName(), pkg);
            }
        }
        return (MofPackage)this.cache.get(packageName);
    }

    private void update() {
        boolean fail = true;
        this.repository.beginTrans(true);
        try {
            try {
                Manifest mf = new Manifest(this.cls.getResourceAsStream("/META-INF/MANIFEST.MF"));
                Attributes attrs = mf.getMainAttributes();
                String extentName = attrs.getValue("NBMDR-Metamodel");
                String fileName = "/" + attrs.getValue("NBMDR-Metamodel-File");
                String version = attrs.getValue("NBMDR-Metamodel-Version");
                Logger.getDefault().log("Looking for extent " + extentName + " in repository " + this.repository);
                this.extent = (ModelPackage)this.repository.getExtent(extentName);
                if (this.extent != null) {
                    Tag tag = null;
                    Iterator it = this.extent.getTag().refAllOfClass().iterator();
                    while (it.hasNext()) {
                        Tag temp = (Tag)it.next();
                        if (!"org.netbeans.version".equals(temp.getTagId())) continue;
                        tag = temp;
                        break;
                    }
                    if (tag == null || tag.getValues().isEmpty() || !tag.getValues().iterator().next().equals(version)) {
                        Logger.getDefault().log("Metamodel version is outdated - it needs to be reloaded.");
                        this.extent.refDelete();
                        this.extent = null;
                    }
                } else {
                    Logger.getDefault().log("Extent not found.");
                }
                if (this.extent == null) {
                    this.extent = (ModelPackage)this.repository.createExtent(extentName);
                    XmiReader xmr = (XmiReader)Lookup.getDefault().lookup(class$javax$jmi$xmi$XmiReader == null ? (class$javax$jmi$xmi$XmiReader = MetamodelManager.class$("javax.jmi.xmi.XmiReader")) : class$javax$jmi$xmi$XmiReader);
                    Collection outermostElements = xmr.read(this.cls.getResource(fileName).toString(), (RefPackage)this.extent);
                    this.extent.getTag().createTag("org.netbeans.version", "", "org.netbeans.version", Arrays.asList(version));
                    this.cache = new HashMap();
                    Iterator it = outermostElements.iterator();
                    while (it.hasNext()) {
                        Object temp = it.next();
                        if (!(temp instanceof MofPackage)) continue;
                        this.cache.put(((MofPackage)temp).getName(), temp);
                    }
                }
                fail = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IllegalStateException("Metamodel XMI malformed.");
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.repository.endTrans(fail);
            throw throwable;
        }
        this.repository.endTrans(fail);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

